@echo off
rem Launch NEOPOP GUI

rem 1.- Find Java 64 bits
set HOME=%CD%
if exist "c:\Program Files\Java\jdk*1.8.*" (
    cd "c:\Program Files\Java\jdk*1.8.*"
    rem Found jdk Java 1.8 architecture 64 bits
) else (
   if exist "c:\Program Files\Java\jre*1.8.*" (
      cd "c:\Program Files\Java\jre*1.8.*"
      rem Found jre Java 1.8 architecture 64 bits
   ) 
)
set JAVA_HOME=%CD%
cd %HOME%
set PATH=%JAVA_HOME%\bin;%PATH%

rem 2.- Get Windows architecture (32 or 64)
systeminfo |  find /I "System type" > windows.bits 2>&1

rem 3.- Get the Java is 64 bit in windows 64 architecture
java -d64 -version > java.version 2>&1 

rem 4.- Detect if Java 64 is not available in windows 64
( find /i "x64" windows.bits ) && (find /i "Error: This Java instance does not support a 64-bit JVM" java.version)  
if %errorlevel% equ 0 msg * < messageError.txt   & exit /b 2

rem Create conf dir so that logfiles can be written
rem The command also works if "%USERPROFILE%\neopop-gui" doesn't exist
mkdir "%USERPROFILE%\neopop-gui\conf"

rem Enter GUI folder
cd gui



rem Run ConfFolderManager to wipe conf folder if necessary
java -jar conf_folder_manager.jar

rem Run GUI
rem "start" ensures that the cmd window closes directly
rem "1>" and "2>" redirect standard output and standard error output to log files
rem "/b" ensures that the log files aren't empty
start /b neopop-gui.exe 1>"%USERPROFILE%\neopop-gui\conf\gui-sysout.log" 2>"%USERPROFILE%\neopop-gui\conf\gui-syserr.log"

rem Return to installation folder
cd .. 
