/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts;

import de.tu_bs.ilr.esa.estec.neopop.gui.view.IPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.Enabler;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.HeteroList;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.IAggregationEquation;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.Util;
import de.tu_bs.ilr.esa.estec.neopop.model.Input;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElement;
import de.tu_bs.ilr.esa.estec.neopop.model.ModelElement;
import de.tu_bs.ilr.esa.estec.neopop.model.ModelElementValue;
import de.tu_bs.ilr.esa.estec.neopop.model.NEOPOPModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawCfgModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawOptModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawSrcModule;
import de.tu_bs.ilr.esa.estec.neopop.model.OpticalSensor;
import de.tu_bs.ilr.esa.estec.neopop.model.OpticalTelescopeType;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpticalSensorsPart
implements IPart {
    @Inject
    private IEventBroker eventBroker;
    private ObsSimRawOptModule obsSimRawOptModule;
    private ObsSimRawCfgModule obsSimRawCfgModule;
    private WritableValue selection = new WritableValue();
    private WritableValue selectionAzimuthErrorRate = new WritableValue();
    private WritableValue selectionElevationErrorRate = new WritableValue();
    private Text nameText;
    private Group selectionGroup;
    private TableViewer telescopesTableViewer;
    private Button addButton;
    private Button removeButton;
    private Text inputFileText;
    private Button inputFileBrowseButton;
    private Button inputFileEditButton;
    private Spinner limitingMagnitudeSpinner;
    private Spinner diameterOfAperatureSpinner;
    private Spinner fieldOfViewSpinner;
    private Spinner numberOfPixelsPerRowSpinner;
    private Spinner pixelSizeSpinner;
    private Spinner scaleSpinner;
    private Spinner fullWidthHalfMaximumSpinner;
    private Spinner integrationTimeSpinner;
    private Spinner gapTimeSpinner;
    private Spinner minNumberOfConsecutiveDetectionsSpinner;
    private Spinner thresholdParameterForDetectionSpinner;
    private Spinner countRateConstantForCcdReadoutNoiseSpinner;
    private Spinner countRateConstantForDarkNoiseSpinner;
    private Text isrFilenameText;
    private Button isrFilenameBrowseButton;
    private Button isrFilenameEditButton;
    private Label countRateConstantForDarkNoiseLabel;
    private Label countRateConstantForCcdReadoutNoiseLabel;
    private Label thresholdParameterForDetectionLabel;
    private Label isrFilenameLabel;
    private Label fullWidthHalfMaximumLabel;
    private Label scaleLabel;
    private Label numberOfPixelsPerRowLabel;
    private Label pixelSizeLabel;
    private Label diameterOfAperatureLabel;
    private Label limitingMagnitudeLabel;
    private Label limitingMaginuteUnitLabel;
    private Label diameterOfAperatureUnitLabel;
    private Label pixelSizeUnitLabel;
    private Label numberOfPixelsPerRowUnitLabel;
    private Label scaleUnitLabel;
    private Label fullWidthHalfMaximumUnitLabel;
    private Label thresholdParameterForDetectionUnitLabel;
    private Label countRateConstantForCcdReadoutNoiseUnitLabel;
    private Label countRateConstantForDarkNoiseUnitLabel;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ComboViewer typeComboViewer;
    private Spinner azimuthBiasErrorRateSpinner;
    private Spinner elevationBiasErrorRateSpinner;
    private Spinner elevationNoiseErrorRateSpinner;
    private Spinner azimuthNoiseErrorRateSpinner;
    private Spinner azimuthDriftErrorRateSpinner;
    private Spinner elevationDriftErrorRateSpinner;
    private Composite noteComposite;
    private Label noteCaptionLabel;
    private Label noteLabel;
    private Canvas canvas;
    private Text txtFdgDgDg;
    private ScrolledComposite scrolledComposite;
    private Composite compInScrolled;
    private Composite composite;
    private Composite composite_1;
    private Label label;
    private Label label_1;
    private Group telescopesGroup;
    private ObsSimRawSrcModule obsSimRawSrcModule;
    private NEOPOPModule neopopModule;

    @Inject
    protected void setAttributesFromContext(Input model) {
        this.logger.trace("setAttributesFromContext(...)");
        this.obsSimRawCfgModule = model.getObsSimRawCfgModule();
        this.obsSimRawOptModule = model.getObsSimRawOptModule();
        this.obsSimRawSrcModule = model.getObsSimRawSrcModule();
        this.neopopModule = model.getNeopopModule();
    }

    @PostConstruct
    public void createGUIElements(Composite parentComposite) {
        this.logger.trace("createGUIElements(...)");
        this.logger.info("Creating GUI elements");
        parentComposite.setLayout((Layout)new GridLayout(2, false));
        this.telescopesGroup = new Group(parentComposite, 0);
        GridLayout gl_telescopesGroup = new GridLayout(1, false);
        this.telescopesGroup.setLayout((Layout)gl_telescopesGroup);
        this.telescopesGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.telescopesGroup.setText("Defined Optical Sensors");
        this.telescopesTableViewer = new TableViewer((Composite)this.telescopesGroup, 67584);
        Table telescopesTable = this.telescopesTableViewer.getTable();
        telescopesTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite addRemoveComposite = new Composite((Composite)this.telescopesGroup, 0);
        addRemoveComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        addRemoveComposite.setLayout((Layout)new RowLayout(256));
        this.addButton = new Button(addRemoveComposite, 0);
        this.addButton.setLayoutData((Object)new RowData(100, -1));
        this.addButton.setText("Add");
        this.removeButton = new Button(addRemoveComposite, 0);
        this.removeButton.setLayoutData((Object)new RowData(100, -1));
        this.removeButton.setText("Remove");
        this.selectionGroup = new Group(parentComposite, 0);
        this.selectionGroup.setLayout((Layout)new FillLayout());
        this.selectionGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.selectionGroup.setText("Attributes of Selected Optical Sensor");
        this.scrolledComposite = new ScrolledComposite((Composite)this.selectionGroup, 768);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.compInScrolled = new Composite((Composite)this.scrolledComposite, 0);
        GridLayout gl_selectionGroup = new GridLayout(3, false);
        gl_selectionGroup.verticalSpacing = 0;
        gl_selectionGroup.marginHeight = 0;
        gl_selectionGroup.horizontalSpacing = 8;
        this.compInScrolled.setLayout((Layout)gl_selectionGroup);
        Label sep0 = new Label(this.compInScrolled, 258);
        GridData gd_sep0 = new GridData(4, 0x1000000, true, false, 3, 1);
        gd_sep0.heightHint = 30;
        sep0.setLayoutData((Object)gd_sep0);
        Label generalLabel = new Label(this.compInScrolled, 0);
        generalLabel.setText("General");
        new Label(this.compInScrolled, 0);
        new Label(this.compInScrolled, 0);
        Label sep1 = new Label(this.compInScrolled, 256);
        GridData gd_sep1 = new GridData(16384, 0x1000000, false, false, 3, 1);
        gd_sep1.heightHint = 15;
        sep1.setLayoutData((Object)gd_sep1);
        Label nameLabel = new Label(this.compInScrolled, 0);
        GridData gd_nameLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_nameLabel.horizontalIndent = 20;
        nameLabel.setLayoutData((Object)gd_nameLabel);
        nameLabel.setText("Designator:");
        this.nameText = new Text(this.compInScrolled, 2048);
        this.nameText.setText("<designator>");
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.label_1 = new Label(this.compInScrolled, 0);
        this.label_1.setText("[-]");
        Label typeLabel = new Label(this.compInScrolled, 0);
        GridData gd_typeLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_typeLabel.horizontalIndent = 20;
        typeLabel.setLayoutData((Object)gd_typeLabel);
        typeLabel.setText("Operational Mode:");
        this.typeComboViewer = new ComboViewer(this.compInScrolled, 8);
        Combo typeCombo = this.typeComboViewer.getCombo();
        typeCombo.setItems(new String[]{"Visible Light", "Thermal Infrared"});
        typeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        typeCombo.select(0);
        this.label = new Label(this.compInScrolled, 0);
        this.label.setText("[-]");
        Label fieldOfViewLabel = new Label(this.compInScrolled, 0);
        GridData gd_fieldOfViewLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_fieldOfViewLabel.horizontalIndent = 20;
        fieldOfViewLabel.setLayoutData((Object)gd_fieldOfViewLabel);
        fieldOfViewLabel.setText("Field of View (FOV):");
        this.fieldOfViewSpinner = new Spinner(this.compInScrolled, 2048);
        this.fieldOfViewSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fieldOfViewSpinner.setPageIncrement(10000);
        this.fieldOfViewSpinner.setMaximum(100000000);
        this.fieldOfViewSpinner.setSelection(48234);
        this.fieldOfViewSpinner.setIncrement(1000);
        this.fieldOfViewSpinner.setDigits(3);
        Label fieldOfViewUnitLabel = new Label(this.compInScrolled, 0);
        fieldOfViewUnitLabel.setText("[deg]");
        Label integrationTimeLabel = new Label(this.compInScrolled, 0);
        GridData gd_integrationTimeLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_integrationTimeLabel.horizontalIndent = 20;
        integrationTimeLabel.setLayoutData((Object)gd_integrationTimeLabel);
        integrationTimeLabel.setText("Integration Time:");
        this.integrationTimeSpinner = new Spinner(this.compInScrolled, 2048);
        this.integrationTimeSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.integrationTimeSpinner.setPageIncrement(10000);
        this.integrationTimeSpinner.setMaximum(100000000);
        this.integrationTimeSpinner.setSelection(1532);
        this.integrationTimeSpinner.setIncrement(1000);
        this.integrationTimeSpinner.setDigits(3);
        Label integrationTimeUnitLabel = new Label(this.compInScrolled, 0);
        integrationTimeUnitLabel.setText("[s]");
        Label gapTimeLabel = new Label(this.compInScrolled, 0);
        GridData gd_gapTimeLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_gapTimeLabel.horizontalIndent = 20;
        gapTimeLabel.setLayoutData((Object)gd_gapTimeLabel);
        gapTimeLabel.setText("Gap Time:");
        this.gapTimeSpinner = new Spinner(this.compInScrolled, 2048);
        this.gapTimeSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.gapTimeSpinner.setPageIncrement(10000);
        this.gapTimeSpinner.setMaximum(100000);
        this.gapTimeSpinner.setSelection(1532);
        this.gapTimeSpinner.setIncrement(1000);
        this.gapTimeSpinner.setDigits(3);
        Label gapTimeUnitLabel = new Label(this.compInScrolled, 0);
        gapTimeUnitLabel.setText("[s]");
        Label minNumberOfConsecutiveDetectionsLabel = new Label(this.compInScrolled, 0);
        GridData gd_minNumberOfConsecutiveDetectionsLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_minNumberOfConsecutiveDetectionsLabel.horizontalIndent = 20;
        minNumberOfConsecutiveDetectionsLabel.setLayoutData((Object)gd_minNumberOfConsecutiveDetectionsLabel);
        minNumberOfConsecutiveDetectionsLabel.setText("Minimum Number of Consecutive Detections:");
        this.minNumberOfConsecutiveDetectionsSpinner = new Spinner(this.compInScrolled, 2048);
        this.minNumberOfConsecutiveDetectionsSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.minNumberOfConsecutiveDetectionsSpinner.setPageIncrement(10000);
        this.minNumberOfConsecutiveDetectionsSpinner.setMaximum(100000000);
        this.minNumberOfConsecutiveDetectionsSpinner.setSelection(48234);
        this.minNumberOfConsecutiveDetectionsSpinner.setIncrement(1000);
        this.minNumberOfConsecutiveDetectionsSpinner.setDigits(3);
        Label minNumberOfConsecutiveDetectionsUnitLabel = new Label(this.compInScrolled, 0);
        minNumberOfConsecutiveDetectionsUnitLabel.setText("[-]");
        this.limitingMagnitudeLabel = new Label(this.compInScrolled, 0);
        GridData gd_limitingMagnitudeLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_limitingMagnitudeLabel.horizontalIndent = 20;
        this.limitingMagnitudeLabel.setLayoutData((Object)gd_limitingMagnitudeLabel);
        this.limitingMagnitudeLabel.setText("Limiting Magnitude:");
        this.limitingMagnitudeSpinner = new Spinner(this.compInScrolled, 2048);
        this.limitingMagnitudeSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.limitingMagnitudeSpinner.setPageIncrement(10000);
        this.limitingMagnitudeSpinner.setMaximum(100000000);
        this.limitingMagnitudeSpinner.setSelection(48234);
        this.limitingMagnitudeSpinner.setIncrement(1000);
        this.limitingMagnitudeSpinner.setDigits(3);
        this.limitingMaginuteUnitLabel = new Label(this.compInScrolled, 0);
        this.limitingMaginuteUnitLabel.setToolTipText("");
        this.limitingMaginuteUnitLabel.setText("[-]");
        this.diameterOfAperatureLabel = new Label(this.compInScrolled, 0);
        GridData gd_diameterOfAperatureLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_diameterOfAperatureLabel.horizontalIndent = 20;
        this.diameterOfAperatureLabel.setLayoutData((Object)gd_diameterOfAperatureLabel);
        this.diameterOfAperatureLabel.setText("Diameter of Aperature:");
        this.diameterOfAperatureSpinner = new Spinner(this.compInScrolled, 2048);
        this.diameterOfAperatureSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.diameterOfAperatureSpinner.setPageIncrement(10000);
        this.diameterOfAperatureSpinner.setMaximum(100000000);
        this.diameterOfAperatureSpinner.setSelection(48234);
        this.diameterOfAperatureSpinner.setIncrement(1000);
        this.diameterOfAperatureSpinner.setDigits(3);
        this.diameterOfAperatureUnitLabel = new Label(this.compInScrolled, 0);
        this.diameterOfAperatureUnitLabel.setToolTipText("");
        this.diameterOfAperatureUnitLabel.setText("[m]");
        this.pixelSizeLabel = new Label(this.compInScrolled, 0);
        GridData gd_pixelSizeLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_pixelSizeLabel.horizontalIndent = 20;
        this.pixelSizeLabel.setLayoutData((Object)gd_pixelSizeLabel);
        this.pixelSizeLabel.setText("Pixel Size:");
        this.pixelSizeSpinner = new Spinner(this.compInScrolled, 2048);
        this.pixelSizeSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.pixelSizeSpinner.setPageIncrement(10000);
        this.pixelSizeSpinner.setMaximum(100000000);
        this.pixelSizeSpinner.setSelection(50456);
        this.pixelSizeSpinner.setIncrement(1000);
        this.pixelSizeSpinner.setDigits(3);
        this.pixelSizeUnitLabel = new Label(this.compInScrolled, 0);
        this.pixelSizeUnitLabel.setText("[um]");
        this.numberOfPixelsPerRowLabel = new Label(this.compInScrolled, 0);
        GridData gd_numberOfPixelsPerRowLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_numberOfPixelsPerRowLabel.horizontalIndent = 20;
        this.numberOfPixelsPerRowLabel.setLayoutData((Object)gd_numberOfPixelsPerRowLabel);
        this.numberOfPixelsPerRowLabel.setText("Number of Pixels per Row:");
        this.numberOfPixelsPerRowSpinner = new Spinner(this.compInScrolled, 2048);
        this.numberOfPixelsPerRowSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.numberOfPixelsPerRowSpinner.setIncrement(1000);
        this.numberOfPixelsPerRowSpinner.setPageIncrement(10000);
        this.numberOfPixelsPerRowSpinner.setMaximum(100000000);
        this.numberOfPixelsPerRowSpinner.setSelection(48234);
        this.numberOfPixelsPerRowSpinner.setDigits(3);
        this.numberOfPixelsPerRowUnitLabel = new Label(this.compInScrolled, 0);
        this.numberOfPixelsPerRowUnitLabel.setText("[-]");
        this.scaleLabel = new Label(this.compInScrolled, 0);
        GridData gd_scaleLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_scaleLabel.horizontalIndent = 20;
        this.scaleLabel.setLayoutData((Object)gd_scaleLabel);
        this.scaleLabel.setText("Scale (Pixel POV):");
        this.scaleSpinner = new Spinner(this.compInScrolled, 2048);
        this.scaleSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.scaleSpinner.setPageIncrement(10000);
        this.scaleSpinner.setMaximum(100000000);
        this.scaleSpinner.setSelection(1532);
        this.scaleSpinner.setIncrement(1000);
        this.scaleSpinner.setDigits(3);
        this.scaleUnitLabel = new Label(this.compInScrolled, 0);
        this.scaleUnitLabel.setText("[\"/pix]");
        this.fullWidthHalfMaximumLabel = new Label(this.compInScrolled, 0);
        GridData gd_fullWidthHalfMaximumLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_fullWidthHalfMaximumLabel.horizontalIndent = 20;
        this.fullWidthHalfMaximumLabel.setLayoutData((Object)gd_fullWidthHalfMaximumLabel);
        this.fullWidthHalfMaximumLabel.setText("Full Width Half Maximum (FWHM):");
        this.fullWidthHalfMaximumSpinner = new Spinner(this.compInScrolled, 2048);
        this.fullWidthHalfMaximumSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fullWidthHalfMaximumSpinner.setPageIncrement(10000);
        this.fullWidthHalfMaximumSpinner.setMaximum(100000000);
        this.fullWidthHalfMaximumSpinner.setSelection(1532);
        this.fullWidthHalfMaximumSpinner.setIncrement(1000);
        this.fullWidthHalfMaximumSpinner.setDigits(3);
        this.fullWidthHalfMaximumUnitLabel = new Label(this.compInScrolled, 0);
        this.fullWidthHalfMaximumUnitLabel.setText("[pix]");
        this.thresholdParameterForDetectionLabel = new Label(this.compInScrolled, 0);
        GridData gd_thresholdParameterForDetectionLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_thresholdParameterForDetectionLabel.horizontalIndent = 20;
        this.thresholdParameterForDetectionLabel.setLayoutData((Object)gd_thresholdParameterForDetectionLabel);
        this.thresholdParameterForDetectionLabel.setText("Threshold Parameter for Detection:");
        this.thresholdParameterForDetectionSpinner = new Spinner(this.compInScrolled, 2048);
        this.thresholdParameterForDetectionSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.thresholdParameterForDetectionSpinner.setPageIncrement(10000);
        this.thresholdParameterForDetectionSpinner.setMaximum(100000000);
        this.thresholdParameterForDetectionSpinner.setSelection(48234);
        this.thresholdParameterForDetectionSpinner.setIncrement(1000);
        this.thresholdParameterForDetectionSpinner.setDigits(3);
        this.thresholdParameterForDetectionUnitLabel = new Label(this.compInScrolled, 0);
        this.thresholdParameterForDetectionUnitLabel.setText("[-]");
        this.countRateConstantForCcdReadoutNoiseLabel = new Label(this.compInScrolled, 0);
        GridData gd_countRateConstantForCcdReadoutNoiseLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_countRateConstantForCcdReadoutNoiseLabel.horizontalIndent = 20;
        this.countRateConstantForCcdReadoutNoiseLabel.setLayoutData((Object)gd_countRateConstantForCcdReadoutNoiseLabel);
        this.countRateConstantForCcdReadoutNoiseLabel.setText("Count Rate Constant for CCD Readout Noise:");
        this.countRateConstantForCcdReadoutNoiseSpinner = new Spinner(this.compInScrolled, 2048);
        this.countRateConstantForCcdReadoutNoiseSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.countRateConstantForCcdReadoutNoiseSpinner.setPageIncrement(10000);
        this.countRateConstantForCcdReadoutNoiseSpinner.setMaximum(100000000);
        this.countRateConstantForCcdReadoutNoiseSpinner.setSelection(48234);
        this.countRateConstantForCcdReadoutNoiseSpinner.setIncrement(1000);
        this.countRateConstantForCcdReadoutNoiseSpinner.setDigits(3);
        this.countRateConstantForCcdReadoutNoiseUnitLabel = new Label(this.compInScrolled, 0);
        this.countRateConstantForCcdReadoutNoiseUnitLabel.setText("[e-/pix]");
        this.countRateConstantForDarkNoiseLabel = new Label(this.compInScrolled, 0);
        GridData gd_countRateConstantForDarkNoiseLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_countRateConstantForDarkNoiseLabel.horizontalIndent = 20;
        this.countRateConstantForDarkNoiseLabel.setLayoutData((Object)gd_countRateConstantForDarkNoiseLabel);
        this.countRateConstantForDarkNoiseLabel.setText("Count Rate Constant for Dark Noise:");
        this.countRateConstantForDarkNoiseSpinner = new Spinner(this.compInScrolled, 2048);
        this.countRateConstantForDarkNoiseSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.countRateConstantForDarkNoiseSpinner.setPageIncrement(10000);
        this.countRateConstantForDarkNoiseSpinner.setMaximum(100000000);
        this.countRateConstantForDarkNoiseSpinner.setSelection(48234);
        this.countRateConstantForDarkNoiseSpinner.setIncrement(1000);
        this.countRateConstantForDarkNoiseSpinner.setDigits(3);
        this.countRateConstantForDarkNoiseUnitLabel = new Label(this.compInScrolled, 0);
        this.countRateConstantForDarkNoiseUnitLabel.setText("[e-/pix/s]");
        this.isrFilenameLabel = new Label(this.compInScrolled, 0);
        GridData gd_isrFilenameLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_isrFilenameLabel.horizontalIndent = 20;
        this.isrFilenameLabel.setLayoutData((Object)gd_isrFilenameLabel);
        this.isrFilenameLabel.setText("ISR Filename:");
        this.isrFilenameText = new Text(this.compInScrolled, 2048);
        this.isrFilenameText.setText("<isr filename>");
        this.isrFilenameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Composite isrFilenameButtonsComposite = new Composite(this.compInScrolled, 0);
        RowLayout rl_isrFilenameButtonsComposite = new RowLayout(256);
        rl_isrFilenameButtonsComposite.marginTop = 0;
        rl_isrFilenameButtonsComposite.marginRight = 0;
        rl_isrFilenameButtonsComposite.marginLeft = 0;
        rl_isrFilenameButtonsComposite.marginBottom = 0;
        isrFilenameButtonsComposite.setLayout((Layout)rl_isrFilenameButtonsComposite);
        this.isrFilenameBrowseButton = new Button(isrFilenameButtonsComposite, 0);
        this.isrFilenameBrowseButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-open-4.png"));
        this.isrFilenameBrowseButton.setToolTipText("Browse");
        this.isrFilenameEditButton = new Button(isrFilenameButtonsComposite, 0);
        this.isrFilenameEditButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-edit.png"));
        this.isrFilenameEditButton.setToolTipText("Edit");
        Label sep2 = new Label(this.compInScrolled, 258);
        GridData gd_sep2 = new GridData(4, 0x1000000, true, false, 3, 1);
        gd_sep2.heightHint = 30;
        sep2.setLayoutData((Object)gd_sep2);
        Label errorRatesLabel = new Label(this.compInScrolled, 0);
        errorRatesLabel.setText("Errors");
        new Label(this.compInScrolled, 0);
        new Label(this.compInScrolled, 0);
        Label sep3 = new Label(this.compInScrolled, 256);
        GridData gd_sep3 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_sep3.heightHint = 15;
        sep3.setLayoutData((Object)gd_sep3);
        Composite errorRatesGroup = new Composite(this.compInScrolled, 0);
        FillLayout fl_errorRatesGroup = new FillLayout(256);
        fl_errorRatesGroup.spacing = 8;
        errorRatesGroup.setLayout((Layout)fl_errorRatesGroup);
        errorRatesGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label biasLabel = new Label(errorRatesGroup, 0);
        biasLabel.setAlignment(0x1000000);
        biasLabel.setText("Bias");
        Label noiseLabel = new Label(errorRatesGroup, 0);
        noiseLabel.setAlignment(0x1000000);
        noiseLabel.setText("Noise");
        Label driftLabel = new Label(errorRatesGroup, 0);
        driftLabel.setAlignment(0x1000000);
        driftLabel.setText("Drift");
        new Label(this.compInScrolled, 0);
        Label azimuthLabel = new Label(this.compInScrolled, 0);
        GridData gd_azimuthLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_azimuthLabel.horizontalIndent = 20;
        azimuthLabel.setLayoutData((Object)gd_azimuthLabel);
        azimuthLabel.setText("Azimuth:");
        this.composite_1 = new Composite(this.compInScrolled, 0);
        FillLayout fl_composite_1 = new FillLayout(256);
        fl_composite_1.spacing = 8;
        this.composite_1.setLayout((Layout)fl_composite_1);
        this.composite_1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.azimuthBiasErrorRateSpinner = new Spinner(this.composite_1, 2048);
        this.azimuthBiasErrorRateSpinner.setPageIncrement(10000);
        this.azimuthBiasErrorRateSpinner.setMaximum(100000000);
        this.azimuthBiasErrorRateSpinner.setSelection(48234);
        this.azimuthBiasErrorRateSpinner.setIncrement(1000);
        this.azimuthBiasErrorRateSpinner.setDigits(3);
        this.azimuthNoiseErrorRateSpinner = new Spinner(this.composite_1, 2048);
        this.azimuthNoiseErrorRateSpinner.setPageIncrement(10000);
        this.azimuthNoiseErrorRateSpinner.setMaximum(100000000);
        this.azimuthNoiseErrorRateSpinner.setSelection(48234);
        this.azimuthNoiseErrorRateSpinner.setIncrement(1000);
        this.azimuthNoiseErrorRateSpinner.setDigits(3);
        this.azimuthDriftErrorRateSpinner = new Spinner(this.composite_1, 2048);
        this.azimuthDriftErrorRateSpinner.setPageIncrement(10000);
        this.azimuthDriftErrorRateSpinner.setMaximum(100000000);
        this.azimuthDriftErrorRateSpinner.setSelection(48234);
        this.azimuthDriftErrorRateSpinner.setIncrement(1000);
        this.azimuthDriftErrorRateSpinner.setDigits(3);
        Label azimuthErrorRateUnitLabel = new Label(this.compInScrolled, 0);
        azimuthErrorRateUnitLabel.setText("[deg]");
        Label elevationLabel = new Label(this.compInScrolled, 0);
        GridData gd_elevationLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_elevationLabel.horizontalIndent = 20;
        elevationLabel.setLayoutData((Object)gd_elevationLabel);
        elevationLabel.setText("Elevation:");
        this.composite = new Composite(this.compInScrolled, 0);
        FillLayout fl_composite = new FillLayout(256);
        fl_composite.spacing = 8;
        this.composite.setLayout((Layout)fl_composite);
        this.composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.elevationBiasErrorRateSpinner = new Spinner(this.composite, 2048);
        this.elevationBiasErrorRateSpinner.setPageIncrement(10000);
        this.elevationBiasErrorRateSpinner.setMaximum(100000000);
        this.elevationBiasErrorRateSpinner.setSelection(48234);
        this.elevationBiasErrorRateSpinner.setIncrement(1000);
        this.elevationBiasErrorRateSpinner.setDigits(3);
        this.elevationNoiseErrorRateSpinner = new Spinner(this.composite, 2048);
        this.elevationNoiseErrorRateSpinner.setPageIncrement(10000);
        this.elevationNoiseErrorRateSpinner.setMaximum(100000000);
        this.elevationNoiseErrorRateSpinner.setSelection(48234);
        this.elevationNoiseErrorRateSpinner.setIncrement(1000);
        this.elevationNoiseErrorRateSpinner.setDigits(3);
        this.elevationDriftErrorRateSpinner = new Spinner(this.composite, 2048);
        this.elevationDriftErrorRateSpinner.setPageIncrement(10000);
        this.elevationDriftErrorRateSpinner.setMaximum(100000000);
        this.elevationDriftErrorRateSpinner.setSelection(48234);
        this.elevationDriftErrorRateSpinner.setIncrement(1000);
        this.elevationDriftErrorRateSpinner.setDigits(3);
        Label elevationErrorRateUnitLabel = new Label(this.compInScrolled, 0);
        elevationErrorRateUnitLabel.setText("[deg]");
        this.noteComposite = new Composite(this.compInScrolled, 0);
        GridData gd_noteComposite = new GridData(4, 0x1000000, true, false, 3, 1);
        gd_noteComposite.verticalIndent = 20;
        this.noteComposite.setLayoutData((Object)gd_noteComposite);
        this.noteComposite.setVisible(false);
        this.noteComposite.setLayout((Layout)new GridLayout(2, false));
        this.noteCaptionLabel = new Label(this.noteComposite, 0);
        this.noteCaptionLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.noteCaptionLabel.setText("Note:");
        this.noteCaptionLabel.setFont(SWTResourceManager.getFont("Sans Serif", 9, 1));
        this.noteLabel = new Label(this.noteComposite, 64);
        GridData gd_noteLabel = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_noteLabel.widthHint = 100;
        this.noteLabel.setLayoutData((Object)gd_noteLabel);
        this.noteLabel.setText("Designator changes do not affect usages of selected element in sensor network definitions.");
        this.scrolledComposite.setContent((Control)this.compInScrolled);
        this.scrolledComposite.setMinSize(this.compInScrolled.computeSize(-1, -1));
        Group inputFileGroup = new Group(parentComposite, 0);
        inputFileGroup.setEnabled(false);
        inputFileGroup.setText("Optical Sensors Input File");
        GridLayout gl_inputFileGroup = new GridLayout(3, false);
        inputFileGroup.setLayout((Layout)gl_inputFileGroup);
        inputFileGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.inputFileText = new Text((Composite)inputFileGroup, 2048);
        this.inputFileText.setEnabled(false);
        this.inputFileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.inputFileText.setText("<optical telescopes input file / obssim.opt>");
        this.inputFileBrowseButton = new Button((Composite)inputFileGroup, 0);
        this.inputFileBrowseButton.setEnabled(false);
        this.inputFileBrowseButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-open-4.png"));
        this.inputFileBrowseButton.setToolTipText("Browse");
        this.inputFileEditButton = new Button((Composite)inputFileGroup, 0);
        this.inputFileEditButton.setEnabled(false);
        this.inputFileEditButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-edit.png"));
        this.inputFileEditButton.setToolTipText("Edit");
    }

    public void doAdditionalStuff() {
        this.logger.trace("doAdditionalStuff()");
        this.logger.info("Doing additional stuff");
        Util.setDefaultDoubleAttributes(this.countRateConstantForCcdReadoutNoiseSpinner, this.countRateConstantForDarkNoiseSpinner, this.diameterOfAperatureSpinner, this.fieldOfViewSpinner, this.fullWidthHalfMaximumSpinner, this.gapTimeSpinner, this.integrationTimeSpinner, this.limitingMagnitudeSpinner, this.pixelSizeSpinner, this.scaleSpinner, this.thresholdParameterForDetectionSpinner);
        Util.setDefaultIntegerAttributes(this.minNumberOfConsecutiveDetectionsSpinner, this.numberOfPixelsPerRowSpinner);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpticalSensorsPart.this.obsSimRawOptModule.addOpticalTelescope();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpticalSensorsPart.this.obsSimRawOptModule.removeOpticalTelescope((OpticalSensor)OpticalSensorsPart.this.selection.getValue());
            }
        });
        Util.setDefaultDoubleAttributes(this.fieldOfViewSpinner, this.integrationTimeSpinner, this.gapTimeSpinner, this.limitingMagnitudeSpinner, this.diameterOfAperatureSpinner, this.pixelSizeSpinner, this.scaleSpinner, this.fullWidthHalfMaximumSpinner, this.thresholdParameterForDetectionSpinner, this.countRateConstantForCcdReadoutNoiseSpinner, this.countRateConstantForDarkNoiseSpinner, this.azimuthBiasErrorRateSpinner, this.azimuthNoiseErrorRateSpinner, this.azimuthDriftErrorRateSpinner, this.elevationBiasErrorRateSpinner, this.elevationNoiseErrorRateSpinner, this.elevationDriftErrorRateSpinner);
        Util.setDefaultIntegerAttributes(this.minNumberOfConsecutiveDetectionsSpinner, this.numberOfPixelsPerRowSpinner);
        Util.letThemSendBrowseAndEditFileEvents(this.eventBroker, this.isrFilenameBrowseButton, this.isrFilenameEditButton, this.selection, "isrFilename");
    }

    public void bindGUIElements() {
        this.logger.trace("bindGUIElements()");
        this.logger.info("Binding GUI elements");
        DataBindingContext dbc = new DataBindingContext();
        this.logger.debug("Binding telescopes table viewer");
        Util.bindList(dbc, (InputElement)this.obsSimRawOptModule, "opticalTelescopes", "name", this.selection, this.telescopesTableViewer);
        this.logger.debug("Binding designator text");
        Util.bindString(dbc, this.selection, "name", (Control)this.nameText);
        this.logger.debug("Binding type combo viewer");
        Util.bindEnum(dbc, this.selection, "type", OpticalTelescopeType.class, this.typeComboViewer, new LabelProvider(){

            public String getText(Object element) {
                if (element == OpticalTelescopeType.VISIBLE_LIGHT) {
                    return "Visible Light";
                }
                if (element == OpticalTelescopeType.THERMAL_INFRARED) {
                    return "Thermal Infrared";
                }
                return null;
            }
        });
        this.logger.debug("Binding field of view spinner");
        Util.bindDouble(dbc, this.selection, "fieldOfView", this.fieldOfViewSpinner);
        this.logger.debug("Binding integration time spinner");
        Util.bindDouble(dbc, this.selection, "integrationTime", this.integrationTimeSpinner);
        this.logger.debug("Binding gap time spinner");
        Util.bindDouble(dbc, this.selection, "gapTime", this.gapTimeSpinner);
        this.logger.debug("Binding min number of consecutive detections spinner");
        Util.bindInteger(dbc, this.selection, "minNumberOfConsecutiveDetections", this.minNumberOfConsecutiveDetectionsSpinner);
        this.logger.debug("Binding limiting magnitude spinner");
        Util.bindDouble(dbc, this.selection, "limitingMagnitude", this.limitingMagnitudeSpinner);
        this.logger.debug("Binding diameter of aperature spinner");
        Util.bindDouble(dbc, this.selection, "diameterOfAperature", this.diameterOfAperatureSpinner);
        this.logger.debug("Binding pixel size spinner");
        Util.bindDouble(dbc, this.selection, "pixelSize", this.pixelSizeSpinner);
        this.logger.debug("Binding number of pixels per row spinner");
        Util.bindInteger(dbc, this.selection, "numberOfPixelsPerRow", this.numberOfPixelsPerRowSpinner);
        this.logger.debug("Binding scale spinner");
        Util.bindDouble(dbc, this.selection, "scale", this.scaleSpinner);
        this.logger.debug("Binding fwhm spinner");
        Util.bindDouble(dbc, this.selection, "fullWidthHalfMaximum", this.fullWidthHalfMaximumSpinner);
        this.logger.debug("Binding threshold parameter for detection spinner");
        Util.bindDouble(dbc, this.selection, "thresholdParameterForDetection", this.thresholdParameterForDetectionSpinner);
        this.logger.debug("Binding count rate constant for ccd readout noise spinner");
        Util.bindDouble(dbc, this.selection, "countRateContantForCcdReadoutNoise", this.countRateConstantForCcdReadoutNoiseSpinner);
        this.logger.debug("Binding count rate constant for dark noise spinner");
        Util.bindDouble(dbc, this.selection, "countRateContantForDarkNoise", this.countRateConstantForDarkNoiseSpinner);
        this.logger.debug("Binding isr filename text");
        Util.bindString(dbc, this.selection, "isrFilename", (Control)this.isrFilenameText);
        this.logger.debug("Binding selection azimuth error rate writable value");
        Util.bind(dbc, this.selection, "azimuthErrorRate", this.selectionAzimuthErrorRate);
        this.logger.debug("Binding selection elevation error rate writable value");
        Util.bind(dbc, this.selection, "elevationErrorRate", this.selectionElevationErrorRate);
        this.logger.debug("Binding azimuth bias error rate spinner");
        Util.bindDouble(dbc, this.selectionAzimuthErrorRate, "bias", this.azimuthBiasErrorRateSpinner);
        this.logger.debug("Binding azimuth noise error rate spinner");
        Util.bindDouble(dbc, this.selectionAzimuthErrorRate, "noise", this.azimuthNoiseErrorRateSpinner);
        this.logger.debug("Binding azimuth drift error rate spinner");
        Util.bindDouble(dbc, this.selectionAzimuthErrorRate, "drift", this.azimuthDriftErrorRateSpinner);
        this.logger.debug("Binding elevation bias error rate spinner");
        Util.bindDouble(dbc, this.selectionElevationErrorRate, "bias", this.elevationBiasErrorRateSpinner);
        this.logger.debug("Binding elevation noise error rate spinner");
        Util.bindDouble(dbc, this.selectionElevationErrorRate, "noise", this.elevationNoiseErrorRateSpinner);
        this.logger.debug("Binding elevation drift error rate spinner");
        Util.bindDouble(dbc, this.selectionElevationErrorRate, "drift", this.elevationDriftErrorRateSpinner);
        this.logger.debug("Binding input file text");
        Util.bindString(dbc, (ModelElement)this.obsSimRawCfgModule, "opticalSensorsInputFile", this.inputFileText);
        this.logger.debug("Binding selection group visibility");
        Util.bindBooleanPropertyToSelectionExistence(dbc, (IObservableValue)WidgetProperties.visible().observe((Widget)this.selectionGroup), (ISelectionProvider)this.telescopesTableViewer);
        this.logger.debug("Binding remove button enablement");
        this.nameText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                OpticalSensorsPart.this.noteComposite.setVisible(true);
            }

            public void focusLost(FocusEvent e) {
                OpticalSensorsPart.this.noteComposite.setVisible(false);
            }
        });
        Enabler enabler = new Enabler(new Control[]{this.selectionGroup, this.telescopesGroup, this.noteComposite});
        enabler.setOutputControlsToBeIgnored(new Control[]{this.removeButton});
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "observationSimulationEnabled"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getPopulationFiles(), "selected"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getAdditionalPopulationFiles(), "selected"));
        enabler.setAggregationEquation(new IAggregationEquation(){

            @Override
            public Object aggregate(HeteroList values) {
                if (((Boolean)values.getTyped(0)).booleanValue() && (((Boolean)values.getTyped(1)).booleanValue() || ((Boolean)values.getTyped(2)).booleanValue())) {
                    return true;
                }
                return false;
            }
        });
        enabler.bind(dbc);
        enabler = new Enabler(new Control[]{this.removeButton});
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "observationSimulationEnabled"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getPopulationFiles(), "selected"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getAdditionalPopulationFiles(), "selected"));
        enabler.addObservable((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.telescopesTableViewer));
        enabler.setAggregationEquation(new IAggregationEquation(){

            @Override
            public Object aggregate(HeteroList values) {
                if (((Boolean)values.getTyped(0)).booleanValue() && (((Boolean)values.getTyped(1)).booleanValue() || ((Boolean)values.getTyped(2)).booleanValue()) && values.getTyped(3) != null) {
                    return true;
                }
                return false;
            }
        });
        enabler.bind(dbc);
    }

    public void focus() {
        this.logger.trace("focus()");
        this.telescopesTableViewer.getTable().setFocus();
    }

    public void finalizeCreation() {
        this.logger.trace("finalizeCreation");
        this.logger.debug("Finalizing creation");
    }

    @Inject
    @Optional
    void fixBrokenLayout(@EventTopic(value="org/eclipse/e4/ui/LifeCycle/activate") Event event) {
        if (!this.selectionGroup.isDisposed()) {
            this.selectionGroup.layout();
        }
    }
}

