/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt;

import de.tu_bs.ilr.esa.estec.neopop.gui.view.DialogType;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.IDialog;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.IPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.IView;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.PartType;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.QuestionDialogOpener;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.dialogs.AboutDialog;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.dialogs.ResetSettingsDialog;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.dialogs.RunDialog;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.dialogs.SettingsDialog;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.dialogs.SimpleDialog;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.dialogs.WorkspaceDialog;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts.BasicSettingsObsSimPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts.BasicSettingsPopGenPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts.FilterSettingsPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts.GroundBasedLocationsPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts.NetworkPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts.OpticalSensorsPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts.OutputCategoryPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts.OutputSubjectPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts.PlotOutputObjectPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts.PlotSettingsPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts.PopulationSettingsObsSimPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts.PopulationSettingsPopGenPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts.RadarSensorsPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts.SettingsOverviewPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts.SpaceBasedLocationsPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts.TextOutputObjectPart;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class View
implements IView {
    public static final int SPINNER_DIGITS = 4;
    private static Map<PartType, Class<? extends IPart>> partImplClasses = new HashMap<PartType, Class<? extends IPart>>();
    private static Map<DialogType, Class<? extends IDialog>> dialogImplClasses = new HashMap<DialogType, Class<? extends IDialog>>();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    static {
        partImplClasses.put(PartType.FILTER_SETTINGS, FilterSettingsPart.class);
        partImplClasses.put(PartType.BASIC_SETTINGS_OBSSIM, BasicSettingsObsSimPart.class);
        partImplClasses.put(PartType.HISTOGRAM_SETTINGS_2D_OBSSIM, PlotSettingsPart.class);
        partImplClasses.put(PartType.HISTOGRAM_SETTINGS_3D_OBSSIM, PlotSettingsPart.class);
        partImplClasses.put(PartType.GROUND_BASED_LOCATION_SETTINGS, GroundBasedLocationsPart.class);
        partImplClasses.put(PartType.SPACE_BASED_LOCATIONS_SETTINGS, SpaceBasedLocationsPart.class);
        partImplClasses.put(PartType.RADAR_SENSOR_SETTINGS, RadarSensorsPart.class);
        partImplClasses.put(PartType.SCATTER_PLOT_SETTINGS_OBSSIM, PlotSettingsPart.class);
        partImplClasses.put(PartType.NETWORK_SETTINGS, NetworkPart.class);
        partImplClasses.put(PartType.OPTICAL_SENSOR_SETTINGS, OpticalSensorsPart.class);
        partImplClasses.put(PartType.BASIC_SETTINGS_POPGEN, BasicSettingsPopGenPart.class);
        partImplClasses.put(PartType.HISTOGRAM_SETTINGS_2D_POPGEN, PlotSettingsPart.class);
        partImplClasses.put(PartType.HISTOGRAM_SETTINGS_3D_POPGEN, PlotSettingsPart.class);
        partImplClasses.put(PartType.POPULATION_SETTINGS_POPGEN, PopulationSettingsPopGenPart.class);
        partImplClasses.put(PartType.SCATTER_PLOT_SETTINGS_POPGEN, PlotSettingsPart.class);
        partImplClasses.put(PartType.SETTINGS_OVERVIEW, SettingsOverviewPart.class);
        partImplClasses.put(PartType.POPULATION_SETTINGS_OBSSIM, PopulationSettingsObsSimPart.class);
        partImplClasses.put(PartType.OUTPUT_SUBJECT, OutputSubjectPart.class);
        partImplClasses.put(PartType.OUTPUT_CATEGORY, OutputCategoryPart.class);
        partImplClasses.put(PartType.TEXT_OUTPUT_OBJECT, TextOutputObjectPart.class);
        partImplClasses.put(PartType.GNUPLOT_TEXT_OUTPUT_OBJECT, TextOutputObjectPart.class);
        partImplClasses.put(PartType.PLOT_OUTPUT_OBJECT, PlotOutputObjectPart.class);
        dialogImplClasses.put(DialogType.ABOUT, AboutDialog.class);
        dialogImplClasses.put(DialogType.EDIT_OPTIONS, SettingsDialog.class);
        dialogImplClasses.put(DialogType.EXPORT_PROJECT, SimpleDialog.class);
        dialogImplClasses.put(DialogType.IMPORT_PROJECT, SimpleDialog.class);
        dialogImplClasses.put(DialogType.NEW_PROJECT, SimpleDialog.class);
        dialogImplClasses.put(DialogType.OPEN_PROJECT, SimpleDialog.class);
        dialogImplClasses.put(DialogType.REMOVE_PROJECT, SimpleDialog.class);
        dialogImplClasses.put(DialogType.RESET_SETTINGS, ResetSettingsDialog.class);
        dialogImplClasses.put(DialogType.RUN, RunDialog.class);
        dialogImplClasses.put(DialogType.SAVE_PROJECT_AS, SimpleDialog.class);
        dialogImplClasses.put(DialogType.SAVE_PROJECT_AS_PDF, SimpleDialog.class);
        dialogImplClasses.put(DialogType.SELECT_WORKSPACE, WorkspaceDialog.class);
    }

    public Class<? extends IPart> getPartImplementationClass(PartType partType) {
        this.logger.trace("getPartImplementationClass(partType={})", (Object)partType);
        return partImplClasses.get(partType);
    }

    public Class<? extends IDialog> getDialogImplementationClass(DialogType dialogType) {
        this.logger.trace("getDialogImplementationClass");
        return dialogImplClasses.get(dialogType);
    }

    public void fillDialogContext(DialogType dialogType, Path defaultFolderPath, IEclipseContext dialogContext) {
        this.logger.trace("fillDialogContext(dialogType={}, defaultFolderPath={})", (Object)dialogType, (Object)defaultFolderPath);
        switch (dialogType) {
            case ABOUT: {
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.title", (Object)"About ESA NEOPOP");
                break;
            }
            case EDIT_OPTIONS: {
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.title", (Object)"Edit Settings");
                break;
            }
            case EXPORT_PROJECT: {
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.title", (Object)"Export Project");
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.event_topic", (Object)"de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/project/exoort");
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.first_row", (Object)SimpleDialog.RowType.FOLDER);
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.second_row", (Object)SimpleDialog.RowType.FILE);
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.file_row_type", (Object)8192);
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.default_folder_path", (Object)defaultFolderPath);
                break;
            }
            case IMPORT_PROJECT: {
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.title", (Object)"Import Project");
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.event_topic", (Object)"de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/project/import");
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.first_row", (Object)SimpleDialog.RowType.FILE);
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.second_row", (Object)SimpleDialog.RowType.FOLDER);
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.file_row_type", (Object)4096);
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.default_folder_path", (Object)defaultFolderPath);
                break;
            }
            case NEW_PROJECT: {
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.title", (Object)"New Project");
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.event_topic", (Object)"de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/project/createAndOpen");
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.first_row", (Object)SimpleDialog.RowType.FOLDER);
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.default_folder_path", (Object)defaultFolderPath);
                break;
            }
            case OPEN_PROJECT: {
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.title", (Object)"Open Project");
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.event_topic", (Object)"de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/project/open");
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.first_row", (Object)SimpleDialog.RowType.FOLDER);
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.default_folder_path", (Object)defaultFolderPath);
                break;
            }
            case REMOVE_PROJECT: {
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.title", (Object)"Remove Project");
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.event_topic", (Object)"de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/project/remove");
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.first_row", (Object)SimpleDialog.RowType.FOLDER);
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.default_folder_path", (Object)defaultFolderPath);
                break;
            }
            case RESET_SETTINGS: {
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.title", (Object)"Reset Settings");
                break;
            }
            case RUN: {
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.title", (Object)"Run NEOPOP");
                break;
            }
            case SAVE_PROJECT_AS: {
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.title", (Object)"Save Project As");
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.event_topic", (Object)"de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/project/saveAs");
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.first_row", (Object)SimpleDialog.RowType.FOLDER);
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.default_folder_path", (Object)defaultFolderPath);
                break;
            }
            case SAVE_PROJECT_AS_PDF: {
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.title", (Object)"Save Project As PDF");
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.event_topic", (Object)"de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/project/saveAsPDF");
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.first_row", (Object)SimpleDialog.RowType.FILE);
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.file_row_type", (Object)8192);
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.default_folder_path", (Object)defaultFolderPath);
                break;
            }
            case SELECT_WORKSPACE: {
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.title", (Object)"Select NEOPOP Workspace");
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.event_topic", (Object)"de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/workspace/open");
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.first_row", (Object)SimpleDialog.RowType.FOLDER);
                dialogContext.set("de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.default_folder_path", (Object)defaultFolderPath);
                break;
            }
            default: {
                this.logger.error("I don't know this dialog type: {}", (Object)dialogType);
            }
        }
    }

    public Path openFileDialog(String title, Path defaultDirPath) {
        FileDialog dlg = new FileDialog(Display.getDefault().getActiveShell(), 4096);
        dlg.setText(title == null ? "" : title);
        dlg.setFilterPath(defaultDirPath.toString());
        String filePath = dlg.open();
        return filePath == null ? null : FileSystems.getDefault().getPath(filePath, new String[0]);
    }

    public Path openDirDialog(String title, Path defaultDirPath) {
        DirectoryDialog dlg = new DirectoryDialog(Display.getDefault().getActiveShell());
        dlg.setText(title == null ? "" : title);
        dlg.setFilterPath(defaultDirPath.toString());
        String dirPath = dlg.open();
        return dirPath == null ? null : FileSystems.getDefault().getPath(dirPath, new String[0]);
    }

    public void openErrorDialog(final String title, final String msg) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)msg);
            }
        });
    }

    public void openWarningDialog(final String title, final String msg) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)msg);
            }
        });
    }

    public void dispose() {
        ResourceManager.dispose();
        SWTResourceManager.dispose();
    }

    public boolean openQuestionDialog(String title, String question) {
        QuestionDialogOpener questionDialogOpener = new QuestionDialogOpener(title, question);
        Display.getDefault().syncExec((Runnable)questionDialogOpener);
        return questionDialogOpener.isResult();
    }
}

