/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import de.tu_bs.ilr.esa.estec.neopop.gui.util.ExtendedUpdateValueStrategy;
import de.tu_bs.ilr.esa.estec.neopop.gui.util.ModelValidator;
import de.tu_bs.ilr.esa.estec.neopop.model.Input;
import de.tu_bs.ilr.esa.estec.neopop.model.Location;
import de.tu_bs.ilr.esa.estec.neopop.model.LocationType;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawGbModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawNetModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawOptModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawRadModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawSbModule;
import de.tu_bs.ilr.esa.estec.neopop.model.Sensor;
import de.tu_bs.ilr.esa.estec.neopop.model.SensorManifestation;
import de.tu_bs.ilr.esa.estec.neopop.model.SensorSystem;
import de.tu_bs.ilr.esa.estec.neopop.model.SensorType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorManifestationLocationAndSensorController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected DataBindingContext dbc = null;
    protected Map<SensorManifestation, BindingData> bindingData = Collections.synchronizedMap(new HashMap());
    @Inject
    private UISynchronize uiSynch;
    private boolean firstExecution = true;

    @PostConstruct
    public void postConstruct() {
        this.logger.trace("postConstruct()");
    }

    @Inject
    @Optional
    void onProjectOpened(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/projectOpened") Event event, Input input) {
        if (this.firstExecution) {
            this.firstExecution = false;
        } else {
            this.reset(input.getObsSimRawNetModule(), input.getObsSimRawGbModule(), input.getObsSimRawSbModule(), input.getObsSimRawOptModule(), input.getObsSimRawRadModule());
        }
    }

    public void reset(ObsSimRawNetModule obsSimRawNetModule, ObsSimRawGbModule obsSimRawGbModule, ObsSimRawSbModule obsSimRawSbModule, ObsSimRawOptModule obsSimRawOptModule, ObsSimRawRadModule obsSimRawRadModule) {
        this.logger.trace("reset(obsSimRawNetModule={}, obsSimRawGbModule={}, obsSimRawSbModule={}, obsSimRawRadModule={})", new Object[]{obsSimRawNetModule, obsSimRawGbModule, obsSimRawSbModule, obsSimRawRadModule});
        this.logger.info("Resetting sensor manifestation location, location name, sensor and sensor name properties");
        if (this.dbc != null) {
            this.logger.debug("Clearing bindings");
            HashMap<SensorManifestation, BindingData> bindingDataMapCopy = new HashMap<SensorManifestation, BindingData>(this.bindingData);
            for (SensorManifestation sensorManifestation : bindingDataMapCopy.keySet()) {
                this.removeBindings(sensorManifestation);
            }
            this.bindingData.clear();
            this.dbc.dispose();
        }
        this.logger.debug("Preparing");
        HashSet<SensorManifestation> allSensorManifestations = new HashSet<SensorManifestation>();
        for (SensorSystem sensorNetwork : obsSimRawNetModule.getSensorNetworks()) {
            allSensorManifestations.add(sensorNetwork.getReceiver());
            allSensorManifestations.add(sensorNetwork.getTransmitter());
        }
        HashMap<String, Location> groundLocationsByName = new HashMap<String, Location>();
        for (Location location : obsSimRawGbModule.getGroundLocations()) {
            groundLocationsByName.put(location.getName(), location);
        }
        HashMap<String, Location> orbitsByName = new HashMap<String, Location>();
        for (Location location : obsSimRawSbModule.getOrbits()) {
            orbitsByName.put(location.getName(), location);
        }
        HashMap<String, Sensor> opticalTelescopesByName = new HashMap<String, Sensor>();
        for (Sensor telescope : obsSimRawOptModule.getOpticalTelescopes()) {
            opticalTelescopesByName.put(telescope.getName(), telescope);
        }
        HashMap<String, Sensor> radarTelescopesByName = new HashMap<String, Sensor>();
        for (Sensor telescope : obsSimRawRadModule.getRadarTelescopes()) {
            radarTelescopesByName.put(telescope.getName(), telescope);
        }
        this.logger.debug("Doing actual reset");
        for (SensorManifestation sensorManifestation : allSensorManifestations) {
            this.logger.debug("Trying to set location referenced by sensor manifestation {}", (Object)sensorManifestation);
            LocationType locationType = sensorManifestation.getParent().getLocationType();
            if (locationType != null) {
                String locationName;
                HashMap<String, Location> locationCandidatesByName = locationType == LocationType.GROUND_BASED ? groundLocationsByName : orbitsByName;
                Location referencedLocation = (Location)locationCandidatesByName.get(locationName = sensorManifestation.getLocationName());
                if (referencedLocation != null) {
                    sensorManifestation.setLocation(referencedLocation);
                } else {
                    this.logger.error("Could not find location referenced by name \"{}\" by sensor manifestation {} in {} location candidates: {}", new Object[]{locationName, sensorManifestation, locationType, locationCandidatesByName});
                    sensorManifestation.setLocation(null);
                }
            } else {
                this.logger.error("Could not search for location referenced by sensor manifestation {}, since locationType is null", (Object)sensorManifestation);
                sensorManifestation.setLocation(null);
            }
            this.logger.debug("Trying to set sensor referenced by sensor manifestation {}", (Object)sensorManifestation);
            SensorType sensorType = sensorManifestation.getParent().getSensorType();
            if (sensorType != null) {
                String sensorName;
                HashMap<String, Sensor> sensorCandidatesByName = sensorType == SensorType.OPTICAL ? opticalTelescopesByName : radarTelescopesByName;
                Sensor referencedTelescope = (Sensor)sensorCandidatesByName.get(sensorName = sensorManifestation.getSensorName());
                if (referencedTelescope != null) {
                    sensorManifestation.setTelescope(referencedTelescope);
                } else {
                    this.logger.error("Could not find sensor referenced by name \"{}\" by sensor manifestation {} in {} telescope candidates: {}", new Object[]{sensorName, sensorManifestation, sensorType, sensorCandidatesByName});
                    sensorManifestation.setTelescope(null);
                }
            } else {
                this.logger.error("Could not search for sensor referenced by sensor manifestation {}, since sensorType is null", (Object)sensorManifestation);
                sensorManifestation.setTelescope(null);
            }
            this.createBindings(sensorManifestation);
        }
    }

    private void createBindings(SensorManifestation sensorManifestation) {
        this.logger.trace("createBindings(sensorManifestation={})", (Object)sensorManifestation);
        this.logger.debug("Creating bindings for sensor manifestation {}", (Object)sensorManifestation);
        if (!this.bindingData.containsKey(sensorManifestation)) {
            this.bindingData.put(sensorManifestation, new BindingData());
        }
        BindingData bindingData = this.bindingData.get(sensorManifestation);
        this.createBindings(sensorManifestation, bindingData.locationData, "location", "locationName", "name");
        this.createBindings(sensorManifestation, bindingData.telescopeData, "telescope", "sensorName", "name");
    }

    private void createBindings(final SensorManifestation sensorManifestation, final LocationOrTelescopeBindingData locationOrTelescopeBindingData, final String locationOrTelescopeProperty, final String locationOrTelescopeNameProperty, final String referencedLocationOrTelescopeNameProperty) {
        this.logger.trace("createBindings(sensorManifestation={}, locationOrTelescopeProperty={}, locationOrTelescopeNameProperty={}, referencedLocationOrTelescopeNameProperty={})", new Object[]{sensorManifestation, locationOrTelescopeProperty, locationOrTelescopeNameProperty, referencedLocationOrTelescopeNameProperty});
        this.logger.debug("Creating bindings for {}", (Object)sensorManifestation);
        if (this.dbc == null) {
            this.logger.debug("Creating data binding context");
            this.dbc = new DataBindingContext();
        }
        this.uiSynch.syncExec(new Runnable(){

            @Override
            public void run() {
                SensorManifestationLocationAndSensorController.this.logger.debug("Creating location/telescope writable binding");
                locationOrTelescopeBindingData.locationOrTelescopeObservable = BeanProperties.value((String)locationOrTelescopeProperty).observe((Object)sensorManifestation);
                WritableValue locationOrTelescopeWritable = new WritableValue();
                locationOrTelescopeBindingData.locationOrTelescopeBinding = SensorManifestationLocationAndSensorController.this.dbc.bindValue((IObservableValue)locationOrTelescopeWritable, locationOrTelescopeBindingData.locationOrTelescopeObservable);
                SensorManifestationLocationAndSensorController.this.logger.debug("Creating actual location/telescope name binding");
                locationOrTelescopeBindingData.locationOrTelescopeNameObservable = BeanProperties.value((String)locationOrTelescopeNameProperty).observe((Object)sensorManifestation);
                locationOrTelescopeBindingData.referencedLocationOrTelescopeNameObservable = BeanProperties.value((String)referencedLocationOrTelescopeNameProperty).observeDetail((IObservableValue)locationOrTelescopeWritable);
                ExtendedUpdateValueStrategy referencedNameToNameUVS = new ExtendedUpdateValueStrategy();
                referencedNameToNameUVS.setBeforeSetValidator((IValidator)new ModelValidator((Object)sensorManifestation, locationOrTelescopeNameProperty));
                locationOrTelescopeBindingData.locationOrTelescopeNameBinding = SensorManifestationLocationAndSensorController.this.dbc.bindValue(locationOrTelescopeBindingData.locationOrTelescopeNameObservable, locationOrTelescopeBindingData.referencedLocationOrTelescopeNameObservable, null, (UpdateValueStrategy)referencedNameToNameUVS);
            }
        });
    }

    public void removeBindings(SensorSystem network) {
        this.logger.trace("removeBindings(network={})", (Object)network);
        this.logger.debug("Removing bindings for sensor network {}", (Object)network);
        this.removeBindings(network.getReceiver());
        this.removeBindings(network.getTransmitter());
    }

    public void createBindings(SensorSystem network) {
        this.logger.trace("createBindings(network={})", (Object)network);
        this.logger.debug("Creating bindings for sensor network {}", (Object)network);
        this.createBindings(network.getReceiver());
        this.createBindings(network.getTransmitter());
    }

    private void removeBindings(SensorManifestation sensorManifestation) {
        this.logger.trace("removeBindings(sensorManifestation={})", (Object)sensorManifestation);
        final BindingData bindingData = this.bindingData.remove(sensorManifestation);
        this.uiSynch.syncExec(new Runnable(){

            @Override
            public void run() {
                SensorManifestationLocationAndSensorController.this.dbc.removeBinding(bindingData.locationData.locationOrTelescopeNameBinding);
                SensorManifestationLocationAndSensorController.this.dbc.removeBinding(bindingData.locationData.locationOrTelescopeBinding);
                bindingData.locationData.locationOrTelescopeNameBinding.dispose();
                bindingData.locationData.locationOrTelescopeBinding.dispose();
                bindingData.locationData.locationOrTelescopeNameObservable.dispose();
                bindingData.locationData.referencedLocationOrTelescopeNameObservable.dispose();
                bindingData.locationData.locationOrTelescopeObservable.dispose();
                SensorManifestationLocationAndSensorController.this.dbc.removeBinding(bindingData.telescopeData.locationOrTelescopeNameBinding);
                SensorManifestationLocationAndSensorController.this.dbc.removeBinding(bindingData.telescopeData.locationOrTelescopeBinding);
                bindingData.telescopeData.locationOrTelescopeNameBinding.dispose();
                bindingData.telescopeData.locationOrTelescopeBinding.dispose();
                bindingData.telescopeData.locationOrTelescopeNameObservable.dispose();
                bindingData.telescopeData.referencedLocationOrTelescopeNameObservable.dispose();
                bindingData.telescopeData.locationOrTelescopeObservable.dispose();
            }
        });
    }

    class BindingData {
        public LocationOrTelescopeBindingData locationData;
        public LocationOrTelescopeBindingData telescopeData;

        BindingData() {
            this.locationData = new LocationOrTelescopeBindingData();
            this.telescopeData = new LocationOrTelescopeBindingData();
        }
    }

    class LocationOrTelescopeBindingData {
        public volatile IObservableValue locationOrTelescopeObservable;
        public volatile IObservableValue locationOrTelescopeNameObservable;
        public volatile IObservableValue referencedLocationOrTelescopeNameObservable;
        public volatile Binding locationOrTelescopeBinding;
        public volatile Binding locationOrTelescopeNameBinding;

        LocationOrTelescopeBindingData() {
        }
    }
}

