/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.PresenterUtil;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.DialogType;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.IView;
import de.tu_bs.ilr.esa.estec.neopop.model.Model;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveProjectController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    protected IEventBroker eventBroker;

    @PostConstruct
    void postConstruct() {
        this.logger.trace("postConstruct");
    }

    @Inject
    @Optional
    void removeProject(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/project/remove") Path projDirPath, Model model, IView view, PresenterUtil presenterUtil) {
        this.logger.trace("removeProject(projDirPath={})", (Object)projDirPath);
        this.logger.info("Removing project {}", (Object)projDirPath);
        if (model.getWorkspace().getProject().getPath().equals(projDirPath)) {
            this.rebound("You can't remove the project you are currently working on!", DialogType.REMOVE_PROJECT, projDirPath, view, presenterUtil);
            return;
        }
        if (!projDirPath.resolve("neopop.cfg").toFile().exists()) {
            this.rebound(projDirPath + "  is no project!", DialogType.REMOVE_PROJECT, projDirPath, view, presenterUtil);
            return;
        }
        try {
            Files.walkFileTree(projDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return super.visitFile(file, attrs);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return super.postVisitDirectory(dir, exc);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void rebound(String errorMsg, DialogType dialogType, Path defaultFolderPath, IView view, PresenterUtil presenterUtil) {
        this.logger.error(errorMsg);
        view.openErrorDialog("Error", errorMsg);
        presenterUtil.sendCreateAndOpenDialogEvent(dialogType, defaultFolderPath);
    }
}

