/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.PresenterUtil;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.DialogType;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.IView;
import de.tu_bs.ilr.esa.estec.neopop.model.Model;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostConstruct
    void postConstruct() {
        this.logger.trace("postConstruct");
    }

    @Inject
    @Optional
    void exportProject(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/project/exoort") Event event, Model model, IView view, PresenterUtil presenterUtil) {
        block15: {
            this.logger.trace("exportProject");
            Path sourceProjectPath = (Path)event.getProperty("de/tu-bs/ilr/esa/estec/neopop/folderPath");
            Path targetFilePath = (Path)event.getProperty("de/tu-bs/ilr/esa/estec/neopop/filePath");
            this.logger.info("Exporting project {} to file {}", (Object)sourceProjectPath, (Object)targetFilePath);
            if (!presenterUtil.isValidProjectDirPath(sourceProjectPath)) {
                presenterUtil.reboundWithError("You selected an invalid folder", DialogType.EXPORT_PROJECT, sourceProjectPath, view);
                return;
            }
            if (!presenterUtil.isValidProjectExportTargetFilePath(targetFilePath)) {
                presenterUtil.reboundWithError("Target file path is invalid", DialogType.EXPORT_PROJECT, sourceProjectPath, view);
                return;
            }
            if (targetFilePath.toFile().exists() && targetFilePath.toFile().isFile() && !view.openQuestionDialog("File already exists", "The file you selected already exists. Do you want to overwrite it ?")) {
                presenterUtil.rebound(DialogType.EXPORT_PROJECT, sourceProjectPath, view);
                return;
            }
            ZipOutputStream zos = null;
            try {
                try {
                    FileOutputStream fos = new FileOutputStream(targetFilePath.toString());
                    final ZipOutputStream zosFinal = zos = new ZipOutputStream(fos);
                    final Path basePath = sourceProjectPath;
                    Files.walkFileTree(basePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes attrs) throws IOException {
                            if (dirPath.endsWith("data")) {
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                            this.createDirEntry(dirPath);
                            return FileVisitResult.CONTINUE;
                        }

                        private String createZipPath(Path path, boolean dir) {
                            Path relativePath = basePath.relativize(path);
                            String zipPath = "";
                            for (Path pathPart : relativePath) {
                                zipPath = String.valueOf(zipPath) + pathPart;
                                if (!dir && relativePath.endsWith(pathPart)) continue;
                                zipPath = String.valueOf(zipPath) + "/";
                            }
                            return zipPath;
                        }

                        private void createDirEntry(Path dirPath) {
                            String zipDirPath = this.createZipPath(dirPath, true);
                            ZipEntry dirZipEntry = new ZipEntry(zipDirPath);
                            try {
                                zosFinal.putNextEntry(dirZipEntry);
                                zosFinal.closeEntry();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) throws IOException {
                            if (!filePath.endsWith("data")) {
                                this.compress(filePath);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        private void compress(Path filePath) {
                            block13: {
                                FileInputStream fis = null;
                                try {
                                    try {
                                        String zipFilePath = this.createZipPath(filePath, false);
                                        ZipEntry fileZipEntry = new ZipEntry(zipFilePath);
                                        zosFinal.putNextEntry(fileZipEntry);
                                        fis = new FileInputStream(filePath.toFile());
                                        byte[] buffer = new byte[1024];
                                        int bytesRead = 0;
                                        bytesRead = fis.read(buffer, 0, 1024);
                                        while (bytesRead != -1) {
                                            zosFinal.write(buffer, 0, bytesRead);
                                            bytesRead = fis.read(buffer, 0, 1024);
                                        }
                                        zosFinal.closeEntry();
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                        if (fis == null) break block13;
                                        try {
                                            fis.close();
                                        }
                                        catch (IOException e2) {
                                            e2.printStackTrace();
                                        }
                                    }
                                }
                                finally {
                                    if (fis != null) {
                                        try {
                                            fis.close();
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }
                            }
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (zos == null) break block15;
                    try {
                        zos.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (zos != null) {
                    try {
                        zos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

