/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.model;

import de.tu_bs.ilr.esa.estec.neopop.model.GUIInterfacePart;
import de.tu_bs.ilr.esa.estec.neopop.model.Input;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElement;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElementCreator;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElementListContainer;
import de.tu_bs.ilr.esa.estec.neopop.model.ObservatoryCode;
import de.tu_bs.ilr.esa.estec.neopop.model.Vars;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObsSimRawOclModule
extends InputElement {
    public static final String PROP_OBSERVATORY_CODES = "observatoryCodes";
    public static final int MAX_OBSERVATORY_CODES = 3000;
    private InputElementListContainer<ObservatoryCode> observatoryCodes;
    private Map<String, ObservatoryCode> observatoryCodesByString = new HashMap<String, ObservatoryCode>();

    protected ObsSimRawOclModule(Input parent) {
        super(GUIInterfacePart.OBSSIM, parent, new int[0]);
        final ObsSimRawOclModule module = this;
        this.observatoryCodes = new InputElementListContainer<ObservatoryCode>(this, 3000, new InputElementCreator<ObservatoryCode>(){

            @Override
            public ObservatoryCode create(int additionalIndex) {
                return new ObservatoryCode(module, additionalIndex);
            }
        }, PROP_OBSERVATORY_CODES, Vars.OBSSIM_INT_OCL_NUMBER_OF_CODES);
    }

    @Override
    public void synchIndexedPropertiesWithFortran() {
        super.synchIndexedPropertiesWithFortran();
        this.observatoryCodesByString.clear();
        for (ObservatoryCode code : this.getObservatoryCodes()) {
            this.observatoryCodesByString.put(code.getCode(), code);
        }
    }

    public ObservatoryCode getCodeByString(String code) {
        return this.observatoryCodesByString.get(code);
    }

    public List<ObservatoryCode> getObservatoryCodes() {
        return this.observatoryCodes.get();
    }

    public ObservatoryCode addGroundBasedLocation() {
        return this.observatoryCodes.add();
    }

    public void removeGroundBasedLocation(ObservatoryCode value) {
        this.observatoryCodes.remove(value);
    }
}

