/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessBuffer;
import org.apache.pdfbox.io.RandomAccessFile;
import org.apache.pdfbox.pdfparser.PDFObjectStreamParser;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.persistence.util.COSObjectKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class COSDocument
extends COSBase
implements Closeable {
    private static final Log LOG = LogFactory.getLog(COSDocument.class);
    private float version = 1.4f;
    private final Map<COSObjectKey, COSObject> objectPool = new HashMap<COSObjectKey, COSObject>();
    private final Map<COSObjectKey, Long> xrefTable = new HashMap<COSObjectKey, Long>();
    private COSDictionary trailer;
    private SignatureInterface signatureInterface;
    private final RandomAccess scratchFile;
    private final File tmpFile;
    private String headerString = "%PDF-" + this.version;
    private boolean warnMissingClose = true;
    private boolean isDecrypted = false;
    private long startXref;
    private boolean closed = false;
    private final boolean forceParsing;

    public COSDocument(RandomAccess scratchFileValue, boolean forceParsingValue) {
        this.scratchFile = scratchFileValue;
        this.tmpFile = null;
        this.forceParsing = forceParsingValue;
    }

    public COSDocument(File scratchDir, boolean forceParsingValue) throws IOException {
        this.tmpFile = File.createTempFile("pdfbox-", ".tmp", scratchDir);
        this.scratchFile = new RandomAccessFile(this.tmpFile, "rw");
        this.forceParsing = forceParsingValue;
    }

    public COSDocument() {
        this(new RandomAccessBuffer(), false);
    }

    public COSDocument(File scratchDir) throws IOException {
        this(scratchDir, false);
    }

    public COSDocument(RandomAccess file) {
        this(file, false);
    }

    public RandomAccess getScratchFile() {
        if (!this.closed) {
            return this.scratchFile;
        }
        LOG.error("Can't access the scratch file as it is already closed!");
        return null;
    }

    public COSStream createCOSStream() {
        return new COSStream(this.getScratchFile());
    }

    public COSStream createCOSStream(COSDictionary dictionary) {
        return new COSStream(dictionary, this.getScratchFile());
    }

    public COSObject getObjectByType(String type) throws IOException {
        return this.getObjectByType(COSName.getPDFName(type));
    }

    public COSObject getObjectByType(COSName type) throws IOException {
        for (COSObject object : this.objectPool.values()) {
            COSBase realObject = object.getObject();
            if (!(realObject instanceof COSDictionary)) continue;
            try {
                COSDictionary dic = (COSDictionary)realObject;
                COSBase typeItem = dic.getItem(COSName.TYPE);
                if (typeItem != null && typeItem instanceof COSName) {
                    COSName objectType = (COSName)typeItem;
                    if (!objectType.equals(type)) continue;
                    return object;
                }
                if (typeItem == null) continue;
                LOG.debug("Expected a /Name object after /Type, got '" + typeItem + "' instead");
            }
            catch (ClassCastException e) {
                LOG.warn(e, e);
            }
        }
        return null;
    }

    public List<COSObject> getObjectsByType(String type) throws IOException {
        return this.getObjectsByType(COSName.getPDFName(type));
    }

    public List<COSObject> getObjectsByType(COSName type) throws IOException {
        ArrayList<COSObject> retval = new ArrayList<COSObject>();
        for (COSObject object : this.objectPool.values()) {
            COSBase realObject = object.getObject();
            if (!(realObject instanceof COSDictionary)) continue;
            try {
                COSDictionary dic = (COSDictionary)realObject;
                COSBase typeItem = dic.getItem(COSName.TYPE);
                if (typeItem != null && typeItem instanceof COSName) {
                    COSName objectType = (COSName)typeItem;
                    if (!objectType.equals(type)) continue;
                    retval.add(object);
                    continue;
                }
                if (typeItem == null) continue;
                LOG.debug("Expected a /Name object after /Type, got '" + typeItem + "' instead");
            }
            catch (ClassCastException e) {
                LOG.warn(e, e);
            }
        }
        return retval;
    }

    public void print() {
        for (COSObject object : this.objectPool.values()) {
            System.out.println(object);
        }
    }

    public void setVersion(float versionValue) {
        if (versionValue != this.version) {
            this.headerString = this.headerString.replaceFirst(String.valueOf(this.version), String.valueOf(versionValue));
        }
        this.version = versionValue;
    }

    public float getVersion() {
        return this.version;
    }

    public void setDecrypted() {
        this.isDecrypted = true;
    }

    public boolean isEncrypted() {
        if (this.isDecrypted) {
            return false;
        }
        boolean encrypted = false;
        if (this.trailer != null) {
            encrypted = this.trailer.getDictionaryObject(COSName.ENCRYPT) != null;
        }
        return encrypted;
    }

    public COSDictionary getEncryptionDictionary() {
        return (COSDictionary)this.trailer.getDictionaryObject(COSName.ENCRYPT);
    }

    public SignatureInterface getSignatureInterface() {
        return this.signatureInterface;
    }

    public void setEncryptionDictionary(COSDictionary encDictionary) {
        this.trailer.setItem(COSName.ENCRYPT, (COSBase)encDictionary);
    }

    public List<COSDictionary> getSignatureDictionaries() throws IOException {
        List<COSDictionary> signatureFields = this.getSignatureFields(false);
        LinkedList<COSDictionary> signatures = new LinkedList<COSDictionary>();
        for (COSDictionary dict : signatureFields) {
            COSBase dictionaryObject = dict.getDictionaryObject(COSName.V);
            if (dictionaryObject == null) continue;
            signatures.add((COSDictionary)dictionaryObject);
        }
        return signatures;
    }

    public List<COSDictionary> getSignatureFields(boolean onlyEmptyFields) throws IOException {
        COSArray fields;
        COSDictionary acroForm;
        COSObject documentCatalog = this.getCatalog();
        if (documentCatalog != null && (acroForm = (COSDictionary)documentCatalog.getDictionaryObject(COSName.ACRO_FORM)) != null && (fields = (COSArray)acroForm.getDictionaryObject(COSName.FIELDS)) != null) {
            HashMap<COSObjectKey, COSDictionary> signatures = new HashMap<COSObjectKey, COSDictionary>();
            for (COSBase object : fields) {
                COSBase dictionaryObject;
                COSObject dict = (COSObject)object;
                if (!COSName.SIG.equals(dict.getItem(COSName.FT)) || (dictionaryObject = dict.getDictionaryObject(COSName.V)) != null && (dictionaryObject == null || onlyEmptyFields)) continue;
                signatures.put(new COSObjectKey(dict), (COSDictionary)dict.getObject());
            }
            return new LinkedList<COSDictionary>(signatures.values());
        }
        return Collections.emptyList();
    }

    public COSArray getDocumentID() {
        return (COSArray)this.getTrailer().getDictionaryObject(COSName.ID);
    }

    public void setDocumentID(COSArray id) {
        this.getTrailer().setItem(COSName.ID, (COSBase)id);
    }

    public void setSignatureInterface(SignatureInterface sigInterface) {
        this.signatureInterface = sigInterface;
    }

    public COSObject getCatalog() throws IOException {
        COSObject catalog = this.getObjectByType(COSName.CATALOG);
        if (catalog == null) {
            throw new IOException("Catalog cannot be found");
        }
        return catalog;
    }

    public List<COSObject> getObjects() {
        return new ArrayList<COSObject>(this.objectPool.values());
    }

    public COSDictionary getTrailer() {
        return this.trailer;
    }

    public void setTrailer(COSDictionary newTrailer) {
        this.trailer = newTrailer;
    }

    @Override
    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromDocument(this);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            List<COSObject> list;
            this.scratchFile.close();
            if (this.tmpFile != null) {
                this.tmpFile.delete();
            }
            if (this.trailer != null) {
                this.trailer.clear();
                this.trailer = null;
            }
            if ((list = this.getObjects()) != null && !list.isEmpty()) {
                for (COSObject object : list) {
                    COSBase cosObject = object.getObject();
                    if (cosObject instanceof COSStream) {
                        ((COSStream)cosObject).close();
                        continue;
                    }
                    if (cosObject instanceof COSDictionary) {
                        ((COSDictionary)cosObject).clear();
                        continue;
                    }
                    if (!(cosObject instanceof COSArray)) continue;
                    ((COSArray)cosObject).clear();
                }
                list.clear();
            }
            this.closed = true;
        }
    }

    protected void finalize() throws IOException {
        if (!this.closed) {
            if (this.warnMissingClose) {
                LOG.warn("Warning: You did not close a PDF Document");
            }
            this.close();
        }
    }

    public void setWarnMissingClose(boolean warn) {
        this.warnMissingClose = warn;
    }

    public String getHeaderString() {
        return this.headerString;
    }

    public void setHeaderString(String header) {
        this.headerString = header;
    }

    public void dereferenceObjectStreams() throws IOException {
        for (COSObject objStream : this.getObjectsByType(COSName.OBJ_STM)) {
            COSStream stream = (COSStream)objStream.getObject();
            PDFObjectStreamParser parser = new PDFObjectStreamParser(stream, this, this.forceParsing);
            parser.parse();
            for (COSObject next : parser.getObjects()) {
                COSObjectKey key = new COSObjectKey(next);
                if (this.objectPool.get(key) != null && this.objectPool.get(key).getObject() != null && (!this.xrefTable.containsKey(key) || this.xrefTable.get(key) != -objStream.getObjectNumber().longValue())) continue;
                COSObject obj = this.getObjectFromPool(key);
                obj.setObject(next.getObject());
            }
        }
    }

    public COSObject getObjectFromPool(COSObjectKey key) throws IOException {
        COSObject obj = null;
        if (key != null) {
            obj = this.objectPool.get(key);
        }
        if (obj == null) {
            obj = new COSObject(null);
            if (key != null) {
                obj.setObjectNumber(COSInteger.get(key.getNumber()));
                obj.setGenerationNumber(COSInteger.get(key.getGeneration()));
                this.objectPool.put(key, obj);
            }
        }
        return obj;
    }

    public COSObject removeObject(COSObjectKey key) {
        return this.objectPool.remove(key);
    }

    public void addXRefTable(Map<COSObjectKey, Long> xrefTableValues) {
        this.xrefTable.putAll(xrefTableValues);
    }

    public Map<COSObjectKey, Long> getXrefTable() {
        return this.xrefTable;
    }

    public void setStartXref(long startXrefValue) {
        this.startXref = startXrefValue;
    }

    public long getStartXref() {
        return this.startXref;
    }

    public boolean isXRefStream() {
        if (this.trailer != null) {
            return COSName.XREF.equals(this.trailer.getItem(COSName.TYPE));
        }
        return false;
    }
}

