/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import de.tu_bs.ilr.esa.estec.neopop.gui.view.IView;
import de.tu_bs.ilr.esa.estec.neopop.model.Model;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenPDFController {
    public static final String HELP_PDF_FILE_NAME = "SGNEOP_SUM.pdf";
    public static final String PLOT_HELP_PDF_FILE_NAME = "gnuplot.pdf";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private IView view;

    @PostConstruct
    void postConstruct() {
        this.logger.trace("postConstruct");
    }

    @Inject
    @Optional
    public void openHelpPDF(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/help") Event event, Model model) {
        this.logger.trace("openHelpPDF()");
        this.logger.info("Opening help PDF");
        this.openPDF(HELP_PDF_FILE_NAME, model.getPdfViewerExeFilePath());
    }

    @Inject
    @Optional
    public void openPlotHelpPDF(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/plotHelp") Event event, Model model) {
        this.logger.trace("openPlotHelpPDF()");
        this.logger.info("Opening plot help PDF");
        this.openPDF(PLOT_HELP_PDF_FILE_NAME, model.getPdfViewerExeFilePath());
    }

    private void openPDF(String pdfFileName, String pdfViewerExeFilePathString) {
        this.logger.trace("openPDF(pdfFileName={}, pdfViewerExeFilePath={})", (Object)pdfFileName, (Object)pdfViewerExeFilePathString);
        Path pdfFilePath = FileSystems.getDefault().getPath(System.getProperty("user.dir"), "..", "docu", pdfFileName);
        this.logger.debug("Opening PDF \"{}\" using PDF viewer \"{}\"", (Object)pdfFilePath, (Object)pdfViewerExeFilePathString);
        if (pdfViewerExeFilePathString == null || pdfViewerExeFilePathString.equals("")) {
            this.logger.error("PDF viewer exe file path not set");
            this.view.openErrorDialog("PDF viewer not set", "PDF viewer has not been set.\nPlease click on the settings button in the toolbar to do so.");
            return;
        }
        try {
            Runtime.getRuntime().exec(new String[]{pdfViewerExeFilePathString, pdfFilePath.toString()});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

