/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import de.tu_bs.ilr.esa.estec.neopop.model.ModelElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelPrintController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Deque<String> propertyStack = new ArrayDeque<String>();
    protected StringBuilder sb = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @PostConstruct
    public void postConstruct() {
        this.logger.trace("postConstruct");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public void print(ModelElement element) {
        this.logger.trace("print(element={})", (Object)element);
        this.logger.debug("Printing model element {}", (Object)element);
        this.sb = new StringBuilder();
        this.printValueLines(element.getClass().getSimpleName().toLowerCase(), element);
        this.logger.debug(this.sb.toString());
    }

    @Inject
    @Optional
    public void processModelPrintEvent(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/model/print") ModelElement modelElement) {
        this.logger.trace("processModelPrintEvent");
        this.print(modelElement);
    }

    private void printValueLines(String property, List<?> list) {
        this.printValueLine(property, "List");
        int index = 0;
        for (Object object : list) {
            if (object instanceof ModelElement) {
                this.printValueLines(String.valueOf(property) + "[" + index + "]", (ModelElement)object);
            } else {
                this.printValueLine(String.valueOf(property) + "[" + index + "]", object);
            }
            ++index;
        }
    }

    private void printValueLines(String property, ModelElement element) {
        this.printValueLine(property, element);
        this.propertyStack.push(property);
        this.printModelElement(element);
        this.propertyStack.pop();
    }

    protected void printValueLine(String property, Object value) {
        this.sb.append("\n");
        this.propertyStack.push(property);
        boolean first = true;
        Iterator<String> bottomUpIt = this.propertyStack.descendingIterator();
        while (bottomUpIt.hasNext()) {
            String currentProperty = bottomUpIt.next();
            if (first) {
                first = false;
            } else {
                this.sb.append(".");
            }
            this.sb.append(currentProperty);
        }
        this.sb.append("=");
        this.sb.append(value instanceof Date ? this.dateFormat.format((Date)value) : value);
        this.propertyStack.pop();
    }

    /*
     * WARNING - void declaration
     */
    private void printModelElement(ModelElement element) {
        void var5_8;
        this.logger.debug("current element: {}", (Object)element);
        Object[] declaredFields = element.getClass().getFields();
        this.logger.debug("fields: {}", (Object)Arrays.toString(declaredFields));
        LinkedList<Object> propertyFields = new LinkedList<Object>();
        Object[] objectArray = declaredFields;
        int n = declaredFields.length;
        boolean n2 = false;
        while (var5_8 < n) {
            int modifiers;
            Object field = objectArray[var5_8];
            if (((Field)field).getType() == String.class && Modifier.isStatic(modifiers = ((Field)field).getModifiers()) && Modifier.isFinal(modifiers) && ((Field)field).getName().startsWith("PROP_")) {
                propertyFields.add(field);
            }
            ++var5_8;
        }
        this.logger.debug("property fields: {}", propertyFields);
        LinkedList<String> properties = new LinkedList<String>();
        for (Field field : propertyFields) {
            String property = null;
            try {
                property = (String)field.get(null);
                properties.add(property);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        this.logger.debug("properties: {}", properties);
        Collections.sort(properties);
        this.logger.debug("properties, sorted: {}", properties);
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        for (String property : properties) {
            String getMethodName = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
            Method getMethod = null;
            try {
                getMethod = element.getClass().getMethod(getMethodName, new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
            hashMap.put(property, getMethod);
        }
        this.logger.debug("property get methods: {}", hashMap);
        for (String property : properties) {
            Object value = null;
            try {
                value = ((Method)hashMap.get(property)).invoke((Object)element, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.logger.error("Internal software problem - see log for details");
                this.logger.debug("Caught exception: ", (Throwable)e);
            }
            if (value instanceof ModelElement) {
                this.printValueLines(property, (ModelElement)value);
                continue;
            }
            if (value instanceof List) {
                this.printValueLines(property, (List)value);
                continue;
            }
            if (value instanceof Map) {
                this.printValueLines(property, (Map)value);
                continue;
            }
            this.printValueLine(property, value);
        }
    }

    private void printValueLines(String property, Map<?, ?> map) {
        this.printValueLine(property, "Map");
        for (Object key : map.keySet()) {
            Object val = map.get(key);
            if (val instanceof ModelElement) {
                this.printValueLines(String.valueOf(property) + "[" + key + "]", (ModelElement)val);
                continue;
            }
            this.printValueLine(String.valueOf(property) + "[" + key + "]", val);
        }
    }
}

