/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import de.tu_bs.ilr.esa.estec.neopop.model.Input;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputCheckController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    IEventBroker eventBroker;
    private InputElement badInputElement = null;
    private String badProperty = null;
    private Object badValue = null;

    @PostConstruct
    public void postConstruct() {
        this.logger.trace("postConstruct");
    }

    @Inject
    @Optional
    void checkInput(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/input/check") Event event, Input input) {
        this.logger.trace("checkInput");
        this.logger.info("Checking NEOPOP input data");
        boolean result = this.checkInputElement((InputElement)input);
        this.logger.info("NEOPOP input data checked. Result: " + (result ? "Everything ok!" : "There is at least one invalid input value."));
        HashMap<String, Object> eventPropertyMap = new HashMap<String, Object>();
        eventPropertyMap.put("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/inputCheckResult", result);
        if (!result) {
            String problemHint = this.badInputElement + "." + this.badProperty + " is \"" + this.badValue + "\"";
            this.logger.info("Problem hint: {}", (Object)problemHint);
            eventPropertyMap.put("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/inputCheckProblemHint", problemHint);
        }
        this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/input/checked", eventPropertyMap);
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkInputElement(InputElement element) {
        void var5_8;
        this.logger.debug("current element: {}", (Object)element);
        Object[] declaredFields = element.getClass().getFields();
        this.logger.debug("fields: {}", (Object)Arrays.toString(declaredFields));
        LinkedList<Object> propertyFields = new LinkedList<Object>();
        Object[] objectArray = declaredFields;
        int n = declaredFields.length;
        boolean n2 = false;
        while (var5_8 < n) {
            int modifiers;
            Object field = objectArray[var5_8];
            if (((Field)field).getType() == String.class && Modifier.isStatic(modifiers = ((Field)field).getModifiers()) && Modifier.isFinal(modifiers) && ((Field)field).getName().startsWith("PROP_")) {
                propertyFields.add(field);
            }
            ++var5_8;
        }
        this.logger.debug("property fields: {}", propertyFields);
        LinkedList<String> properties = new LinkedList<String>();
        for (Field field : propertyFields) {
            String property = null;
            try {
                property = (String)field.get(null);
                properties.add(property);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        this.logger.debug("properties: {}", properties);
        Collections.sort(properties);
        this.logger.debug("properties, sorted: {}", properties);
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        HashMap propertyCheckMethods = new HashMap();
        for (String property : properties) {
            String getMethodName = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
            Method getMethod = null;
            try {
                getMethod = element.getClass().getMethod(getMethodName, new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
            hashMap.put(property, getMethod);
            Object checkMethod = null;
            String checkMethodName = "check" + property.substring(0, 1).toUpperCase() + property.substring(1);
            Method[] methodArray = element.getClass().getMethods();
            int n3 = methodArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Method method = methodArray[n4];
                if (method.getName().equals(checkMethodName)) {
                    checkMethod = method;
                    break;
                }
                ++n4;
            }
            if (checkMethod == null) continue;
            propertyCheckMethods.put(property, checkMethod);
        }
        this.logger.debug("property get methods: {}", hashMap);
        this.logger.debug("property check methods: {}", propertyCheckMethods);
        for (String property : properties) {
            Object object = null;
            try {
                object = ((Method)hashMap.get(property)).invoke((Object)element, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.logger.error("Internal software problem - see log for details");
                this.logger.debug("Caught exception: ", (Throwable)e);
            }
            if (propertyCheckMethods.containsKey(property)) {
                try {
                    boolean checkResult = (Boolean)((Method)propertyCheckMethods.get(property)).invoke((Object)element, object);
                    if (!checkResult) {
                        this.badInputElement = element;
                        this.badProperty = property;
                        this.badValue = object;
                        return false;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            if (object instanceof InputElement) {
                if (this.checkInputElement((InputElement)object)) continue;
                return false;
            }
            if (object instanceof List) {
                for (Object listObject : (List)object) {
                    if (!(listObject instanceof InputElement) || this.checkInputElement((InputElement)listObject)) continue;
                    return false;
                }
                continue;
            }
            if (!(object instanceof Map)) continue;
            Map map = (Map)object;
            for (Object key : map.keySet()) {
                Object val = map.get(key);
                if (!(val instanceof InputElement) || this.checkInputElement((InputElement)val)) continue;
                return false;
            }
        }
        return true;
    }
}

