/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter;

import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.WorkaroundBufferedImage;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDPixelMap;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;

public class PDFCreator {
    public static float VERTICAL_SPACING = 0.0f;
    public static float PAGE_BORDER = 50.0f;
    public static final float Y_BEGIN = PDPage.PAGE_SIZE_A4.getUpperRightY() - PAGE_BORDER;
    public static final float USABLE_PAGE_WIDTH = PDPage.PAGE_SIZE_A4.getWidth() - PAGE_BORDER * 2.0f;
    public static final float CHAR_WIDTH_RELATIVE_TO_HEIGHT = 0.6025f;
    private PDDocument document = new PDDocument();
    private PDPage page = new PDPage(PDPage.PAGE_SIZE_A4);
    private PDPageContentStream pageContentStream;
    private Path targetPath;
    private boolean beginningOfNewPage = true;
    private boolean defaultBoldness = false;
    private float defaultFontSize = 12.0f;
    private float y = Y_BEGIN;

    public PDFCreator(Path targetPath) throws IOException, COSVisitorException {
        this.targetPath = targetPath;
        this.document.addPage(this.page);
        this.pageContentStream = new PDPageContentStream(this.document, this.page);
    }

    public void addTextLine(String text, float fontSize, boolean bold) throws IOException {
        this.addLineBreak(fontSize);
        this.pageContentStream.beginText();
        this.pageContentStream.setFont((PDFont)(bold ? PDType1Font.COURIER_BOLD : PDType1Font.COURIER), fontSize);
        this.pageContentStream.moveTextPositionByAmount(PAGE_BORDER, this.y);
        int maxCharactersPerLine = this.getMaxCharsAllowedForTextLine(fontSize);
        if (text.length() > maxCharactersPerLine) {
            String textForCurrentLine = text.substring(0, maxCharactersPerLine);
            String textForNextLineOrLines = text.substring(maxCharactersPerLine);
            this.pageContentStream.drawString(textForCurrentLine);
            this.pageContentStream.endText();
            this.addTextLine(textForNextLineOrLines, fontSize, bold);
        } else {
            this.pageContentStream.drawString(text);
            this.pageContentStream.endText();
        }
    }

    public void saveResult() throws COSVisitorException, IOException {
        this.pageContentStream.close();
        this.document.save(this.targetPath.toFile());
        this.document.close();
    }

    public void addLineBreak(float fontSize) throws IOException {
        this.y -= fontSize + (this.beginningOfNewPage ? 0.0f : VERTICAL_SPACING);
        this.beginningOfNewPage = false;
        if (this.y < PAGE_BORDER) {
            this.addPageBreak();
            this.addLineBreak(fontSize);
        }
    }

    public void addRasterImage(Path filePath) throws IOException {
        WorkaroundBufferedImage bufferedImage = new WorkaroundBufferedImage(ImageIO.read(filePath.toFile()));
        PDPixelMap image = new PDPixelMap(this.document, (BufferedImage)bufferedImage);
        float width = image.getWidth();
        float height = image.getHeight();
        float scale = 1.0f;
        float usablePageWidth = PDPage.PAGE_SIZE_A4.getWidth() - PAGE_BORDER * 2.0f;
        if (width > usablePageWidth) {
            scale = usablePageWidth / width;
        }
        this.addLineBreak(height *= scale);
        this.pageContentStream.drawXObject((PDXObject)image, PAGE_BORDER, this.y, width *= scale, height);
    }

    public void addPageBreak() throws IOException {
        this.pageContentStream.close();
        this.page = new PDPage(PDPage.PAGE_SIZE_A4);
        this.document.addPage(this.page);
        this.pageContentStream = new PDPageContentStream(this.document, this.page);
        this.y = Y_BEGIN;
        this.beginningOfNewPage = true;
    }

    public void addTextFile(Path filePath, float fontSize, boolean bold) throws IOException {
        String line;
        FileReader fr = new FileReader(filePath.toFile());
        BufferedReader br = new BufferedReader(fr);
        int maxChars = 0;
        while ((line = br.readLine()) != null) {
            if (line.length() <= maxChars) continue;
            maxChars = line.length();
        }
        br.close();
        int maxCharsAllowedPerLine = this.getMaxCharsAllowedForTextLine(fontSize);
        if (maxChars > maxCharsAllowedPerLine) {
            fontSize = this.getMaxFontSizeAllowedForTextLine(maxChars);
        }
        fr = new FileReader(filePath.toFile());
        br = new BufferedReader(fr);
        while ((line = br.readLine()) != null) {
            this.addTextLine(line, fontSize, bold);
        }
        br.close();
    }

    protected float getMaxFontSizeAllowedForTextLine(int numberOfChars) {
        float maxWidthForOneChar = USABLE_PAGE_WIDTH / (float)numberOfChars;
        return maxWidthForOneChar / 0.6025f;
    }

    protected int getMaxCharsAllowedForTextLine(float fontSize) {
        float characterWidth = fontSize * 0.6025f;
        return (int)(USABLE_PAGE_WIDTH / characterWidth);
    }

    public void setDefaultBoldness(boolean boldness) {
        this.defaultBoldness = boldness;
    }

    public void setDefaultFontSize(float size) {
        this.defaultFontSize = size;
    }

    public void addTextLine(String text) throws IOException {
        this.addTextLine(text, this.defaultFontSize, this.defaultBoldness);
    }

    public void addTextLine(String text, boolean bold) throws IOException {
        this.addTextLine(text, this.defaultFontSize, bold);
    }

    public void addTextLine(String text, float fontSize) throws IOException {
        this.addTextLine(text, fontSize, this.defaultBoldness);
    }

    public void addLineBreak() throws IOException {
        this.addLineBreak(this.defaultFontSize);
    }

    public void addLineBreaks(int breakCount) throws IOException {
        this.addLineBreaks(breakCount, this.defaultFontSize);
    }

    public void addLineBreaks(int breakCount, float fontSize) throws IOException {
        int i = 0;
        while (i < breakCount) {
            this.addLineBreak(fontSize);
            ++i;
        }
    }

    public void addTextFile(Path filePath) throws IOException {
        this.addTextFile(filePath, this.defaultFontSize, this.defaultBoldness);
    }

    public void addTextFile(Path filePath, float fontSize) throws IOException {
        this.addTextFile(filePath, fontSize, this.defaultBoldness);
    }

    public void addTextFile(Path filePath, boolean bold) throws IOException {
        this.addTextFile(filePath, this.defaultFontSize, bold);
    }
}

