/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts;

import de.tu_bs.ilr.esa.estec.neopop.gui.view.IPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.ToggleSelectEventButtons;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.Util;
import de.tu_bs.ilr.esa.estec.neopop.model.Input;
import de.tu_bs.ilr.esa.estec.neopop.model.MainComponentOutput;
import de.tu_bs.ilr.esa.estec.neopop.model.MainComponentType;
import de.tu_bs.ilr.esa.estec.neopop.model.ModelElement;
import de.tu_bs.ilr.esa.estec.neopop.model.NEOPOPModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsAnaOutput;
import de.tu_bs.ilr.esa.estec.neopop.model.Output;
import de.tu_bs.ilr.esa.estec.neopop.model.OutputSubject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.SWTResourceManager;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputSubjectPart
implements IPart {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private IEventBroker eventBroker;
    private Button popGenButton;
    private Button popAnaButton;
    private Button obsSimButton;
    private Button obsAnaButton;
    private Output output;
    private Group plotSubjectsGroup;
    private ToggleSelectEventButtons<OutputSubject> subjectButtons;
    private ToggleSelectEventButtons<MainComponentType> outputButtons;
    private NEOPOPModule neopopModule;
    private Group mainComponentsGroup;
    private Composite plotSubjectsComposite;
    private Composite compInScrolled;
    private Composite parentComposite;

    @Inject
    void setAttributesFromContext(Output output, Input input) {
        this.logger.trace("setAttributesFromContext");
        this.output = output;
        this.neopopModule = input.getNeopopModule();
    }

    @PostConstruct
    void createGUIElements(Composite parentComposite) {
        this.logger.trace("createGUIElements");
        this.logger.debug("Creating GUI elements");
        this.parentComposite = parentComposite;
        parentComposite.setLayout((Layout)new GridLayout(1, false));
        this.mainComponentsGroup = new Group(parentComposite, 0);
        this.mainComponentsGroup.setText("Output Selection");
        this.mainComponentsGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.mainComponentsGroup.setLayout((Layout)new GridLayout(2, false));
        this.outputButtons = new ToggleSelectEventButtons(this.eventBroker, "de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/output/mainComponentSelected");
        this.outputButtons.addButton((Composite)this.mainComponentsGroup, "PopGen", MainComponentType.POP_GEN).setToolTipText("Open Population Generation Output");
        this.outputButtons.addButton((Composite)this.mainComponentsGroup, "PopAna", MainComponentType.POP_ANA).setToolTipText("Open Population Analysis Output");
        this.outputButtons.addButton((Composite)this.mainComponentsGroup, "ObsSim", MainComponentType.OBS_SIM).setToolTipText("Open Observation Simulation Output");
        this.outputButtons.addButton((Composite)this.mainComponentsGroup, "ObsAna", MainComponentType.OBS_ANA).setToolTipText("Open Observation Analysis Output");
        this.plotSubjectsGroup = new Group(parentComposite, 0);
        this.plotSubjectsGroup.setText("Plot Subjects");
        this.plotSubjectsGroup.setLayout((Layout)new FillLayout());
        this.plotSubjectsGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.plotSubjectsGroup, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.compInScrolled = new Composite((Composite)scrolledComposite, 0);
        this.compInScrolled.setLayout((Layout)new GridLayout(1, false));
        scrolledComposite.setContent((Control)this.compInScrolled);
    }

    public void doAdditionalStuff() {
        this.logger.trace("doAdditionalStuff");
        this.logger.debug("Doing additional stuff");
        this.subjectButtons = new ToggleSelectEventButtons(this.eventBroker, "de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/output/subjectSelected");
        this.output.addPropertyChangeListener("currentComponentOutput", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    OutputSubjectPart.this.deselectButton(OutputSubjectPart.this.popGenButton);
                    OutputSubjectPart.this.deselectButton(OutputSubjectPart.this.popAnaButton);
                    OutputSubjectPart.this.deselectButton(OutputSubjectPart.this.obsSimButton);
                    OutputSubjectPart.this.deselectButton(OutputSubjectPart.this.obsAnaButton);
                }
            }
        });
    }

    public void bindGUIElements() {
        this.logger.trace("bindGUIElements");
        this.logger.debug("Binding GUI elements");
        DataBindingContext dbc = new DataBindingContext();
        Util.bindBooleanPropertyToValueExistence(dbc, (IObservableValue)WidgetProperties.enabled().observe((Widget)this.outputButtons.getButton(MainComponentType.POP_GEN)), (ModelElement)this.output, "popGenOutput");
        Util.bindBooleanPropertyToValueExistence(dbc, (IObservableValue)WidgetProperties.enabled().observe((Widget)this.outputButtons.getButton(MainComponentType.POP_ANA)), (ModelElement)this.output, "popAnaOutput");
        Util.bindBooleanPropertyToValueExistence(dbc, (IObservableValue)WidgetProperties.enabled().observe((Widget)this.outputButtons.getButton(MainComponentType.OBS_SIM)), (ModelElement)this.output, "obsSimOutput");
        Util.bindBooleanPropertyToValueExistence(dbc, (IObservableValue)WidgetProperties.enabled().observe((Widget)this.outputButtons.getButton(MainComponentType.OBS_ANA)), (ModelElement)this.output, "obsAnaOutput");
    }

    public void focus() {
        this.logger.trace("focus");
    }

    @Inject
    @Optional
    void showMainComponentOutput(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/output/showMainComponent") Event event, UISynchronize uiSynch, Output output) {
        final MainComponentOutput componentOutput = (MainComponentOutput)event.getProperty("org.eclipse.e4.data");
        this.logger.trace("showMainComponentOutput(output={})", (Object)componentOutput);
        uiSynch.syncExec(new Runnable(){

            @Override
            public void run() {
                if (componentOutput == null) {
                    OutputSubjectPart.this.outputButtons.resetSelection();
                }
                OutputSubjectPart.this.updatePlotSubjectButtons(componentOutput);
            }
        });
    }

    private void updatePlotSubjectButtons(MainComponentOutput output) {
        this.logger.trace("updatePlotSubjectButtons(output={})", (Object)output);
        this.removePlotSubjectButtons();
        this.createPlotSubjectButtons(output);
        this.updateLayout();
    }

    private void updateLayout() {
        this.logger.trace("updateLayout()");
        this.plotSubjectsGroup.layout();
    }

    private void createPlotSubjectButtons(MainComponentOutput output) {
        this.logger.trace("createPlotSubjectButtons(output={})", (Object)output);
        if (output instanceof ObsAnaOutput) {
            ObsAnaOutput obsAnaOutput = (ObsAnaOutput)output;
            for (OutputSubject subject : obsAnaOutput.getSubjects()) {
                this.subjectButtons.addButton(this.compInScrolled, subject.getName(), subject);
            }
            Util.activateScrolling((Control)this.compInScrolled);
        }
    }

    private OutputSubject getDefaultSubject(ObsAnaOutput obsAnaOutput) {
        if (!obsAnaOutput.getSubjects().isEmpty()) {
            return (OutputSubject)obsAnaOutput.getSubjects().get(0);
        }
        return null;
    }

    private void removePlotSubjectButtons() {
        this.logger.trace("removePlotSubjectButtons()");
        this.subjectButtons.clear();
    }

    private void deselectButton(Button button) {
        if (button != null) {
            button.setSelection(false);
            button.setFont(SWTResourceManager.getFont("Sans Serif", 9, 0));
        }
    }

    private void selectButton(Button button) {
        if (button != null) {
            button.setSelection(true);
            button.setFont(SWTResourceManager.getFont("Sans Serif", 9, 1));
            MainComponentOutputSelecter.lastButton = button;
        }
    }

    public void finalizeCreation() {
        this.logger.trace("finalizeCreation");
        this.logger.debug("Finalizing creation");
    }

    @Inject
    @Optional
    void fixBrokenLayout(@EventTopic(value="org/osgi/framework/ServiceEvent/MODIFIED") Event event, EPartService partService) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!OutputSubjectPart.this.parentComposite.isDisposed()) {
                    OutputSubjectPart.this.parentComposite.layout();
                }
            }
        });
    }

    static class MainComponentOutputSelecter
    extends SelectionAdapter {
        private MainComponentType mainComponentType;
        private IEventBroker eventBroker;
        private Button button;
        private static Button lastButton = null;
        private Logger logger;

        private MainComponentOutputSelecter(Button button, IEventBroker eventBroker, MainComponentType mainComponentType) {
            this.logger = LoggerFactory.getLogger((String)(String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + mainComponentType + "]"));
            this.logger.trace("(Constructor)");
            this.button = button;
            this.eventBroker = eventBroker;
            this.mainComponentType = mainComponentType;
            this.button.addSelectionListener((SelectionListener)this);
        }

        public void widgetSelected(SelectionEvent e) {
            this.logger.trace("widgetSelected");
            if (lastButton == this.button) {
                this.button.setSelection(true);
                return;
            }
            this.eventBroker.post("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/output/mainComponentSelected", (Object)this.mainComponentType);
        }

        static /* synthetic */ Button access$0() {
            return lastButton;
        }
    }
}

