#!/bin/bash

#
# Launch NEOPOP GUI
#

# Create conf directory so that logfiles can be written.
# The following command also works if $HOME/neopop-gui doesn't exist
mkdir --parents $HOME/neopop-gui/conf

# Enter GUI folder
cd gui
  
  # Run ConfFolderManager to wipe conf folder if necessary
  java -jar conf_folder_manager.jar
  
  # Run GUI
  # "1>" and "2>" redirect standard output and standard error output to log files
  # The LC_NUMERIC override should prevent conflicts on Fortran text I/O due to process
  # locale settings by the Java side of the process.
  LC_NUMERIC="C" ./neopop-gui 1>$HOME/neopop-gui/conf/gui-sysout.log 2>$HOME/neopop-gui/conf/gui-syserr.log
  
# Return to installation folder
cd .. 
