reset
set term png
set key vertical outside right center
set key textcolor rgbcolor "grey70"
unset logscale x
unset logscale y
set xrange [      -5.400:       5.400]
set yrange [      -5.400:       5.400]
set title "Test run of the\nPopulation Generator\nSolar System Polar View" offset 0,2
# prepare the solar system
set parametric
set trange [0:2*pi]
# Sun
rs = 0.04
fxs(t) = rs*cos(t)
fys(t) = rs*sin(t)
# Mercury
rme = 0.387
fxme(t) = rme*cos(t)
fyme(t) = rme*sin(t)
# Venus
rv = 0.723
fxv(t) = rv*cos(t)
fyv(t) = rv*sin(t)
# Earth
re = 1.000
fxe(t) = re*cos(t)
fye(t) = re*sin(t)
# Mars
rma = 1.324
fxma(t) = rma*cos(t)
fyma(t) = rma*sin(t)
# Jupiter
rj = 5.201
fxj(t) = rj*cos(t)
fyj(t) = rj*sin(t)
# common z axis = 0
fz(t) = 0
set view 0,0
unset border
set size square
set xlabel "[AU]"
set xlabel textcolor rgbcolor "grey30"
set xlabel offset 25,1.5
set ylabel "[AU]"
set ylabel offset 0.5,9.75
set ylabel textcolor rgbcolor "grey30"
set ylabel norotate
set border linecolor rgbcolor "grey30"
set title textcolor rgbcolor "grey70"
set obj 1 rectangle behind from screen 0,0 to screen 1,1
set obj 1 fillstyle solid 1.0 fillcolor rgbcolor "black"
set style fill pattern 2
set output "neopop_S01_SLP_MC01.png"
plot fxs(t),fys(t) lc rgb "yellow" lw 2 t "Sun" w filledcurves below, \
fxme(t),fyme(t) lt 1 lc rgb "#BBBBBB" lw 1 t "Mercury", \
fxv(t),fyv(t) lt 2 lc rgb "#DDDDB0" lw 1 t "Venus", \
fxe(t),fye(t) lt 3 lc rgb "#7070DD" lw 1 t "Earth", \
fxma(t),fyma(t) lt 4 lc rgb "#DD9090" lw 1 t "Mars", \
fxj(t),fyj(t) lc rgb "#DDB070" lw 1 t "Jupiter", \
"neopop_S01_SL_MC01_d.spc" u 4:($3 <= 4 ? $5 : 1/0) lc rgb "green" lw 1 w dots t "Crossings", \
"neopop_S01_SL_MC01_d.spc" u 4:($3 == 4 ? $5 : 1/0) lc rgb "red" lw 1 w dots t "Detections"
