# ----------------------------------------------
#
# Scattered moonlight:
# ====================
#
# Based on:
# ---------
# G.M. DANIELS, "A night sky model for satellite 
# search systems", Optical Engineering No.1, 
# Vol.16, pp. 66-71, January-February 1977
#
# ----------------------------------------------
# BIN-1 = Bin for zenith angle of the Moon   [-]
#         Data given for: 0,30,60,75       [deg]
#         Data interpolated for 15° and 45°
#         Thus, there are 5 bins internally: 
#                1)  0° to 15°
#                2) 15° to 30°
#                3) 30° to 45°
#                4) 45° to 60°
#                5) 60° to 75°
#         For larger zenith angles of the Moon 
#         the data of 75° is used! 
#
#
# BIN-2 = Bin for azimuth offset             [-]
#         Data given for: 0,45,90,135,180  [deg]
#         Thus, there are 4 bins internally: 
#                1)   0° to  45°
#                2)  45° to  90°
#                3)  90° to 135°
#                4) 135° to 180°
#
#
# BIN-3 = Bin for zenith angle of LOS        [-]
#         Data given for: 0,10,20,..,70,80 [deg]
#         Thus, there are 8 bins internally: 
#                1)   0° to  10°
#                2)  10° to  20°
#                3)  20° to  30°
#                4)  30° to  40°
#                5)  40° to  50°
#                6)  50° to  60°
#                7)  60° to  70°
#                8)  70° to  80°
#         For larger zenith angles of the LOS 
#         the data of 80° is used!
#
#
# DATA  = RAYLEIGH scattered moonlight 
#                      [10E-10 * W/cm**2/mym/sr]
#                        equal to  [W/m**2/m/sr]
#
# ----------------------------------------------
#
# ----------------------------------------------
#  BIN-1  BIN-2  BIN-3   DATA
# ----------------------------------------------
     1      1      1     22.0
     1      1      2     22.0
     1      1      3     22.0
     1      1      4     22.0
     1      1      5     23.0
     1      1      6     24.0
     1      1      7     27.0
     1      1      8     34.0
     1      1      9     55.0
     1      2      1     22.0
     1      2      2     22.0
     1      2      3     22.0
     1      2      4     22.0
     1      2      5     23.0
     1      2      6     24.0
     1      2      7     27.0
     1      2      8     34.0
     1      2      9     55.0
     1      3      1     22.0
     1      3      2     22.0
     1      3      3     22.0
     1      3      4     22.0
     1      3      5     23.0
     1      3      6     24.0
     1      3      7     27.0
     1      3      8     34.0
     1      3      9     55.0
     1      4      1     22.0
     1      4      2     22.0
     1      4      3     22.0
     1      4      4     22.0
     1      4      5     23.0
     1      4      6     24.0
     1      4      7     27.0
     1      4      8     34.0
     1      4      9     55.0
     1      5      1     22.0
     1      5      2     22.0
     1      5      3     22.0
     1      5      4     22.0
     1      5      5     23.0
     1      5      6     24.0
     1      5      7     27.0
     1      5      8     34.0
     1      5      9     58.0
     3      1      1     19.0
     3      1      2     21.0
     3      1      3     23.0
     3      1      4     25.0
     3      1      5     28.0
     3      1      6     31.0
     3      1      7     37.0
     3      1      8     47.0
     3      1      9     72.0
     3      2      1     19.0
     3      2      2     20.0
     3      2      3     22.0
     3      2      4     23.0
     3      2      5     25.0
     3      2      6     28.0
     3      2      7     33.0
     3      2      8     41.0
     3      2      9     65.0
     3      3      1     19.0
     3      3      2     19.0
     3      3      3     19.0
     3      3      4     20.0
     3      3      5     21.0
     3      3      6     22.0
     3      3      7     25.0
     3      3      8     33.0
     3      3      9     54.0
     3      4      1     19.0
     3      4      2     18.0
     3      4      3     17.0
     3      4      4     17.0
     3      4      5     17.0
     3      4      6     17.0
     3      4      7     22.0
     3      4      8     30.0
     3      4      9     54.0
     3      5      1     19.0
     3      5      2     18.0
     3      5      3     17.0
     3      5      4     16.0
     3      5      5     16.0
     3      5      6     18.0
     3      5      7     22.0
     3      5      8     31.0
     3      5      9     58.0
     5      1      1     13.0
     5      1      2     15.0
     5      1      3     18.0
     5      1      4     21.0
     5      1      5     25.0
     5      1      6     31.0
     5      1      7     39.0
     5      1      8     54.0
     5      1      9     89.0
     5      2      1     13.0
     5      2      2     14.0
     5      2      3     16.0
     5      2      4     18.0
     5      2      5     21.0
     5      2      6     26.0
     5      2      7     32.0
     5      2      8     43.0
     5      2      9     71.0
     5      3      1     13.0
     5      3      2     13.0
     5      3      3     14.0
     5      3      4     14.0
     5      3      5     16.0
     5      3      6     18.0
     5      3      7     22.0
     5      3      8     29.0
     5      3      9     50.0
     5      4      1     13.0
     5      4      2     12.0
     5      4      3     12.0
     5      4      4     12.0
     5      4      5     14.0
     5      4      6     17.0
     5      4      7     22.0
     5      4      8     33.0
     5      4      9     61.0
     5      5      1     13.0
     5      5      2     12.0
     5      5      3     12.0
     5      5      4     12.0
     5      5      5     14.0
     5      5      6     18.0
     5      5      7     25.0
     5      5      8     40.0
     5      5      9     76.0
     6      1      1     10.0
     6      1      2     11.0
     6      1      3     13.0
     6      1      4     16.0
     6      1      5     20.0
     6      1      6     25.0
     6      1      7     33.0
     6      1      8     48.0
     6      1      9     82.0
     6      2      1     10.0
     6      2      2     11.0
     6      2      3     12.0
     6      2      4     14.0
     6      2      5     17.0
     6      2      6     20.0
     6      2      7     26.0
     6      2      8     37.0
     6      2      9     63.0
     6      3      1     10.0
     6      3      2     10.0
     6      3      3     10.0
     6      3      4     11.0
     6      3      5     12.0
     6      3      6     15.0
     6      3      7     18.0
     6      3      8     25.0
     6      3      9     43.0
     6      4      1     10.0
     6      4      2      9.7
     6      4      3      9.9
     6      4      4     11.0
     6      4      5     13.0
     6      4      6     16.0
     6      4      7     21.0
     6      4      8     32.0
     6      4      9     58.0
     6      5      1     10.0
     6      5      2      9.6  
     6      5      3     10.0
     6      5      4     11.0
     6      5      5     14.0
     6      5      6     18.0
     6      5      7     26.0
     6      5      8     40.0
     6      5      9     75.0
 