/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.PrefUtil;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.PreferenceEntry;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.PresenterUtil;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.handlers.OpenDialogHandler;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.DialogType;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.IView;
import de.tu_bs.ilr.esa.estec.neopop.model.Model;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import javax.inject.Inject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceController
extends OpenDialogHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Inject
    @Optional
    void openCurrentWorkspace(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/workspace/openCurrent") Event event, PrefUtil prefUtil, IView view, IEclipseContext context, Model model, PresenterUtil presenterUtil) {
        this.logger.trace("openCurrentWorkspace(...)");
        this.logger.info("Opening current workspace");
        String workspacePath = prefUtil.get(PreferenceEntry.WORKSPACE_PATH);
        if (workspacePath != null && !FileSystems.getDefault().getPath(workspacePath, new String[0]).toFile().exists()) {
            workspacePath = null;
        }
        if (workspacePath == null) {
            this.logger.info("No current workspace - asking user");
            Path defaultWorkspacePath = FileSystems.getDefault().getPath(System.getProperty("user.home"), "neopop-gui", "workspace");
            presenterUtil.sendCreateAndOpenDialogEvent(DialogType.SELECT_WORKSPACE, defaultWorkspacePath, true);
        } else {
            this.openWorkspace(FileSystems.getDefault().getPath(workspacePath, new String[0]), prefUtil, model, view, presenterUtil);
        }
    }

    @Inject
    @Optional
    void openWorkspace(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/workspace/open") Path workspacePath, PrefUtil prefUtil, Model model, IView view, PresenterUtil presenterUtil) {
        this.logger.trace("openWorkspace(workspacePath={})", (Object)workspacePath);
        boolean emergencyWorkspace = false;
        if (workspacePath == null) {
            emergencyWorkspace = true;
            workspacePath = FileSystems.getDefault().getPath(System.getProperty("user.home"), "neopop-gui", "conf", "emergency-workspace");
            this.logger.warn("No workspace given by user - falling back to emergency workspace path at {}", (Object)workspacePath);
        }
        if (!presenterUtil.isValidWorkspacePath(workspacePath)) {
            presenterUtil.reboundWithError("You selected an invalid folder", DialogType.SELECT_WORKSPACE, workspacePath, view);
            return;
        }
        this.logger.info("Opening workspace {}", (Object)workspacePath);
        Location instanceLocation = Platform.getInstanceLocation();
        try {
            instanceLocation.set(new URL("file", null, workspacePath.toString()), false);
        }
        catch (IOException | IllegalStateException e) {
            this.logger.error("Could not set Eclipse instance area to {}", (Object)workspacePath, (Object)e);
        }
        if (!emergencyWorkspace) {
            model.getWorkspace().setPath(workspacePath.toString());
            prefUtil.set(PreferenceEntry.WORKSPACE_PATH, workspacePath.toString());
        }
    }

    @Inject
    @Optional
    void openDifferentWorkspace(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/workspace/openDifferent") Event event, Model model, IEventBroker eventBroker) {
        this.logger.trace("openDifferentWorkspace");
        this.logger.info("Opening a different workspace (Please restart NEOPOP GUI)");
        model.getWorkspace().setPath(null);
        model.getWorkspace().getProject().setPath(null);
        eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/quit", null);
    }
}

