/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.ProjectController;
import de.tu_bs.ilr.esa.estec.neopop.model.PopulationFileFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class NEOPOPRunner
extends Job {
    private static volatile Job previousNEOPOPStdOutputReader = null;
    private static volatile Job previousNEOPOPErrorLogReader = null;
    private Logger logger;
    private volatile Process neopopCLTProcess = null;
    private String absoluteNEOPOPExeFilePath;
    private String projDirPathAsString;
    private IEventBroker eventBroker;
    private NEOPOPRunner previousRunner = null;
    private volatile boolean cancel = false;
    private Job neopopStdOutputReader;
    private Job neopopErrorLogReader;
    protected String originalObsSimPopulationFilePath = null;
    protected String originalObsSimPPFFilePath = null;
    protected PopulationFileFormat originalObsSimPopulationFileFormat = null;

    public NEOPOPRunner(String absoluteNEOPOPExeFilePath, String projDirPathAsString, IEventBroker eventBroker, NEOPOPRunner previousRunner) {
        super("NEOPOP Runner");
        this.logger = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass() + "[previousRunner=" + (Object)((Object)previousRunner) + "]"));
        this.absoluteNEOPOPExeFilePath = absoluteNEOPOPExeFilePath;
        this.projDirPathAsString = projDirPathAsString;
        this.eventBroker = eventBroker;
        this.previousRunner = previousRunner;
    }

    protected void canceling() {
        this.logger.debug("Cancel requested - waking up and cancelling jobs");
        this.cancel = true;
        this.getThread().interrupt();
        if (this.neopopStdOutputReader != null) {
            this.neopopStdOutputReader.cancel();
            this.neopopStdOutputReader.getThread().interrupt();
        }
        if (this.neopopErrorLogReader != null) {
            this.neopopErrorLogReader.cancel();
            this.neopopErrorLogReader.getThread().interrupt();
        }
    }

    public IStatus run(IProgressMonitor monitor) {
        Thread.currentThread().setName(this.getName());
        this.logger.trace("run");
        this.logger.debug("Running");
        ProjectController.runningRunners.add(this);
        if (this.previousRunner != null) {
            this.logger.debug("Waiting for previous NEOPOP Runner");
            try {
                this.previousRunner.join();
            }
            catch (InterruptedException e) {
                if (this.cancel) {
                    this.logger.debug("I've been interrupted unexpectedly while waiting for previous runner, but that's ok, since user requested cancellation!");
                    this.logger.debug("Won't run after all - cancelling execution");
                    return Status.CANCEL_STATUS;
                }
                this.logger.error("I've been interrupted unexpectedly while waiting for previous runner: ", (Object)e, (Object)e);
            }
        }
        this.doRun();
        ProjectController.runningRunners.remove((Object)this);
        return Status.OK_STATUS;
    }

    protected void doExec() {
        if (this.cancel) {
            this.logger.debug("CANCELLED");
            return;
        }
        this.logger.debug("Executing \"{}\" in \"{}\"", (Object)this.absoluteNEOPOPExeFilePath, (Object)this.projDirPathAsString);
        try {
            this.neopopCLTProcess = Runtime.getRuntime().exec(new String[]{this.absoluteNEOPOPExeFilePath.toString()}, new String[0], new File(this.projDirPathAsString));
        }
        catch (IOException e) {
            this.logger.error("Could not run NEOPOP CLT ({}) in proj dir {}", new Object[]{this.absoluteNEOPOPExeFilePath, this.projDirPathAsString, e});
        }
        final Process neopopProcessFinal = this.neopopCLTProcess;
        this.neopopStdOutputReader = new Job("NEOPOP Standard Output Reader"){

            protected IStatus run(IProgressMonitor monitor) {
                Thread.currentThread().setName(this.getName());
                NEOPOPRunner.this.logger.trace("run");
                NEOPOPRunner.this.logger.debug("Running");
                InputStream is = neopopProcessFinal.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                if (previousNEOPOPStdOutputReader != null) {
                    Job previousReader = previousNEOPOPStdOutputReader;
                    previousNEOPOPStdOutputReader = this;
                    NEOPOPRunner.this.logger.debug("Waiting for previous NEOPOP Std Output Reader");
                    try {
                        previousReader.join();
                    }
                    catch (InterruptedException e) {
                        if (NEOPOPRunner.this.cancel) {
                            NEOPOPRunner.this.logger.debug("I've been interrupted unexpectedly while waiting for previous reader, but that's ok, since user requested cancellation!");
                            NEOPOPRunner.this.logger.debug("Won't try to read console output - cancelling execution");
                            return Status.CANCEL_STATUS;
                        }
                        NEOPOPRunner.this.logger.error("I've been interrupted unexpectedly while waiting for previous reader: ", (Object)e, (Object)e);
                    }
                } else {
                    previousNEOPOPStdOutputReader = this;
                }
                try {
                    String currentLine = reader.readLine();
                    while (currentLine != null) {
                        if (NEOPOPRunner.this.cancel) {
                            NEOPOPRunner.this.logger.debug("Cancel requested - stopping to read standard output - terminating");
                            return Status.CANCEL_STATUS;
                        }
                        NEOPOPRunner.this.logger.debug("NEOPOP: {}", (Object)currentLine);
                        if (currentLine.contains("Estimated time left:")) {
                            NEOPOPRunner.this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/caughtNEOPOPRemainTime", (Object)NEOPOPRunner.this.parseRemainingTime(currentLine));
                        } else if (currentLine.contains("Estimated time to run the remaining strategies:")) {
                            NEOPOPRunner.this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/caughtNEOPOPRemainTime", (Object)NEOPOPRunner.this.parseRemainingStrategies(currentLine));
                        }
                        NEOPOPRunner.this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/caughtNEOPOPOutputLine", (Object)currentLine);
                        currentLine = reader.readLine();
                    }
                    NEOPOPRunner.this.logger.debug("Terminating");
                }
                catch (IOException e) {
                    NEOPOPRunner.this.logger.error("Could not read line from standard output of NEOPOP", (Throwable)e);
                }
                NEOPOPRunner.this.logger.debug("Terminating");
                return Status.OK_STATUS;
            }
        };
        this.neopopStdOutputReader.schedule();
        this.neopopErrorLogReader = new Job("NEOPOP Error Log Reader"){

            protected IStatus run(IProgressMonitor monitor) {
                block27: {
                    Thread.currentThread().setName(this.getName());
                    NEOPOPRunner.this.logger.trace("run");
                    NEOPOPRunner.this.logger.debug("Running");
                    if (previousNEOPOPErrorLogReader != null) {
                        Job previousReader = previousNEOPOPErrorLogReader;
                        previousNEOPOPErrorLogReader = this;
                        NEOPOPRunner.this.logger.debug("Waiting for previous NEOPOP Error Log Reader");
                        try {
                            previousReader.join();
                        }
                        catch (InterruptedException e) {
                            if (NEOPOPRunner.this.cancel) {
                                NEOPOPRunner.this.logger.debug("I've been interrupted unexpectedly while waiting for previous reader, but that's ok, since user requested cancellation!");
                                NEOPOPRunner.this.logger.debug("Won't try to read error log - cancelling execution");
                                return Status.CANCEL_STATUS;
                            }
                            NEOPOPRunner.this.logger.error("I've been interrupted unexpectedly while waiting for previous reader: ", (Object)e, (Object)e);
                        }
                    } else {
                        previousNEOPOPErrorLogReader = this;
                    }
                    try {
                        neopopProcessFinal.waitFor();
                    }
                    catch (InterruptedException e) {
                        if (NEOPOPRunner.this.cancel) {
                            NEOPOPRunner.this.logger.debug("I've been interrupted unexpectedly while waiting for NEOPOP CLT to finish execution, but that's ok, since user requested cancellation!");
                            NEOPOPRunner.this.logger.debug("Won't try to read error log - cancelling execution");
                            return Status.CANCEL_STATUS;
                        }
                        NEOPOPRunner.this.logger.error("I've been interrupted unexpectedly while waiting for NEOPOP CLT to finish execution: ", (Object)e, (Object)e);
                    }
                    NEOPOPRunner.this.logger.debug("NEOPOP execution has completed");
                    if (NEOPOPRunner.this.cancel) {
                        NEOPOPRunner.this.logger.debug("Cancel requested - won't try to read error log - terminating");
                        return Status.CANCEL_STATUS;
                    }
                    Path errorLogPath = FileSystems.getDefault().getPath(NEOPOPRunner.this.projDirPathAsString, "neopop.err");
                    if (Files.exists(errorLogPath, new LinkOption[0])) {
                        NEOPOPRunner.this.logger.debug("Reading error log");
                        File file = errorLogPath.toFile();
                        BufferedReader fileReader = null;
                        try {
                            try {
                                fileReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                                String fileContent = "";
                                String line = fileReader.readLine();
                                while (line != null) {
                                    if (fileContent.length() != 0) {
                                        line = String.valueOf(line) + "\n";
                                    }
                                    fileContent = String.valueOf(fileContent) + line;
                                    line = fileReader.readLine();
                                }
                                NEOPOPRunner.this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/readErrorLog", (Object)fileContent);
                            }
                            catch (IOException e) {
                                NEOPOPRunner.this.logger.error("Error while reading error log: {}", (Throwable)e);
                                NEOPOPRunner.this.logger.debug("Exception thrown:", (Throwable)e);
                                if (fileReader != null) {
                                    try {
                                        fileReader.close();
                                    }
                                    catch (IOException e2) {
                                        NEOPOPRunner.this.logger.error("Could not close error log file: {}", (Object)e2, (Object)e2);
                                    }
                                }
                                break block27;
                            }
                        }
                        catch (Throwable throwable) {
                            if (fileReader != null) {
                                try {
                                    fileReader.close();
                                }
                                catch (IOException e) {
                                    NEOPOPRunner.this.logger.error("Could not close error log file: {}", (Object)e, (Object)e);
                                }
                            }
                            throw throwable;
                        }
                        if (fileReader != null) {
                            try {
                                fileReader.close();
                            }
                            catch (IOException e) {
                                NEOPOPRunner.this.logger.error("Could not close error log file: {}", (Object)e, (Object)e);
                            }
                        }
                    } else {
                        NEOPOPRunner.this.logger.debug("Error log doesn't exist");
                    }
                }
                NEOPOPRunner.this.logger.debug("Terminating");
                return Status.OK_STATUS;
            }
        };
        this.neopopErrorLogReader.schedule();
        if (this.cancel) {
            this.logger.debug("Cancel requested - destroying NEOPOP CLT");
            this.neopopCLTProcess.destroy();
            return;
        }
        try {
            this.neopopCLTProcess.waitFor();
        }
        catch (InterruptedException e) {
            if (this.cancel) {
                this.logger.debug("I've been interrupted unexpectedly while waiting for NEOPOP CLT to finish execution, but that's ok, since user requested cancellation!");
                this.logger.debug("Destroying NEOPOP CLT process - muahahah");
                this.neopopCLTProcess.destroy();
            }
            this.logger.error("I've been interrupted unexpectedly while waiting for NEOPOP CLT to finish execution: ", (Object)e, (Object)e);
        }
    }

    private String parseRemainingTime(String currentLine) {
        String atTime = currentLine.substring(0, 19);
        int index = currentLine.indexOf("left:");
        index = currentLine.indexOf(" ", index);
        String remainingTime = currentLine.substring(index).trim();
        return "remaining time is " + remainingTime + " at " + atTime;
    }

    private String parseRemainingStrategies(String currentLine) {
        String atTime = currentLine.substring(0, 19);
        int index = currentLine.indexOf("strategies:");
        index = currentLine.indexOf(" ", index);
        String remainingTime = currentLine.substring(index).trim();
        return "remaining time is " + remainingTime + " at " + atTime;
    }

    public abstract void doRun();
}

