/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import de.tu_bs.ilr.esa.estec.neopop.gui.view.DialogType;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.IDialog;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.IView;
import java.nio.file.Path;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialogController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private IView view;
    @Inject
    protected IEventBroker eventBroker;

    @PostConstruct
    public void postConstruct() {
        this.logger.trace("postConstruct()");
    }

    @Inject
    @Optional
    void createAndOpenDialog(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/dialog/createAndOpen") Event event, IEclipseContext parentContext, UISynchronize uiSynch) {
        this.logger.trace("createAndOpenDialog(event={})", (Object)event);
        DialogType dialogType = (DialogType)event.getProperty("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/dialogType");
        Path defaultFolderPath = (Path)event.getProperty("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/defaultFolderPath");
        boolean block = event.containsProperty("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/block") ? (Boolean)event.getProperty("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/block") : false;
        this.logger.debug("Creating and opening {} dialog (default folder path: {})", (Object)defaultFolderPath);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/dialogType", dialogType);
        data.put("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/defaultFolderPath", defaultFolderPath);
        this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/dialog/create", data);
        if (block) {
            this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/dialog/openPreviouslyCreated", data);
        } else {
            this.eventBroker.post("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/dialog/openPreviouslyCreated", data);
        }
    }

    @Inject
    @Optional
    void createDialog(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/dialog/create") Event event, final IEclipseContext parentContext, UISynchronize uiSynch) {
        this.logger.trace("createDialog(event={})", (Object)event);
        DialogType dialogType = (DialogType)event.getProperty("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/dialogType");
        Path defaultFolderPath = (Path)event.getProperty("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/defaultFolderPath");
        this.logger.debug("Creating {} dialog (default folder path: {})", (Object)defaultFolderPath);
        final Class dialogClass = this.view.getDialogImplementationClass(dialogType);
        final IEclipseContext dialogContext = parentContext.createChild();
        this.view.fillDialogContext(dialogType, defaultFolderPath, dialogContext);
        uiSynch.syncExec(new Runnable(){

            @Override
            public void run() {
                IDialog dialog = (IDialog)ContextInjectionFactory.make((Class)dialogClass, (IEclipseContext)dialogContext);
                parentContext.set(IDialog.class, (Object)dialog);
            }
        });
    }

    @Inject
    @Optional
    void openPreviouslyCreatedDialog(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/dialog/openPreviouslyCreated") Event event, UISynchronize uiSynch, final IDialog dlg) {
        this.logger.trace("openPreviouslyCreatedDialog");
        this.logger.debug("Opening previously created dialog: {}", (Object)dlg);
        uiSynch.syncExec(new Runnable(){

            @Override
            public void run() {
                dlg.doOpen();
            }
        });
    }

    @Inject
    @Optional
    void destroyCurrentDialog(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/dialog/destroy") Event event, UISynchronize uiSynch, final IDialog dlg) {
        this.logger.trace("openPreviouslyCreatedDialog");
        this.logger.debug("Opening previously created dialog: {}", (Object)dlg);
        uiSynch.syncExec(new Runnable(){

            @Override
            public void run() {
                dlg.dispose();
            }
        });
    }
}

