/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter;

import de.tu_bs.ilr.esa.estec.neopop.gui.view.DialogType;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.IView;
import java.nio.file.Path;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PresenterUtil {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    protected IEventBroker eventBroker;

    @PostConstruct
    void postConstruct() {
        this.logger.trace("postConstruct");
    }

    public void sendCreateAndOpenDialogEvent(DialogType dialogType, Path defaultFolderPath) {
        this.logger.trace("sendCreateAndOpenDialogEvent(dialogType={}, defaultFolderPath={})", (Object)dialogType, (Object)defaultFolderPath);
        this.sendCreateAndOpenDialogEvent(dialogType, defaultFolderPath, true);
    }

    public void sendCreateAndOpenDialogEvent(DialogType dialogType, Path defaultFolderPath, boolean block) {
        this.logger.trace("sendCreateAndOpenDialogEvent(dialogType={}, defaultFolderPath={}, block={})", new Object[]{dialogType, defaultFolderPath, block});
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/dialogType", dialogType);
        data.put("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/defaultFolderPath", defaultFolderPath);
        data.put("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/block", block);
        if (block) {
            this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/dialog/createAndOpen", data);
        } else {
            this.eventBroker.post("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/dialog/createAndOpen", data);
        }
    }

    public boolean isValidWorkspacePath(Path path) {
        while (path != null && !path.toFile().exists()) {
            path = path.getParent();
        }
        if (path == null) {
            return false;
        }
        if (!path.toFile().isDirectory()) {
            return false;
        }
        return path.toFile().canRead() && path.toFile().canWrite() && path.toFile().canExecute();
    }

    public boolean isValidProjectDirPathForProjectCreation(Path path) {
        boolean lookingAtParent = false;
        while (path != null && !path.toFile().exists()) {
            lookingAtParent = true;
            path = path.getParent();
        }
        if (path == null) {
            return false;
        }
        if (!path.toFile().isDirectory()) {
            return false;
        }
        if (!(path.toFile().canRead() && path.toFile().canWrite() && path.toFile().canExecute())) {
            return false;
        }
        return lookingAtParent || path.toFile().list().length <= 0;
    }

    public boolean isValidProjectDirPath(Path projDirPath) {
        if (!projDirPath.toFile().exists()) {
            return false;
        }
        if (!projDirPath.toFile().isDirectory()) {
            return false;
        }
        if (!projDirPath.toFile().canRead()) {
            return false;
        }
        if (!projDirPath.toFile().canWrite()) {
            return false;
        }
        if (!projDirPath.toFile().canExecute()) {
            return false;
        }
        return projDirPath.resolve("neopop.cfg").toFile().exists();
    }

    public void rebound(DialogType dialogType, Path defaultFolderPath, IView view) {
        this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/dialog/destroy", null);
        this.sendCreateAndOpenDialogEvent(dialogType, defaultFolderPath);
    }

    public void reboundWithError(String errorMsg, DialogType dialogType, Path defaultFolderPath, IView view) {
        this.logger.error(errorMsg);
        view.openErrorDialog("Error", errorMsg);
        this.rebound(dialogType, defaultFolderPath, view);
    }

    public boolean isValidProjectExportTargetFilePath(Path targetFilePath) {
        return !targetFilePath.toFile().exists() || !targetFilePath.toFile().isDirectory();
    }
}

