/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts;

import de.tu_bs.ilr.esa.estec.neopop.gui.view.IPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.ToggleSelectEventButtons;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.Util;
import de.tu_bs.ilr.esa.estec.neopop.model.MainComponentOutput;
import de.tu_bs.ilr.esa.estec.neopop.model.MainComponentOutputWithPlotCategories;
import de.tu_bs.ilr.esa.estec.neopop.model.Output;
import de.tu_bs.ilr.esa.estec.neopop.model.OutputCategory;
import de.tu_bs.ilr.esa.estec.neopop.model.OutputPlotCategory;
import de.tu_bs.ilr.esa.estec.neopop.model.OutputSummaryCategory;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputCategoryPart
implements IPart {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Button summaryButton;
    private Output output;
    @Inject
    private IEventBroker eventBroker;
    private Composite _2dPlotsComposite;
    private Composite _3dPlotsComposite;
    private Composite scatterPlotsComposite;
    private TabFolder tabFolder;
    private Group summaryGroup;
    private ToggleSelectEventButtons<OutputCategory> buttons;
    @Inject
    private Composite parentComposite;

    @Inject
    void setAttributesFromContext(Output output) {
        this.logger.trace("setAttributesFromContext");
        this.output = output;
    }

    @PostConstruct
    void createGUIElements(Composite parentComposite) {
        this.logger.trace("createGUIElements");
        this.logger.info("Creating GUI elements");
        parentComposite.setLayout((Layout)new GridLayout(1, false));
        this.summaryGroup = new Group(parentComposite, 0);
        this.summaryGroup.setLayout((Layout)new GridLayout(1, false));
        this.summaryGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Group plotCategoriesGroup = new Group(parentComposite, 0);
        plotCategoriesGroup.setLayout((Layout)new GridLayout(2, false));
        plotCategoriesGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        plotCategoriesGroup.setText("Plot Categories");
        this.tabFolder = new TabFolder((Composite)plotCategoriesGroup, 0);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TabItem _2dPlotsTabItem = new TabItem(this.tabFolder, 0);
        _2dPlotsTabItem.setText("2D");
        ScrolledComposite scrolled2dPlotsComposite = new ScrolledComposite((Composite)this.tabFolder, 768);
        scrolled2dPlotsComposite.setExpandHorizontal(true);
        scrolled2dPlotsComposite.setExpandVertical(true);
        _2dPlotsTabItem.setControl((Control)scrolled2dPlotsComposite);
        this._2dPlotsComposite = new Composite((Composite)scrolled2dPlotsComposite, 0);
        this._2dPlotsComposite.setLayout((Layout)new GridLayout(1, false));
        scrolled2dPlotsComposite.setContent((Control)this._2dPlotsComposite);
        TabItem _3dPlotsTabItem = new TabItem(this.tabFolder, 0);
        _3dPlotsTabItem.setText("3D");
        ScrolledComposite scrolled3dPlotsComposite = new ScrolledComposite((Composite)this.tabFolder, 768);
        scrolled3dPlotsComposite.setExpandHorizontal(true);
        scrolled3dPlotsComposite.setExpandVertical(true);
        _3dPlotsTabItem.setControl((Control)scrolled3dPlotsComposite);
        this._3dPlotsComposite = new Composite((Composite)scrolled3dPlotsComposite, 0);
        this._3dPlotsComposite.setLayout((Layout)new GridLayout(1, false));
        scrolled3dPlotsComposite.setContent((Control)this._3dPlotsComposite);
        TabItem scatterPlotsTabItem = new TabItem(this.tabFolder, 0);
        scatterPlotsTabItem.setText("Scatter");
        ScrolledComposite scrolledScatterPlotsComposite = new ScrolledComposite((Composite)this.tabFolder, 768);
        scrolledScatterPlotsComposite.setExpandHorizontal(true);
        scrolledScatterPlotsComposite.setExpandVertical(true);
        scatterPlotsTabItem.setControl((Control)scrolledScatterPlotsComposite);
        this.scatterPlotsComposite = new Composite((Composite)scrolledScatterPlotsComposite, 0);
        this.scatterPlotsComposite.setLayout((Layout)new GridLayout(1, false));
        scrolledScatterPlotsComposite.setContent((Control)this.scatterPlotsComposite);
    }

    public void doAdditionalStuff() {
        this.logger.trace("doAdditionalStuff");
        this.logger.info("Doing additional stuff");
        DataBindingContext dbc = new DataBindingContext();
        this.buttons = new ToggleSelectEventButtons(this.eventBroker, "de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/output/categorySelected");
    }

    @Inject
    @Optional
    void showMainComponentOutput(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/output/showMainComponent") Event event, UISynchronize uiSynch) {
        final MainComponentOutput output = (MainComponentOutput)event.getProperty("org.eclipse.e4.data");
        this.logger.trace("showMainComponentOutput(output={})", (Object)output);
        uiSynch.syncExec(new Runnable(){

            @Override
            public void run() {
                OutputCategoryPart.this.updateButtons(output);
            }
        });
    }

    private void updateButtons(MainComponentOutput output) {
        this.logger.trace("updateButtons(output={})", (Object)output);
        this.removeButtons();
        this.createButtons(output);
        this.updateLayout();
    }

    private void updateLayout() {
        this.logger.trace("updateLayout()");
        this.summaryGroup.layout();
        this._2dPlotsComposite.layout();
        this._3dPlotsComposite.layout();
        this.scatterPlotsComposite.layout();
        this.parentComposite.layout();
    }

    private void createButtons(MainComponentOutput output) {
        this.logger.trace("createButtons(output={})", (Object)output);
        if (output == null) {
            return;
        }
        if (output.getSummaryCategory() != null) {
            this.buttons.addButton((Composite)this.summaryGroup, output.getSummaryCategory().getName(), (OutputCategory)output.getSummaryCategory());
        }
        OutputSummaryCategory defaultCategory = null;
        if (output instanceof MainComponentOutputWithPlotCategories) {
            MainComponentOutputWithPlotCategories outputWithPlotCategories = (MainComponentOutputWithPlotCategories)output;
            for (OutputPlotCategory cat : outputWithPlotCategories.get2dPlotCategories()) {
                this.buttons.addButton(this._2dPlotsComposite, cat.getName(), (OutputCategory)cat);
            }
            for (OutputPlotCategory cat : outputWithPlotCategories.get3dPlotCategories()) {
                this.buttons.addButton(this._3dPlotsComposite, cat.getName(), (OutputCategory)cat);
            }
            for (OutputPlotCategory cat : outputWithPlotCategories.getScatterPlotCategories()) {
                this.buttons.addButton(this.scatterPlotsComposite, cat.getName(), (OutputCategory)cat);
            }
            defaultCategory = this.getDefaultCategory(outputWithPlotCategories);
        } else {
            defaultCategory = output.getSummaryCategory();
        }
        Util.activateScrolling((Control)this._2dPlotsComposite);
        Util.activateScrolling((Control)this._3dPlotsComposite);
        Util.activateScrolling((Control)this.scatterPlotsComposite);
    }

    private OutputCategory getDefaultCategory(MainComponentOutputWithPlotCategories<?> outputWithPlotCategories) {
        if (!outputWithPlotCategories.get2dPlotCategories().isEmpty()) {
            return (OutputCategory)outputWithPlotCategories.get2dPlotCategories().get(0);
        }
        if (!outputWithPlotCategories.get3dPlotCategories().isEmpty()) {
            return (OutputCategory)outputWithPlotCategories.get3dPlotCategories().get(0);
        }
        if (!outputWithPlotCategories.getScatterPlotCategories().isEmpty()) {
            return (OutputCategory)outputWithPlotCategories.getScatterPlotCategories().get(0);
        }
        if (outputWithPlotCategories.getSummaryCategory() != null) {
            return outputWithPlotCategories.getSummaryCategory();
        }
        return null;
    }

    private Button createButton(Composite composite, final OutputCategory cat) {
        this.logger.trace("createButton(composite={}, cat={})", (Object)composite, (Object)cat);
        Button button = new Button(composite, 0);
        button.setText(cat.getName());
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutputCategoryPart.this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/output/categorySelected", (Object)cat);
            }
        });
        return button;
    }

    private void removeButtons() {
        this.logger.trace("removeButtons");
        this.buttons.clear();
    }

    public void bindGUIElements() {
        this.logger.trace("bindGUIElements");
        this.logger.info("Binding GUI elements");
    }

    public void focus() {
        this.logger.trace("focus");
    }

    public void finalizeCreation() {
        this.logger.trace("finalizeCreation");
        this.logger.debug("Finalizing creation");
    }
}

