/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.swt.SWTResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToggleSelectEventButtons<T> {
    private static final Font NORMAL_FONT = SWTResourceManager.getFont("Sans Serif", 9, 0);
    private static final Font SELECTION_FONT = SWTResourceManager.getFont("Sans Serif", 9, 1);
    private Map<T, Button> buttons = new HashMap<T, Button>();
    private Button selected = null;
    private IEventBroker eventBroker;
    private String eventTopic;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<T, SelectionListener<T>> selectionListeners = new HashMap<T, SelectionListener<T>>();

    public ToggleSelectEventButtons(IEventBroker eventBroker, String eventTopic) {
        this.logger.trace("C(.., eventTopic={})", (Object)eventTopic);
        this.eventBroker = eventBroker;
        this.eventTopic = eventTopic;
    }

    public Button addButton(Composite composite, String label, T eventItem) {
        this.logger.trace("addButton(composite={}, label={}, eventItem={})", new Object[]{composite, label, eventItem});
        Button button = new Button(composite, 2);
        this.buttons.put(eventItem, button);
        button.setText(label == null ? "" : label);
        SelectionListener<T> selectionListener = new SelectionListener<T>(button, eventItem);
        button.addSelectionListener(selectionListener);
        this.selectionListeners.put(eventItem, selectionListener);
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return button;
    }

    public void select(T item) {
        this.selectionListeners.get(item).selectFromSystem();
    }

    public void clear() {
        this.logger.trace("clear()");
        for (Button button : this.buttons.values()) {
            button.dispose();
        }
        this.buttons.clear();
        this.selectionListeners.clear();
        this.selected = null;
    }

    public void resetSelection() {
        this.logger.trace("resetSelection()");
        if (this.selected != null) {
            this.selected.setSelection(false);
            this.selected.setFont(NORMAL_FONT);
            this.selected = null;
        }
    }

    public Button getButton(T eventItem) {
        return this.buttons.get(eventItem);
    }

    private class SelectionListener<T>
    extends SelectionAdapter {
        private T eventItem;
        private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        private Button button;

        public SelectionListener(Button button, T eventItem) {
            this.logger.trace("C(eventItem={})", eventItem);
            this.button = button;
            this.eventItem = eventItem;
        }

        public void selectFromSystem() {
            this.logger.trace("selectFromSystem()");
            this.select();
        }

        public void widgetSelected(SelectionEvent e) {
            this.logger.trace("widgetSelected(e={})", (Object)e);
            this.select();
        }

        private void select() {
            this.logger.trace("select()");
            if (ToggleSelectEventButtons.this.selected == this.button) {
                ToggleSelectEventButtons.this.selected.setSelection(true);
                return;
            }
            if (ToggleSelectEventButtons.this.selected != null) {
                ToggleSelectEventButtons.this.selected.setSelection(false);
                ToggleSelectEventButtons.this.selected.setFont(NORMAL_FONT);
            }
            ToggleSelectEventButtons.this.selected = this.button;
            ToggleSelectEventButtons.this.selected.setSelection(true);
            ToggleSelectEventButtons.this.selected.setFont(SELECTION_FONT);
            ToggleSelectEventButtons.this.eventBroker.send(ToggleSelectEventButtons.this.eventTopic, this.eventItem);
        }
    }
}

