/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt;

import java.util.Arrays;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnablementPropagator
extends SelectionAdapter {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Control[] controls;
    private boolean doTheOpposite = false;
    private Button buttonListeningTo;

    public EnablementPropagator(Button buttonListeningTo, Control ... controls) {
        this(false, buttonListeningTo, controls);
    }

    public EnablementPropagator(boolean doTheOpposite, Button buttonToListenTo, Control ... controls) {
        this.controls = controls;
        this.doTheOpposite = doTheOpposite;
        this.buttonListeningTo = buttonToListenTo;
        this.buttonListeningTo.addSelectionListener((SelectionListener)this);
        this.logger.debug("{}: Created", (Object)this);
        this.logger.debug("{}: My controls are {}", (Object)this, (Object)Arrays.toString(controls));
        this.doIt();
    }

    public void widgetSelected(SelectionEvent e) {
        this.logger.debug("Handling SelectionEvent");
        this.doIt();
    }

    private void doIt() {
        boolean enable = this.buttonListeningTo.getSelection();
        enable = this.doTheOpposite ? !enable : enable;
        this.logger.debug("{}abling controls", (Object)(enable ? "En" : "Dis"));
        this.propagateEnablement(this.controls, enable, true);
    }

    private void propagateEnablement(Control[] controls, boolean enableControls, boolean controlsBelongToMe) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            boolean setEnablementOfThisControl = true;
            if (controlsBelongToMe) {
                control.setData("hiddenEnablement", (Object)enableControls);
            } else if (control.getData("hiddenEnablement") != null) {
                boolean hiddenEnablement = (Boolean)control.getData("hiddenEnablement");
                if (enableControls && !control.isEnabled() && !hiddenEnablement) {
                    setEnablementOfThisControl = false;
                }
            }
            if (control instanceof Composite) {
                this.propagateEnablement(((Composite)control).getChildren(), enableControls, false);
            }
            if (setEnablementOfThisControl) {
                control.setEnabled(enableControls);
            }
            ++n2;
        }
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "[doTheOpposite=" + this.doTheOpposite + ", buttonListeningTo=" + this.buttonListeningTo + ", controls=" + Arrays.toString(this.controls) + "]";
    }
}

