/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.model.internal;

import de.tu_bs.ilr.esa.estec.neopop.model.CompleteVarIndexes;
import de.tu_bs.ilr.esa.estec.neopop.model.connector.IModelConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VarDataType<J> {
    protected Class<J> javaClass;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public VarDataType(Class<J> javaClass) {
        this.logger.trace("FortranDataType(javaClass={})", javaClass);
        this.javaClass = javaClass;
    }

    public Class<J> getJavaClass() {
        return this.javaClass;
    }

    protected J get(IModelConnector connector, String id, CompleteVarIndexes indexes) {
        this.logger.trace("get(connector={}, id={}, indexes={})", new Object[]{connector, id, indexes});
        J result = this.doGet(connector, id, indexes);
        this.logger.trace("result={}", result);
        return result;
    }

    protected void set(IModelConnector connector, String id, CompleteVarIndexes indexes, J value) {
        this.logger.trace("set(connector={}, id={}, indexes={} value={})", new Object[]{connector, id, indexes, value});
        this.doSet(connector, id, indexes, value);
    }

    protected boolean check(IModelConnector connector, String id, CompleteVarIndexes indexes, J value) {
        this.logger.trace("connector={}, check(id={}, indexes={} value={})", new Object[]{connector, id, indexes, value});
        int intResult = this.doCheck(connector, id, indexes, value);
        if (intResult != 0 && intResult != 1) {
            this.logger.error("Checking {} as value for variable {}{} failed: Unexpected int result: {}", new Object[]{value, id, indexes, intResult, new RuntimeException()});
            throw new RuntimeException();
        }
        boolean result = intResult == 1;
        this.logger.trace("result={}", (Object)result);
        return result;
    }

    protected abstract J doGet(IModelConnector var1, String var2, CompleteVarIndexes var3);

    protected abstract void doSet(IModelConnector var1, String var2, CompleteVarIndexes var3, J var4);

    protected abstract int doCheck(IModelConnector var1, String var2, CompleteVarIndexes var3, J var4);
}

