/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.model;

import de.tu_bs.ilr.esa.estec.neopop.model.CompleteVarIndexes;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElement;
import de.tu_bs.ilr.esa.estec.neopop.model.connector.IModelConnector;
import de.tu_bs.ilr.esa.estec.neopop.model.internal.Var;
import java.beans.PropertyChangeSupport;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VarUsage<J> {
    private static List<VarUsage<?>> varUsages = new LinkedList();
    protected Logger logger;
    private Var<J> var;
    private String property;
    private CompleteVarIndexes indexes;
    private IModelConnector connector;
    private PropertyChangeSupport modelElementPcs;
    private J tempValue;
    private J defaultValue = null;
    private InputElement modelElement;
    private boolean suppressEvents = false;

    public static void test() {
        for (VarUsage<?> varUsage : varUsages) {
            if (!varUsage.property.equals("line1")) continue;
            varUsage.reGet();
        }
    }

    public VarUsage(InputElement modelElement, Var<J> var, String property, int ... additionalVarUsageOnlyIndexes) {
        this(modelElement, var, property, null, additionalVarUsageOnlyIndexes);
        varUsages.add(this);
    }

    public VarUsage(InputElement modelElement, Var<J> var, String property, J defaultValue, int ... additionalIndexes) {
        this.logger = LoggerFactory.getLogger((String)(String.valueOf(this.getClass().getName()) + "[modelElement=" + modelElement.getClass().getSimpleName() + ", var=" + var + ", property=" + property + "]"));
        this.modelElement = modelElement;
        this.property = property;
        this.var = var;
        this.indexes = new CompleteVarIndexes(modelElement.indexes, additionalIndexes);
        this.connector = modelElement.connector;
        this.modelElementPcs = modelElement.pcs;
        this.defaultValue = defaultValue;
        modelElement.varUsages.add(this);
        varUsages.add(this);
        this.var.addUsage(this);
    }

    public J get() {
        this.logger.trace("get()");
        J result = this.var.get(this.connector, this.indexes);
        this.logger.trace("result={}", result);
        return result;
    }

    public void set(J value) {
        this.logger.trace("set(value={})", value);
        J oldValue = this.var.get(this.connector, this.indexes);
        this.var.set(this.connector, this.indexes, value);
        if (!this.suppressEvents && !this.property.equals("numberOfPixelsPerRow")) {
            this.modelElementPcs.firePropertyChange(this.property, oldValue, value);
        }
    }

    public void checkDependencyChanged() {
        this.modelElement.fireCheckDependencyChanged(this.property);
    }

    public boolean check(J value) {
        this.logger.trace("check(value={})", value);
        boolean result = this.var.check(this.connector, this.indexes, value);
        this.logger.trace("result={}", (Object)result);
        return result;
    }

    public void loadTempValue() {
        this.tempValue = this.get();
    }

    public void saveTempValue() {
        if (this.check(this.tempValue)) {
            this.set(this.tempValue);
        }
    }

    public void setDefaultValue() {
        if (this.defaultValue != null) {
            this.set(this.defaultValue);
        }
    }

    public void reGet() {
        this.loadTempValue();
        this.set("muh");
        this.saveTempValue();
    }

    public void checkChangeAgainstTempValues() {
        this.modelElementPcs.firePropertyChange(this.property, this.tempValue, this.get());
        this.var.letDependentVarsReCheck(this.connector);
    }

    public void setSuppressEvents(boolean suppress) {
        this.suppressEvents = suppress;
    }

    public boolean isSuppressEvents() {
        return this.suppressEvents;
    }
}

