/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.model;

import de.tu_bs.ilr.esa.estec.neopop.model.GroundLocationType;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElement;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElementReference;
import de.tu_bs.ilr.esa.estec.neopop.model.Location;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawOclModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObservatoryCode;
import de.tu_bs.ilr.esa.estec.neopop.model.VarUsage;
import de.tu_bs.ilr.esa.estec.neopop.model.Vars;

public class GroundBasedLocation
extends Location {
    public static final String PROP_TEMPERATURE = "temperature";
    public static final String PROP_PRESSURE = "pressure";
    public static final String PROP_HUMIDITY = "humidity";
    public static final String PROP_LAPSE_RATE = "lapseRate";
    public static final String PROP_TYPE = "type";
    public static final String PROP_DATA0 = "data0";
    public static final String PROP_DATA1 = "data1";
    public static final String PROP_DATA2 = "data2";
    public static final String PROP_OBSERVATORY_CODE = "observatoryCode";
    protected VarUsage<GroundLocationType> type;
    protected VarUsage<Double> data0;
    protected VarUsage<Double> data1;
    protected VarUsage<Double> data2;
    protected VarUsage<Double> temperature = new VarUsage<Double>((InputElement)this, Vars.OBSSIM_DBL_G_B_TEMPERATURE, "temperature", 273.5, new int[0]);
    protected VarUsage<Double> pressure = new VarUsage<Double>((InputElement)this, Vars.OBSSIM_DBL_G_B_PRESSURE, "pressure", 1013.2, new int[0]);
    protected VarUsage<Double> humidity = new VarUsage<Double>((InputElement)this, Vars.OBSSIM_DBL_G_B_HUMIDITY, "humidity", 50.0, new int[0]);
    protected VarUsage<Double> lapseRate = new VarUsage<Double>((InputElement)this, Vars.OBSSIM_DBL_G_B_LAPSRATE, "lapseRate", 6.5, new int[0]);
    private InputElementReference<ObservatoryCode> observatoryCode;
    private ObsSimRawOclModule obsSimRawOclModule;

    protected GroundBasedLocation(InputElement parent, ObsSimRawOclModule obsSimRawOclModule, int ... additionalIndexes) {
        super(parent, Vars.OBSSIM_STR_G_B_LOCATION_NAME, "New GB Location", additionalIndexes);
        this.type = new VarUsage<GroundLocationType>((InputElement)this, Vars.OBSSIM_CHOICE_G_B_LOCATION_DEFINITION, PROP_TYPE, GroundLocationType.GEODETIC, new int[0]);
        this.data0 = new VarUsage<Double>((InputElement)this, Vars.OBSSIM_DBL_G_B_LOCATION_DATA, PROP_DATA0, 0.0, 1);
        this.data1 = new VarUsage<Double>((InputElement)this, Vars.OBSSIM_DBL_G_B_LOCATION_DATA, PROP_DATA1, 0.0, 2);
        this.data2 = new VarUsage<Double>((InputElement)this, Vars.OBSSIM_DBL_G_B_LOCATION_DATA, PROP_DATA2, 0.0, 3);
        this.observatoryCode = new InputElementReference(this, PROP_OBSERVATORY_CODE);
        this.obsSimRawOclModule = obsSimRawOclModule;
        if (this.type.get() == GroundLocationType.OBSERVATORY_CODE) {
            String name = this.getName();
            this.observatoryCode.setElement(obsSimRawOclModule.getCodeByString(name));
        }
    }

    public ObservatoryCode getObservatoryCode() {
        return this.observatoryCode.getElement();
    }

    public void setObservatoryCode(ObservatoryCode value) {
        this.logger.trace("setObservatoryCode(value={})", (Object)value);
        this.observatoryCode.setElement(value);
        if (this.getType() == GroundLocationType.OBSERVATORY_CODE) {
            this.setName(value != null ? value.getCode() : "<designator>");
        }
    }

    public boolean checkObservatoryCode(ObservatoryCode value) {
        return true;
    }

    public double getTemperature() {
        return this.temperature.get();
    }

    public void setTemperature(double value) {
        this.temperature.set(value);
    }

    public boolean checkTemperature(double value) {
        return this.temperature.check(value);
    }

    public double getPressure() {
        return this.pressure.get();
    }

    public void setPressure(double value) {
        this.pressure.set(value);
    }

    public boolean checkPressure(double value) {
        return this.pressure.check(value);
    }

    public double getHumidity() {
        return this.humidity.get();
    }

    public void setHumidity(double value) {
        this.humidity.set(value);
    }

    public boolean checkHumidity(double value) {
        return this.humidity.check(value);
    }

    public double getLapseRate() {
        return this.lapseRate.get();
    }

    public void setLapseRate(double value) {
        this.lapseRate.set(value);
    }

    public boolean checkLapseRate(double value) {
        return this.lapseRate.check(value);
    }

    public GroundLocationType getType() {
        return this.type.get();
    }

    public void setType(GroundLocationType value) {
        this.type.set(value);
        if (value == GroundLocationType.OBSERVATORY_CODE) {
            String name = this.getName();
            boolean found = false;
            for (ObservatoryCode code : this.obsSimRawOclModule.getObservatoryCodes()) {
                if (!code.getCode().equals(name)) continue;
                this.setObservatoryCode(code);
                found = true;
                break;
            }
            if (!found) {
                this.setObservatoryCode(null);
            }
        }
    }

    public boolean checkType(GroundLocationType value) {
        return this.type.check(value);
    }

    public double getData0() {
        return this.data0.get();
    }

    public void setData0(double value) {
        this.data0.set(value);
    }

    public boolean checkData0(double value) {
        return this.data0.check(value);
    }

    public double getData1() {
        return this.data1.get();
    }

    public void setData1(double value) {
        this.data1.set(value);
    }

    public boolean checkData1(double value) {
        return this.data1.check(value);
    }

    public double getData2() {
        return this.data2.get();
    }

    public void setData2(double value) {
        this.data2.set(value);
    }

    public boolean checkData2(double value) {
        return this.data2.check(value);
    }
}

