/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts;

import de.tu_bs.ilr.esa.estec.neopop.gui.view.IPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.Enabler;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.Util;
import de.tu_bs.ilr.esa.estec.neopop.model.ChangableAxis;
import de.tu_bs.ilr.esa.estec.neopop.model.ChangableAxisWithClassDefinition;
import de.tu_bs.ilr.esa.estec.neopop.model.ChangableObsSimAxisType;
import de.tu_bs.ilr.esa.estec.neopop.model.ChangablePopGenAxisType;
import de.tu_bs.ilr.esa.estec.neopop.model.Input;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElement;
import de.tu_bs.ilr.esa.estec.neopop.model.ModelElement;
import de.tu_bs.ilr.esa.estec.neopop.model.ModelElementValue;
import de.tu_bs.ilr.esa.estec.neopop.model.PlotWithOneChangableAxis;
import de.tu_bs.ilr.esa.estec.neopop.model.PlotWithTwoChangableAxes;
import de.tu_bs.ilr.esa.estec.neopop.model.PopGenInpPltModule;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.wb.swt.SWTResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlotSettingsPart
implements IPart {
    private static final int PLOT_COUNT = 15;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    @Named(value="plottype")
    private String plottype;
    @Inject
    @Named(value="function")
    private String function;
    private AxisGUIElements xAxisGUIElements = new AxisGUIElements();
    private AxisGUIElements yAxisGUIElements = new AxisGUIElements();
    private List<Button> enabledCheckBoxes = new ArrayList<Button>();
    private Input input;
    private Group grpPlots;
    private Composite parentComposite;

    @Inject
    void setAttributesFromContext(Input input) {
        this.logger.trace("setAttributesFromContext");
        this.input = input;
    }

    @PostConstruct
    public void createGUIElements(Composite actualParentComposite) {
        this.logger.trace("createGUIElements");
        this.logger.debug("Creating gui elements for plot settings part (type: {})", (Object)this.plottype);
        actualParentComposite.setLayout((Layout)new FillLayout());
        ScrolledComposite scrolledComposite = new ScrolledComposite(actualParentComposite, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.parentComposite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)this.parentComposite);
        GridLayout gl_cmpParent = new GridLayout(1, false);
        gl_cmpParent.marginWidth = 15;
        gl_cmpParent.marginHeight = 15;
        this.parentComposite.setLayout((Layout)gl_cmpParent);
        this.grpPlots = new Group(this.parentComposite, 0);
        GridLayout gl_grpPlots = new GridLayout(1, false);
        this.grpPlots.setLayout((Layout)gl_grpPlots);
        this.grpPlots.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.grpPlots.setText("Plots");
        Composite comp = new Composite((Composite)this.grpPlots, 0);
        RowLayout rl = new RowLayout();
        rl.center = true;
        comp.setLayoutData((Object)new GridData(0x1000000, 4, true, true, 1, 1));
        comp.setLayout((Layout)rl);
        Composite comp2 = new Composite(comp, 0);
        GridLayout gl = new GridLayout(this.plottype.equals("scatter") ? 5 : 7, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 8;
        comp2.setLayout((Layout)gl);
        this.createCaptions(comp2);
        this.createAxisRows(comp2);
        new Label(comp2, 0);
        new Label(comp2, 0);
        new Label(comp2, 0);
        new Label(comp2, 0);
        new Label(comp2, 0);
        new Label(comp2, 0);
    }

    private void createAxisRows(Composite composite) {
        int i = 0;
        while (i < 15) {
            this.createAxisRow(composite, this.xAxisGUIElements);
            if (this.plottype.equals("3dhist") || this.plottype.equals("scatter")) {
                this.createAxisRow(composite, this.yAxisGUIElements);
            }
            ++i;
        }
    }

    private void createAxisRow(Composite composite, AxisGUIElements axisGUIElements) {
        boolean xAxis = axisGUIElements == this.xAxisGUIElements;
        GridData gdTemplate = new GridData();
        gdTemplate.horizontalAlignment = 0x1000000;
        int n = gdTemplate.verticalIndent = xAxis ? 10 : 0;
        if (xAxis) {
            Button enabledButton = new Button(composite, 32);
            enabledButton.setLayoutData((Object)Util.copy(gdTemplate));
            this.enabledCheckBoxes.add(enabledButton);
        } else {
            GridData gd = Util.copy(gdTemplate);
            new Label(composite, 0).setLayoutData((Object)gd);
        }
        ComboViewer cmbvAxisType = new ComboViewer(composite, 8);
        Combo cmbAxisType = cmbvAxisType.getCombo();
        cmbAxisType.setLayoutData((Object)Util.copy(gdTemplate));
        cmbAxisType.select(0);
        axisGUIElements.typeComboViewers.add(cmbvAxisType);
        Button logScaleButton = new Button(composite, 32);
        logScaleButton.setLayoutData((Object)Util.copy(gdTemplate));
        axisGUIElements.logScaleButtons.add(logScaleButton);
        Spinner minSpinner = this.createDoubleSpinner(composite);
        minSpinner.setLayoutData((Object)Util.copy(gdTemplate));
        Spinner maxSpinner = this.createDoubleSpinner(composite);
        maxSpinner.setLayoutData((Object)Util.copy(gdTemplate));
        axisGUIElements.minSpinners.add(minSpinner);
        axisGUIElements.maxSpinners.add(maxSpinner);
        if (!this.plottype.equals("scatter")) {
            Spinner spnClassDef = new Spinner(composite, 2048);
            spnClassDef.setMinimum(Integer.MIN_VALUE);
            spnClassDef.setMaximum(Integer.MAX_VALUE);
            spnClassDef.setSelection(2);
            spnClassDef.setLayoutData((Object)Util.copy(gdTemplate));
            axisGUIElements.classDefSpinners.add(spnClassDef);
            ComboViewer cmbvClassDefType = new ComboViewer(composite, 8);
            Combo cmbClassDefType = cmbvClassDefType.getCombo();
            cmbClassDefType.setLayoutData((Object)Util.copy(gdTemplate));
            cmbClassDefType.select(0);
            axisGUIElements.classDefTypeComboViewers.add(cmbvClassDefType);
        }
    }

    private Spinner createDoubleSpinner(Composite composite) {
        Spinner spinner = new Spinner(composite, 2048);
        spinner.setPageIncrement(1000);
        spinner.setMinimum(Integer.MIN_VALUE);
        spinner.setMaximum(Integer.MAX_VALUE);
        spinner.setSelection(2);
        spinner.setIncrement(100);
        spinner.setDigits(3);
        return spinner;
    }

    private void createCaptions(Composite composite) {
        this.createCaptionLabel(composite, "", false);
        this.createCaptionLabel(composite, "Axis Type", false);
        this.createCaptionLabel(composite, "Log.", false);
        this.createCaptionLabel(composite, "Min.", false);
        this.createCaptionLabel(composite, "Max.", false);
        if (!this.plottype.equals("scatter")) {
            this.createCaptionLabel(composite, "Class Width or Number", true);
        }
    }

    private Label createCaptionLabel(Composite composite, String labelText, boolean span) {
        Label label = new Label(composite, 0);
        label.setFont(SWTResourceManager.getFont("Sans Serif", 9, 1));
        label.setText(labelText);
        GridData gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        if (span) {
            gd.horizontalSpan = 2;
        }
        label.setLayoutData((Object)gd);
        return label;
    }

    public void doAdditionalStuff() {
        this.logger.trace("doAdditionalStuff");
        this.logger.debug("Doing additional stuff");
        Util.setDefaultDoubleAttributes(this.xAxisGUIElements.minSpinners.toArray(new Spinner[0]));
        Util.setDefaultDoubleAttributes(this.yAxisGUIElements.minSpinners.toArray(new Spinner[0]));
        Util.setDefaultDoubleAttributes(this.xAxisGUIElements.classDefSpinners.toArray(new Spinner[0]));
        Util.setDefaultDoubleAttributes(this.yAxisGUIElements.classDefSpinners.toArray(new Spinner[0]));
    }

    public void bindGUIElements() {
        PopGenInpPltModule pltModule;
        this.logger.trace("bindGUIElements");
        this.logger.debug("Binding gui elements");
        DataBindingContext dbc = new DataBindingContext();
        List plots = null;
        if (this.function.equals("p")) {
            pltModule = this.input.getPopGenInpPltModule();
            plots = this.plottype.equals("2dhist") ? pltModule.get2dPlots() : (this.plottype.equals("3dhist") ? pltModule.get3dPlots() : pltModule.getScatterPlots());
        } else {
            pltModule = this.input.getObsSimRawPltModule();
            plots = this.plottype.equals("2dhist") ? pltModule.get2dPlots() : (this.plottype.equals("3dhist") ? pltModule.get3dPlots() : pltModule.getScatterPlots());
        }
        int index = 0;
        while (index < 15) {
            PlotWithOneChangableAxis plot = (PlotWithOneChangableAxis)plots.get(index);
            Util.bindBoolean(dbc, (InputElement)plot, "enabled", this.enabledCheckBoxes.get(index));
            this.bindAxisGUIElements(dbc, plot, plot.getXAxis(), this.xAxisGUIElements, index);
            if (plot instanceof PlotWithTwoChangableAxes) {
                PlotWithTwoChangableAxes plotWithTwoAxes = (PlotWithTwoChangableAxes)plots.get(index);
                this.bindAxisGUIElements(dbc, plot, plotWithTwoAxes.getYAxis(), this.yAxisGUIElements, index);
            }
            ++index;
        }
        Enabler enabler = new Enabler(this.enabledCheckBoxes.toArray(new Control[0]));
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.input.getNeopopModule(), this.function.equals("p") ? "populationAnalysisEnabled" : "observationAnalysisEnabled"));
        enabler.bind(dbc);
    }

    private void bindAxisGUIElements(DataBindingContext dbc, PlotWithOneChangableAxis<? extends ChangableAxis<? extends Enum<?>>, ? extends Enum<?>> plot, ChangableAxis<? extends Enum<?>> axis, AxisGUIElements axisGUIElements, int index) {
        Util.bindEnum(dbc, axis, "type", this.function.equals("p") ? ChangablePopGenAxisType.class : ChangableObsSimAxisType.class, axisGUIElements.typeComboViewers.get(index), new LabelProvider());
        Util.bindBoolean(dbc, axis, "logScale", axisGUIElements.logScaleButtons.get(index));
        Util.bindDouble(dbc, axis, "min", axisGUIElements.minSpinners.get(index));
        Util.bindDouble(dbc, axis, "max", axisGUIElements.maxSpinners.get(index));
        LinkedList<Control> controlsWithEnablementToBind = new LinkedList<Control>();
        controlsWithEnablementToBind.add(axisGUIElements.typeComboViewers.get(index).getControl());
        controlsWithEnablementToBind.add((Control)axisGUIElements.logScaleButtons.get(index));
        controlsWithEnablementToBind.add((Control)axisGUIElements.minSpinners.get(index));
        controlsWithEnablementToBind.add((Control)axisGUIElements.maxSpinners.get(index));
        if (axis instanceof ChangableAxisWithClassDefinition) {
            ChangableAxisWithClassDefinition axisWithClassDef = (ChangableAxisWithClassDefinition)axis;
            Util.bindDouble(dbc, (InputElement)axisWithClassDef, "classDefinition", axisGUIElements.classDefSpinners.get(index));
            Util.bindBoolean(dbc, (ModelElement)axisWithClassDef, "classDefinitionByClassWidth", axisGUIElements.classDefTypeComboViewers.get(index), "Number of Classes", "Class Width");
            controlsWithEnablementToBind.add((Control)axisGUIElements.classDefSpinners.get(index));
            controlsWithEnablementToBind.add(axisGUIElements.classDefTypeComboViewers.get(index).getControl());
        }
        Enabler enabler = new Enabler(controlsWithEnablementToBind.toArray(new Control[0]));
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.input.getNeopopModule(), this.function.equals("p") ? "populationAnalysisEnabled" : "observationAnalysisEnabled"), new ModelElementValue(plot, "enabled"));
        enabler.bind(dbc);
    }

    public void focus() {
        this.logger.trace("focus");
        if (!this.enabledCheckBoxes.isEmpty()) {
            this.enabledCheckBoxes.get(0).setFocus();
        }
    }

    public void finalizeCreation() {
        Util.activateScrolling((Control)this.parentComposite);
    }

    class AxisGUIElements {
        public List<ComboViewer> typeComboViewers = new ArrayList<ComboViewer>();
        public List<Button> logScaleButtons = new ArrayList<Button>();
        public List<Spinner> minSpinners = new ArrayList<Spinner>();
        public List<Spinner> maxSpinners = new ArrayList<Spinner>();
        public List<Spinner> classDefSpinners = new ArrayList<Spinner>();
        public List<ComboViewer> classDefTypeComboViewers = new ArrayList<ComboViewer>();

        AxisGUIElements() {
        }
    }
}

