/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts;

import de.tu_bs.ilr.esa.estec.neopop.gui.view.IPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.Enabler;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.HeteroList;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.IAggregationEquation;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.Util;
import de.tu_bs.ilr.esa.estec.neopop.model.Input;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElement;
import de.tu_bs.ilr.esa.estec.neopop.model.ModelElement;
import de.tu_bs.ilr.esa.estec.neopop.model.ModelElementValue;
import de.tu_bs.ilr.esa.estec.neopop.model.NEOPOPModule;
import de.tu_bs.ilr.esa.estec.neopop.model.PopGenInpCfgModule;
import de.tu_bs.ilr.esa.estec.neopop.model.PopGenInpInpModule;
import de.tu_bs.ilr.esa.estec.neopop.model.PopGenInpPltModule;
import de.tu_bs.ilr.esa.estec.neopop.model.PopulationAnalysisMode;
import de.tu_bs.ilr.esa.estec.neopop.model.PopulationFileFormat;
import de.tu_bs.ilr.esa.estec.neopop.model.PopulationGenerationMode;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicSettingsPopGenPart
implements IPart {
    @Inject
    private IEventBroker eventBroker;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Text commentLine0text;
    private Text commentLine1text;
    private Text dumpedPopulationFileText;
    private Text dumpedPPFText;
    private Text populationFileText;
    private Text generatedPPTFileText;
    private Button generateSyntheticUsingOldModelRadioButton;
    private Button generateSyntheticUsingNewModelRadioButton;
    private Button generateFictitiousRadioButton;
    private Button generatePPFOnlyRadioButton;
    private Button computeMOIDCheckButton;
    private Button computeCollisionProbabilityCheckButton;
    private Button dumpedPopulationCheckButton;
    private PopGenInpCfgModule popGenInpCfgModule;
    private PopGenInpInpModule popGenInpInpModule;
    private ComboViewer dumpedPopulationFileFormatComboViewer;
    private ComboViewer populationFileFormatComboViewer;
    private Spinner randomGeneratorSeedSpinner;
    private Button analyseGeneratedPopulationRadioButton;
    private Button analyseProvidedPopulationRadioButton;
    private Button analysisEpochCheckButton;
    private CDateTime analysisEpochDateTime;
    private Text analysedPopulationFileText;
    private Text analysedPPTFileText;
    private ComboViewer analysedPopulationFilesFormatComboViewer;
    private CDateTime generationEpochDateTime;
    private Composite parentComposite;
    private Button populationFileBrowseButton;
    private Button populationFileEditButton;
    private Button generatedPPTFileBrowseButton;
    private Button generatedPPTFileEditButton;
    private Button analysedPopulationFileBrowseButton;
    private Button analysedPopulationFileEditButton;
    private Button analysedPPTFileBrowseButton;
    private Button analysedPPTFileEditButton;
    private Button dumpedPopulationFileBrowseButton;
    private Button dumpedPopulationFileEditButton;
    private Button dumpedPPFBrowseButton;
    private Button dumpedPPFEditButton;
    private Label populationFileLabel;
    private Label generatedPPTFileLabel;
    private Label analysedPPTFileLabel;
    private Label analysedPopulationFileLabel;
    private Combo propagatorCombo;
    private ComboViewer propagatorComboViewer;
    private Label propagatorLabel;
    private Label populationFileFormatLabel;
    private Composite populationFileFormatComposite;
    private NEOPOPModule neopopModule;
    private Group populationGenerationGroup;
    private Composite populationFilesGroup;
    private Label generationEpochLabel;
    private Group commentGroup;
    private Group populationAnalysisGroup;
    private Composite analysedPopulationFilesComposite;
    private Label dumpedPopulationFileLabel;
    private Combo dumpedPopulationFileFormatCombo;
    private Group dumpedPopulationGroup;
    private Button drawSolarSystemPlotAxesCheckbox;
    private Group plotGenerationSpecificsGroup;
    private PopGenInpPltModule popGenInpPltModule;
    private Button plotObjectSourcesCheckBox;

    @Inject
    void setAttributesFromContext(Input input) {
        this.popGenInpCfgModule = input.getPopGenInpCfgModule();
        this.popGenInpInpModule = input.getPopGenInpInpModule();
        this.popGenInpPltModule = input.getPopGenInpPltModule();
        this.neopopModule = input.getNeopopModule();
    }

    @PostConstruct
    public void createGUIElements(Composite actualParentComposite) {
        this.logger.debug("Constructing {}", (Object)this.getClass().getSimpleName());
        actualParentComposite.setLayout((Layout)new FillLayout());
        ScrolledComposite scrolledComposite = new ScrolledComposite(actualParentComposite, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.parentComposite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)this.parentComposite);
        this.parentComposite.setLayout((Layout)new GridLayout(1, false));
        this.commentGroup = new Group(this.parentComposite, 0);
        this.commentGroup.setText("Comment Lines");
        this.commentGroup.setLayout((Layout)new GridLayout(1, false));
        this.commentGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.commentLine0text = new Text((Composite)this.commentGroup, 2048);
        this.commentLine0text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.commentLine0text.setText("<comment line 0>");
        this.commentLine1text = new Text((Composite)this.commentGroup, 2048);
        this.commentLine1text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.commentLine1text.setText("<comment line 1>");
        this.populationGenerationGroup = new Group(this.parentComposite, 0);
        this.populationGenerationGroup.setLayout((Layout)new GridLayout(2, false));
        this.populationGenerationGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.populationGenerationGroup.setText("Population Generation");
        this.generateSyntheticUsingOldModelRadioButton = new Button((Composite)this.populationGenerationGroup, 16);
        this.generateSyntheticUsingOldModelRadioButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.generateSyntheticUsingOldModelRadioButton.setText("Generate synthetic NEO population (OLD model)");
        Label computeStuffLabel = new Label((Composite)this.populationGenerationGroup, 0);
        computeStuffLabel.setText("If a population and/or at least a cross-reference file is generated:");
        this.generateSyntheticUsingNewModelRadioButton = new Button((Composite)this.populationGenerationGroup, 16);
        this.generateSyntheticUsingNewModelRadioButton.setText("Generate synthetic NEO population");
        Composite composite_2 = new Composite((Composite)this.populationGenerationGroup, 0);
        composite_2.setLayout((Layout)new RowLayout(256));
        this.computeMOIDCheckButton = new Button(composite_2, 32);
        this.computeMOIDCheckButton.setText("Compute MOID for PPF");
        this.computeCollisionProbabilityCheckButton = new Button(composite_2, 32);
        this.computeCollisionProbabilityCheckButton.setText("Compute collision probability for PPF");
        this.generateFictitiousRadioButton = new Button((Composite)this.populationGenerationGroup, 16);
        this.generateFictitiousRadioButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.generateFictitiousRadioButton.setText("Generate fictitious NEO population");
        Composite composite = new Composite((Composite)this.populationGenerationGroup, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 2));
        GridLayout gl_composite = new GridLayout(2, false);
        gl_composite.horizontalSpacing = 8;
        composite.setLayout((Layout)gl_composite);
        Label randomGeneratorSeedLabel = new Label(composite, 0);
        randomGeneratorSeedLabel.setText("Random Generator Seed:");
        this.randomGeneratorSeedSpinner = new Spinner(composite, 2048);
        this.randomGeneratorSeedSpinner.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.generationEpochLabel = new Label(composite, 0);
        this.generationEpochLabel.setText("Epoch:");
        this.generationEpochDateTime = new CDateTime(composite, 0x10A00001);
        this.generationEpochDateTime.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.generationEpochDateTime.setTimeZone("UTC");
        this.generationEpochDateTime.setPattern("yyyy-MM-dd HH:mm:ss");
        this.generatePPFOnlyRadioButton = new Button((Composite)this.populationGenerationGroup, 16);
        this.generatePPFOnlyRadioButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.generatePPFOnlyRadioButton.setText("Generate Physical Properties File only:");
        this.populationFilesGroup = new Composite((Composite)this.populationGenerationGroup, 0);
        this.populationFilesGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout gl_populationFilesGroup = new GridLayout(4, false);
        gl_populationFilesGroup.horizontalSpacing = 8;
        this.populationFilesGroup.setLayout((Layout)gl_populationFilesGroup);
        this.populationFileLabel = new Label(this.populationFilesGroup, 0);
        this.populationFileLabel.setText("Population File:");
        this.populationFileLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.populationFileText = new Text(this.populationFilesGroup, 2048);
        this.populationFileText.setText("<population file>");
        this.populationFileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.populationFileBrowseButton = new Button(this.populationFilesGroup, 0);
        this.populationFileBrowseButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-open-4.png"));
        this.populationFileBrowseButton.setToolTipText("Browse");
        this.populationFileEditButton = new Button(this.populationFilesGroup, 0);
        this.populationFileEditButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-edit.png"));
        this.populationFileEditButton.setToolTipText("Edit");
        this.generatedPPTFileLabel = new Label(this.populationFilesGroup, 0);
        this.generatedPPTFileLabel.setText("Physical Properties File:");
        this.generatedPPTFileLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.generatedPPTFileText = new Text(this.populationFilesGroup, 2048);
        this.generatedPPTFileText.setText("<ppt file>");
        this.generatedPPTFileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.generatedPPTFileBrowseButton = new Button(this.populationFilesGroup, 0);
        this.generatedPPTFileBrowseButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-open-4.png"));
        this.generatedPPTFileBrowseButton.setToolTipText("Browse");
        this.generatedPPTFileEditButton = new Button(this.populationFilesGroup, 0);
        this.generatedPPTFileEditButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-edit.png"));
        this.generatedPPTFileEditButton.setToolTipText("Edit");
        this.populationFileFormatComposite = new Composite((Composite)this.populationGenerationGroup, 0);
        this.populationFileFormatComposite.setLayout((Layout)new GridLayout(2, false));
        this.populationFileFormatLabel = new Label(this.populationFileFormatComposite, 0);
        this.populationFileFormatLabel.setText("Generated/Provided Population File Format:");
        this.populationFileFormatComboViewer = new ComboViewer(this.populationFileFormatComposite, 8);
        Combo populationFileFormatCombo = this.populationFileFormatComboViewer.getCombo();
        new Label((Composite)this.populationGenerationGroup, 0);
        this.populationAnalysisGroup = new Group(this.parentComposite, 0);
        GridLayout gl_populationAnalysisGroup = new GridLayout(3, false);
        gl_populationAnalysisGroup.horizontalSpacing = 8;
        this.populationAnalysisGroup.setLayout((Layout)gl_populationAnalysisGroup);
        this.populationAnalysisGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.populationAnalysisGroup.setText("Population Analysis");
        this.analyseGeneratedPopulationRadioButton = new Button((Composite)this.populationAnalysisGroup, 16);
        this.analyseGeneratedPopulationRadioButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.analyseGeneratedPopulationRadioButton.setText("Analyse generated population");
        this.analysisEpochCheckButton = new Button((Composite)this.populationAnalysisGroup, 32);
        this.analysisEpochCheckButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.analysisEpochCheckButton.setText("Analysis Epoch:");
        this.analysisEpochDateTime = new CDateTime((Composite)this.populationAnalysisGroup, 0x10A00001);
        this.analysisEpochDateTime.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.analysisEpochDateTime.setTimeZone("UTC");
        this.analysisEpochDateTime.setPattern("yyyy-MM-dd HH:mm:ss");
        this.analyseProvidedPopulationRadioButton = new Button((Composite)this.populationAnalysisGroup, 16);
        this.analyseProvidedPopulationRadioButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.analyseProvidedPopulationRadioButton.setText("Analyse population defined below:");
        this.propagatorLabel = new Label((Composite)this.populationAnalysisGroup, 0);
        this.propagatorLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.propagatorLabel.setText("Propagator:");
        this.propagatorComboViewer = new ComboViewer((Composite)this.populationAnalysisGroup, 8);
        this.propagatorCombo = this.propagatorComboViewer.getCombo();
        this.propagatorCombo.setItems(new String[]{"SPICE (\"PROP2B\")"});
        this.propagatorCombo.select(0);
        this.analysedPopulationFilesComposite = new Composite((Composite)this.populationAnalysisGroup, 0);
        this.analysedPopulationFilesComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        GridLayout gl_analysedPopulationFilesComposite = new GridLayout(5, false);
        gl_analysedPopulationFilesComposite.horizontalSpacing = 8;
        this.analysedPopulationFilesComposite.setLayout((Layout)gl_analysedPopulationFilesComposite);
        this.analysedPopulationFileLabel = new Label(this.analysedPopulationFilesComposite, 0);
        this.analysedPopulationFileLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.analysedPopulationFileLabel.setText("Population File:");
        this.analysedPopulationFileText = new Text(this.analysedPopulationFilesComposite, 2048);
        this.analysedPopulationFileText.setText("<population file>");
        this.analysedPopulationFileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.analysedPopulationFileBrowseButton = new Button(this.analysedPopulationFilesComposite, 0);
        this.analysedPopulationFileBrowseButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-open-4.png"));
        this.analysedPopulationFileBrowseButton.setToolTipText("Browse");
        this.analysedPopulationFileEditButton = new Button(this.analysedPopulationFilesComposite, 0);
        this.analysedPopulationFileEditButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-edit.png"));
        this.analysedPopulationFileEditButton.setToolTipText("Edit");
        this.analysedPopulationFilesFormatComboViewer = new ComboViewer(this.analysedPopulationFilesComposite, 8);
        Combo analysedPopulationFilesFormatCombo = this.analysedPopulationFilesFormatComboViewer.getCombo();
        analysedPopulationFilesFormatCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.analysedPPTFileLabel = new Label(this.analysedPopulationFilesComposite, 0);
        this.analysedPPTFileLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.analysedPPTFileLabel.setText("Physical Properties File:");
        this.analysedPPTFileText = new Text(this.analysedPopulationFilesComposite, 2048);
        this.analysedPPTFileText.setText("<ppt file>");
        this.analysedPPTFileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.analysedPPTFileBrowseButton = new Button(this.analysedPopulationFilesComposite, 0);
        this.analysedPPTFileBrowseButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-open-4.png"));
        this.analysedPPTFileBrowseButton.setToolTipText("Browse");
        this.analysedPPTFileEditButton = new Button(this.analysedPopulationFilesComposite, 0);
        this.analysedPPTFileEditButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-edit.png"));
        this.analysedPPTFileEditButton.setToolTipText("Edit");
        new Label(this.analysedPopulationFilesComposite, 0);
        this.dumpedPopulationGroup = new Group(this.parentComposite, 0);
        GridLayout gl_dumpedPopulationGroup = new GridLayout(6, false);
        gl_dumpedPopulationGroup.horizontalSpacing = 8;
        this.dumpedPopulationGroup.setLayout((Layout)gl_dumpedPopulationGroup);
        this.dumpedPopulationGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.dumpedPopulationGroup.setText("Dump Analysed Population");
        this.dumpedPopulationCheckButton = new Button((Composite)this.dumpedPopulationGroup, 32);
        this.dumpedPopulationCheckButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.dumpedPopulationCheckButton.setText("Dump subset considering filter settings, close approach analysis, etc.");
        new Label((Composite)this.dumpedPopulationGroup, 0);
        new Label((Composite)this.dumpedPopulationGroup, 0);
        new Label((Composite)this.dumpedPopulationGroup, 0);
        new Label((Composite)this.dumpedPopulationGroup, 0);
        this.dumpedPopulationFileLabel = new Label((Composite)this.dumpedPopulationGroup, 0);
        this.dumpedPopulationFileLabel.setText("Population File:");
        this.dumpedPopulationFileLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.dumpedPopulationFileText = new Text((Composite)this.dumpedPopulationGroup, 2048);
        this.dumpedPopulationFileText.setText("<subset.cat>");
        this.dumpedPopulationFileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.dumpedPopulationFileBrowseButton = new Button((Composite)this.dumpedPopulationGroup, 0);
        this.dumpedPopulationFileBrowseButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-open-4.png"));
        this.dumpedPopulationFileBrowseButton.setToolTipText("Browse");
        this.dumpedPopulationFileEditButton = new Button((Composite)this.dumpedPopulationGroup, 0);
        this.dumpedPopulationFileEditButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-edit.png"));
        this.dumpedPopulationFileEditButton.setToolTipText("Edit");
        this.dumpedPopulationFileFormatComboViewer = new ComboViewer((Composite)this.dumpedPopulationGroup, 8);
        this.dumpedPopulationFileFormatCombo = this.dumpedPopulationFileFormatComboViewer.getCombo();
        this.dumpedPopulationFileFormatCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        new Label((Composite)this.dumpedPopulationGroup, 0);
        Label dumpedPPFLabel = new Label((Composite)this.dumpedPopulationGroup, 0);
        dumpedPPFLabel.setText("Physical Properties File:");
        dumpedPPFLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.dumpedPPFText = new Text((Composite)this.dumpedPopulationGroup, 2048);
        this.dumpedPPFText.setText("<subset.ppf>");
        this.dumpedPPFText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.dumpedPPFBrowseButton = new Button((Composite)this.dumpedPopulationGroup, 0);
        this.dumpedPPFBrowseButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-open-4.png"));
        this.dumpedPPFBrowseButton.setToolTipText("Browse");
        this.dumpedPPFEditButton = new Button((Composite)this.dumpedPopulationGroup, 0);
        this.dumpedPPFEditButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-edit.png"));
        this.dumpedPPFEditButton.setToolTipText("Edit");
        new Label((Composite)this.dumpedPopulationGroup, 0);
        this.plotGenerationSpecificsGroup = new Group(this.parentComposite, 0);
        this.plotGenerationSpecificsGroup.setLayout((Layout)new GridLayout(2, false));
        this.plotGenerationSpecificsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.plotGenerationSpecificsGroup.setText("Plot Generation Specifics");
        this.drawSolarSystemPlotAxesCheckbox = new Button((Composite)this.plotGenerationSpecificsGroup, 32);
        this.drawSolarSystemPlotAxesCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.drawSolarSystemPlotAxesCheckbox.setText("Draw Axes in Solar System Plots");
        this.plotObjectSourcesCheckBox = new Button((Composite)this.plotGenerationSpecificsGroup, 32);
        this.plotObjectSourcesCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.plotObjectSourcesCheckBox.setText("Plot Object Sources instead of Groups in 2D Plots");
    }

    public void doAdditionalStuff() {
        Util.setDefaultIntegerAttributes(this.randomGeneratorSeedSpinner);
        Util.letItSendBrowseFileEvents(this.eventBroker, this.populationFileBrowseButton, this.popGenInpInpModule.getPopulationGeneration().getGeneratedPopulationFiles(), "populationFilePath");
        Util.letItSendBrowseFileEvents(this.eventBroker, this.generatedPPTFileBrowseButton, this.popGenInpInpModule.getPopulationGeneration().getGeneratedPopulationFiles(), "crossReferenceFilePath");
        Util.letItSendBrowseFileEvents(this.eventBroker, this.analysedPopulationFileBrowseButton, this.popGenInpInpModule.getPopulationAnalysis().getAnalysedPopulationFiles(), "populationFilePath");
        Util.letItSendBrowseFileEvents(this.eventBroker, this.analysedPPTFileBrowseButton, this.popGenInpInpModule.getPopulationAnalysis().getAnalysedPopulationFiles(), "crossReferenceFilePath");
        Util.letItSendBrowseFileEvents(this.eventBroker, this.dumpedPopulationFileBrowseButton, this.popGenInpInpModule.getPopulationAnalysis().getPopulationDump(), "populationFilePath");
        Util.letItSendBrowseFileEvents(this.eventBroker, this.dumpedPPFBrowseButton, this.popGenInpInpModule.getPopulationAnalysis().getPopulationDump(), "crossReferenceFilePath");
        Util.letItSendEditFileEvents(this.eventBroker, this.populationFileEditButton, this.popGenInpInpModule.getPopulationGeneration().getGeneratedPopulationFiles(), "populationFilePath");
        Util.letItSendEditFileEvents(this.eventBroker, this.generatedPPTFileEditButton, this.popGenInpInpModule.getPopulationGeneration().getGeneratedPopulationFiles(), "crossReferenceFilePath");
        Util.letItSendEditFileEvents(this.eventBroker, this.analysedPopulationFileEditButton, this.popGenInpInpModule.getPopulationAnalysis().getAnalysedPopulationFiles(), "populationFilePath");
        Util.letItSendEditFileEvents(this.eventBroker, this.analysedPPTFileEditButton, this.popGenInpInpModule.getPopulationAnalysis().getAnalysedPopulationFiles(), "crossReferenceFilePath");
        Util.letItSendEditFileEvents(this.eventBroker, this.dumpedPopulationFileEditButton, this.popGenInpInpModule.getPopulationAnalysis().getPopulationDump(), "populationFilePath");
        Util.letItSendEditFileEvents(this.eventBroker, this.dumpedPPFEditButton, this.popGenInpInpModule.getPopulationAnalysis().getPopulationDump(), "crossReferenceFilePath");
        this.generateSyntheticUsingOldModelRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BasicSettingsPopGenPart.this.generateSyntheticUsingOldModelRadioButton.getSelection()) {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"This NEO model is outdated. It should be used only for comparison of the methods, their improvements, and for discussion about technical details.");
                }
            }
        });
    }

    public void bindGUIElements() {
        DataBindingContext dbc = new DataBindingContext();
        Util.bindString(dbc, (ModelElement)this.popGenInpCfgModule.getComment(), "line0", this.commentLine0text);
        Util.bindString(dbc, (ModelElement)this.popGenInpCfgModule.getComment(), "line1", this.commentLine1text);
        Util.bindString(dbc, (ModelElement)this.popGenInpInpModule.getPopulationGeneration().getGeneratedPopulationFiles(), "populationFilePath", this.populationFileText);
        Util.bindString(dbc, (ModelElement)this.popGenInpInpModule.getPopulationGeneration().getGeneratedPopulationFiles(), "crossReferenceFilePath", this.generatedPPTFileText);
        Util.bindEnum(dbc, (InputElement)this.popGenInpInpModule.getPopulationGeneration().getGeneratedPopulationFiles(), "format", PopulationFileFormat.class, this.populationFileFormatComboViewer, new LabelProvider());
        Util.bindString(dbc, (ModelElement)this.popGenInpInpModule.getPopulationAnalysis().getAnalysedPopulationFiles(), "populationFilePath", this.analysedPopulationFileText);
        Util.bindString(dbc, (ModelElement)this.popGenInpInpModule.getPopulationAnalysis().getAnalysedPopulationFiles(), "crossReferenceFilePath", this.analysedPPTFileText);
        Util.bindEnum(dbc, (InputElement)this.popGenInpInpModule.getPopulationAnalysis().getAnalysedPopulationFiles(), "format", PopulationFileFormat.class, this.analysedPopulationFilesFormatComboViewer, new LabelProvider());
        Util.bindString(dbc, (ModelElement)this.popGenInpInpModule.getPopulationAnalysis().getPopulationDump(), "populationFilePath", this.dumpedPopulationFileText);
        Util.bindString(dbc, (ModelElement)this.popGenInpInpModule.getPopulationAnalysis().getPopulationDump(), "crossReferenceFilePath", this.dumpedPPFText);
        Util.bindEnum(dbc, (InputElement)this.popGenInpInpModule.getPopulationAnalysis().getPopulationDump(), "format", PopulationFileFormat.class, this.dumpedPopulationFileFormatComboViewer, new LabelProvider());
        Util.bindEnum(dbc, (InputElement)this.popGenInpInpModule.getPopulationGeneration(), "mode", PopulationGenerationMode.class, this.generateSyntheticUsingOldModelRadioButton, this.generateSyntheticUsingNewModelRadioButton, this.generateFictitiousRadioButton, this.generatePPFOnlyRadioButton);
        Util.bindBoolean(dbc, (InputElement)this.popGenInpInpModule.getPopulationAnalysis().getPopulationDump(), "selected", this.dumpedPopulationCheckButton);
        Util.bindBoolean(dbc, (InputElement)this.popGenInpInpModule.getPopulationGeneration(), "computeMOID", this.computeMOIDCheckButton);
        Util.bindBoolean(dbc, (InputElement)this.popGenInpInpModule.getPopulationGeneration(), "computeStatisticalCollisionProbability", this.computeCollisionProbabilityCheckButton);
        Util.bindInteger(dbc, (InputElement)this.popGenInpInpModule.getPopulationGeneration(), "randomGeneratorSeed", this.randomGeneratorSeedSpinner);
        Util.bindEnum(dbc, (InputElement)this.popGenInpInpModule.getPopulationAnalysis(), "mode", PopulationAnalysisMode.class, this.analyseGeneratedPopulationRadioButton, this.analyseProvidedPopulationRadioButton);
        Util.bindBoolean(dbc, (InputElement)this.popGenInpInpModule.getPopulationAnalysis().getAnalysisEpoch(), "enabled", this.analysisEpochCheckButton);
        Util.bindDateTime(dbc, (InputElement)this.popGenInpInpModule.getPopulationAnalysis().getAnalysisEpoch(), "referenceEpoch", this.analysisEpochDateTime);
        Util.bindDateTime(dbc, (InputElement)this.popGenInpInpModule.getPopulationGeneration(), "epoch", this.generationEpochDateTime);
        Util.bindBoolean(dbc, (InputElement)this.popGenInpPltModule, "drawSolarSystemPlotAxes", this.drawSolarSystemPlotAxesCheckbox);
        Util.bindBoolean(dbc, (InputElement)this.popGenInpPltModule, "plotSourcesIn2DPlots", this.plotObjectSourcesCheckBox);
        Enabler enabler = new Enabler((Composite)this.commentGroup);
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "populationGenerationEnabled"), new ModelElementValue((ModelElement)this.neopopModule, "populationAnalysisEnabled"));
        enabler.setAggregationEquation(IAggregationEquation.OR_BOOLEANS);
        enabler.bind(dbc);
        enabler = new Enabler((Composite)this.populationGenerationGroup);
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "populationGenerationEnabled"));
        enabler.setOutputControlsToBeIgnored(new Control[]{this.populationFilesGroup});
        enabler.bind(dbc);
        enabler = new Enabler(this.populationFilesGroup);
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "populationGenerationEnabled"), new ModelElementValue((ModelElement)this.popGenInpInpModule.getPopulationGeneration(), "mode"));
        enabler.setAggregationEquation(new IAggregationEquation(){

            @Override
            public Object aggregate(HeteroList values) {
                if (((Boolean)values.getTyped(0)).booleanValue() && values.getTyped(1) == PopulationGenerationMode.GENERATE_PHYSICAL_PROPERTIES_FILE_FOR_PROVIDED_POPULATION) {
                    return true;
                }
                return false;
            }
        });
        enabler.bind(dbc);
        enabler = new Enabler((Composite)this.populationAnalysisGroup);
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "populationAnalysisEnabled"));
        enabler.setOutputControlsToBeIgnored(new Control[]{this.analysedPopulationFilesComposite, this.analysisEpochDateTime});
        enabler.bind(dbc);
        enabler = new Enabler(this.analysedPopulationFilesComposite);
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "populationAnalysisEnabled"), new ModelElementValue((ModelElement)this.popGenInpInpModule.getPopulationAnalysis(), "mode"));
        enabler.setAggregationEquation(new IAggregationEquation(){

            @Override
            public Object aggregate(HeteroList values) {
                if (((Boolean)values.getTyped(0)).booleanValue() && values.getTyped(1) == PopulationAnalysisMode.ANALYSE_USER_PROVIDED_POPULATION) {
                    return true;
                }
                return false;
            }
        });
        enabler.bind(dbc);
        enabler = new Enabler((Composite)this.analysisEpochDateTime);
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "populationAnalysisEnabled"), new ModelElementValue((ModelElement)this.popGenInpInpModule.getPopulationAnalysis().getAnalysisEpoch(), "enabled"));
        enabler.bind(dbc);
        enabler = new Enabler((Composite)this.dumpedPopulationGroup, (Control)this.dumpedPopulationGroup, (Control)this.dumpedPopulationCheckButton);
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "populationAnalysisEnabled"));
        enabler.bind(dbc);
        enabler = new Enabler((Composite)this.dumpedPopulationGroup, (Control)this.dumpedPopulationFileLabel, (Control)this.dumpedPPFEditButton);
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "populationAnalysisEnabled"), new ModelElementValue((ModelElement)this.popGenInpInpModule.getPopulationAnalysis().getPopulationDump(), "selected"));
        enabler.bind(dbc);
        enabler = new Enabler((Composite)this.plotGenerationSpecificsGroup);
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "populationAnalysisEnabled"));
        enabler.bind(dbc);
    }

    public void finalizeCreation() {
        Util.activateScrolling((Control)this.parentComposite);
    }

    public void focus() {
        this.commentLine0text.setFocus();
    }
}

