/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.dialogs;

import de.tu_bs.ilr.esa.estec.neopop.gui.view.IDialog;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.dialogs.ButtonType;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NEOPOPDialog
extends Dialog
implements IDialog {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ButtonType pressedButton = null;
    private boolean disposing = false;
    @Inject
    protected IEventBroker eventBroker;
    @Inject
    @Named(value="de.tu_bs.ilr.esa.estec.neopop.gui.simple_dialog.title")
    protected String title;
    private boolean makeParentInvisibleAfterDialogOpened = false;

    public NEOPOPDialog() {
        super(Display.getDefault().getActiveShell() == null ? new Shell(Display.getDefault(), 16384) : Display.getDefault().getActiveShell(), 67680);
    }

    public NEOPOPDialog(boolean makeParentInvisibleAfterDialogOpened) {
        this();
        this.makeParentInvisibleAfterDialogOpened = makeParentInvisibleAfterDialogOpened;
    }

    public abstract void open();

    public abstract Shell getShell();

    public void doOpen() {
        this.logger.trace("doOpen");
        this.open();
        this.logger.debug("title={}", (Object)this.title);
        this.getShell().setText(this.title);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                NEOPOPDialog.this.logger.trace("Shell dispose listener");
                if (!NEOPOPDialog.this.disposing) {
                    NEOPOPDialog.this.pressed(ButtonType.X);
                }
            }
        });
        this.getShell().open();
        this.getShell().layout();
        this.getShell().forceActive();
        this.getShell().forceFocus();
        if (this.makeParentInvisibleAfterDialogOpened) {
            this.getParent().setVisible(false);
        }
        Display display = this.getParent().getDisplay();
        while (!this.getShell().isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void pressed(ButtonType button) {
        this.pressedButton = button;
        this.logger.debug("pressedButton={}", (Object)button);
        this.saveAndLogContents();
        this.process(button);
        if (button == ButtonType.X) {
            this.dispose();
        }
    }

    protected abstract void process(ButtonType var1);

    protected abstract void saveAndLogContents();

    public void dispose() {
        this.logger.trace("dispose");
        this.disposing = true;
        this.saveAndLogContents();
        if (this.pressedButton != ButtonType.X) {
            this.getShell().dispose();
        }
    }

    public ButtonType getPressedButton() {
        return this.pressedButton;
    }

    class ButtonPressListener
    extends SelectionAdapter {
        private ButtonType buttonType;

        public ButtonPressListener(ButtonType buttonType) {
            this.buttonType = buttonType;
        }

        public void widgetSelected(SelectionEvent e) {
            NEOPOPDialog.this.logger.trace("{} button selection listener", (Object)this.buttonType);
            NEOPOPDialog.this.pressed(this.buttonType);
        }
    }
}

