/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.databinding.conversion.IConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumToButtonSelectionConverter<T extends Enum<?>>
implements IConverter {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Class<T> enumClass;
    private T value;

    public EnumToButtonSelectionConverter(Class<T> enumClass, int enumOrdinal) {
        this.enumClass = enumClass;
        Method m = null;
        try {
            m = this.enumClass.getDeclaredMethod("values", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            this.logger.error("Could not get enum values method");
            throw new RuntimeException(e);
        }
        Enum[] values = null;
        try {
            values = (Enum[])m.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.logger.error("Could not invoke enum values method");
            throw new RuntimeException(e);
        }
        this.value = values[enumOrdinal];
    }

    public Object getFromType() {
        return this.enumClass;
    }

    public Object getToType() {
        return Boolean.class;
    }

    public Object convert(Object fromObject) {
        Enum e = (Enum)fromObject;
        if (e == this.value) {
            return true;
        }
        return false;
    }
}

