/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.swt.widgets.Button;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ButtonSelectionToEnumConverter<T extends Enum<?>>
implements IConverter {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Class<T> enumClass;
    private Button[] buttons;

    public ButtonSelectionToEnumConverter(Class<T> enumClass, Button ... buttons) {
        this.enumClass = enumClass;
        this.buttons = buttons;
    }

    public Object getFromType() {
        return Boolean.class;
    }

    public Object getToType() {
        return this.enumClass;
    }

    public Object convert(Object fromObject) {
        int ordinal = 0;
        while (ordinal < this.buttons.length) {
            if (this.buttons[ordinal].getSelection()) {
                Method m = null;
                try {
                    m = this.enumClass.getDeclaredMethod("values", new Class[0]);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    this.logger.error("Could not get enum values method");
                    throw new RuntimeException(e);
                }
                Enum[] values = null;
                try {
                    values = (Enum[])m.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    this.logger.error("Could not invoke enum values method");
                    throw new RuntimeException(e);
                }
                return values[ordinal];
            }
            ++ordinal;
        }
        return null;
    }
}

