/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.view;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PartType {
    SETTINGS_OVERVIEW("de.tu_bs.ilr.esa.estec.neopop.gui.parts.settings.overview"),
    FILTER_SETTINGS("de.tu_bs.ilr.esa.estec.neopop.gui.parts.settings.filter"),
    BASIC_SETTINGS_POPGEN("de.tu_bs.ilr.esa.estec.neopop.gui.parts.settings.basic.popgen"),
    POPULATION_SETTINGS_POPGEN("de.tu_bs.ilr.esa.estec.neopop.gui.parts.settings.population.popgen"),
    HISTOGRAM_SETTINGS_2D_POPGEN("de.tu_bs.ilr.esa.estec.neopop.gui.parts.settings.histograms.2d.popgen"),
    HISTOGRAM_SETTINGS_3D_POPGEN("de.tu_bs.ilr.esa.estec.neopop.gui.parts.settings.histograms.3d.popgen"),
    SCATTER_PLOT_SETTINGS_POPGEN("de.tu_bs.ilr.esa.estec.neopop.gui.parts.settings.scatterplots.popgen"),
    BASIC_SETTINGS_OBSSIM("de.tu_bs.ilr.esa.estec.neopop.gui.parts.settings.basic.obssim"),
    POPULATION_SETTINGS_OBSSIM("de.tu_bs.ilr.esa.estec.neopop.gui.parts.settings.population.obssim"),
    NETWORK_SETTINGS("de.tu_bs.ilr.esa.estec.neopop.gui.parts.settings.network"),
    GROUND_BASED_LOCATION_SETTINGS("de.tu_bs.ilr.esa.estec.neopop.gui.parts.settings.locations.ground"),
    SPACE_BASED_LOCATIONS_SETTINGS("de.tu_bs.ilr.esa.estec.neopop.gui.parts.settings.locations.space"),
    OPTICAL_SENSOR_SETTINGS("de.tu_bs.ilr.esa.estec.neopop.gui.parts.settings.sensors.optical"),
    RADAR_SENSOR_SETTINGS("de.tu_bs.ilr.esa.estec.neopop.gui.parts.settings.sensors.radar"),
    HISTOGRAM_SETTINGS_2D_OBSSIM("de.tu_bs.ilr.esa.estec.neopop.gui.parts.settings.histograms.2d.obssim"),
    HISTOGRAM_SETTINGS_3D_OBSSIM("de.tu_bs.ilr.esa.estec.neopop.gui.parts.settings.histograms.3d.obssim"),
    SCATTER_PLOT_SETTINGS_OBSSIM("de.tu_bs.ilr.esa.estec.neopop.gui.parts.settings.scatterplots.obssim"),
    OUTPUT_SUBJECT("de.tu_bs.ilr.esa.estec.neopop.gui.parts.output.subject"),
    OUTPUT_CATEGORY("de.tu_bs.ilr.esa.estec.neopop.gui.parts.output.category"),
    PLOT_OUTPUT_OBJECT("de.tu_bs.ilr.esa.estec.neopop.gui.parts.output.object.plot"),
    TEXT_OUTPUT_OBJECT("de.tu_bs.ilr.esa.estec.neopop.gui.parts.output.object.text"),
    GNUPLOT_TEXT_OUTPUT_OBJECT("de.tu_bs.ilr.esa.estec.neopop.gui.parts.output.object.text.gnuplot"),
    DUMMY_OUTPUT_OBJECT("de.tu_bs.ilr.esa.estec.neopop.gui.parts.output.object.primary.dummy");

    public static final PartType[] NON_SPECIFIC_SETTINGS_PARTS;
    public static final PartType[] POPULATION_GENERATOR_SETTINGS_PARTS;
    public static final PartType[] OBSERVATION_SIMULATOR_SETTINGS_PARTS;
    private static Map<String, PartType> typeByPartID;
    private Logger logger = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass() + "." + this.name()));
    private String id;

    static {
        NON_SPECIFIC_SETTINGS_PARTS = new PartType[0];
        POPULATION_GENERATOR_SETTINGS_PARTS = new PartType[]{BASIC_SETTINGS_POPGEN, POPULATION_SETTINGS_POPGEN, FILTER_SETTINGS, HISTOGRAM_SETTINGS_2D_POPGEN, HISTOGRAM_SETTINGS_3D_POPGEN, SCATTER_PLOT_SETTINGS_POPGEN};
        OBSERVATION_SIMULATOR_SETTINGS_PARTS = new PartType[]{BASIC_SETTINGS_OBSSIM, POPULATION_SETTINGS_OBSSIM, NETWORK_SETTINGS, GROUND_BASED_LOCATION_SETTINGS, SPACE_BASED_LOCATIONS_SETTINGS, OPTICAL_SENSOR_SETTINGS, RADAR_SENSOR_SETTINGS, HISTOGRAM_SETTINGS_2D_OBSSIM, HISTOGRAM_SETTINGS_3D_OBSSIM, SCATTER_PLOT_SETTINGS_OBSSIM};
        typeByPartID = new HashMap<String, PartType>();
        PartType[] partTypeArray = PartType.values();
        int n = partTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PartType settingsType = partTypeArray[n2];
            typeByPartID.put(settingsType.getID(), settingsType);
            ++n2;
        }
    }

    public static PartType getByID(String partID) {
        return typeByPartID.get(partID);
    }

    private PartType(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public String getButtonName(EPartService partService) {
        MPart part = partService.findPart(this.id);
        Object buttonName = part.getProperties().get("buttonName");
        if (buttonName == null) {
            String partLabel = part.getLabel();
            if (partLabel.endsWith(" (Population Generator)")) {
                return partLabel.replace(" (Population Generator)", "");
            }
            if (partLabel.endsWith(" (Observation Simulator)")) {
                return partLabel.replace(" (Observation Simulator)", "");
            }
            return part.getLabel();
        }
        if (!(buttonName instanceof String)) {
            this.logger.error("button name is not a string ?!");
            return null;
        }
        return (String)buttonName;
    }

    public String getName(EPartService partService) {
        MPart part = partService.findPart(this.id);
        return part.getLabel();
    }
}

