/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.FilterManager;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessBuffer;
import org.apache.pdfbox.io.RandomAccessFile;
import org.apache.pdfbox.io.RandomAccessFileInputStream;
import org.apache.pdfbox.io.RandomAccessFileOutputStream;
import org.apache.pdfbox.pdfparser.PDFStreamParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class COSStream
extends COSDictionary
implements Closeable {
    private static final Log LOG = LogFactory.getLog(COSStream.class);
    private static final int BUFFER_SIZE = 16384;
    private RandomAccess file;
    private RandomAccessFileOutputStream filteredStream;
    private RandomAccessFileOutputStream unFilteredStream;

    private RandomAccess clone(RandomAccess file) {
        if (file == null) {
            return null;
        }
        if (file instanceof RandomAccessFile) {
            return file;
        }
        return ((RandomAccessBuffer)file).clone();
    }

    public COSStream(RandomAccess storage) {
        this.file = this.clone(storage);
    }

    public COSStream(COSDictionary dictionary, RandomAccess storage) {
        super(dictionary);
        this.file = this.clone(storage);
    }

    public void replaceWithStream(COSStream stream) {
        this.clear();
        this.addAll(stream);
        this.file = stream.file;
        this.filteredStream = stream.filteredStream;
        this.unFilteredStream = stream.unFilteredStream;
    }

    public RandomAccess getScratchFile() {
        return this.file;
    }

    public List<Object> getStreamTokens() throws IOException {
        PDFStreamParser parser = new PDFStreamParser(this);
        parser.parse();
        return parser.getTokens();
    }

    public InputStream getFilteredStream() throws IOException {
        if (this.filteredStream == null) {
            this.doEncode();
        }
        long position = this.filteredStream.getPosition();
        long length = this.filteredStream.getLengthWritten();
        RandomAccessFileInputStream input = new RandomAccessFileInputStream(this.file, position, length);
        return new BufferedInputStream(input, 16384);
    }

    public long getFilteredLength() throws IOException {
        if (this.filteredStream == null) {
            this.doEncode();
        }
        return this.filteredStream.getLength();
    }

    public InputStream getUnfilteredStream() throws IOException {
        InputStream retval;
        if (this.unFilteredStream == null) {
            this.doDecode();
        }
        if (this.unFilteredStream != null) {
            long position = this.unFilteredStream.getPosition();
            long length = this.unFilteredStream.getLengthWritten();
            RandomAccessFileInputStream input = new RandomAccessFileInputStream(this.file, position, length);
            retval = new BufferedInputStream(input, 16384);
        } else {
            retval = new ByteArrayInputStream(new byte[0]);
        }
        return retval;
    }

    @Override
    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromStream(this);
    }

    private void doDecode() throws IOException {
        this.unFilteredStream = this.filteredStream;
        COSBase filters = this.getFilters();
        if (filters != null) {
            if (filters instanceof COSName) {
                this.doDecode((COSName)filters, 0);
            } else if (filters instanceof COSArray) {
                COSArray filterArray = (COSArray)filters;
                for (int i = 0; i < filterArray.size(); ++i) {
                    COSName filterName = (COSName)filterArray.get(i);
                    this.doDecode(filterName, i);
                }
            } else {
                throw new IOException("Error: Unknown filter type:" + filters);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDecode(COSName filterName, int filterIndex) throws IOException {
        FilterManager manager = this.getFilterManager();
        Filter filter = manager.getFilter(filterName);
        boolean done = false;
        IOException exception = null;
        long position = this.unFilteredStream.getPosition();
        long length = this.unFilteredStream.getLength();
        long writtenLength = this.unFilteredStream.getLengthWritten();
        if (length == 0L && writtenLength == 0L) {
            IOUtils.closeQuietly(this.unFilteredStream);
            this.unFilteredStream = new RandomAccessFileOutputStream(this.file);
            done = true;
        } else {
            BufferedInputStream input;
            int tryCount;
            for (tryCount = 0; length > 0L && !done && tryCount < 5; ++tryCount) {
                input = null;
                try {
                    input = new BufferedInputStream(new RandomAccessFileInputStream(this.file, position, length), 16384);
                    IOUtils.closeQuietly(this.unFilteredStream);
                    this.unFilteredStream = new RandomAccessFileOutputStream(this.file);
                    filter.decode(input, this.unFilteredStream, this, filterIndex);
                    done = true;
                    IOUtils.closeQuietly(input);
                    continue;
                }
                catch (IOException io) {
                    --length;
                    exception = io;
                    continue;
                }
                finally {
                    IOUtils.closeQuietly(input);
                }
            }
            if (!done) {
                length = writtenLength;
                for (tryCount = 0; !done && tryCount < 5; ++tryCount) {
                    input = null;
                    try {
                        input = new BufferedInputStream(new RandomAccessFileInputStream(this.file, position, length), 16384);
                        IOUtils.closeQuietly(this.unFilteredStream);
                        this.unFilteredStream = new RandomAccessFileOutputStream(this.file);
                        filter.decode(input, this.unFilteredStream, this, filterIndex);
                        done = true;
                    }
                    catch (IOException io) {
                        try {
                            --length;
                            exception = io;
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(input);
                            throw throwable;
                        }
                        IOUtils.closeQuietly(input);
                        continue;
                    }
                    IOUtils.closeQuietly(input);
                    continue;
                }
            }
        }
        if (!done) {
            throw exception;
        }
    }

    private void doEncode() throws IOException {
        this.filteredStream = this.unFilteredStream;
        COSBase filters = this.getFilters();
        if (filters != null) {
            if (filters instanceof COSName) {
                this.doEncode((COSName)filters, 0);
            } else if (filters instanceof COSArray) {
                COSArray filterArray = (COSArray)filters;
                for (int i = filterArray.size() - 1; i >= 0; --i) {
                    COSName filterName = (COSName)filterArray.get(i);
                    this.doEncode(filterName, i);
                }
            }
        }
    }

    private void doEncode(COSName filterName, int filterIndex) throws IOException {
        FilterManager manager = this.getFilterManager();
        Filter filter = manager.getFilter(filterName);
        BufferedInputStream input = new BufferedInputStream(new RandomAccessFileInputStream(this.file, this.filteredStream.getPosition(), this.filteredStream.getLength()), 16384);
        IOUtils.closeQuietly(this.filteredStream);
        this.filteredStream = new RandomAccessFileOutputStream(this.file);
        filter.encode(input, this.filteredStream, this, filterIndex);
        IOUtils.closeQuietly(input);
    }

    public COSBase getFilters() {
        return this.getDictionaryObject(COSName.FILTER);
    }

    public OutputStream createFilteredStream() throws IOException {
        IOUtils.closeQuietly(this.unFilteredStream);
        this.unFilteredStream = null;
        IOUtils.closeQuietly(this.filteredStream);
        this.filteredStream = new RandomAccessFileOutputStream(this.file);
        return new BufferedOutputStream(this.filteredStream, 16384);
    }

    public OutputStream createFilteredStream(COSBase expectedLength) throws IOException {
        IOUtils.closeQuietly(this.unFilteredStream);
        this.unFilteredStream = null;
        IOUtils.closeQuietly(this.filteredStream);
        this.filteredStream = new RandomAccessFileOutputStream(this.file);
        this.filteredStream.setExpectedLength(expectedLength);
        return new BufferedOutputStream(this.filteredStream, 16384);
    }

    public void setFilters(COSBase filters) throws IOException {
        this.setItem(COSName.FILTER, filters);
        IOUtils.closeQuietly(this.filteredStream);
        this.filteredStream = null;
    }

    public OutputStream createUnfilteredStream() throws IOException {
        IOUtils.closeQuietly(this.filteredStream);
        this.filteredStream = null;
        IOUtils.closeQuietly(this.unFilteredStream);
        this.unFilteredStream = new RandomAccessFileOutputStream(this.file);
        return new BufferedOutputStream(this.unFilteredStream, 16384);
    }

    @Override
    public void close() {
        try {
            if (this.file != null) {
                this.file.close();
                this.file = null;
            }
        }
        catch (IOException exception) {
            LOG.error("Exception occured when closing the file.", exception);
        }
        if (this.filteredStream != null) {
            IOUtils.closeQuietly(this.filteredStream);
        }
        if (this.unFilteredStream != null) {
            IOUtils.closeQuietly(this.unFilteredStream);
        }
        this.clear();
    }
}

