/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts;

import de.tu_bs.ilr.esa.estec.neopop.gui.view.ITextOutputObjectPart;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.swt.ResourceManager;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextOutputObjectPart
implements ITextOutputObjectPart {
    public static final int MAX_FILE_SIZE = 0x200000;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String filePath;
    private Composite parentComposite;
    @Inject
    private UISynchronize uiSynch;
    private boolean disposed = false;
    private StyledText styledText;

    @Inject
    void setAttributesFromContext(@Named(value="filePath") String filePath) {
        this.logger.trace("setAttributesFromContext");
        this.filePath = filePath;
        this.logger.debug("File path: {}", (Object)filePath);
    }

    @PostConstruct
    void createGUIElements(Composite parentComposite) {
        this.logger.trace("createGUIElements");
        this.logger.debug("Creating GUI elements");
        this.parentComposite = parentComposite;
        parentComposite.setLayout((Layout)new GridLayout(1, false));
        this.styledText = new StyledText(parentComposite, 2816);
        this.styledText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.styledText.setFont(ResourceManager.getFont("Courier", 10, 0));
    }

    public void doAdditionalStuff() {
        this.logger.trace("doAdditionalStuff");
        this.logger.debug("Doing additional stuff");
        this.reloadText();
    }

    @Inject
    @Optional
    void onOutputDestroyEvent(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/output/destroy") Event event) {
        this.logger.trace("onOutputDestroyEvent");
        if (this.disposed) {
            return;
        }
        this.uiSynch.syncExec(new Runnable(){

            @Override
            public void run() {
                TextOutputObjectPart.this.styledText.dispose();
            }
        });
        this.disposed = true;
    }

    public void bindGUIElements() {
        this.logger.trace("bindGUIElements");
        this.logger.debug("Binding GUI elements");
    }

    public void focus() {
        this.logger.trace("focus");
        this.styledText.setFocus();
    }

    @PreDestroy
    void preDestroy() {
        this.logger.trace("preDestroy");
        this.styledText.dispose();
    }

    public void finalizeCreation() {
        this.logger.trace("finalizeCreation");
        this.logger.debug("Finalizing creation");
    }

    public String getText() {
        return this.styledText.isDisposed() ? null : this.styledText.getText();
    }

    public void reloadText() {
        StringBuilder textFieldContent;
        block23: {
            this.logger.trace("reloadText");
            this.logger.debug("Reading text file");
            File file = new File(this.filePath);
            textFieldContent = new StringBuilder("");
            if (file.length() > 0x200000L) {
                this.logger.info("Didn't read text file \"{}\" since it is bigger than {} MiB", (Object)this.filePath, (Object)2.0);
                textFieldContent.append("This file is bigger than 2.0 MiB\n");
                textFieldContent.append("Note: File is located at \"" + this.filePath + "\"");
            } else {
                FileInputStream ifs = null;
                InputStreamReader isr = null;
                BufferedReader br = null;
                try {
                    try {
                        ifs = new FileInputStream(file);
                        isr = new InputStreamReader(ifs);
                        br = new BufferedReader(isr);
                        this.logger.debug("Reading line");
                        String line = br.readLine();
                        while (line != null) {
                            this.logger.debug("\"Saving\" line");
                            textFieldContent.append(line);
                            textFieldContent.append("\n");
                            this.logger.debug("Reading line");
                            line = br.readLine();
                        }
                    }
                    catch (IOException e) {
                        this.logger.error("Could not read text file \"{}\":", (Object)this.filePath, (Object)e);
                        try {
                            if (ifs != null) {
                                ifs.close();
                            }
                            if (isr != null) {
                                isr.close();
                            }
                            if (br != null) {
                                br.close();
                            }
                            break block23;
                        }
                        catch (IOException e2) {
                            this.logger.error("Could not close one of the data streams for file \"{}\":", (Object)this.filePath);
                            this.logger.debug("Exception: ", (Throwable)e2);
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (ifs != null) {
                            ifs.close();
                        }
                        if (isr != null) {
                            isr.close();
                        }
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException e) {
                        this.logger.error("Could not close one of the data streams for file \"{}\":", (Object)this.filePath);
                        this.logger.debug("Exception: ", (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    if (ifs != null) {
                        ifs.close();
                    }
                    if (isr != null) {
                        isr.close();
                    }
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {
                    this.logger.error("Could not close one of the data streams for file \"{}\":", (Object)this.filePath);
                    this.logger.debug("Exception: ", (Throwable)e);
                }
            }
        }
        this.logger.debug("Done with reading text file");
        this.logger.debug("Setting text field text");
        this.styledText.setText(textFieldContent.toString());
        this.logger.debug("Done with setting text field text");
    }
}

