/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts;

import de.tu_bs.ilr.esa.estec.neopop.gui.util.ExtendedUpdateValueStrategy;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.IPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.Enabler;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.HeteroList;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.IAggregationEquation;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.Util;
import de.tu_bs.ilr.esa.estec.neopop.model.Input;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElement;
import de.tu_bs.ilr.esa.estec.neopop.model.ModelElement;
import de.tu_bs.ilr.esa.estec.neopop.model.ModelElementValue;
import de.tu_bs.ilr.esa.estec.neopop.model.NEOPOPModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawCfgModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawSbModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawSrcModule;
import de.tu_bs.ilr.esa.estec.neopop.model.OrbitDefinitionType;
import de.tu_bs.ilr.esa.estec.neopop.model.OrbitType;
import de.tu_bs.ilr.esa.estec.neopop.model.SpaceBasedLocation;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceBasedLocationsPart
implements IPart {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObsSimRawSbModule obsSimRawSbModule;
    private ObsSimRawCfgModule obsSimRawCfgModule;
    private WritableValue selectedSensorOrbit = new WritableValue();
    private Text designatorText;
    private ComboViewer orbitTypeComboViewer;
    private ComboViewer orbitDefinitionTypeComboViewer;
    private Spinner pointInTimeSpinner;
    private Spinner data0Spinner;
    private Spinner data1Spinner;
    private Spinner data2Spinner;
    private Spinner data3Spinner;
    private Spinner data4Spinner;
    private Spinner data5Spinner;
    private Label data0Label;
    private Label data1Label;
    private Label data2Label;
    private Label data3Label;
    private Label data4Label;
    private Label data5Label;
    private Label data0UnitLabel;
    private Label data1UnitLabel;
    private Label data2UnitLabel;
    private Label data3UnitLabel;
    private Label data4UnitLabel;
    private Label data5UnitLabel;
    private Text inputFileText;
    private TableViewer sensorOrbitsTableViewer;
    private Group selectedSensorOrbitGroup;
    private Button removeButton;
    private Button addButton;
    private Composite noteComposite;
    private Label noteCaptionLabel;
    private Label noteLabel;
    private Label label;
    private Label label_1;
    private Label label_2;
    private Composite compInScrolled;
    private ObsSimRawSrcModule obsSimRawSrcModule;
    private NEOPOPModule neopopModule;
    private Group sensorOrbitsGroup;
    private Label spkFileLabel;
    private Label sep4;
    private Label auxFile;
    private Text spkFileText;
    private Text auxFileText;
    private Button spkFileBrowseButton;
    private Button auxFileBrowseButton;
    @Inject
    private IEventBroker eventBroker;
    private Label pointInTimeLabel;

    @Inject
    protected void setAttributesFromContext(Input model) {
        this.logger.trace("setAttributesFromContext");
        this.obsSimRawSbModule = model.getObsSimRawSbModule();
        this.obsSimRawCfgModule = model.getObsSimRawCfgModule();
        this.obsSimRawSrcModule = model.getObsSimRawSrcModule();
        this.neopopModule = model.getNeopopModule();
    }

    @PostConstruct
    public void createGUIElements(Composite parentComposite) {
        this.logger.trace("createGUIElements");
        this.logger.debug("Creating GUI elements");
        parentComposite.setLayout((Layout)new GridLayout(2, false));
        this.sensorOrbitsGroup = new Group(parentComposite, 0);
        GridLayout gl_sensorOrbitsGroup = new GridLayout(1, false);
        this.sensorOrbitsGroup.setLayout((Layout)gl_sensorOrbitsGroup);
        this.sensorOrbitsGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.sensorOrbitsGroup.setText("Defined Space-based Locations");
        this.sensorOrbitsTableViewer = new TableViewer((Composite)this.sensorOrbitsGroup, 67584);
        Table sensorOrbitsTable = this.sensorOrbitsTableViewer.getTable();
        sensorOrbitsTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite addRemoveComposite = new Composite((Composite)this.sensorOrbitsGroup, 0);
        addRemoveComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        addRemoveComposite.setLayout((Layout)new RowLayout(256));
        this.addButton = new Button(addRemoveComposite, 0);
        this.addButton.setLayoutData((Object)new RowData(100, -1));
        this.addButton.setText("Add");
        this.removeButton = new Button(addRemoveComposite, 0);
        this.removeButton.setLayoutData((Object)new RowData(100, -1));
        this.removeButton.setText("Remove");
        this.selectedSensorOrbitGroup = new Group(parentComposite, 0);
        this.selectedSensorOrbitGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.selectedSensorOrbitGroup.setLayout((Layout)new FillLayout());
        this.selectedSensorOrbitGroup.setText("Attributes of Selected Space-based Locations");
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.selectedSensorOrbitGroup, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.compInScrolled = new Composite((Composite)scrolledComposite, 0);
        GridLayout gl_compInScrolled = new GridLayout(3, false);
        gl_compInScrolled.verticalSpacing = 0;
        gl_compInScrolled.marginHeight = 0;
        gl_compInScrolled.horizontalSpacing = 8;
        this.compInScrolled.setLayout((Layout)gl_compInScrolled);
        Label sep0 = new Label(this.compInScrolled, 258);
        GridData gd_sep0 = new GridData(4, 0x1000000, true, false, 3, 1);
        gd_sep0.heightHint = 30;
        sep0.setLayoutData((Object)gd_sep0);
        Label generalLabel = new Label(this.compInScrolled, 0);
        generalLabel.setText("General");
        new Label(this.compInScrolled, 0);
        new Label(this.compInScrolled, 0);
        Label sep1 = new Label(this.compInScrolled, 256);
        sep1.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        Label designatorLabel = new Label(this.compInScrolled, 0);
        GridData gd_designatorLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_designatorLabel.horizontalIndent = 20;
        designatorLabel.setLayoutData((Object)gd_designatorLabel);
        designatorLabel.setText("Designator:");
        this.designatorText = new Text(this.compInScrolled, 2048);
        this.designatorText.setText("<designator>");
        this.designatorText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.label = new Label(this.compInScrolled, 0);
        this.label.setText("[-]");
        Label orbitTypeLabel = new Label(this.compInScrolled, 0);
        GridData gd_orbitTypeLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_orbitTypeLabel.horizontalIndent = 20;
        orbitTypeLabel.setLayoutData((Object)gd_orbitTypeLabel);
        orbitTypeLabel.setText("Orbit Type:");
        this.orbitTypeComboViewer = new ComboViewer(this.compInScrolled, 8);
        Combo orbitTypeCombo = this.orbitTypeComboViewer.getCombo();
        orbitTypeCombo.setItems(new String[0]);
        orbitTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        orbitTypeCombo.select(0);
        this.label_1 = new Label(this.compInScrolled, 0);
        this.label_1.setText("[-]");
        Label orbitDefinitionTypeLabel = new Label(this.compInScrolled, 0);
        GridData gd_orbitDefinitionTypeLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_orbitDefinitionTypeLabel.horizontalIndent = 20;
        orbitDefinitionTypeLabel.setLayoutData((Object)gd_orbitDefinitionTypeLabel);
        orbitDefinitionTypeLabel.setText("Definition of Orbit by...");
        this.orbitDefinitionTypeComboViewer = new ComboViewer(this.compInScrolled, 8);
        Combo orbitDefinitionTypeCombo = this.orbitDefinitionTypeComboViewer.getCombo();
        orbitDefinitionTypeCombo.setItems(new String[0]);
        orbitDefinitionTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        orbitDefinitionTypeCombo.select(0);
        this.label_2 = new Label(this.compInScrolled, 0);
        this.label_2.setText("[-]");
        Label sep2 = new Label(this.compInScrolled, 258);
        GridData gd_sep2 = new GridData(4, 0x1000000, true, false, 3, 1);
        gd_sep2.heightHint = 30;
        sep2.setLayoutData((Object)gd_sep2);
        sep2.setText("dfgfdg");
        Label definitionDataLabel = new Label(this.compInScrolled, 0);
        definitionDataLabel.setText("Definition Data");
        new Label(this.compInScrolled, 0);
        new Label(this.compInScrolled, 0);
        Label sep3 = new Label(this.compInScrolled, 256);
        sep3.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.pointInTimeLabel = new Label(this.compInScrolled, 0);
        GridData gd_pointInTimeLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_pointInTimeLabel.horizontalIndent = 20;
        this.pointInTimeLabel.setLayoutData((Object)gd_pointInTimeLabel);
        this.pointInTimeLabel.setText("Epoch:");
        this.pointInTimeSpinner = new Spinner(this.compInScrolled, 2048);
        this.pointInTimeSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.pointInTimeSpinner.setPageIncrement(10000);
        this.pointInTimeSpinner.setMaximum(Integer.MAX_VALUE);
        this.pointInTimeSpinner.setMinimum(Integer.MIN_VALUE);
        this.pointInTimeSpinner.setSelection(48234);
        this.pointInTimeSpinner.setIncrement(1000);
        this.pointInTimeSpinner.setDigits(3);
        Label pointInTimeUnitLabel = new Label(this.compInScrolled, 0);
        pointInTimeUnitLabel.setToolTipText("DDD is the day of the calendar year for any time during the first of January, the integer portion of the day will be 1.");
        pointInTimeUnitLabel.setText("[YYYYDDD.ddd]");
        this.data0Label = new Label(this.compInScrolled, 0);
        GridData gd_data0Label = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_data0Label.horizontalIndent = 20;
        this.data0Label.setLayoutData((Object)gd_data0Label);
        this.data0Label.setText("<Data 0>:");
        this.data0Spinner = new Spinner(this.compInScrolled, 2048);
        this.data0Spinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.data0Spinner.setIncrement(1000);
        this.data0Spinner.setPageIncrement(10000);
        this.data0Spinner.setMaximum(100000000);
        this.data0Spinner.setSelection(48234);
        this.data0Spinner.setDigits(3);
        this.data0UnitLabel = new Label(this.compInScrolled, 0);
        this.data0UnitLabel.setText("[<Unit 0>]");
        this.data1Label = new Label(this.compInScrolled, 0);
        GridData gd_data1Label = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_data1Label.horizontalIndent = 20;
        this.data1Label.setLayoutData((Object)gd_data1Label);
        this.data1Label.setText("<Data 1>:");
        this.data1Spinner = new Spinner(this.compInScrolled, 2048);
        this.data1Spinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.data1Spinner.setPageIncrement(10000);
        this.data1Spinner.setMaximum(100000000);
        this.data1Spinner.setSelection(50456);
        this.data1Spinner.setIncrement(1000);
        this.data1Spinner.setDigits(3);
        this.data1UnitLabel = new Label(this.compInScrolled, 0);
        this.data1UnitLabel.setText("[<Unit 1>]");
        this.data2Label = new Label(this.compInScrolled, 0);
        GridData gd_data2Label = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_data2Label.horizontalIndent = 20;
        this.data2Label.setLayoutData((Object)gd_data2Label);
        this.data2Label.setText("<Data 2>:");
        this.data2Spinner = new Spinner(this.compInScrolled, 2048);
        this.data2Spinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.data2Spinner.setPageIncrement(10000);
        this.data2Spinner.setMaximum(100000000);
        this.data2Spinner.setSelection(1532);
        this.data2Spinner.setIncrement(1000);
        this.data2Spinner.setDigits(3);
        this.data2UnitLabel = new Label(this.compInScrolled, 0);
        this.data2UnitLabel.setText("[<Unit 2>]");
        this.data3Label = new Label(this.compInScrolled, 0);
        GridData gd_data3Label = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_data3Label.horizontalIndent = 20;
        this.data3Label.setLayoutData((Object)gd_data3Label);
        this.data3Label.setText("<Data 3>:");
        this.data3Spinner = new Spinner(this.compInScrolled, 2048);
        this.data3Spinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.data3Spinner.setPageIncrement(10000);
        this.data3Spinner.setMaximum(100000000);
        this.data3Spinner.setSelection(1532);
        this.data3Spinner.setIncrement(1000);
        this.data3Spinner.setDigits(3);
        this.data3UnitLabel = new Label(this.compInScrolled, 0);
        this.data3UnitLabel.setText("[<Unit 3>]");
        this.data4Label = new Label(this.compInScrolled, 0);
        GridData gd_data4Label = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_data4Label.horizontalIndent = 20;
        this.data4Label.setLayoutData((Object)gd_data4Label);
        this.data4Label.setText("<Data 4>:");
        this.data4Spinner = new Spinner(this.compInScrolled, 2048);
        this.data4Spinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.data4Spinner.setPageIncrement(10000);
        this.data4Spinner.setMaximum(100000000);
        this.data4Spinner.setSelection(1532);
        this.data4Spinner.setIncrement(1000);
        this.data4Spinner.setDigits(3);
        this.data4UnitLabel = new Label(this.compInScrolled, 0);
        this.data4UnitLabel.setText("[<Unit 4>]");
        this.data5Label = new Label(this.compInScrolled, 0);
        GridData gd_data5Label = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_data5Label.horizontalIndent = 20;
        this.data5Label.setLayoutData((Object)gd_data5Label);
        this.data5Label.setText("<Data 5>:");
        this.data5Spinner = new Spinner(this.compInScrolled, 2048);
        this.data5Spinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.data5Spinner.setPageIncrement(10000);
        this.data5Spinner.setMaximum(100000);
        this.data5Spinner.setSelection(1532);
        this.data5Spinner.setIncrement(1000);
        this.data5Spinner.setDigits(3);
        this.data5UnitLabel = new Label(this.compInScrolled, 0);
        this.data5UnitLabel.setText("[<Unit 5>]");
        this.sep4 = new Label(this.compInScrolled, 256);
        this.sep4.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.spkFileLabel = new Label(this.compInScrolled, 0);
        GridData gd_spkFileLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_spkFileLabel.horizontalIndent = 20;
        this.spkFileLabel.setLayoutData((Object)gd_spkFileLabel);
        this.spkFileLabel.setToolTipText("e.g. *.bsp, relative within the work directory");
        this.spkFileLabel.setText("SPK File:");
        this.spkFileText = new Text(this.compInScrolled, 2048);
        this.spkFileText.setToolTipText("e.g. *.bsp, relative within the work directory");
        this.spkFileText.setText("<spk file>");
        this.spkFileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.spkFileBrowseButton = new Button(this.compInScrolled, 0);
        this.spkFileBrowseButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-open-4.png"));
        this.spkFileBrowseButton.setToolTipText("Browse");
        this.auxFile = new Label(this.compInScrolled, 0);
        GridData gd_auxFile = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_auxFile.horizontalIndent = 20;
        this.auxFile.setLayoutData((Object)gd_auxFile);
        this.auxFile.setToolTipText("Might be needed by the SPK file\ne.g. *.tls, relative within the work directory");
        this.auxFile.setText("Auxiliary File:");
        this.auxFileText = new Text(this.compInScrolled, 2048);
        this.auxFileText.setToolTipText("Might be needed by the SPK file\ne.g. *.tls, relative within the work directory");
        this.auxFileText.setText("<aux file>");
        this.auxFileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.auxFileBrowseButton = new Button(this.compInScrolled, 0);
        this.auxFileBrowseButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-open-4.png"));
        this.auxFileBrowseButton.setToolTipText("Browse");
        this.noteComposite = new Composite(this.compInScrolled, 0);
        GridData gd_noteComposite = new GridData(4, 0x1000000, true, false, 3, 1);
        gd_noteComposite.verticalIndent = 20;
        this.noteComposite.setLayoutData((Object)gd_noteComposite);
        this.noteComposite.setVisible(false);
        this.noteComposite.setLayout((Layout)new GridLayout(2, false));
        this.noteCaptionLabel = new Label(this.noteComposite, 0);
        this.noteCaptionLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.noteCaptionLabel.setText("Note:");
        this.noteCaptionLabel.setFont(SWTResourceManager.getFont("Sans Serif", 9, 1));
        this.noteLabel = new Label(this.noteComposite, 64);
        GridData gd_noteLabel = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_noteLabel.widthHint = 100;
        this.noteLabel.setLayoutData((Object)gd_noteLabel);
        this.noteLabel.setText("Designator changes do not affect usages of selected element in sensor network definitions.");
        scrolledComposite.setContent((Control)this.compInScrolled);
        scrolledComposite.setMinSize(this.compInScrolled.computeSize(-1, -1));
        Group inputFileGroup = new Group(parentComposite, 0);
        inputFileGroup.setEnabled(false);
        inputFileGroup.setText("Space-based Locations Input File");
        GridLayout gl_inputFileGroup = new GridLayout(3, false);
        inputFileGroup.setLayout((Layout)gl_inputFileGroup);
        inputFileGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.inputFileText = new Text((Composite)inputFileGroup, 2048);
        this.inputFileText.setEnabled(false);
        this.inputFileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.inputFileText.setText("<orbits input file / obssim.s_b>");
        Button inputFileBrowseButton = new Button((Composite)inputFileGroup, 0);
        inputFileBrowseButton.setEnabled(false);
        inputFileBrowseButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-open-4.png"));
        inputFileBrowseButton.setToolTipText("Browse");
        Button inputFileEditButton = new Button((Composite)inputFileGroup, 0);
        inputFileEditButton.setEnabled(false);
        inputFileEditButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-edit.png"));
        inputFileEditButton.setToolTipText("Edit");
        scrolledComposite.setContent((Control)this.compInScrolled);
        scrolledComposite.setMinSize(this.compInScrolled.computeSize(-1, -1));
    }

    public void doAdditionalStuff() {
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpaceBasedLocationsPart.this.obsSimRawSbModule.addOrbit();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpaceBasedLocationsPart.this.obsSimRawSbModule.removeOrbit((SpaceBasedLocation)SpaceBasedLocationsPart.this.selectedSensorOrbit.getValue());
            }
        });
        Util.setDefaultDoubleAttributes(this.pointInTimeSpinner, this.data0Spinner, this.data1Spinner, this.data2Spinner, this.data3Spinner, this.data4Spinner, this.data5Spinner);
        this.data0Spinner.setDigits(2);
        this.data1Spinner.setDigits(2);
        this.data2Spinner.setDigits(2);
        Util.letItSendBrowseFileEvents(this.eventBroker, this.spkFileBrowseButton, this.selectedSensorOrbit, "spkFile");
        Util.letItSendBrowseFileEvents(this.eventBroker, this.auxFileBrowseButton, this.selectedSensorOrbit, "auxFile");
    }

    public void bindGUIElements() {
        this.logger.trace("bindGUIElements()");
        this.logger.info("Binding GUI elements");
        DataBindingContext dbc = new DataBindingContext();
        this.logger.debug("Binding Sensor Orbits Table Viewer");
        Util.bindList(dbc, (InputElement)this.obsSimRawSbModule, "orbits", "name", this.selectedSensorOrbit, this.sensorOrbitsTableViewer);
        this.logger.debug("Binding Designator Text");
        Util.bindString(dbc, this.selectedSensorOrbit, "name", (Control)this.designatorText);
        this.logger.debug("Binding Orbit Type Combo Viewer");
        Util.bindEnum(dbc, this.selectedSensorOrbit, "type", OrbitType.class, this.orbitTypeComboViewer, new LabelProvider(){

            public String getText(Object element) {
                if (element == OrbitType.GEOCENTRIC) {
                    return "Geocentric";
                }
                if (element == OrbitType.HELIOCENTRIC) {
                    return "Heliocentric";
                }
                return null;
            }
        });
        this.logger.debug("Binding Orbit Definition Type Combo Viewer");
        Util.bindEnum(dbc, this.selectedSensorOrbit, "definitionType", OrbitDefinitionType.class, this.orbitDefinitionTypeComboViewer, new LabelProvider(){

            public String getText(Object element) {
                if (element == OrbitDefinitionType.ORBITAL_ELEMENTS) {
                    return "Orbital Elements";
                }
                if (element == OrbitDefinitionType.STATE_VECTOR) {
                    return "State Vector";
                }
                if (element == OrbitDefinitionType.SPK_KERNEL) {
                    return "SPK Kernel";
                }
                return null;
            }
        });
        this.logger.debug("Binding Point in Time label");
        Util.bindDouble(dbc, this.selectedSensorOrbit, "pointInTime", this.pointInTimeSpinner);
        this.logger.debug("Binding Data Labels");
        this.bindDataLabel(dbc, this.data0Label, "Semi-Major Axis", "x");
        this.bindDataLabel(dbc, this.data1Label, "Eccentricity", "y");
        this.bindDataLabel(dbc, this.data2Label, "Inclination", "z");
        this.bindDataLabel(dbc, this.data3Label, "Long. of asc. Node", "v_x");
        this.bindDataLabel(dbc, this.data4Label, "Argument of Perihel", "v_y");
        this.bindDataLabel(dbc, this.data5Label, "Mean Anomaly", "v_z");
        this.logger.debug("Binding Data Spinners");
        Util.bindDouble(dbc, this.selectedSensorOrbit, "data0", this.data0Spinner);
        Util.bindDouble(dbc, this.selectedSensorOrbit, "data1", this.data1Spinner);
        Util.bindDouble(dbc, this.selectedSensorOrbit, "data2", this.data2Spinner);
        Util.bindDouble(dbc, this.selectedSensorOrbit, "data3", this.data3Spinner);
        Util.bindDouble(dbc, this.selectedSensorOrbit, "data4", this.data4Spinner);
        Util.bindDouble(dbc, this.selectedSensorOrbit, "data5", this.data5Spinner);
        this.logger.debug("Binding Data Unit Labels");
        this.bindDataUnitLabel(dbc, this.data0UnitLabel, new OrbitToDataUnitTextMapping("km", "AU", "km", "AU"));
        this.bindDataUnitLabel(dbc, this.data1UnitLabel, new OrbitToDataUnitTextMapping("-", "-", "km", "AU"));
        this.bindDataUnitLabel(dbc, this.data2UnitLabel, new OrbitToDataUnitTextMapping("deg", "deg", "km", "AU"));
        this.bindDataUnitLabel(dbc, this.data3UnitLabel, new OrbitToDataUnitTextMapping("deg", "deg", "km/s", "AU/d"));
        this.bindDataUnitLabel(dbc, this.data4UnitLabel, new OrbitToDataUnitTextMapping("deg", "deg", "km/s", "AU/d"));
        this.bindDataUnitLabel(dbc, this.data5UnitLabel, new OrbitToDataUnitTextMapping("deg", "deg", "km/s", "AU/d"));
        this.logger.debug("Binding Input File Text");
        Util.bindString(dbc, (ModelElement)this.obsSimRawCfgModule, "spaceLocationsInputFile", this.inputFileText);
        this.logger.debug("Binding selection group visibility and remove button enablement");
        Util.bindBooleanPropertyToSelectionExistence(dbc, (IObservableValue)WidgetProperties.visible().observe((Widget)this.selectedSensorOrbitGroup), (ISelectionProvider)this.sensorOrbitsTableViewer);
        this.designatorText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                SpaceBasedLocationsPart.this.noteComposite.setVisible(true);
            }

            public void focusLost(FocusEvent e) {
                SpaceBasedLocationsPart.this.noteComposite.setVisible(false);
            }
        });
        Util.bindString(dbc, this.selectedSensorOrbit, "spkFile", (Control)this.spkFileText);
        Util.bindString(dbc, this.selectedSensorOrbit, "auxFile", (Control)this.auxFileText);
        Enabler enabler = new Enabler(new Control[]{this.sensorOrbitsGroup, this.selectedSensorOrbitGroup, this.noteComposite});
        enabler.setOutputControlsToBeIgnored(new Control[]{this.removeButton});
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "observationSimulationEnabled"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getPopulationFiles(), "selected"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getAdditionalPopulationFiles(), "selected"));
        enabler.setAggregationEquation(new IAggregationEquation(){

            @Override
            public Object aggregate(HeteroList values) {
                if (((Boolean)values.getTyped(0)).booleanValue() && (((Boolean)values.getTyped(1)).booleanValue() || ((Boolean)values.getTyped(2)).booleanValue())) {
                    return true;
                }
                return false;
            }
        });
        enabler.bind(dbc);
        enabler = new Enabler(new Control[]{this.removeButton});
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "observationSimulationEnabled"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getPopulationFiles(), "selected"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getAdditionalPopulationFiles(), "selected"));
        enabler.addObservable((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.sensorOrbitsTableViewer));
        enabler.setAggregationEquation(new IAggregationEquation(){

            @Override
            public Object aggregate(HeteroList values) {
                if (((Boolean)values.getTyped(0)).booleanValue() && (((Boolean)values.getTyped(1)).booleanValue() || ((Boolean)values.getTyped(2)).booleanValue()) && values.getTyped(3) != null) {
                    return true;
                }
                return false;
            }
        });
        enabler.bind(dbc);
        enabler = new Enabler(this.compInScrolled, (Control)this.pointInTimeLabel, (Control)this.data5UnitLabel);
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "observationSimulationEnabled"));
        enabler.addWritableValue(this.selectedSensorOrbit, "definitionType");
        enabler.addObservable((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.sensorOrbitsTableViewer));
        enabler.setAggregationEquation(new IAggregationEquation(){

            @Override
            public Object aggregate(HeteroList values) {
                if (((Boolean)values.getTyped(0)).booleanValue() && values.getTyped(1) != OrbitDefinitionType.SPK_KERNEL && values.getTyped(2) != null) {
                    return true;
                }
                return false;
            }
        });
        enabler.bind(dbc);
        enabler = new Enabler(this.compInScrolled, (Control)this.spkFileLabel, (Control)this.auxFileBrowseButton);
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "observationSimulationEnabled"));
        enabler.addWritableValue(this.selectedSensorOrbit, "definitionType");
        enabler.addObservable((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.sensorOrbitsTableViewer));
        enabler.setAggregationEquation(new IAggregationEquation(){

            @Override
            public Object aggregate(HeteroList values) {
                if (((Boolean)values.getTyped(0)).booleanValue() && values.getTyped(1) == OrbitDefinitionType.SPK_KERNEL && values.getTyped(2) != null) {
                    return true;
                }
                return false;
            }
        });
        enabler.bind(dbc);
    }

    private void bindDataLabel(DataBindingContext dbc, Label dataLabel, final String orbitalElementsText, final String stateVectorText) {
        IObservableValue observableDefinitionType = BeanProperties.value((String)"definitionType").observeDetail((IObservableValue)this.selectedSensorOrbit);
        ISWTObservableValue observableDataLabelText = WidgetProperties.text().observe((Widget)dataLabel);
        ExtendedUpdateValueStrategy labelToModelUVS = new ExtendedUpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER);
        ExtendedUpdateValueStrategy modelToLabelUVS = new ExtendedUpdateValueStrategy();
        modelToLabelUVS.setConverter(new IConverter(){

            public Object getFromType() {
                return OrbitDefinitionType.class;
            }

            public Object getToType() {
                return String.class;
            }

            public Object convert(Object fromObject) {
                String result = "<Data>";
                if (fromObject == OrbitDefinitionType.ORBITAL_ELEMENTS) {
                    result = orbitalElementsText;
                } else if (fromObject == OrbitDefinitionType.STATE_VECTOR) {
                    result = stateVectorText;
                }
                return String.valueOf(result) + ":";
            }
        });
        dbc.bindValue((IObservableValue)observableDataLabelText, observableDefinitionType, (UpdateValueStrategy)labelToModelUVS, (UpdateValueStrategy)modelToLabelUVS);
        observableDefinitionType.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                SpaceBasedLocationsPart.this.compInScrolled.layout();
            }
        });
    }

    private void bindDataUnitLabel(DataBindingContext dbc, Label dataUnitLabel, OrbitToDataUnitTextMapping mapping) {
        this.bindDataUnitLabel(dbc, dataUnitLabel, new OrbitTypeToDataUnitTextConverter(mapping), BeanProperties.value((String)"type"));
        this.bindDataUnitLabel(dbc, dataUnitLabel, new OrbitDefinitionTypeToDataUnitTextConverter(mapping), BeanProperties.value((String)"definitionType"));
    }

    private void bindDataUnitLabel(DataBindingContext dbc, Label dataUnitLabel, OrbitToDataUnitTextConverter orbitToDataUnitTextConverter, IBeanValueProperty typeOrDefinitionTypeProperty) {
        IObservableValue observableTypeOrDefinitionType = typeOrDefinitionTypeProperty.observeDetail((IObservableValue)this.selectedSensorOrbit);
        ISWTObservableValue observableDataUnitLabelText = WidgetProperties.text().observe((Widget)dataUnitLabel);
        ExtendedUpdateValueStrategy labelToModelUVS = new ExtendedUpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER);
        ExtendedUpdateValueStrategy modelToLabelUVS = new ExtendedUpdateValueStrategy();
        modelToLabelUVS.setConverter((IConverter)orbitToDataUnitTextConverter);
        dbc.bindValue((IObservableValue)observableDataUnitLabelText, observableTypeOrDefinitionType, (UpdateValueStrategy)labelToModelUVS, (UpdateValueStrategy)modelToLabelUVS);
        observableTypeOrDefinitionType.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                SpaceBasedLocationsPart.this.selectedSensorOrbitGroup.layout();
            }
        });
    }

    public void focus() {
        this.logger.trace("focus");
        this.sensorOrbitsTableViewer.getTable().setFocus();
    }

    public void finalizeCreation() {
        this.logger.trace("finalizeCreation");
        this.logger.debug("Finalizing creation");
    }

    @Inject
    @Optional
    void fixBrokenLayout(@EventTopic(value="org/eclipse/e4/ui/LifeCycle/activate") Event event) {
        if (!this.selectedSensorOrbitGroup.isDisposed()) {
            this.selectedSensorOrbitGroup.layout();
        }
    }

    class OrbitDefinitionTypeToDataUnitTextConverter
    extends OrbitToDataUnitTextConverter {
        private OrbitDefinitionTypeToDataUnitTextConverter(OrbitToDataUnitTextMapping mapping) {
            super(mapping);
        }

        public Object getFromType() {
            return OrbitDefinitionType.class;
        }

        public Object convert(Object fromObject) {
            this.mapping.orbitDefinitionType = (OrbitDefinitionType)fromObject;
            return this.convert();
        }
    }

    abstract class OrbitToDataUnitTextConverter
    implements IConverter {
        protected OrbitToDataUnitTextMapping mapping;

        private OrbitToDataUnitTextConverter(OrbitToDataUnitTextMapping mapping) {
            this.mapping = mapping;
        }

        public Object getToType() {
            return String.class;
        }

        public String convert() {
            String result = "<unit>";
            if (this.mapping.orbitType != null && this.mapping.orbitDefinitionType != null) {
                result = this.mapping.orbitDefinitionType == OrbitDefinitionType.ORBITAL_ELEMENTS && this.mapping.orbitType == OrbitType.GEOCENTRIC ? this.mapping.orbitalElementsGeocentricText : (this.mapping.orbitDefinitionType == OrbitDefinitionType.ORBITAL_ELEMENTS && this.mapping.orbitType == OrbitType.HELIOCENTRIC ? this.mapping.orbitalElementsHeliocentricText : (this.mapping.orbitDefinitionType == OrbitDefinitionType.STATE_VECTOR && this.mapping.orbitType == OrbitType.GEOCENTRIC ? this.mapping.stateVectorGeocentricText : this.mapping.stateVectorHeliocentricText));
            }
            return "[" + result + "]";
        }
    }

    class OrbitToDataUnitTextMapping {
        public OrbitType orbitType;
        public OrbitDefinitionType orbitDefinitionType;
        public String orbitalElementsGeocentricText;
        public String orbitalElementsHeliocentricText;
        public String stateVectorGeocentricText;
        public String stateVectorHeliocentricText;

        public OrbitToDataUnitTextMapping(String orbitalElementsGeocentricText, String orbitalElementsHeliocentricText, String stateVectorGeocentricText, String stateVectorHeliocentricText) {
            this.orbitalElementsGeocentricText = orbitalElementsGeocentricText;
            this.orbitalElementsHeliocentricText = orbitalElementsHeliocentricText;
            this.stateVectorGeocentricText = stateVectorGeocentricText;
            this.stateVectorHeliocentricText = stateVectorHeliocentricText;
        }
    }

    class OrbitTypeToDataUnitTextConverter
    extends OrbitToDataUnitTextConverter {
        private OrbitTypeToDataUnitTextConverter(OrbitToDataUnitTextMapping mapping) {
            super(mapping);
        }

        public Object getFromType() {
            return OrbitType.class;
        }

        public Object convert(Object fromObject) {
            this.mapping.orbitType = (OrbitType)fromObject;
            return this.convert();
        }
    }
}

