/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts;

import de.tu_bs.ilr.esa.estec.neopop.gui.util.ModelValidator;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.IPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.PartType;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.Enabler;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.HeteroList;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.IAggregationEquation;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.Util;
import de.tu_bs.ilr.esa.estec.neopop.model.Input;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElement;
import de.tu_bs.ilr.esa.estec.neopop.model.ModelElement;
import de.tu_bs.ilr.esa.estec.neopop.model.ModelElementValue;
import de.tu_bs.ilr.esa.estec.neopop.model.NEOPOPModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawCfgModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawSrcModule;
import de.tu_bs.ilr.esa.estec.neopop.model.PopGenInpCfgModule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.SWTResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsOverviewPart
implements IPart {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObsSimRawCfgModule obsSimRawCfgModule;
    private PopGenInpCfgModule popGenInpCfgModule;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private ESelectionService selectionService;
    private Map<PartType, Button> settingsButtons = new HashMap<PartType, Button>();
    private Map<PartType, SettingsSelecter> settingsSelecter = new HashMap<PartType, SettingsSelecter>();
    private Text runIdText;
    private Button populationGenerationButton;
    private Button populationAnalysisButton;
    private Button observationSimulationButton;
    private Button observationAnalysisButton;
    private Button populationGeneratorFilterSettingsButton;
    private Button populationGeneratorBasicSettingsButton;
    private Button populationGenerator2DPlotSettingsButton;
    private Button populationGenerator3DPlotSettingsButton;
    private Button populationGeneratorScatterPlotSettingsButton;
    private Button populationGeneratorPopulationSettingsButton;
    private Button observationSimulatorBasicSettingsButton;
    private Button observationSimulatorPopulationSettingsButton;
    private Button observationSimulatorNetworkSettingsButton;
    private Button observationSimulatorGroundBasedLocationSettingsButton;
    private Button observationSimulatorSpaceBasedLocationSettingsButton;
    private Button observationSimulatorOpticalSensorSettingsButton;
    private Button observationSimulatorRadarSensorSettingsButton;
    private Button observationSimulator2DPlotSettingsButton;
    private Button observationSimulator3DPlotSettingsButton;
    private Button observationSimulatorScatterPlotSettingsButton;
    private Composite runConfComposite;
    private NEOPOPModule neopopModule;
    private Composite compInScrolled;
    private ObsSimRawSrcModule obsSimRawSrcModule;
    private static Map<PartType, String> indentLabels = new HashMap<PartType, String>();

    static {
        indentLabels.put(PartType.GROUND_BASED_LOCATION_SETTINGS, "\u2502\u251c");
        indentLabels.put(PartType.SPACE_BASED_LOCATIONS_SETTINGS, "\u2502\u2514");
        indentLabels.put(PartType.OPTICAL_SENSOR_SETTINGS, "\u251c\u2500");
        indentLabels.put(PartType.RADAR_SENSOR_SETTINGS, "\u2514\u2500");
    }

    @Inject
    protected void setAttributesFromContext(Input input) {
        this.logger.trace("setAttributesFromContext");
        this.obsSimRawCfgModule = input.getObsSimRawCfgModule();
        this.obsSimRawSrcModule = input.getObsSimRawSrcModule();
        this.neopopModule = input.getNeopopModule();
        this.popGenInpCfgModule = input.getPopGenInpCfgModule();
    }

    @PostConstruct
    public void createGUIElements(Composite cmpParent, EPartService partService) {
        this.logger.trace("createGUIElements");
        cmpParent.setLayout((Layout)new FillLayout());
        ScrolledComposite scrolledComposite = new ScrolledComposite(cmpParent, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.compInScrolled = new Composite((Composite)scrolledComposite, 0);
        GridLayout glCmpParent = new GridLayout();
        this.compInScrolled.setLayout((Layout)glCmpParent);
        scrolledComposite.setContent((Control)this.compInScrolled);
        this.runConfComposite = new Composite(this.compInScrolled, 0);
        this.runConfComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gl_runConfComposite = new GridLayout(2, true);
        gl_runConfComposite.verticalSpacing = 2;
        this.runConfComposite.setLayout((Layout)gl_runConfComposite);
        Label runIdLabel = new Label(this.runConfComposite, 0);
        runIdLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 2, 1));
        runIdLabel.setAlignment(0x1000000);
        runIdLabel.setText("Run ID");
        this.runIdText = new Text(this.runConfComposite, 2048);
        this.runIdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.populationGenerationButton = new Button(this.runConfComposite, 2);
        this.populationGenerationButton.setToolTipText("Switch on/off Population Generation");
        this.populationGenerationButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.populationGenerationButton.setText("PopGen");
        this.populationAnalysisButton = new Button(this.runConfComposite, 2);
        this.populationAnalysisButton.setToolTipText("Switch on/off Population Analysis");
        this.populationAnalysisButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.populationAnalysisButton.setText("PopAna");
        this.observationSimulationButton = new Button(this.runConfComposite, 2);
        this.observationSimulationButton.setToolTipText("Switch on/off Observation Simulation");
        this.observationSimulationButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.observationSimulationButton.setText("ObsSim");
        this.observationAnalysisButton = new Button(this.runConfComposite, 2);
        this.observationAnalysisButton.setToolTipText("Switch on/off Observation Analysis");
        this.observationAnalysisButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.observationAnalysisButton.setText("ObsAna");
        Group grpPSettings = new Group(this.compInScrolled, 0);
        grpPSettings.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        grpPSettings.setText("Population Generator");
        GridLayout gl_grpPSettings = new GridLayout();
        gl_grpPSettings.horizontalSpacing = 0;
        gl_grpPSettings.numColumns = 2;
        gl_grpPSettings.marginBottom = 10;
        gl_grpPSettings.verticalSpacing = 0;
        gl_grpPSettings.marginHeight = 0;
        grpPSettings.setLayout((Layout)gl_grpPSettings);
        this.createSettingsButtons((Composite)grpPSettings, PartType.POPULATION_GENERATOR_SETTINGS_PARTS, partService);
        Group grpOSettings = new Group(this.compInScrolled, 0);
        grpOSettings.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        grpOSettings.setText("Observation Simulator");
        GridLayout gl_grpOSettings = new GridLayout();
        gl_grpOSettings.horizontalSpacing = 0;
        gl_grpOSettings.numColumns = 2;
        gl_grpOSettings.marginBottom = 10;
        gl_grpOSettings.verticalSpacing = 0;
        gl_grpOSettings.marginHeight = 0;
        grpOSettings.setLayout((Layout)gl_grpOSettings);
        this.createSettingsButtons((Composite)grpOSettings, PartType.OBSERVATION_SIMULATOR_SETTINGS_PARTS, partService);
        Composite composite = new Composite(this.compInScrolled, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        final Button btnTest = new Button(composite, 8);
        btnTest.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        btnTest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SettingsOverviewPart.this.eventBroker.post("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/test", null);
            }
        });
        btnTest.setText("Test");
        btnTest.setVisible(false);
        composite.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                btnTest.setVisible(true);
            }
        });
        btnTest.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                btnTest.setVisible(false);
            }
        });
    }

    private Set<Button> createSettingsButtons(Composite composite, PartType[] partTypes, EPartService partService) {
        HashSet<Button> result = new HashSet<Button>();
        PartType[] partTypeArray = partTypes;
        int n = partTypes.length;
        int n2 = 0;
        while (n2 < n) {
            PartType partType = partTypeArray[n2];
            this.logger.debug("Creating setting button row for {}", (Object)partType);
            boolean indentRow = indentLabels.containsKey(partType);
            GridData buttonGridData = new GridData(4, 0x1000000, true, false, 1, 1);
            GridData indentLabelGridData = null;
            if (indentRow) {
                Label indentLabel = new Label(composite, 0);
                indentLabel.setFont(SWTResourceManager.getFont("Courier", 15, 0));
                indentLabel.setForeground(SWTResourceManager.getColor(16));
                indentLabel.setText(indentLabels.get(partType));
                indentLabelGridData = new GridData(16384, 0x1000000, false, false, 1, 1);
                indentLabel.setLayoutData((Object)indentLabelGridData);
            } else {
                buttonGridData.horizontalSpan = 2;
            }
            if (partType == PartType.NETWORK_SETTINGS || partType == PartType.GROUND_BASED_LOCATION_SETTINGS || partType == PartType.HISTOGRAM_SETTINGS_2D_OBSSIM) {
                buttonGridData.verticalIndent = 5;
                if (indentLabelGridData != null) {
                    indentLabelGridData.verticalIndent = 5;
                }
            }
            Button button = new Button(composite, 2);
            button.setText(partType.getButtonName(partService) == null ? "" : partType.getButtonName(partService));
            button.setLayoutData((Object)buttonGridData);
            this.settingsSelecter.put(partType, new SettingsSelecter(button, this.eventBroker, partType, this.selectionService));
            this.settingsButtons.put(partType, button);
            result.add(button);
            if (partType == PartType.FILTER_SETTINGS) {
                this.populationGeneratorFilterSettingsButton = button;
            }
            if (partType == PartType.BASIC_SETTINGS_POPGEN) {
                this.populationGeneratorBasicSettingsButton = button;
            }
            if (partType == PartType.HISTOGRAM_SETTINGS_2D_POPGEN) {
                this.populationGenerator2DPlotSettingsButton = button;
            }
            if (partType == PartType.HISTOGRAM_SETTINGS_3D_POPGEN) {
                this.populationGenerator3DPlotSettingsButton = button;
            }
            if (partType == PartType.SCATTER_PLOT_SETTINGS_POPGEN) {
                this.populationGeneratorScatterPlotSettingsButton = button;
            }
            if (partType == PartType.POPULATION_SETTINGS_POPGEN) {
                this.populationGeneratorPopulationSettingsButton = button;
            }
            if (partType == PartType.BASIC_SETTINGS_OBSSIM) {
                this.observationSimulatorBasicSettingsButton = button;
            }
            if (partType == PartType.POPULATION_SETTINGS_OBSSIM) {
                this.observationSimulatorPopulationSettingsButton = button;
            }
            if (partType == PartType.GROUND_BASED_LOCATION_SETTINGS) {
                this.observationSimulatorGroundBasedLocationSettingsButton = button;
            }
            if (partType == PartType.SPACE_BASED_LOCATIONS_SETTINGS) {
                this.observationSimulatorSpaceBasedLocationSettingsButton = button;
            }
            if (partType == PartType.OPTICAL_SENSOR_SETTINGS) {
                this.observationSimulatorOpticalSensorSettingsButton = button;
            }
            if (partType == PartType.RADAR_SENSOR_SETTINGS) {
                this.observationSimulatorRadarSensorSettingsButton = button;
            }
            if (partType == PartType.NETWORK_SETTINGS) {
                this.observationSimulatorNetworkSettingsButton = button;
            }
            if (partType == PartType.HISTOGRAM_SETTINGS_2D_OBSSIM) {
                this.observationSimulator2DPlotSettingsButton = button;
            }
            if (partType == PartType.HISTOGRAM_SETTINGS_3D_OBSSIM) {
                this.observationSimulator3DPlotSettingsButton = button;
            }
            if (partType == PartType.SCATTER_PLOT_SETTINGS_OBSSIM) {
                this.observationSimulatorScatterPlotSettingsButton = button;
            }
            ++n2;
        }
        return result;
    }

    @Inject
    @Optional
    public void select(@Named(value="org.eclipse.ui.selection") PartType selectedSettings) {
        this.logger.trace("select");
    }

    @Focus
    public void focus() {
        this.logger.trace("focus()");
        if (!this.settingsButtons.isEmpty()) {
            this.settingsButtons.values().toArray(new Button[0])[0].setFocus();
        }
    }

    public void bindGUIElements() {
        this.logger.trace("bindGUIElements");
        DataBindingContext dbc = new DataBindingContext();
        Util.bindString(dbc, (ModelElement)this.popGenInpCfgModule, "runId", this.runIdText);
        this.bindToggleButton(dbc, this.populationGenerationButton, "populationGenerationEnabled");
        this.bindToggleButton(dbc, this.populationAnalysisButton, "populationAnalysisEnabled");
        this.bindToggleButton(dbc, this.observationSimulationButton, "observationSimulationEnabled");
        this.bindToggleButton(dbc, this.observationAnalysisButton, "observationAnalysisEnabled");
        Enabler enabler = new Enabler(new Control[]{this.populationGeneratorPopulationSettingsButton});
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "populationGenerationEnabled"));
        enabler.bind(dbc);
        enabler = new Enabler(new Control[]{this.populationGeneratorFilterSettingsButton, this.populationGenerator2DPlotSettingsButton, this.populationGenerator3DPlotSettingsButton, this.populationGeneratorScatterPlotSettingsButton});
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "populationAnalysisEnabled"));
        enabler.bind(dbc);
        enabler = new Enabler(new Control[]{this.populationGeneratorBasicSettingsButton});
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "populationGenerationEnabled"), new ModelElementValue((ModelElement)this.neopopModule, "populationAnalysisEnabled"));
        enabler.setAggregationEquation(IAggregationEquation.OR_BOOLEANS);
        enabler.bind(dbc);
        enabler = new Enabler(new Control[]{this.observationSimulatorPopulationSettingsButton});
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "observationSimulationEnabled"));
        enabler.bind(dbc);
        enabler = new Enabler(new Control[]{this.observationSimulatorNetworkSettingsButton, this.observationSimulatorOpticalSensorSettingsButton, this.observationSimulatorRadarSensorSettingsButton, this.observationSimulatorGroundBasedLocationSettingsButton, this.observationSimulatorSpaceBasedLocationSettingsButton});
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "observationSimulationEnabled"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getPopulationFiles(), "selected"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getAdditionalPopulationFiles(), "selected"));
        enabler.setAggregationEquation(new IAggregationEquation(){

            @Override
            public Object aggregate(HeteroList values) {
                if (((Boolean)values.getTyped(0)).booleanValue() && (((Boolean)values.getTyped(1)).booleanValue() || ((Boolean)values.getTyped(2)).booleanValue())) {
                    return true;
                }
                return false;
            }
        });
        enabler.bind(dbc);
        enabler = new Enabler(new Control[]{this.observationSimulator2DPlotSettingsButton, this.observationSimulator3DPlotSettingsButton, this.observationSimulatorScatterPlotSettingsButton});
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "observationAnalysisEnabled"));
        enabler.bind(dbc);
        enabler = new Enabler(new Control[]{this.observationSimulatorBasicSettingsButton});
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "observationSimulationEnabled"), new ModelElementValue((ModelElement)this.neopopModule, "observationAnalysisEnabled"));
        enabler.setAggregationEquation(IAggregationEquation.OR_BOOLEANS);
        enabler.bind(dbc);
    }

    private void bindToggleButton(DataBindingContext dbc, Button button, String prop) {
        Util.bindBoolean(dbc, (InputElement)this.neopopModule, prop, button);
        ISWTObservableValue observableButtonFont = WidgetProperties.font().observe((Widget)button);
        IObservableValue observableModelProp = BeanProperties.value((String)prop).observe((Object)this.neopopModule);
        IConverter modelPropToButtonFontConverter = new IConverter(){

            public Object getFromType() {
                return Boolean.class;
            }

            public Object getToType() {
                return Font.class;
            }

            public Object convert(Object fromObject) {
                boolean enabled;
                int fontType = 0;
                if (fromObject != null && (enabled = ((Boolean)fromObject).booleanValue())) {
                    fontType = 1;
                }
                return SWTResourceManager.getFont("Sans Serif", 9, fontType);
            }
        };
        Util.bind(dbc, observableModelProp, (IObservableValue)observableButtonFont, modelPropToButtonFontConverter, null, (IValidator)new ModelValidator((Object)this.neopopModule, prop), null);
    }

    public void doAdditionalStuff() {
    }

    public void finalizeCreation() {
        this.logger.trace("finalizeCreation");
        this.logger.debug("Finalizing creation");
        Util.activateScrolling((Control)this.compInScrolled);
    }

    @Inject
    @Optional
    public void selectSettings(final @EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/settings/select") PartType selectedSettings) {
        this.logger.trace("selectSettings(selectedSettings={})", (Object)selectedSettings);
        this.logger.debug("Checking if settings have been auto-selected or if we got the selection on GUI-start-up");
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (selectedSettings == null) {
                    SettingsOverviewPart.this.logger.debug("{} settings have been auto-selected.", (Object)selectedSettings);
                    for (SettingsSelecter currentSettingsSelecter : SettingsOverviewPart.this.settingsSelecter.values()) {
                        if (currentSettingsSelecter.button.isDisposed() || !currentSettingsSelecter.button.getSelection()) continue;
                        currentSettingsSelecter.unSelect();
                        break;
                    }
                } else if (!((Button)SettingsOverviewPart.this.settingsButtons.get(selectedSettings)).isDisposed() && !((Button)SettingsOverviewPart.this.settingsButtons.get(selectedSettings)).getSelection()) {
                    SettingsOverviewPart.this.logger.debug("{} settings have been auto-selected.", (Object)selectedSettings);
                    ((SettingsSelecter)((Object)SettingsOverviewPart.this.settingsSelecter.get(selectedSettings))).selectWithoutSendingSelectEvent();
                } else {
                    SettingsOverviewPart.this.logger.debug("No auto-selection occured and what we got wasnt the selection on GUI-start-up. Nothing to do for me.");
                }
            }
        });
    }

    static class SettingsSelecter
    extends SelectionAdapter {
        private PartType settings;
        private IEventBroker eventBroker;
        private Button button;
        private static Button lastButton = null;
        private Logger logger;
        private ESelectionService selectionService;

        private SettingsSelecter(Button button, IEventBroker eventBroker, PartType settings, ESelectionService selectionService) {
            this.logger = LoggerFactory.getLogger((String)(String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + settings + "]"));
            this.logger.trace("Constructor");
            this.button = button;
            this.eventBroker = eventBroker;
            this.settings = settings;
            this.selectionService = selectionService;
            this.button.addSelectionListener((SelectionListener)this);
        }

        public void widgetSelected(SelectionEvent e) {
            this.logger.trace("Settings button selection listener");
            this.select();
        }

        private void select() {
            this.selectWithoutSendingSelectEvent();
            this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/settings/select", (Object)this.settings);
        }

        public void selectWithoutSendingSelectEvent() {
            if (lastButton == this.button && !this.button.isDisposed()) {
                this.button.setSelection(true);
                return;
            }
            if (lastButton != null && !lastButton.isDisposed()) {
                lastButton.setSelection(false);
                lastButton.setFont(SWTResourceManager.getFont("Sans Serif", 9, 0));
            }
            if (!this.button.isDisposed()) {
                this.button.setSelection(true);
                this.button.setFont(SWTResourceManager.getFont("Sans Serif", 9, 1));
            }
            lastButton = this.button;
        }

        public void unSelect() {
            if (!this.button.isDisposed()) {
                this.button.setSelection(false);
                this.button.setFont(SWTResourceManager.getFont("Sans Serif", 9, 0));
            }
            lastButton = null;
        }
    }
}

