/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.parts;

import de.tu_bs.ilr.esa.estec.neopop.gui.view.IPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.Enabler;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.HeteroList;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.IAggregationEquation;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.jface.swt.Util;
import de.tu_bs.ilr.esa.estec.neopop.model.GroundBasedLocation;
import de.tu_bs.ilr.esa.estec.neopop.model.GroundLocationType;
import de.tu_bs.ilr.esa.estec.neopop.model.Input;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElement;
import de.tu_bs.ilr.esa.estec.neopop.model.ModelElement;
import de.tu_bs.ilr.esa.estec.neopop.model.ModelElementValue;
import de.tu_bs.ilr.esa.estec.neopop.model.NEOPOPModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawCfgModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawGbModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawOclModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawSrcModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObservatoryCode;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroundBasedLocationsPart
implements IPart {
    private ObsSimRawGbModule obsSimRawGbModule;
    private ObsSimRawCfgModule obsSimRawCfgModule;
    private ObsSimRawOclModule obsSimRawOclModule;
    private WritableValue selection = new WritableValue();
    private DataBindingContext dbc;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private TableViewer tableViewer;
    private Spinner ambientTemperatureSpinner;
    private Combo typeCombo;
    private Combo cmbObsCode;
    private Text txtDesignator;
    private Spinner data1Spinner;
    private Spinner data2Spinner;
    private Spinner atmosphericPressureSpinner;
    private Spinner relativeHumiditySpinner;
    private Spinner troposphericLapseRateSpinner;
    private Spinner data0Spinner;
    private ComboViewer cmbvObsCode;
    private ComboViewer typeComboViewer;
    private Changer changer = new Changer();
    private Composite cmpDesignatorOrObsCode;
    private Group selectionGroup;
    private Label data0Label;
    private Label data1Label;
    private Label data2Label;
    private Label data0UnitLabel;
    private Label data2UnitLabel;
    private Label data1UnitLabel;
    private Label nameLabel;
    private Composite noteComposite;
    private Button addButton;
    private Button removeButton;
    private Text inputFileText;
    private ScrolledComposite scrolledComposite;
    private Composite compInScrolled;
    private Label designatorUnitLabel;
    private ObsSimRawSrcModule obsSimRawSrcModule;
    private NEOPOPModule neopopModule;
    private Group tableGroup;
    private Label troposphericLapseRateUnitLabel;
    private Label ambientTemperatureLabel;

    @Inject
    protected void setAttributesFromContext(Input input) {
        this.logger.trace("setAttributesFromContext(...)");
        this.obsSimRawGbModule = input.getObsSimRawGbModule();
        this.obsSimRawCfgModule = input.getObsSimRawCfgModule();
        this.obsSimRawOclModule = input.getObsSimRawOclModule();
        this.obsSimRawSrcModule = input.getObsSimRawSrcModule();
        this.neopopModule = input.getNeopopModule();
    }

    @PostConstruct
    public void createGUIElements(Composite cmpParent) {
        this.logger.trace("createGUIElements");
        cmpParent.setLayout((Layout)new GridLayout(3, false));
        this.tableGroup = new Group(cmpParent, 0);
        this.tableGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableGroup.setText("Defined Ground-based Locations");
        this.tableGroup.setLayout((Layout)new GridLayout(1, false));
        this.tableViewer = new TableViewer((Composite)this.tableGroup, 67584);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite addRemoveComposite = new Composite((Composite)this.tableGroup, 0);
        addRemoveComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        addRemoveComposite.setLayout((Layout)new RowLayout(256));
        this.addButton = new Button(addRemoveComposite, 0);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroundBasedLocation newLoc = GroundBasedLocationsPart.this.obsSimRawGbModule.addGroundBasedLocation();
            }
        });
        this.addButton.setLayoutData((Object)new RowData(100, -1));
        this.addButton.setText("Add");
        this.removeButton = new Button(addRemoveComposite, 0);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroundBasedLocationsPart.this.obsSimRawGbModule.removeGroundBasedLocation((GroundBasedLocation)GroundBasedLocationsPart.this.selection.getValue());
                GroundBasedLocationsPart.this.tableViewer.refresh();
                if (!GroundBasedLocationsPart.this.obsSimRawGbModule.getGroundLocations().isEmpty()) {
                    GroundBasedLocationsPart.this.tableViewer.getTable().select(0);
                    GroundBasedLocationsPart.this.tableViewer.setSelection(GroundBasedLocationsPart.this.tableViewer.getSelection());
                }
            }
        });
        this.removeButton.setLayoutData((Object)new RowData(100, -1));
        this.removeButton.setText("Remove");
        this.tableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroundBasedLocationsPart.this.noteComposite.setVisible(false);
            }
        });
        this.selectionGroup = new Group(cmpParent, 0);
        this.selectionGroup.setText("Attributes of Selected Ground-based Location");
        this.selectionGroup.setLayout((Layout)new FillLayout());
        this.selectionGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.scrolledComposite = new ScrolledComposite((Composite)this.selectionGroup, 768);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.compInScrolled = new Composite((Composite)this.scrolledComposite, 0);
        GridLayout gl_selectionGroup = new GridLayout(3, false);
        gl_selectionGroup.marginHeight = 0;
        gl_selectionGroup.verticalSpacing = 0;
        gl_selectionGroup.horizontalSpacing = 8;
        this.compInScrolled.setLayout((Layout)gl_selectionGroup);
        Label label_1 = new Label(this.compInScrolled, 258);
        GridData gd_label_1 = new GridData(4, 0x1000000, true, false, 5, 1);
        gd_label_1.heightHint = 30;
        label_1.setLayoutData((Object)gd_label_1);
        Label typeLabel = new Label(this.compInScrolled, 0);
        typeLabel.setText("Location Definition by ...");
        this.typeComboViewer = new ComboViewer(this.compInScrolled, 8);
        this.typeCombo = this.typeComboViewer.getCombo();
        this.typeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.typeCombo.setItems(new String[]{"Observatory Code", "Geocentric Coordinates", "Geodetic Coordinates", "Earth-fixed Vector"});
        this.typeComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GroundBasedLocationsPart.this.changer.go();
            }
        });
        this.typeCombo.select(2);
        Label label_3 = new Label(this.compInScrolled, 0);
        label_3.setText("[-]");
        this.nameLabel = new Label(this.compInScrolled, 0);
        this.nameLabel.setAlignment(131072);
        this.nameLabel.setText("Designator:");
        this.cmpDesignatorOrObsCode = new Composite(this.compInScrolled, 0);
        this.cmpDesignatorOrObsCode.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gl_cmpDesignator = new GridLayout(1, false);
        gl_cmpDesignator.marginWidth = 0;
        gl_cmpDesignator.marginHeight = 0;
        gl_cmpDesignator.verticalSpacing = 0;
        gl_cmpDesignator.horizontalSpacing = 0;
        this.cmpDesignatorOrObsCode.setLayout((Layout)gl_cmpDesignator);
        this.designatorUnitLabel = new Label(this.compInScrolled, 0);
        this.designatorUnitLabel.setText("[-]");
        Label lblDfgfdg = new Label(this.compInScrolled, 256);
        GridData gd_lblDfgfdg = new GridData(4, 0x1000000, false, false, 5, 1);
        gd_lblDfgfdg.heightHint = 15;
        lblDfgfdg.setLayoutData((Object)gd_lblDfgfdg);
        this.data0Label = new Label(this.compInScrolled, 0);
        this.data0Label.setAlignment(131072);
        this.data0Label.setText("<data0>:");
        this.data0Spinner = new Spinner(this.compInScrolled, 2048);
        this.data0Spinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.data0Spinner.setIncrement(1000);
        this.data0Spinner.setPageIncrement(10000);
        this.data0Spinner.setMaximum(Integer.MAX_VALUE);
        this.data0Spinner.setMinimum(Integer.MIN_VALUE);
        this.data0Spinner.setSelection(48234);
        this.data0Spinner.setDigits(3);
        this.data0UnitLabel = new Label(this.compInScrolled, 0);
        this.data0UnitLabel.setText("[<data0 unit>]");
        this.data1Label = new Label(this.compInScrolled, 0);
        this.data1Label.setAlignment(131072);
        this.data1Label.setText("<data1>:");
        this.data1Spinner = new Spinner(this.compInScrolled, 2048);
        this.data1Spinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.data1Spinner.setPageIncrement(10000);
        this.data1Spinner.setMaximum(Integer.MAX_VALUE);
        this.data1Spinner.setMinimum(Integer.MIN_VALUE);
        this.data1Spinner.setSelection(50456);
        this.data1Spinner.setIncrement(1000);
        this.data1Spinner.setDigits(3);
        this.data1UnitLabel = new Label(this.compInScrolled, 0);
        this.data1UnitLabel.setText("[<data1 unit>]");
        this.data2Label = new Label(this.compInScrolled, 0);
        this.data2Label.setAlignment(131072);
        this.data2Label.setText("<data2>:");
        this.data2Spinner = new Spinner(this.compInScrolled, 2048);
        this.data2Spinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.data2Spinner.setPageIncrement(10000);
        this.data2Spinner.setMaximum(Integer.MAX_VALUE);
        this.data2Spinner.setMinimum(Integer.MIN_VALUE);
        this.data2Spinner.setSelection(1532);
        this.data2Spinner.setIncrement(1000);
        this.data2Spinner.setDigits(3);
        this.data2UnitLabel = new Label(this.compInScrolled, 0);
        this.data2UnitLabel.setText("[<data2 unit>]");
        Label label = new Label(this.compInScrolled, 256);
        GridData gd_label = new GridData(4, 0x1000000, false, false, 5, 1);
        gd_label.heightHint = 15;
        label.setLayoutData((Object)gd_label);
        this.ambientTemperatureLabel = new Label(this.compInScrolled, 0);
        this.ambientTemperatureLabel.setText("Ambient Temperature:");
        this.ambientTemperatureSpinner = new Spinner(this.compInScrolled, 2048);
        this.ambientTemperatureSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.ambientTemperatureSpinner.setPageIncrement(10000);
        this.ambientTemperatureSpinner.setMaximum(Integer.MAX_VALUE);
        this.ambientTemperatureSpinner.setMinimum(Integer.MIN_VALUE);
        this.ambientTemperatureSpinner.setSelection(293155);
        this.ambientTemperatureSpinner.setIncrement(1000);
        this.ambientTemperatureSpinner.setDigits(3);
        Label ambientTemperatureUnitLabel = new Label(this.compInScrolled, 0);
        ambientTemperatureUnitLabel.setText("[K]");
        Label atmosphericPressureLabel = new Label(this.compInScrolled, 0);
        atmosphericPressureLabel.setText("Atmospheric Pressure:");
        this.atmosphericPressureSpinner = new Spinner(this.compInScrolled, 2048);
        this.atmosphericPressureSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.atmosphericPressureSpinner.setPageIncrement(10000);
        this.atmosphericPressureSpinner.setMaximum(Integer.MAX_VALUE);
        this.atmosphericPressureSpinner.setMinimum(Integer.MIN_VALUE);
        this.atmosphericPressureSpinner.setSelection(1013200);
        this.atmosphericPressureSpinner.setIncrement(1000);
        this.atmosphericPressureSpinner.setDigits(3);
        Label atmosphericPressureUnitLabel = new Label(this.compInScrolled, 0);
        atmosphericPressureUnitLabel.setText("[mbar]");
        Label relativeHumidityLabel = new Label(this.compInScrolled, 0);
        relativeHumidityLabel.setText("Relative Humidity:");
        this.relativeHumiditySpinner = new Spinner(this.compInScrolled, 2048);
        this.relativeHumiditySpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.relativeHumiditySpinner.setPageIncrement(10000);
        this.relativeHumiditySpinner.setMaximum(Integer.MAX_VALUE);
        this.relativeHumiditySpinner.setMinimum(Integer.MIN_VALUE);
        this.relativeHumiditySpinner.setSelection(50000);
        this.relativeHumiditySpinner.setIncrement(1000);
        this.relativeHumiditySpinner.setDigits(3);
        Label relativeHumidityUnitLabel = new Label(this.compInScrolled, 0);
        relativeHumidityUnitLabel.setText("[%]");
        Label troposphericLapseRateLabel = new Label(this.compInScrolled, 0);
        troposphericLapseRateLabel.setText("Tropospheric Lapse Rate:");
        this.troposphericLapseRateSpinner = new Spinner(this.compInScrolled, 2048);
        this.troposphericLapseRateSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.troposphericLapseRateSpinner.setPageIncrement(100000);
        this.troposphericLapseRateSpinner.setMaximum(Integer.MAX_VALUE);
        this.troposphericLapseRateSpinner.setMinimum(Integer.MIN_VALUE);
        this.troposphericLapseRateSpinner.setSelection(65);
        this.troposphericLapseRateSpinner.setIncrement(10000);
        this.troposphericLapseRateSpinner.setDigits(4);
        this.troposphericLapseRateUnitLabel = new Label(this.compInScrolled, 0);
        this.troposphericLapseRateUnitLabel.setText("[K/m]");
        this.noteComposite = new Composite(this.compInScrolled, 0);
        this.noteComposite.setLayout((Layout)new GridLayout(2, false));
        GridData gd_noteComposite = new GridData(4, 0x1000000, true, false, 5, 1);
        gd_noteComposite.verticalIndent = 20;
        this.noteComposite.setLayoutData((Object)gd_noteComposite);
        this.noteComposite.setVisible(false);
        this.noteComposite.pack();
        this.noteComposite.pack();
        Label noteCaptionLabel = new Label(this.noteComposite, 0);
        noteCaptionLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        noteCaptionLabel.setText("Note:");
        noteCaptionLabel.setFont(SWTResourceManager.getFont("Sans Serif", 9, 1));
        Label noteLabel = new Label(this.noteComposite, 64);
        noteLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        noteLabel.setText("Designator changes do not affect usages of selected element in sensor network definitions.");
        this.scrolledComposite.setContent((Control)this.compInScrolled);
        this.scrolledComposite.setMinSize(this.compInScrolled.computeSize(-1, -1));
        this.logger.debug("min height of scrolledComposite: {}", (Object)this.compInScrolled.computeSize((int)-1, (int)-1).y);
        new Label(cmpParent, 0);
        Group inputFileComposite = new Group(cmpParent, 0);
        inputFileComposite.setEnabled(false);
        inputFileComposite.setText("Ground-based Locations Input File");
        inputFileComposite.setLayout((Layout)new GridLayout(3, false));
        inputFileComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.inputFileText = new Text((Composite)inputFileComposite, 2048);
        this.inputFileText.setEnabled(false);
        this.inputFileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.inputFileText.setText("<ground locations input file / obssim.g_b>");
        Button inputFileBrowseButton = new Button((Composite)inputFileComposite, 0);
        inputFileBrowseButton.setEnabled(false);
        inputFileBrowseButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-open-4.png"));
        inputFileBrowseButton.setToolTipText("Browse");
        Button inputFileEditButton = new Button((Composite)inputFileComposite, 0);
        inputFileEditButton.setEnabled(false);
        inputFileEditButton.setImage(ResourceManager.getPluginImage("de.tu_bs.ilr.esa.estec.neopop.gui.res", "icons/open_icon_library/document-edit.png"));
        inputFileEditButton.setToolTipText("Edit");
        this.changer.go();
    }

    public void focus() {
        if (this.tableViewer != null) {
            this.tableViewer.getTable().setFocus();
        }
    }

    public void bindGUIElements() {
        this.dbc = new DataBindingContext();
        Util.bindList(this.dbc, (InputElement)this.obsSimRawGbModule, "groundLocations", "name", this.selection, this.tableViewer);
        Util.bindDouble(this.dbc, this.selection, "temperature", this.ambientTemperatureSpinner);
        Util.bindDouble(this.dbc, this.selection, "pressure", this.atmosphericPressureSpinner);
        Util.bindDouble(this.dbc, this.selection, "humidity", this.relativeHumiditySpinner);
        Util.bindDouble(this.dbc, this.selection, "lapseRate", this.troposphericLapseRateSpinner);
        Util.bindDouble(this.dbc, this.selection, "data0", this.data0Spinner);
        Util.bindDouble(this.dbc, this.selection, "data1", this.data1Spinner);
        Util.bindDouble(this.dbc, this.selection, "data2", this.data2Spinner);
        Util.bindEnum(this.dbc, this.selection, "type", GroundLocationType.class, this.typeComboViewer, new LabelProvider(){

            public String getText(Object element) {
                return ((GroundLocationType)element).getName();
            }
        });
        Util.bindBooleanPropertyToSelectionExistence(this.dbc, (IObservableValue)WidgetProperties.visible().observe((Widget)this.selectionGroup), (ISelectionProvider)this.tableViewer);
        Util.bindString(this.dbc, (ModelElement)this.obsSimRawCfgModule, "groundLocationsInputFile", this.inputFileText);
        Enabler enabler = new Enabler(new Control[]{this.tableGroup, this.noteComposite});
        enabler.setOutputControlsToBeIgnored(new Control[]{this.removeButton});
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "observationSimulationEnabled"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getPopulationFiles(), "selected"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getAdditionalPopulationFiles(), "selected"));
        enabler.setAggregationEquation(new IAggregationEquation(){

            @Override
            public Object aggregate(HeteroList values) {
                if (((Boolean)values.getTyped(0)).booleanValue() && (((Boolean)values.getTyped(1)).booleanValue() || ((Boolean)values.getTyped(2)).booleanValue())) {
                    return true;
                }
                return false;
            }
        });
        enabler.bind(this.dbc);
        enabler = new Enabler((Composite)this.selectionGroup, (Control)this.selectionGroup, (Control)this.designatorUnitLabel);
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "observationSimulationEnabled"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getPopulationFiles(), "selected"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getAdditionalPopulationFiles(), "selected"));
        enabler.setAggregationEquation(new IAggregationEquation(){

            @Override
            public Object aggregate(HeteroList values) {
                if (((Boolean)values.getTyped(0)).booleanValue() && (((Boolean)values.getTyped(1)).booleanValue() || ((Boolean)values.getTyped(2)).booleanValue())) {
                    return true;
                }
                return false;
            }
        });
        enabler.bind(this.dbc);
        enabler = new Enabler((Composite)this.selectionGroup, (Control)this.data0Label, (Control)this.data2UnitLabel);
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "observationSimulationEnabled"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getPopulationFiles(), "selected"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getAdditionalPopulationFiles(), "selected"));
        enabler.addObservable(BeanProperties.value((String)"type").observeDetail((IObservableValue)this.selection));
        enabler.setAggregationEquation(new IAggregationEquation(){

            @Override
            public Object aggregate(HeteroList values) {
                if (((Boolean)values.getTyped(0)).booleanValue() && (((Boolean)values.getTyped(1)).booleanValue() || ((Boolean)values.getTyped(2)).booleanValue()) && values.getTyped(3) != GroundLocationType.OBSERVATORY_CODE) {
                    return true;
                }
                return false;
            }
        });
        enabler.bind(this.dbc);
        enabler = new Enabler((Composite)this.selectionGroup, (Control)this.ambientTemperatureLabel, (Control)this.troposphericLapseRateUnitLabel);
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "observationSimulationEnabled"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getPopulationFiles(), "selected"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getAdditionalPopulationFiles(), "selected"));
        enabler.setAggregationEquation(new IAggregationEquation(){

            @Override
            public Object aggregate(HeteroList values) {
                if (((Boolean)values.getTyped(0)).booleanValue() && (((Boolean)values.getTyped(1)).booleanValue() || ((Boolean)values.getTyped(2)).booleanValue())) {
                    return true;
                }
                return false;
            }
        });
        enabler.bind(this.dbc);
        enabler = new Enabler(new Control[]{this.removeButton});
        enabler.setInputModelElementValues(new ModelElementValue((ModelElement)this.neopopModule, "observationSimulationEnabled"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getPopulationFiles(), "selected"), new ModelElementValue((ModelElement)this.obsSimRawSrcModule.getAdditionalPopulationFiles(), "selected"));
        enabler.addObservable((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.tableViewer));
        enabler.setAggregationEquation(new IAggregationEquation(){

            @Override
            public Object aggregate(HeteroList values) {
                if (((Boolean)values.getTyped(0)).booleanValue() && (((Boolean)values.getTyped(1)).booleanValue() || ((Boolean)values.getTyped(2)).booleanValue()) && values.getTyped(3) != null) {
                    return true;
                }
                return false;
            }
        });
        enabler.bind(this.dbc);
    }

    public void doAdditionalStuff() {
        Util.setDefaultDoubleAttributes(this.ambientTemperatureSpinner, this.atmosphericPressureSpinner, this.relativeHumiditySpinner, this.troposphericLapseRateSpinner, this.data0Spinner, this.data1Spinner, this.data2Spinner);
    }

    public void finalizeCreation() {
        this.logger.trace("finalizeCreation");
        this.logger.debug("Finalizing creation");
    }

    @Inject
    @Optional
    void fixBrokenLayout(@EventTopic(value="org/eclipse/e4/ui/LifeCycle/activate") Event event) {
        if (!this.selectionGroup.isDisposed()) {
            this.selectionGroup.layout();
        }
    }

    class Changer {
        private Binding currentBinding = null;
        private int data0ValueBackup;
        private int data1ValueBackup;
        private int data2ValueBackup;

        Changer() {
        }

        public void go() {
            GroundLocationType selectedType;
            if (this.currentBinding != null && !this.currentBinding.isDisposed()) {
                this.currentBinding.dispose();
            }
            if (GroundBasedLocationsPart.this.cmbObsCode != null && !GroundBasedLocationsPart.this.cmbObsCode.isDisposed()) {
                GroundBasedLocationsPart.this.cmbObsCode.dispose();
            }
            if (GroundBasedLocationsPart.this.txtDesignator != null && !GroundBasedLocationsPart.this.txtDesignator.isDisposed()) {
                GroundBasedLocationsPart.this.txtDesignator.dispose();
            }
            if ((selectedType = (GroundLocationType)((IStructuredSelection)GroundBasedLocationsPart.this.typeComboViewer.getSelection()).getFirstElement()) == GroundLocationType.OBSERVATORY_CODE) {
                GroundBasedLocationsPart.this.cmbvObsCode = new ComboViewer(GroundBasedLocationsPart.this.cmpDesignatorOrObsCode, 8);
                GroundBasedLocationsPart.this.cmbObsCode = GroundBasedLocationsPart.this.cmbvObsCode.getCombo();
                GroundBasedLocationsPart.this.cmbObsCode.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
                Util.bindInput((StructuredViewer)GroundBasedLocationsPart.this.cmbvObsCode, "observatoryCodes", (InputElement)GroundBasedLocationsPart.this.obsSimRawOclModule, "code");
                Util.bindSelection((StructuredViewer)GroundBasedLocationsPart.this.cmbvObsCode, GroundBasedLocationsPart.this.dbc, "observatoryCode", GroundBasedLocationsPart.this.selection);
                GroundBasedLocationsPart.this.nameLabel.setText("Code:");
                GroundBasedLocationsPart.this.cmbObsCode.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        GroundBasedLocationsPart.this.noteComposite.setVisible(true);
                    }
                });
                this.data0ValueBackup = GroundBasedLocationsPart.this.data0Spinner.getSelection();
                this.data1ValueBackup = GroundBasedLocationsPart.this.data1Spinner.getSelection();
                this.data2ValueBackup = GroundBasedLocationsPart.this.data2Spinner.getSelection();
                GroundBasedLocationsPart.this.cmbvObsCode.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        Changer.this.fillDataSpinnersWithObsCodeAttributes();
                    }
                });
                this.fillDataSpinnersWithObsCodeAttributes();
                GroundBasedLocationsPart.this.data2Label.setVisible(false);
                GroundBasedLocationsPart.this.data2Spinner.setVisible(false);
                GroundBasedLocationsPart.this.data2UnitLabel.setVisible(false);
            } else if (selectedType != null) {
                GroundBasedLocationsPart.this.data2Label.setVisible(true);
                GroundBasedLocationsPart.this.data2Spinner.setVisible(true);
                GroundBasedLocationsPart.this.data2UnitLabel.setVisible(true);
                GroundBasedLocationsPart.this.txtDesignator = new Text(GroundBasedLocationsPart.this.cmpDesignatorOrObsCode, 2048);
                GroundBasedLocationsPart.this.txtDesignator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
                GroundBasedLocationsPart.this.nameLabel.setText("Designator:");
                this.currentBinding = Util.bindString(GroundBasedLocationsPart.this.dbc, GroundBasedLocationsPart.this.selection, "name", (Control)GroundBasedLocationsPart.this.txtDesignator);
                GroundBasedLocationsPart.this.txtDesignator.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                        GroundBasedLocationsPart.this.noteComposite.setVisible(true);
                    }

                    public void focusLost(FocusEvent e) {
                        GroundBasedLocationsPart.this.noteComposite.setVisible(false);
                        GroundBasedLocationsPart.this.compInScrolled.layout();
                    }
                });
            }
            if (selectedType != null) {
                GroundBasedLocationsPart.this.data0Label.setText(String.valueOf(selectedType.getData0Name()) + ":");
                GroundBasedLocationsPart.this.data1Label.setText(String.valueOf(selectedType.getData1Name()) + ":");
                GroundBasedLocationsPart.this.data2Label.setText(String.valueOf(selectedType.getData2Name()) + ":");
                GroundBasedLocationsPart.this.data0UnitLabel.setText("[" + selectedType.getData0Unit() + "]");
                GroundBasedLocationsPart.this.data1UnitLabel.setText("[" + selectedType.getData1Unit() + "]");
                GroundBasedLocationsPart.this.data2UnitLabel.setText("[" + selectedType.getData2Unit() + "]");
            }
            GroundBasedLocationsPart.this.compInScrolled.layout();
            GroundBasedLocationsPart.this.cmpDesignatorOrObsCode.layout();
        }

        private void fillDataSpinnersWithObsCodeAttributes() {
            IStructuredSelection selection = (IStructuredSelection)GroundBasedLocationsPart.this.cmbvObsCode.getSelection();
            if (selection.isEmpty()) {
                GroundBasedLocationsPart.this.data0Spinner.setSelection(0);
                GroundBasedLocationsPart.this.data1Spinner.setSelection(0);
                GroundBasedLocationsPart.this.data2Spinner.setSelection(0);
            } else {
                ObservatoryCode obsCode = (ObservatoryCode)selection.getFirstElement();
                GroundBasedLocationsPart.this.data0Spinner.setSelection((int)Math.round(obsCode.getLongitude() * Math.pow(10.0, GroundBasedLocationsPart.this.data0Spinner.getDigits())));
                double geocentricLatitude = Math.toDegrees(Math.atan(obsCode.getSine() / obsCode.getCosine()));
                GroundBasedLocationsPart.this.data1Spinner.setSelection((int)Math.round(geocentricLatitude * Math.pow(10.0, GroundBasedLocationsPart.this.data1Spinner.getDigits())));
            }
        }
    }
}

