/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MSnippetContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowLayoutResetController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostConstruct
    public void postConstruct() {
        this.logger.trace("postConstruct()");
    }

    @Inject
    @Optional
    public void resetWindowLayout(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/windowLayoutReset") Event event, EModelService modelService, MApplication app) {
        this.logger.trace("resetWindowLayout(...)");
        this.logger.info("Resetting Window Layout");
        this.logger.debug("Replacing perspectives with backups");
        MWindow window = (MWindow)modelService.findElements((MUIElement)app, null, MWindow.class, null).get(0);
        MPerspectiveStack perspStack = (MPerspectiveStack)modelService.find("de.tu_bs.ilr.esa.estec.neopop.gui.perspectivestack", (MUIElement)app);
        String elementIDOfSelectedPerspective = ((MPerspective)perspStack.getSelectedElement()).getElementId();
        for (MPerspective persp : modelService.findElements((MUIElement)app, null, MPerspective.class, null)) {
            MPerspective perspBackup = (MPerspective)modelService.findSnippet((MSnippetContainer)app, persp.getElementId());
            MPerspective newPersp = (MPerspective)modelService.cloneElement((MUIElement)perspBackup, null);
            modelService.resetPerspectiveModel(persp, window);
            modelService.removePerspectiveModel(persp, window);
            perspStack.getChildren().remove(persp);
            perspStack.getChildren().add(newPersp);
            if (!newPersp.getElementId().equals(elementIDOfSelectedPerspective)) continue;
            perspStack.setSelectedElement((MUIElement)newPersp);
        }
    }
}

