/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import de.tu_bs.ilr.esa.estec.neopop.gui.util.BinaryFilePathValidator;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.IPlotOutputObjectPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.ITextOutputObjectPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.IView;
import de.tu_bs.ilr.esa.estec.neopop.model.MainComponentOutput;
import de.tu_bs.ilr.esa.estec.neopop.model.Model;
import de.tu_bs.ilr.esa.estec.neopop.model.Output;
import de.tu_bs.ilr.esa.estec.neopop.model.OutputPlot;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplotController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Path popGenOutputDirPath;
    private Path obsSimOutputDirPath;
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    public void postConstruct(Model model) {
        this.logger.trace("postConstruct");
    }

    @Inject
    @Optional
    void onProjectOpened(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/projectOpened") Event event, Model model) {
        this.logger.trace("onProjectOpened");
        this.logger.debug("Setting output dir paths");
        this.popGenOutputDirPath = model.getWorkspace().getProject().getPath().resolve("01-POPGEN").resolve("output");
        this.obsSimOutputDirPath = model.getWorkspace().getProject().getPath().resolve("02-OBSSIM").resolve("output");
    }

    @Inject
    @Optional
    void replotSingle(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/replotSingle") Event event, Model model, MainComponentOutput componentOutput, Output output, @Named(value="de.tu_bs.ilr.esa.estec.neopop.gui.gnuplotFilePart") ITextOutputObjectPart textPart, @Named(value="de.tu_bs.ilr.esa.estec.neopop.gui.currentOutputDirPath") Path currentOutputDirPath, IPlotOutputObjectPart plotPart, OutputPlot currentPlot, IView view) {
        this.logger.trace("replotSingle");
        this.logger.info("Replotting {}", (Object)currentPlot);
        Path outputDirPath = componentOutput == output.getPopGenOutput() || componentOutput == output.getPopAnaOutput() ? this.popGenOutputDirPath : this.obsSimOutputDirPath;
        this.saveGnuPlotFileText(textPart.getText(), currentOutputDirPath, currentPlot.getGnuplotFile().getFileName());
        this.executeGnuplot(model.getGnuplotExeFilePath(), currentPlot.getGnuplotFile().getFileName(), outputDirPath.toFile(), view);
        plotPart.reloadPlots();
    }

    @Inject
    @Optional
    void replotAll(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/replotAll") boolean afterRun, Model model, Output output, @Optional @Named(value="de.tu_bs.ilr.esa.estec.neopop.gui.gnuplotFilePart") ITextOutputObjectPart textPart, @Optional @Named(value="de.tu_bs.ilr.esa.estec.neopop.gui.currentOutputDirPath") Path currentOutputDirPath, @Optional OutputPlot currentPlot, @Optional IPlotOutputObjectPart plotPart, IView view) {
        this.logger.trace("replotAll");
        this.logger.info("Replotting all plots");
        this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/output/refreshIfRequired", null);
        if (output.getPopAnaOutput() == null && output.getObsAnaOutput() == null) {
            this.logger.debug("No Population or Observation Analysis output has been read (yet)");
            return;
        }
        if (!afterRun && textPart != null) {
            this.saveGnuPlotFileText(textPart.getText(), currentOutputDirPath, currentPlot.getGnuplotFile().getFileName());
        }
        if (output.getPopAnaOutput() != null) {
            this.executeGnuplot(model.getGnuplotExeFilePath(), output.getPopAnaOutput().getMainGnuplotFileName(), this.popGenOutputDirPath.toFile(), view);
        }
        if (output.getObsAnaOutput() != null) {
            this.executeGnuplot(model.getGnuplotExeFilePath(), output.getObsAnaOutput().getMainGnuplotFileName(), this.obsSimOutputDirPath.toFile(), view);
        }
        if (!afterRun && plotPart != null) {
            plotPart.reloadPlots();
        }
    }

    private void saveGnuPlotFileText(String text, Path currentOutputDirPath, String fileName) {
        block14: {
            this.logger.trace("saveGnuPlotFileText(text={}, currentOutputDirPath={}, fileName={})", new Object[]{text, currentOutputDirPath, fileName});
            Path filePath = currentOutputDirPath.resolve(fileName);
            this.logger.debug("Saving changes of gnuplot file \"{}\"", (Object)filePath);
            OutputStreamWriter stream = null;
            try {
                try {
                    stream = new OutputStreamWriter(new FileOutputStream(filePath.toFile()));
                    stream.write(text);
                }
                catch (IOException e) {
                    this.logger.error("Could not save gnuplot file \"{}\": {}", new Object[]{filePath, e, e});
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e2) {
                            this.logger.error("Could not close gnuplot file \"{}\": {}", new Object[]{filePath, e2, e2});
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        this.logger.error("Could not close gnuplot file \"{}\": {}", new Object[]{filePath, e, e});
                    }
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    this.logger.error("Could not close gnuplot file \"{}\": {}", new Object[]{filePath, e, e});
                }
            }
        }
    }

    private void executeGnuplot(String gnuplotExeFilePathString, String gnuplotFileName, File execDir, IView view) {
        Process process;
        this.logger.trace("executeGnuplot(gnuplotExeFilePathString={}, gnuplotFileName={}, execDir={})", new Object[]{gnuplotExeFilePathString, gnuplotFileName, execDir});
        if (!new BinaryFilePathValidator().validate((Object)gnuplotExeFilePathString).isOK()) {
            this.logger.error("gnuplot file path is bad");
            view.openErrorDialog("NEOPOP GUI Error", "Could not execute gnuplot because the specified file path is not executable. As a result, plot images can not be generated.\n\nPlease check the provided gnuplot executable file path via the Settings Button in the Main Toolbar at the top of the window.After a correct path has been specified, you can create the plot images by using the Replot Button which can be found in the toolbar as well.\n\nNote for Linux users: Installations of NEOPOP do not install gnuplot; you have to install it separately by yourself.");
            return;
        }
        Path gnuplotExeFilePath = FileSystems.getDefault().getPath(gnuplotExeFilePathString, new String[0]);
        if (!gnuplotExeFilePath.isAbsolute()) {
            gnuplotExeFilePath = gnuplotExeFilePath.toAbsolutePath();
        }
        String command = gnuplotExeFilePath + " " + gnuplotFileName;
        this.logger.info("Executing gnuplot");
        this.logger.debug("Executing \"{}\" in dir \"{}\"", (Object)command, (Object)execDir);
        this.logger.debug("Absolute gnuplot exe file path: {} ({})", (Object)gnuplotExeFilePath, (Object)(gnuplotExeFilePath.toFile().exists() ? "exists" : "doesn't exist"));
        try {
            process = Runtime.getRuntime().exec(command, new String[0], execDir);
        }
        catch (IOException e) {
            this.logger.error("Could not run gnuplot (command: {}) in dir {}", new Object[]{command, execDir, e});
            return;
        }
        final Process gnuplotProcessFinal = process;
        Job stdOutputReader = new Job("gnuplot Standard Output Reader"){

            protected IStatus run(IProgressMonitor monitor) {
                block12: {
                    Thread.currentThread().setName(this.getName());
                    ReplotController.this.logger.trace("run");
                    ReplotController.this.logger.debug("Running");
                    ReplotController.this.logger.debug("Getting IS");
                    InputStream is = gnuplotProcessFinal.getInputStream();
                    ReplotController.this.logger.debug("Creating reader");
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    try {
                        try {
                            ReplotController.this.logger.debug("Reading line");
                            String currentLine = reader.readLine();
                            while (currentLine != null) {
                                ReplotController.this.logger.debug("gnuplot: {}", (Object)currentLine);
                                ReplotController.this.logger.debug("Reading line");
                                currentLine = reader.readLine();
                            }
                        }
                        catch (IOException e) {
                            ReplotController.this.logger.error("Could not read line from standard output of gnuplot", (Throwable)e);
                            try {
                                ReplotController.this.logger.debug("Closing IS");
                                is.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            ReplotController.this.logger.debug("Closing IS");
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        ReplotController.this.logger.debug("Closing IS");
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ReplotController.this.logger.debug("Terminating");
                return Status.OK_STATUS;
            }
        };
        stdOutputReader.schedule();
        Job stdErrorOutputReader = new Job("gnuplot Standard Error Output Reader"){

            protected IStatus run(IProgressMonitor monitor) {
                block12: {
                    Thread.currentThread().setName(this.getName());
                    ReplotController.this.logger.trace("run");
                    ReplotController.this.logger.debug("Running");
                    ReplotController.this.logger.debug("Getting IS");
                    InputStream is = gnuplotProcessFinal.getErrorStream();
                    ReplotController.this.logger.debug("Creating reader");
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    try {
                        try {
                            ReplotController.this.logger.debug("Reading line");
                            String currentLine = reader.readLine();
                            while (currentLine != null) {
                                ReplotController.this.logger.debug("gnuplot: {}", (Object)currentLine);
                                ReplotController.this.logger.debug("Reading line");
                                currentLine = reader.readLine();
                            }
                        }
                        catch (IOException e) {
                            ReplotController.this.logger.error("Could not read line from standard error output of gnuplot", (Throwable)e);
                            try {
                                ReplotController.this.logger.debug("Closing IS");
                                is.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            ReplotController.this.logger.debug("Closing IS");
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        ReplotController.this.logger.debug("Closing IS");
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ReplotController.this.logger.debug("Terminating");
                return Status.OK_STATUS;
            }
        };
        stdErrorOutputReader.schedule();
        try {
            gnuplotProcessFinal.waitFor();
        }
        catch (InterruptedException e) {
            this.logger.error("While waiting for gnuplot process to finish: {}", (Object)e, (Object)e);
        }
    }
}

