/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.Activator;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.PDFCreator;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.PrefUtil;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.PresenterUtil;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.ProjectCopyFileVisitor;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.NEOPOPRunner;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.DialogType;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.IView;
import de.tu_bs.ilr.esa.estec.neopop.model.Input;
import de.tu_bs.ilr.esa.estec.neopop.model.Model;
import de.tu_bs.ilr.esa.estec.neopop.model.Output;
import de.tu_bs.ilr.esa.estec.neopop.model.OutputSubject;
import de.tu_bs.ilr.esa.estec.neopop.model.PopAnaOutputPlotCategory;
import de.tu_bs.ilr.esa.estec.neopop.model.PopulationFileFormat;
import de.tu_bs.ilr.esa.estec.neopop.model.PopulationGenerationMode;
import de.tu_bs.ilr.esa.estec.neopop.model.Project;
import de.tu_bs.ilr.esa.estec.neopop.model.connector.IModelConnector;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.inject.Inject;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private IModelConnector modelConnector;
    @Inject
    private Input input;
    @Inject
    private Model model;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private PrefUtil prefUtil;
    @Inject
    private UISynchronize uiSynch;
    private volatile Job previousNEOPOPStdOutputReader = null;
    private volatile Job previousNEOPOPRunner = null;
    protected static Set<NEOPOPRunner> runningRunners = Collections.synchronizedSet(new HashSet());
    private volatile SaveOperation saveOperationToComeBackToAfterCheckOfInput = null;
    private volatile Path lastProjectSaveAsPath = null;
    private boolean lastInputCheckResult;

    @Inject
    @Optional
    void openCurrentProject(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/project/openCurrent") Event event, PrefUtil prefUtil, IModelConnector modelConnector, Model model, PresenterUtil presenterUtil, IView view) {
        this.logger.trace("openCurrentProject(...)");
        this.logger.info("Opening current project");
        Path projectDirPath = model.getWorkspace().getProject().getPath();
        if (projectDirPath != null && !projectDirPath.toFile().exists()) {
            this.logger.error("Current project \"{}\" does not exist!", (Object)projectDirPath);
            projectDirPath = null;
        }
        if (projectDirPath == null) {
            this.logger.info("No current project");
            Path defaultProjectDirPath = FileSystems.getDefault().getPath(model.getWorkspace().getPath(), "NEOPOP");
            if (presenterUtil.isValidProjectDirPath(defaultProjectDirPath)) {
                this.logger.info("Opening default project");
                this.openProject(defaultProjectDirPath, prefUtil, modelConnector, model, view, presenterUtil);
            } else {
                this.logger.info("Creating and opening default project");
                this.createAndOpenProject(defaultProjectDirPath, prefUtil, modelConnector, model, presenterUtil, view);
            }
        } else {
            this.openProject(projectDirPath, prefUtil, modelConnector, model, view, presenterUtil);
        }
    }

    @Inject
    @Optional
    void createAndOpenProject(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/project/createAndOpen") Path projDirPath, PrefUtil prefUtil, IModelConnector modelConnector, Model model, PresenterUtil presenterUtil, IView view) {
        this.logger.trace("createAndOpenProject(projDirPath={}, ...)", (Object)projDirPath);
        this.logger.info("Creating and opening project {}", (Object)projDirPath);
        if (!presenterUtil.isValidProjectDirPathForProjectCreation(projDirPath)) {
            presenterUtil.reboundWithError("You selected an invalid folder", DialogType.NEW_PROJECT, projDirPath, view);
            return;
        }
        this.createProject(projDirPath, prefUtil);
        this.openProject(projDirPath, prefUtil, modelConnector, model, view, presenterUtil);
    }

    private void copyProject(Path sourceProjDirPath, Path targetProjDirPath) {
        targetProjDirPath.getParent().toFile().mkdirs();
        this.logger.debug("Copying files and folders from {} to {} (except data folders and executables)", (Object)sourceProjDirPath, (Object)targetProjDirPath);
        try {
            Files.walkFileTree(sourceProjDirPath, Collections.singleton(FileVisitOption.FOLLOW_LINKS), 3, new ProjectCopyFileVisitor(sourceProjDirPath, targetProjDirPath));
        }
        catch (IOException e) {
            this.logger.error("Could not copy files and folders from {} to {}", new Object[]{sourceProjDirPath, targetProjDirPath, e});
            return;
        }
    }

    void createProject(Path projDirPath, PrefUtil prefUtil) {
        this.logger.trace("createProject(projDirPath={})", (Object)projDirPath);
        this.logger.info("Creating project {}", (Object)projDirPath);
        Path defaultProjDirPath = FileSystems.getDefault().getPath(System.getProperty("user.dir"), "..", "default");
        this.copyProject(defaultProjDirPath, projDirPath);
    }

    @Inject
    @Optional
    void openProject(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/project/open") Path projDirPath, PrefUtil prefUtil, IModelConnector modelConnector, Model model, IView view, PresenterUtil presenterUtil) {
        this.logger.trace("openProject(projDirPath={})", (Object)projDirPath);
        this.logger.info("Opening project {}", (Object)projDirPath);
        if (!presenterUtil.isValidProjectDirPath(projDirPath)) {
            presenterUtil.reboundWithError("You selected an invalid folder", DialogType.OPEN_PROJECT, projDirPath, view);
            return;
        }
        Path workspaceDirPath = FileSystems.getDefault().getPath(model.getWorkspace().getPath(), new String[0]);
        this.logger.debug("workspace dir path = {}", (Object)workspaceDirPath);
        Path neopopCfgFilePath = projDirPath.resolve("neopop.cfg");
        this.logger.debug("neopop cfg file path = {}", (Object)neopopCfgFilePath);
        Input input = model.getWorkspace().getProject().getInput();
        input.getNeopopModule().setNeopopCfgFilePath(neopopCfgFilePath.toString());
        model.getWorkspace().getProject().setPath(projDirPath);
        this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/input/reset", (Object)true);
        this.saveCurrentProject(false, input);
        if (projDirPath.startsWith(workspaceDirPath)) {
            model.getWorkspace().getProject().setName(workspaceDirPath.relativize(projDirPath).toString());
        } else {
            model.getWorkspace().getProject().setName(projDirPath.toString());
        }
        this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/showProjectName", null);
        this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/projectOpened", null);
        this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/project/readOutput", null);
    }

    @Inject
    @Optional
    void saveCurrentProject(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/project/save") Boolean checkInputBefore, Input input) {
        this.logger.trace("saveCurrentProject(checkInputBefore={})", (Object)checkInputBefore);
        if (checkInputBefore == null) {
            checkInputBefore = true;
        }
        if (checkInputBefore.booleanValue()) {
            this.saveOperationToComeBackToAfterCheckOfInput = SaveOperation.NORMAL_SAVE;
            this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/input/check", null);
            return;
        }
        this.logger.info("Saving current project");
        input.defragmentateLists();
        this.logger.debug("Writing model data");
        this.modelConnector.write_input_file("NEOPOP_WRITE_CFG");
        input.getObsSimRawCfgModule().setRunId(input.getPopGenInpCfgModule().getRunId());
        String tmp = this.input.getPopGenInpCfgModule().getProjectFolder();
        this.input.getPopGenInpCfgModule().setProjectFolder(".");
        this.modelConnector.write_input_file("POPGEN_WRITE_CFG");
        this.input.getPopGenInpCfgModule().setProjectFolder(tmp);
        this.modelConnector.write_input_file("POPGEN_WRITE_PLT");
        this.modelConnector.write_input_file("POPGEN_WRITE_INP");
        this.modelConnector.write_input_file("POPGEN_WRITE_FIL");
        tmp = this.input.getObsSimRawCfgModule().getProjectDirPath();
        this.input.getObsSimRawCfgModule().setProjectDirPath(".");
        this.modelConnector.write_input_file("OBSSIM_WRITE_CFG");
        this.input.getObsSimRawCfgModule().setProjectDirPath(tmp);
        this.modelConnector.write_input_file("OBSSIM_WRITE_INP");
        this.modelConnector.write_input_file("OBSSIM_WRITE_SRC");
        this.modelConnector.write_input_file("OBSSIM_WRITE_NET");
        this.modelConnector.write_input_file("OBSSIM_WRITE_G_B");
        this.modelConnector.write_input_file("OBSSIM_WRITE_S_B");
        this.modelConnector.write_input_file("OBSSIM_WRITE_OPT");
        this.modelConnector.write_input_file("OBSSIM_WRITE_RAD");
        this.modelConnector.write_input_file("OBSSIM_WRITE_PLT");
    }

    @Inject
    @Optional
    void inputChecked(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/input/checked") Event event, IView view) {
        boolean result;
        this.lastInputCheckResult = result = ((Boolean)event.getProperty("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/inputCheckResult")).booleanValue();
        String problemHint = (String)event.getProperty("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/inputCheckProblemHint");
        this.logger.trace("inputChecked(result={}, problemHint={})", (Object)result, (Object)problemHint);
        if (result) {
            if (this.saveOperationToComeBackToAfterCheckOfInput == SaveOperation.NORMAL_SAVE) {
                this.eventBroker.post("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/project/save", (Object)false);
            } else {
                HashMap<String, Comparable<Boolean>> mapToSend = new HashMap<String, Comparable<Boolean>>();
                mapToSend.put("de/tu-bs/ilr/esa/estec/neopop/checkInputBefore", Boolean.valueOf(false));
                mapToSend.put("de/tu-bs/ilr/esa/estec/neopop/targetPath", this.lastProjectSaveAsPath);
                this.eventBroker.post("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/project/saveAs", mapToSend);
            }
        } else {
            view.openErrorDialog("Input check failed", "At least one input value is invalid.\nYou have to correct that before proceeding.\n\nProblem hint: " + problemHint);
        }
    }

    @Inject
    @Optional
    void runCurrentProject(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/project/run") Event event, PresenterUtil presenterUtil, IView view) {
        this.logger.trace("runCurrentProject");
        this.logger.info("Running current project");
        this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/project/save", (Object)true);
        if (!this.lastInputCheckResult) {
            return;
        }
        final String projDirPathAsString = this.input.getObsSimRawCfgModule().getProjectDirPath();
        String neopopExeFilePath = this.model.getNeopopExeFilePath();
        if (neopopExeFilePath == null || neopopExeFilePath.equals("")) {
            this.logger.error("NEOPOP executable file path not set");
            return;
        }
        Path absoluteNEOPOPExeFilePath = FileSystems.getDefault().getPath(neopopExeFilePath, new String[0]).toAbsolutePath();
        new File(projDirPathAsString);
        final Path projDirPath = FileSystems.getDefault().getPath(projDirPathAsString, new String[0]);
        presenterUtil.sendCreateAndOpenDialogEvent(DialogType.RUN, null, false);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        final boolean usePopGenModulePopulationAsObservationSimulatorInput = this.model.getWorkspace().getProject().getUseGeneratedPopulationAsObservationSimulatorInput() != false && (this.input.getNeopopModule().getObservationSimulationEnabled() != false || this.input.getNeopopModule().getObservationAnalysisEnabled() != false);
        this.logger.debug("Population generated/used by Population Generation module will be used as input for Observation Simulator");
        NEOPOPRunner runner = new NEOPOPRunner(absoluteNEOPOPExeFilePath.toString(), projDirPathAsString, this.eventBroker, null){

            @Override
            public void doRun() {
                ProjectController.this.uiSynch.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (usePopGenModulePopulationAsObservationSimulatorInput) {
                            Path populationGenerationPopulationFilePath = null;
                            Path populationGenerationPPFPath = null;
                            String runID = ProjectController.this.input.getPopGenInpCfgModule().getRunId();
                            String populationFileExtension = ProjectController.this.input.getPopGenInpInpModule().getPopulationGeneration().getGeneratedPopulationFiles().getFormat().getFileExtension();
                            if (ProjectController.this.input.getPopGenInpInpModule().getPopulationGeneration().getMode() == PopulationGenerationMode.GENERATE_PHYSICAL_PROPERTIES_FILE_FOR_PROVIDED_POPULATION) {
                                populationGenerationPopulationFilePath = ProjectController.this.getAbsolutePopGenPathIfRelative(projDirPathAsString, ProjectController.this.input.getPopGenInpInpModule().getPopulationGeneration().getGeneratedPopulationFiles().getPopulationFilePath());
                                populationGenerationPPFPath = ProjectController.this.getAbsolutePopGenPathIfRelative(projDirPathAsString, ProjectController.this.input.getPopGenInpInpModule().getPopulationGeneration().getGeneratedPopulationFiles().getCrossReferenceFilePath());
                            } else {
                                populationGenerationPopulationFilePath = FileSystems.getDefault().getPath(projDirPathAsString, "01-POPGEN", "output", String.valueOf(runID) + "." + populationFileExtension);
                                populationGenerationPPFPath = FileSystems.getDefault().getPath(projDirPathAsString, "01-POPGEN", "output", String.valueOf(runID) + ".ppf");
                            }
                            originalObsSimPopulationFilePath = ProjectController.this.input.getObsSimRawSrcModule().getPopulationFiles().getPopulationFilePath();
                            originalObsSimPPFFilePath = ProjectController.this.input.getObsSimRawSrcModule().getPopulationFiles().getCrossReferenceFilePath();
                            originalObsSimPopulationFileFormat = ProjectController.this.input.getObsSimRawSrcModule().getPopulationFiles().getFormat();
                            String tempObsSimPopulationFilePath = projDirPath.relativize(populationGenerationPopulationFilePath).toString();
                            String tempObsSimPPFFilePath = projDirPath.relativize(populationGenerationPPFPath).toString();
                            PopulationFileFormat tempObsSimPopulationFileFormat = ProjectController.this.input.getPopGenInpInpModule().getPopulationGeneration().getGeneratedPopulationFiles().getFormat();
                            ProjectController.this.logger.debug("Setting ObsSim population file path temporarily from \"{}\" to \"{}\"", (Object)originalObsSimPopulationFilePath, (Object)tempObsSimPopulationFilePath);
                            ProjectController.this.input.getObsSimRawSrcModule().getPopulationFiles().setPopulationFilePath(tempObsSimPopulationFilePath);
                            ProjectController.this.logger.debug("Setting ObsSim PPF file path temporarily from \"{}\" to \"{}\"", (Object)originalObsSimPPFFilePath, (Object)tempObsSimPPFFilePath);
                            ProjectController.this.input.getObsSimRawSrcModule().getPopulationFiles().setCrossReferenceFilePath(tempObsSimPPFFilePath);
                            ProjectController.this.logger.debug("Setting ObsSim population file format temporarily from {} to {}", (Object)originalObsSimPopulationFileFormat, (Object)tempObsSimPopulationFileFormat);
                            ProjectController.this.input.getObsSimRawSrcModule().getPopulationFiles().setFormat(tempObsSimPopulationFileFormat);
                            ProjectController.this.saveCurrentProject(false, ProjectController.this.input);
                        }
                    }
                });
                this.doExec();
                if (usePopGenModulePopulationAsObservationSimulatorInput) {
                    ProjectController.this.uiSynch.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ProjectController.this.input.getObsSimRawSrcModule().getPopulationFiles().setPopulationFilePath(originalObsSimPopulationFilePath);
                            ProjectController.this.input.getObsSimRawSrcModule().getPopulationFiles().setCrossReferenceFilePath(originalObsSimPPFFilePath);
                            ProjectController.this.input.getObsSimRawSrcModule().getPopulationFiles().setFormat(originalObsSimPopulationFileFormat);
                            ProjectController.this.saveCurrentProject(false, ProjectController.this.input);
                        }
                    });
                }
                ProjectController.this.logger.info("NEOPOP Command-Line Tool execution has completed.");
                ProjectController.this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/neopopCLTExecutionCompleted", null);
                ProjectController.this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/project/readOutput", null);
                ProjectController.this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/replotAll", (Object)true);
                ProjectController.this.logger.info("Project run completed.");
                ProjectController.this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/projectRunCompleted", null);
            }
        };
        runner.schedule();
    }

    private Path getAbsolutePopGenPathIfRelative(String projDirPath, String filePath) {
        Path result = FileSystems.getDefault().getPath(filePath, new String[0]);
        if (!result.isAbsolute()) {
            result = FileSystems.getDefault().getPath(projDirPath, filePath);
        }
        return result;
    }

    @Inject
    @Optional
    void saveCurrentProjectAs(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/project/saveAs") Event event, Input input, Model model, IView view, PresenterUtil presenterUtil) {
        Path targetProjDirPath = event.getProperty("org.eclipse.e4.data") instanceof Path ? (Path)event.getProperty("org.eclipse.e4.data") : (Path)event.getProperty("de/tu-bs/ilr/esa/estec/neopop/targetPath");
        Boolean checkInputBefore = (Boolean)event.getProperty("de/tu-bs/ilr/esa/estec/neopop/checkInputBefore");
        this.logger.trace("saveCurrentProjectAs(targetProjDirPath={}, checkInputBefore={})", (Object)targetProjDirPath, (Object)checkInputBefore);
        this.logger.info("Saving current project as {}", (Object)targetProjDirPath);
        if (!presenterUtil.isValidProjectDirPathForProjectCreation(targetProjDirPath)) {
            presenterUtil.reboundWithError("You selected an invalid folder", DialogType.SAVE_PROJECT_AS, targetProjDirPath, view);
            return;
        }
        if (checkInputBefore == null) {
            checkInputBefore = true;
        }
        if (checkInputBefore.booleanValue()) {
            this.saveOperationToComeBackToAfterCheckOfInput = SaveOperation.SAVE_AS;
            this.lastProjectSaveAsPath = targetProjDirPath;
            this.eventBroker.post("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/input/check", null);
            return;
        }
        Path currentProjDirPath = model.getWorkspace().getProject().getPath();
        this.copyProject(currentProjDirPath, targetProjDirPath);
        input.getNeopopModule().setNeopopCfgFilePath(targetProjDirPath.resolve("neopop.cfg").toString());
        input.getPopGenInpCfgModule().setProjectFolder(targetProjDirPath.toString());
        input.getObsSimRawCfgModule().setProjectDirPath(targetProjDirPath.toString());
        this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenter/project/save", (Object)false);
        this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/project/open", (Object)targetProjDirPath);
    }

    private String replaceFolder(String filePathStr, String oldFolder, String newFolder) {
        Path filePath = FileSystems.getDefault().getPath(filePathStr, new String[0]);
        LinkedList<Path> pathPartStack = new LinkedList<Path>();
        boolean found = false;
        do {
            Path pathPart = filePath.getFileName();
            filePath = filePath.getParent();
            if (pathPart.toString().equals(oldFolder)) {
                pathPartStack.push(FileSystems.getDefault().getPath(newFolder, new String[0]));
                found = true;
                continue;
            }
            pathPartStack.push(pathPart);
        } while (!found);
        Path newFilePath = filePath;
        while (!pathPartStack.isEmpty()) {
            newFilePath = newFilePath.resolve((Path)pathPartStack.pop());
        }
        return newFilePath.toString();
    }

    @Inject
    @Optional
    void runCancellationRequested(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/runCancellationRequested") Event event, IView view) {
        this.logger.trace("runCancellationRequested");
        this.logger.info("Run cancellation requested");
        for (NEOPOPRunner runningRunner : runningRunners) {
            runningRunner.cancel();
        }
        runningRunners.clear();
    }

    @Inject
    @Optional
    void saveCurrentProjectAsPDF(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/project/saveAsPDF") Path targetPath, Input input, Model model, Output output) {
        this.logger.trace("saveCurrentProjectAsPDF(targetPath={})", (Object)targetPath);
        this.logger.info("Saving current project as PDF to {}", (Object)targetPath);
        Project project = model.getWorkspace().getProject();
        Path projectPath = project.getPath();
        Path popGenPath = projectPath.resolve("01-POPGEN");
        Path obsSimPath = projectPath.resolve("02-OBSSIM");
        Path popGenInputPath = popGenPath.resolve("input");
        Path popGenOutputPath = popGenPath.resolve("output");
        Path obsSimInputPath = obsSimPath.resolve("input");
        Path obsSimOutputPath = obsSimPath.resolve("output");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        try {
            PDFCreator pdf = new PDFCreator(targetPath);
            pdf.setDefaultBoldness(false);
            pdf.setDefaultFontSize(19.0f);
            pdf.addLineBreaks(5);
            pdf.addTextLine("ESA NEOPOP " + Activator.getVersion(), 26.0f, true);
            pdf.addLineBreaks(5);
            pdf.addTextLine("Project:         " + model.getWorkspace().getProject().getName());
            pdf.addLineBreak();
            pdf.addTextLine("Run:             " + output.getRunId());
            pdf.addLineBreak();
            pdf.addTextLine("Generation time: " + dateFormat.format(new Date()));
            pdf.setDefaultFontSize(12.0f);
            pdf.addPageBreak();
            pdf.addTextLine("1 Configuration and Input Files", 16.0f, true);
            pdf.addLineBreak();
            pdf.addTextLine("1.2 neopop.cfg", 16.0f, true);
            pdf.addLineBreak();
            pdf.addTextFile(projectPath.resolve("neopop.cfg"));
            pdf.addLineBreak();
            pdf.addTextLine("1.3 popgen.cfg", 16.0f, true);
            pdf.addLineBreak();
            pdf.addTextFile(popGenPath.resolve("popgen.cfg"));
            pdf.addLineBreak();
            pdf.addTextLine("1.4 popgen.inp", 16.0f, true);
            pdf.addLineBreak();
            pdf.addTextFile(popGenInputPath.resolve("popgen.inp"));
            pdf.addLineBreak();
            pdf.addTextLine("1.5 popgen.fil", 16.0f, true);
            pdf.addLineBreak();
            pdf.addTextFile(popGenInputPath.resolve("popgen.fil"));
            pdf.addLineBreak();
            pdf.addTextLine("1.6 popgen.plt", 16.0f, true);
            pdf.addLineBreak();
            pdf.addTextFile(popGenInputPath.resolve("popgen.plt"));
            pdf.addLineBreak();
            pdf.addTextLine("1.7 obssim.cfg", 16.0f, true);
            pdf.addLineBreak();
            pdf.addTextFile(obsSimPath.resolve("obssim.cfg"));
            pdf.addLineBreak();
            pdf.addTextLine("1.8 obssim.inp", 16.0f, true);
            pdf.addLineBreak();
            pdf.addTextFile(obsSimInputPath.resolve("obssim.inp"));
            pdf.addLineBreak();
            pdf.addTextLine("1.9 obssim.src", 16.0f, true);
            pdf.addLineBreak();
            pdf.addTextFile(obsSimInputPath.resolve("obssim.src"));
            pdf.addLineBreak();
            pdf.addTextLine("1.10 obssim.net", 16.0f, true);
            pdf.addLineBreak();
            pdf.addTextFile(obsSimInputPath.resolve("obssim.net"));
            pdf.addLineBreak();
            pdf.addTextLine("1.11 obssim.g_b", 16.0f, true);
            pdf.addLineBreak();
            pdf.addTextFile(obsSimInputPath.resolve("obssim.g_b"));
            pdf.addLineBreak();
            pdf.addTextLine("1.12 obssim.s_b", 16.0f, true);
            pdf.addLineBreak();
            pdf.addTextFile(obsSimInputPath.resolve("obssim.s_b"));
            pdf.addLineBreak();
            pdf.addTextLine("1.13 obssim.opt", 16.0f, true);
            pdf.addLineBreak();
            pdf.addTextFile(obsSimInputPath.resolve("obssim.opt"));
            pdf.addLineBreak();
            pdf.addTextLine("1.14 obssim.rad", 16.0f, true);
            pdf.addLineBreak();
            pdf.addTextFile(obsSimInputPath.resolve("obssim.rad"));
            pdf.addLineBreak();
            pdf.addTextLine("1.15 obssim.plt", 16.0f, true);
            pdf.addLineBreak();
            pdf.addTextFile(obsSimInputPath.resolve("obssim.plt"));
            pdf.addPageBreak();
            pdf.addTextLine("2 Output Files", 16.0f, true);
            pdf.addLineBreak();
            int i = 0;
            if (output.getPopGenOutput() != null && output.getPopGenOutput().getSummaryCategory() != null) {
                pdf.addTextLine("2." + ++i + " " + output.getPopGenOutput().getSummaryCategory().getSummaryFile().getFileName(), 16.0f, true);
                pdf.addLineBreak();
                pdf.addTextFile(popGenOutputPath.resolve(output.getPopGenOutput().getSummaryCategory().getSummaryFile().getFileName()));
                pdf.addLineBreak();
            }
            if (output.getPopAnaOutput() != null) {
                String fileName;
                if (output.getPopAnaOutput().getSummaryCategory() != null) {
                    pdf.addTextLine("2." + ++i + " " + output.getPopAnaOutput().getSummaryCategory().getSummaryFile().getFileName(), 16.0f, true);
                    pdf.addLineBreak();
                    pdf.addTextFile(popGenOutputPath.resolve(output.getPopAnaOutput().getSummaryCategory().getSummaryFile().getFileName()));
                    pdf.addLineBreak();
                }
                for (PopAnaOutputPlotCategory cat : output.getPopAnaOutput().get2dPlotCategories()) {
                    if (i != 0) {
                        pdf.addPageBreak();
                    }
                    fileName = cat.getPlotSet().getDifferentialPlot().getPictureFile().getFileName();
                    pdf.addTextLine("2." + ++i + " " + fileName, 16.0f, true);
                    pdf.addLineBreak();
                    pdf.addRasterImage(popGenOutputPath.resolve(fileName));
                    pdf.addLineBreak();
                    pdf.addPageBreak();
                    fileName = cat.getPlotSet().getCumulativePlot().getPictureFile().getFileName();
                    pdf.addTextLine("2." + ++i + " " + fileName, 16.0f, true);
                    pdf.addLineBreak();
                    pdf.addRasterImage(popGenOutputPath.resolve(fileName));
                    pdf.addLineBreak();
                    pdf.addPageBreak();
                    fileName = cat.getPlotSet().getReverseCumulativePlot().getPictureFile().getFileName();
                    pdf.addTextLine("2." + ++i + " " + fileName, 16.0f, true);
                    pdf.addLineBreak();
                    pdf.addRasterImage(popGenOutputPath.resolve(fileName));
                    pdf.addLineBreak();
                }
                for (PopAnaOutputPlotCategory cat : output.getPopAnaOutput().get3dPlotCategories()) {
                    if (i != 0) {
                        pdf.addPageBreak();
                    }
                    fileName = cat.getPlotSet().getDifferentialPlot().getPictureFile().getFileName();
                    pdf.addTextLine("2." + ++i + " " + fileName, 16.0f, true);
                    pdf.addLineBreak();
                    pdf.addRasterImage(popGenOutputPath.resolve(fileName));
                    pdf.addLineBreak();
                }
                for (PopAnaOutputPlotCategory cat : output.getPopAnaOutput().getScatterPlotCategories()) {
                    if (i != 0) {
                        pdf.addPageBreak();
                    }
                    fileName = cat.getPlotSet().getDifferentialPlot().getPictureFile().getFileName();
                    pdf.addTextLine("2." + ++i + " " + fileName, 16.0f, true);
                    pdf.addLineBreak();
                    pdf.addRasterImage(popGenOutputPath.resolve(fileName));
                    pdf.addLineBreak();
                }
            }
            if (output.getObsSimOutput() != null && output.getObsSimOutput().getSummaryCategory() != null) {
                pdf.addTextLine("2." + ++i + " " + output.getObsSimOutput().getSummaryCategory().getSummaryFile().getFileName(), 16.0f, true);
                pdf.addLineBreak();
                pdf.addTextFile(obsSimOutputPath.resolve(output.getObsSimOutput().getSummaryCategory().getSummaryFile().getFileName()));
                pdf.addLineBreak();
            }
            if (output.getObsAnaOutput() != null) {
                String fileName;
                if (output.getObsAnaOutput().getSummaryCategory() != null) {
                    pdf.addTextLine("2." + ++i + " " + output.getObsAnaOutput().getSummaryCategory().getSummaryFile().getFileName(), 16.0f, true);
                    pdf.addLineBreak();
                    pdf.addTextFile(obsSimOutputPath.resolve(output.getObsAnaOutput().getSummaryCategory().getSummaryFile().getFileName()));
                    pdf.addLineBreak();
                }
                for (PopAnaOutputPlotCategory cat : output.getObsAnaOutput().get2dPlotCategories()) {
                    for (OutputSubject subject : output.getObsAnaOutput().getSubjects()) {
                        if (i != 0) {
                            pdf.addPageBreak();
                        }
                        fileName = cat.getPlotSet(subject).getDifferentialPlot().getPictureFile().getFileName();
                        pdf.addTextLine("2." + ++i + " " + fileName, 16.0f, true);
                        pdf.addLineBreak();
                        pdf.addRasterImage(obsSimOutputPath.resolve(fileName));
                        pdf.addLineBreak();
                        pdf.addPageBreak();
                        fileName = cat.getPlotSet(subject).getCumulativePlot().getPictureFile().getFileName();
                        pdf.addTextLine("2." + ++i + " " + fileName, 16.0f, true);
                        pdf.addLineBreak();
                        pdf.addRasterImage(obsSimOutputPath.resolve(fileName));
                        pdf.addLineBreak();
                        pdf.addPageBreak();
                        fileName = cat.getPlotSet(subject).getReverseCumulativePlot().getPictureFile().getFileName();
                        pdf.addTextLine("2." + ++i + " " + fileName, 16.0f, true);
                        pdf.addLineBreak();
                        pdf.addRasterImage(obsSimOutputPath.resolve(fileName));
                        pdf.addLineBreak();
                    }
                }
                for (PopAnaOutputPlotCategory cat : output.getObsAnaOutput().get3dPlotCategories()) {
                    for (OutputSubject subject : output.getObsAnaOutput().getSubjects()) {
                        if (cat.getPlotSet(subject) == null) continue;
                        if (i != 0) {
                            pdf.addPageBreak();
                        }
                        fileName = cat.getPlotSet(subject).getDifferentialPlot().getPictureFile().getFileName();
                        pdf.addTextLine("2." + ++i + " " + fileName, 16.0f, true);
                        pdf.addLineBreak();
                        pdf.addRasterImage(obsSimOutputPath.resolve(fileName));
                        pdf.addLineBreak();
                    }
                }
                for (PopAnaOutputPlotCategory cat : output.getObsAnaOutput().getScatterPlotCategories()) {
                    for (OutputSubject subject : output.getObsAnaOutput().getSubjects()) {
                        if (i != 0) {
                            pdf.addPageBreak();
                        }
                        fileName = cat.getPlotSet(subject).getDifferentialPlot().getPictureFile().getFileName();
                        pdf.addTextLine("2." + ++i + " " + fileName, 16.0f, true);
                        pdf.addLineBreak();
                        pdf.addRasterImage(obsSimOutputPath.resolve(fileName));
                        pdf.addLineBreak();
                    }
                }
            }
            pdf.saveResult();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (COSVisitorException e) {
            e.printStackTrace();
        }
    }

    private static enum SaveOperation {
        NORMAL_SAVE,
        SAVE_AS;

    }
}

