/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.Activator;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.PreferenceEntry;
import de.tu_bs.ilr.esa.estec.neopop.model.Model;
import java.nio.file.FileSystems;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.osgi.service.event.Event;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostConstruct
    public void postConstruct() {
        this.logger.trace("postConstruct");
    }

    @Inject
    @Optional
    void loadPreferences(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/preferences/load") Event event, Model model) {
        this.logger.info("LoadPreferences : {}", (Object)Platform.getOS());
        String defaultCLTExeFilePath = Platform.getOS().toLowerCase().equals("win32") ? "..\\default\\neopop.exe" : "../default/neopop";
        model.setNeopopExeFilePath(this.get(PreferenceEntry.NEOPOP_EXE_FILE_PATH, defaultCLTExeFilePath));
        String defaultGnuplotExeFilePath = Platform.getOS().toLowerCase().equals("win32") ? "..\\gnuplot\\bin\\gnuplot.exe" : "/usr/bin/gnuplot";
        model.setGnuplotExeFilePath(this.get(PreferenceEntry.GNUPLOT_EXE_FILE_PATH, defaultGnuplotExeFilePath));
        model.setPdfViewerExeFilePath(this.get(PreferenceEntry.PDF_VIEWER_EXE_FILE_PATH, "pdfViewerExeFilePath"));
        model.getWorkspace().setPath(this.get(PreferenceEntry.WORKSPACE_PATH));
        if (this.exists(PreferenceEntry.PROJECT_PATH)) {
            model.getWorkspace().getProject().setPath(FileSystems.getDefault().getPath(this.get(PreferenceEntry.PROJECT_PATH), new String[0]));
        }
        model.getWorkspace().getProject().setUseGeneratedPopulationAsObservationSimulatorInput(Boolean.valueOf(this.get(PreferenceEntry.USE_GENERATED_POPULATION_AS_OBSERVATION_SIMULATOR_INPUT, "false")));
        model.setTextEditorExeFilePath(this.get(PreferenceEntry.TEXT_EDITOR_FILE_PATH, "textEditorExeFilePath"));
    }

    @Inject
    @Optional
    void savePreferences(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/preferences/save") Event event, Model model) {
        this.logger.info("savePreferences");
        this.set(PreferenceEntry.NEOPOP_EXE_FILE_PATH, model.getNeopopExeFilePath());
        this.set(PreferenceEntry.GNUPLOT_EXE_FILE_PATH, model.getGnuplotExeFilePath());
        this.set(PreferenceEntry.PDF_VIEWER_EXE_FILE_PATH, model.getPdfViewerExeFilePath());
        this.set(PreferenceEntry.WORKSPACE_PATH, model.getWorkspace().getPath());
        this.set(PreferenceEntry.PROJECT_PATH, model.getWorkspace().getProject().getPath() == null ? null : model.getWorkspace().getProject().getPath().toString());
        this.set(PreferenceEntry.USE_GENERATED_POPULATION_AS_OBSERVATION_SIMULATOR_INPUT, String.valueOf(model.getWorkspace().getProject().getUseGeneratedPopulationAsObservationSimulatorInput()));
        this.set(PreferenceEntry.TEXT_EDITOR_FILE_PATH, model.getTextEditorExeFilePath());
    }

    private boolean exists(PreferenceEntry entry) {
        this.logger.trace("exists(entry={})", (Object)entry);
        IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(Activator.getSymbolicBundleName());
        boolean result = prefs.get(entry.getKey(), null) != null;
        this.logger.trace("result={}", (Object)result);
        return result;
    }

    private String get(PreferenceEntry entry, String def) {
        this.logger.trace("get(entry={}, def={})", (Object)entry, (Object)def);
        IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(Activator.getSymbolicBundleName());
        String result = prefs.get(entry.getKey(), def);
        this.logger.trace("Result={}", (Object)result);
        return result;
    }

    private String get(PreferenceEntry entry) {
        return this.get(entry, null);
    }

    private void set(PreferenceEntry entry, String value) {
        this.logger.trace("set(entry={}, value={})", (Object)entry, (Object)value);
        IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(Activator.getSymbolicBundleName());
        if (value == null) {
            prefs.remove(entry.getKey());
        } else {
            prefs.put(entry.getKey(), value);
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            this.logger.error("Could not set preference entry {} to {}", new Object[]{entry, value, e});
        }
    }
}

