/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers.PartController;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.IPlotOutputObjectPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.ITextOutputObjectPart;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.PartType;
import de.tu_bs.ilr.esa.estec.neopop.model.Input;
import de.tu_bs.ilr.esa.estec.neopop.model.MainComponentOutput;
import de.tu_bs.ilr.esa.estec.neopop.model.MainComponentOutputWithPlotCategories;
import de.tu_bs.ilr.esa.estec.neopop.model.MainComponentType;
import de.tu_bs.ilr.esa.estec.neopop.model.Model;
import de.tu_bs.ilr.esa.estec.neopop.model.NEOPOPFile;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsAnaOutput;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsAnaOutputPlotCategory;
import de.tu_bs.ilr.esa.estec.neopop.model.Output;
import de.tu_bs.ilr.esa.estec.neopop.model.OutputCategory;
import de.tu_bs.ilr.esa.estec.neopop.model.OutputPlot;
import de.tu_bs.ilr.esa.estec.neopop.model.OutputPlotCategory;
import de.tu_bs.ilr.esa.estec.neopop.model.OutputPlotSet;
import de.tu_bs.ilr.esa.estec.neopop.model.OutputPlotVariant;
import de.tu_bs.ilr.esa.estec.neopop.model.OutputSubject;
import de.tu_bs.ilr.esa.estec.neopop.model.OutputSummaryCategory;
import de.tu_bs.ilr.esa.estec.neopop.model.PlotType;
import de.tu_bs.ilr.esa.estec.neopop.model.PopAnaOutput;
import de.tu_bs.ilr.esa.estec.neopop.model.PopAnaOutputPlotCategory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputController {
    public static int QUOTE = 39;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EModelService modelService;
    @Inject
    private UISynchronize uiSynch;
    private MainComponentOutput selectedComponentOutput = null;
    private OutputSubject selectedSubject = null;
    private OutputCategory selectedCategory = null;
    private OutputPlotSet selectedPlotSet = null;
    private OutputPlot selectedPlot = null;
    private Reader currentFileReader = null;

    @PostConstruct
    void postConstruct(Output output) {
        this.logger.trace("postConstruct");
    }

    @Inject
    @Optional
    void refreshOutputIfRequired(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/output/refreshIfRequired") Event event, Model model, EPartService partService, MApplication app) {
        this.logger.trace("refreshOutputIfRequired");
        Input input = model.getWorkspace().getProject().getInput();
        Output output = model.getWorkspace().getProject().getOutput();
        if (input.getPopGenInpCfgModule().getRunId().equals(output.getRunId())) {
            this.logger.debug("Run id didn't change - doing nothing");
        } else {
            this.logger.debug("Refreshing output");
            output.setCurrentComponentOutput(null);
            this.selectedComponentOutput = null;
            this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/output/showMainComponent", null);
            this.getAndRemoveOutputObjectParts(partService, app);
            String runId = input.getPopGenInpCfgModule().getRunId();
            this.readOutput(null, runId, model, partService, app);
        }
    }

    @Inject
    @Optional
    void readOutput(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenter/project/readOutput") Event event, @Optional String runId, Model model, EPartService partService, MApplication app) {
        this.logger.trace("readOutput(runId={})", (Object)runId);
        if (runId == null) {
            runId = model.getWorkspace().getProject().getInput().getObsSimRawCfgModule().getRunId();
        }
        this.logger.info("Reading output for run id {}", (Object)runId);
        Output output = model.getWorkspace().getProject().getOutput();
        model.getWorkspace().getProject().getInput();
        output.setRunId(runId);
        output.setPopGenOutput(null);
        output.setPopAnaOutput(null);
        output.setObsSimOutput(null);
        output.setObsAnaOutput(null);
        this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/output/showMainComponent", null);
        this.getAndRemoveOutputObjectParts(partService, app);
        try {
            this.readPopGenOutput(model);
            this.readPopAnaOutput(model);
            this.readObsSimOutput(model);
            this.readObsAnaOutput(model);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private MainComponentOutput getComponentOutputSelection(Input input, Output output) {
        if (input.getNeopopModule().getObservationAnalysisEnabled().booleanValue() && output.getObsAnaOutput() != null) {
            return output.getObsAnaOutput();
        }
        if (input.getNeopopModule().getObservationSimulationEnabled().booleanValue() && output.getObsSimOutput() != null) {
            return output.getObsSimOutput();
        }
        if (input.getNeopopModule().getPopulationAnalysisEnabled().booleanValue() && output.getPopAnaOutput() != null) {
            return output.getPopAnaOutput();
        }
        if (input.getNeopopModule().getPopulationGenerationEnabled().booleanValue() && output.getPopGenOutput() != null) {
            return output.getPopGenOutput();
        }
        if (output.getObsAnaOutput() != null) {
            return output.getObsAnaOutput();
        }
        if (output.getObsSimOutput() != null) {
            return output.getObsSimOutput();
        }
        if (output.getPopAnaOutput() != null) {
            return output.getPopAnaOutput();
        }
        if (output.getPopGenOutput() != null) {
            return output.getPopGenOutput();
        }
        return null;
    }

    private void readPopGenOutput(Model model) {
        this.logger.trace("readPopGenOutput(..)");
        Output output = model.getWorkspace().getProject().getOutput();
        Path outputDirPath = this.createOutputDirPath(model, true);
        String SUMMARY_FILE_NAME = String.valueOf(output.getRunId()) + ".sum";
        Path summaryFilePath = outputDirPath.resolve(SUMMARY_FILE_NAME);
        if (summaryFilePath.toFile().exists()) {
            output.setPopGenOutput(new MainComponentOutput(new OutputSummaryCategory(new NEOPOPFile(SUMMARY_FILE_NAME))));
        }
    }

    private void readPopAnaOutput(Model model) throws IOException {
        this.logger.trace("readPopAnaOutput(..)");
        Output output = model.getWorkspace().getProject().getOutput();
        Path outputDirPath = this.createOutputDirPath(model, true);
        String mainGnuplotFileName = String.valueOf(output.getRunId()) + "_ANA.gnu";
        PlotsGnuFile plotsGnuFile = this.readPlotsGnuFile(outputDirPath.resolve(mainGnuplotFileName).toFile());
        if (plotsGnuFile == null) {
            return;
        }
        this.readPlotGnuFiles(plotsGnuFile._2dPlotEntries, outputDirPath);
        this.readPlotGnuFiles(plotsGnuFile._3dPlotEntries, outputDirPath);
        this.readPlotGnuFiles(plotsGnuFile.scatterPlotEntries, outputDirPath);
        PopAnaOutput popAnaOutput = output.getPopAnaOutput();
        if (popAnaOutput == null) {
            popAnaOutput = new PopAnaOutput();
            output.setPopAnaOutput(popAnaOutput);
            popAnaOutput.setSummaryCategory(new OutputSummaryCategory(new NEOPOPFile("../../neopop.log")));
        }
        popAnaOutput.setMainGnuplotFileName(mainGnuplotFileName);
        this.createAndAddCategories(plotsGnuFile, (MainComponentOutputWithPlotCategories)popAnaOutput, (Class)PopAnaOutputPlotCategory.class);
        this.createAndAddPlotSets(plotsGnuFile, null);
        this.createAndAddPlots(plotsGnuFile);
    }

    private void readMainPopAnaGnuFile(File file, PopAnaOutput output, Path outputDirPath) throws IOException {
        this.logger.trace("readMainPopAnaGnuFile(file={}, output={}, outputDirPath={})", new Object[]{file, output, outputDirPath});
        StreamTokenizer streamTokenizer = this.createStreamTokenizer(file);
        streamTokenizer.ordinaryChars(48, 57);
        streamTokenizer.wordChars(48, 57);
        this.currentFileReader.close();
    }

    private void readObsSimOutput(Model model) {
        this.logger.trace("readObsSimOutput(..)");
        Output output = model.getWorkspace().getProject().getOutput();
        Path outputDirPath = this.createOutputDirPath(model, false);
        String SUMMARY_FILE_NAME = String.valueOf(output.getRunId()) + "_OBSSIM.sum";
        Path summaryFilePath = outputDirPath.resolve(SUMMARY_FILE_NAME);
        if (summaryFilePath.toFile().exists()) {
            output.setObsSimOutput(new MainComponentOutput(new OutputSummaryCategory(new NEOPOPFile(SUMMARY_FILE_NAME))));
        }
    }

    private void readObsAnaOutput(Model model) throws IOException {
        String mainGnuplotFileName;
        SubjectsGnuFile subjectsGnuFile;
        this.logger.trace("readObsAnaOutput(..)");
        Output output = model.getWorkspace().getProject().getOutput();
        Path outputDirPath = this.createOutputDirPath(model, false);
        String SUMMARY_FILE_NAME = String.valueOf(output.getRunId()) + "_OBSSIM.gnu";
        Path summaryFilePath = outputDirPath.resolve(SUMMARY_FILE_NAME);
        if (summaryFilePath.toFile().exists()) {
            output.setObsAnaOutput(new ObsAnaOutput());
            output.getObsAnaOutput().setSummaryCategory(new OutputSummaryCategory(new NEOPOPFile("../../neopop.log")));
        }
        if ((subjectsGnuFile = this.readSubjectsGnuFile(outputDirPath.resolve(mainGnuplotFileName = String.valueOf(output.getRunId()) + "_OBSSIM.gnu").toFile())) == null) {
            return;
        }
        for (SubjectsGnuFileEntry subjectsGnuFileEntry : subjectsGnuFile.entries) {
            subjectsGnuFileEntry.plotsGnuFile = this.readPlotsGnuFile(outputDirPath.resolve(subjectsGnuFileEntry.plotsGnuFileName).toFile());
            this.readPlotGnuFiles(subjectsGnuFileEntry.plotsGnuFile._2dPlotEntries, outputDirPath);
            this.readPlotGnuFiles(subjectsGnuFileEntry.plotsGnuFile._3dPlotEntries, outputDirPath);
            this.readPlotGnuFiles(subjectsGnuFileEntry.plotsGnuFile.scatterPlotEntries, outputDirPath);
        }
        ObsAnaOutput obsAnaOutput = output.getObsAnaOutput() == null ? new ObsAnaOutput() : output.getObsAnaOutput();
        obsAnaOutput.setMainGnuplotFileName(mainGnuplotFileName);
        output.setObsAnaOutput(obsAnaOutput);
        this.createAndAddSubjects(subjectsGnuFile, obsAnaOutput);
        this.createAndAddCategories(subjectsGnuFile, obsAnaOutput);
        this.createAndAddPlotSets(subjectsGnuFile);
        this.createAndAddPlots(subjectsGnuFile);
    }

    private void createAndAddPlots(SubjectsGnuFile subjectsGnuFile) {
        for (SubjectsGnuFileEntry entry : subjectsGnuFile.entries) {
            this.createAndAddPlots(entry.plotsGnuFile);
        }
    }

    private <T extends OutputPlotCategory> void createAndAddPlots(PlotsGnuFile<T> plotsGnuFile) {
        this.createAndAddPlots(plotsGnuFile._2dPlotEntries, true);
        this.createAndAddPlots(plotsGnuFile._3dPlotEntries, false);
        this.createAndAddPlots(plotsGnuFile.scatterPlotEntries, false);
    }

    private <T extends OutputPlotCategory> void createAndAddPlots(List<PlotsGnuFileEntry<T>> plotsGnuFileEntries, boolean _2d) {
        int entryCount = plotsGnuFileEntries.size();
        int _2dPlotCategoriesCount = entryCount / 3;
        int index = 0;
        for (PlotsGnuFileEntry<T> entry : plotsGnuFileEntries) {
            OutputPlot plot;
            entry.plot = plot = new OutputPlot();
            plot.setGnuplotFile(new NEOPOPFile(entry.plotGnuFileName));
            plot.setPictureFile(new NEOPOPFile(entry.plotGnuFile.picFileName));
            ArrayList<String> fileNames = new ArrayList<String>();
            for (String dataFileName : entry.plotGnuFile.dataFileNames) {
                if (fileNames.contains(dataFileName)) continue;
                plot.addDataFile(new NEOPOPFile(dataFileName));
                fileNames.add(dataFileName);
            }
            if (!_2d) {
                entry.plotSet.setDifferentialPlot(plot);
            } else if (_2d && index < _2dPlotCategoriesCount) {
                entry.plotSet.setDifferentialPlot(plot);
            } else if (_2d && index < 2 * _2dPlotCategoriesCount) {
                entry.plotSet.setCumulativePlot(plot);
            } else {
                entry.plotSet.setReverseCumulativePlot(plot);
            }
            ++index;
        }
    }

    private void createAndAddPlotSets(SubjectsGnuFile subjectsGnuFile) {
        for (SubjectsGnuFileEntry entry : subjectsGnuFile.entries) {
            this.createAndAddPlotSets(entry.plotsGnuFile, entry.subject);
        }
    }

    private <T extends OutputPlotCategory> void createAndAddPlotSets(PlotsGnuFile<T> plotsGnuFile, OutputSubject subject) {
        this.createAndAddPlotSets(plotsGnuFile._2dPlotEntries, subject, true);
        this.createAndAddPlotSets(plotsGnuFile._3dPlotEntries, subject, false);
        this.createAndAddPlotSets(plotsGnuFile.scatterPlotEntries, subject, false);
    }

    private <T extends OutputPlotCategory> void createAndAddPlotSets(List<PlotsGnuFileEntry<T>> plotsGnuFileEntries, OutputSubject subject, boolean _2d) {
        int entryCount = plotsGnuFileEntries.size();
        int _2dPlotCategoriesCount = entryCount / 3;
        int index = 0;
        for (PlotsGnuFileEntry<T> entry : plotsGnuFileEntries) {
            OutputPlotSet plotSet = null;
            plotSet = _2d && index >= _2dPlotCategoriesCount ? plotsGnuFileEntries.get((int)(index % _2dPlotCategoriesCount)).plotSet : new OutputPlotSet();
            entry.plotSet = plotSet;
            if (entry.category instanceof PopAnaOutputPlotCategory) {
                ((PopAnaOutputPlotCategory)entry.category).setPlotSet(plotSet);
            } else {
                ((ObsAnaOutputPlotCategory)entry.category).addPlotSet(subject, plotSet);
            }
            ++index;
        }
    }

    private void createAndAddCategories(SubjectsGnuFile subjectsGnuFile, ObsAnaOutput obsAnaOutput) {
        for (SubjectsGnuFileEntry entry : subjectsGnuFile.entries) {
            this.createAndAddCategories(entry.plotsGnuFile, (MainComponentOutputWithPlotCategories)obsAnaOutput, (Class)ObsAnaOutputPlotCategory.class);
        }
    }

    private <T extends OutputPlotCategory> void createAndAddCategories(PlotsGnuFile<T> plotsGnuFile, MainComponentOutputWithPlotCategories<T> anaOutput, Class<T> categoryClass) {
        this.createAndAddCategories(plotsGnuFile._2dPlotEntries, anaOutput.get2dPlotCategories(), categoryClass);
        this.createAndAddCategories(plotsGnuFile._3dPlotEntries, anaOutput.get3dPlotCategories(), categoryClass);
        this.createAndAddCategories(plotsGnuFile.scatterPlotEntries, anaOutput.getScatterPlotCategories(), categoryClass);
    }

    public <T extends OutputPlotCategory> void createAndAddCategories(List<PlotsGnuFileEntry<T>> plotsGnuFileEntries, List<T> categoryList, Class<T> categoryClass) {
        HashMap<String, Object> existingCategories = new HashMap<String, Object>();
        for (OutputPlotCategory outputPlotCategory : categoryList) {
            existingCategories.put(outputPlotCategory.getName(), outputPlotCategory);
        }
        for (PlotsGnuFileEntry plotsGnuFileEntry : plotsGnuFileEntries) {
            if (existingCategories.containsKey(plotsGnuFileEntry.categoryName)) {
                plotsGnuFileEntry.category = (OutputPlotCategory)existingCategories.get(plotsGnuFileEntry.categoryName);
                continue;
            }
            try {
                plotsGnuFileEntry.category = (OutputPlotCategory)categoryClass.newInstance();
                plotsGnuFileEntry.category.setName(plotsGnuFileEntry.categoryName);
                categoryList.add(plotsGnuFileEntry.category);
                existingCategories.put(plotsGnuFileEntry.categoryName, plotsGnuFileEntry.category);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    private void createAndAddSubjects(SubjectsGnuFile subjectsGnuFile, ObsAnaOutput obsAnaOutput) {
        this.logger.trace("createAndAddSubjects");
        for (SubjectsGnuFileEntry entry : subjectsGnuFile.entries) {
            entry.subject = new OutputSubject();
            entry.subject.setName(entry.subjectName);
            obsAnaOutput.addSubject(entry.subject);
        }
    }

    private <T extends OutputPlotCategory> void readPlotGnuFiles(List<PlotsGnuFileEntry<T>> plotsGnuFileEntries, Path outputDirPath) throws IOException {
        for (PlotsGnuFileEntry<T> entry : plotsGnuFileEntries) {
            entry.plotGnuFile = this.readPlotGnuFile(outputDirPath.resolve(entry.plotGnuFileName).toFile());
        }
    }

    private PlotGnuFile readPlotGnuFile(File file) throws IOException {
        int token;
        this.logger.trace("readPlotGnuFile(file={})", (Object)file);
        PlotGnuFile result = new PlotGnuFile();
        StreamTokenizer streamTokenizer = this.createStreamTokenizer(file);
        State state = State.DEFAULT;
        block7: do {
            token = streamTokenizer.nextToken();
            switch (state) {
                case DEFAULT: {
                    if (token != -3) break;
                    if (streamTokenizer.sval.equals("set")) {
                        state = State.SET_STATEMENT;
                        break;
                    }
                    if (!streamTokenizer.sval.equals("plot") && !streamTokenizer.sval.equals("splot")) continue block7;
                    state = State.PLOT_STATEMENT;
                    break;
                }
                case SET_STATEMENT: {
                    if (token == -3 && streamTokenizer.sval.equals("output")) {
                        state = State.SET_OUTPUT_STATEMENT;
                        break;
                    }
                    state = State.DEFAULT;
                    break;
                }
                case SET_OUTPUT_STATEMENT: {
                    result.picFileName = streamTokenizer.sval;
                    state = State.DEFAULT;
                    break;
                }
                case PLOT_STATEMENT: {
                    if (token != 34 || !streamTokenizer.sval.endsWith(".spc") && !streamTokenizer.sval.endsWith(".res")) continue block7;
                    result.dataFileNames.add(streamTokenizer.sval);
                    state = State.PLOT_STATEMENT_AFTER_DATA_FILE_NAME;
                    break;
                }
                case PLOT_STATEMENT_AFTER_DATA_FILE_NAME: {
                    if (token != 44) break;
                    state = State.PLOT_STATEMENT;
                }
            }
        } while (token != -1);
        this.currentFileReader.close();
        this.logger.trace("result={}", (Object)result);
        return result;
    }

    private <T extends OutputPlotCategory> PlotsGnuFile<T> readPlotsGnuFile(File file) throws IOException {
        int token;
        this.logger.trace("readPlotsGnuFile(file={})", (Object)file);
        if (!file.exists()) {
            return null;
        }
        PlotsGnuFile result = new PlotsGnuFile();
        StreamTokenizer streamTokenizer = this.createStreamTokenizer(file);
        streamTokenizer.ordinaryChars(48, 57);
        streamTokenizer.wordChars(48, 57);
        List currentCategoryEntries = null;
        do {
            if ((token = streamTokenizer.nextToken()) != -3) continue;
            if (streamTokenizer.sval.toLowerCase().equals("2d")) {
                currentCategoryEntries = result._2dPlotEntries;
                continue;
            }
            if (streamTokenizer.sval.toLowerCase().equals("3d")) {
                currentCategoryEntries = result._3dPlotEntries;
                continue;
            }
            if (streamTokenizer.sval.toLowerCase().equals("scatter")) {
                currentCategoryEntries = result.scatterPlotEntries;
                continue;
            }
            if (!streamTokenizer.sval.toLowerCase().equals("load")) continue;
            PlotsGnuFileEntry entry = new PlotsGnuFileEntry();
            currentCategoryEntries.add(entry);
            streamTokenizer.nextToken();
            entry.plotGnuFileName = streamTokenizer.sval;
            streamTokenizer.nextToken();
            entry.categoryName = streamTokenizer.sval;
        } while (token != -1);
        this.currentFileReader.close();
        this.logger.trace("result={}", result);
        return result;
    }

    private SubjectsGnuFile readSubjectsGnuFile(File file) throws IOException {
        int token;
        this.logger.trace("readSubjectsGnuFile(file={})", (Object)file);
        if (!file.exists()) {
            return null;
        }
        SubjectsGnuFile result = new SubjectsGnuFile();
        StreamTokenizer streamTokenizer = this.createStreamTokenizer(file);
        do {
            if ((token = streamTokenizer.nextToken()) != -3 || !streamTokenizer.sval.equals("load")) continue;
            SubjectsGnuFileEntry entry = new SubjectsGnuFileEntry();
            result.entries.add(entry);
            streamTokenizer.nextToken();
            entry.plotsGnuFileName = streamTokenizer.sval;
            streamTokenizer.nextToken();
            entry.subjectName = streamTokenizer.sval;
        } while (token != -1);
        this.currentFileReader.close();
        this.logger.trace("result={}", (Object)result);
        return result;
    }

    private void readMainObsAnaGnuFile(File file, ObsAnaOutput output, Path outputDirPath) throws IOException {
        int token;
        this.logger.trace("readMainObsAnaGnuFile(file={}, output={}, outputDirPath={})", new Object[]{file, output, outputDirPath});
        StreamTokenizer streamTokenizer = this.createStreamTokenizer(file);
        do {
            if ((token = streamTokenizer.nextToken()) != -3 || !streamTokenizer.sval.equals("load")) continue;
            OutputSubject subject = new OutputSubject();
            output.addSubject(subject);
            streamTokenizer.nextToken();
            String subjectGnuFileName = streamTokenizer.sval;
            streamTokenizer.nextToken();
            subject.setName(streamTokenizer.sval);
            this.readObsAnaSubjectGnuFile(outputDirPath.resolve(subjectGnuFileName).toFile(), output, outputDirPath, subject);
        } while (token != -1);
        this.currentFileReader.close();
    }

    private StreamTokenizer createStreamTokenizer(File file) throws FileNotFoundException {
        FileInputStream ifs = new FileInputStream(file);
        BufferedReader r = new BufferedReader(new InputStreamReader(ifs));
        this.currentFileReader = r;
        StreamTokenizer streamTokenizer = new StreamTokenizer(r);
        streamTokenizer.quoteChar(39);
        streamTokenizer.whitespaceChars(35, 35);
        return streamTokenizer;
    }

    private void readObsAnaSubjectGnuFile(File file, ObsAnaOutput output, Path outputDirPath, OutputSubject subject) throws IOException {
        int token;
        this.logger.trace("readObsAnaSubjectGnuFile(file={}, output={}, outputDirPath={}, subject={})", new Object[]{file, output, outputDirPath, subject});
        StreamTokenizer streamTokenizer = this.createStreamTokenizer(file);
        streamTokenizer.ordinaryChars(48, 57);
        streamTokenizer.wordChars(48, 57);
        PlotType currentPlotType = null;
        OutputPlotVariant currentPlotVariant = null;
        ArrayList<String> encounteredCategoryLabels = new ArrayList<String>();
        HashMap<String, ObsAnaOutputPlotCategory> existing2dPlotCategories = new HashMap<String, ObsAnaOutputPlotCategory>();
        HashMap<String, ObsAnaOutputPlotCategory> existing3dPlotCategories = new HashMap<String, ObsAnaOutputPlotCategory>();
        HashMap<String, ObsAnaOutputPlotCategory> existingScatterPlotCategories = new HashMap<String, ObsAnaOutputPlotCategory>();
        for (ObsAnaOutputPlotCategory cat : output.get2dPlotCategories()) {
            existing2dPlotCategories.put(cat.getName(), cat);
        }
        for (ObsAnaOutputPlotCategory cat : output.get3dPlotCategories()) {
            existing3dPlotCategories.put(cat.getName(), cat);
        }
        for (ObsAnaOutputPlotCategory cat : output.getScatterPlotCategories()) {
            existingScatterPlotCategories.put(cat.getName(), cat);
        }
        do {
            boolean createNewCategory;
            if ((token = streamTokenizer.nextToken()) != -3) continue;
            if (streamTokenizer.sval.toLowerCase().equals("2d")) {
                currentPlotType = PlotType._2D;
                currentPlotVariant = OutputPlotVariant.DIFFERENTIAL;
                continue;
            }
            if (streamTokenizer.sval.toLowerCase().equals("3d")) {
                currentPlotType = PlotType._3D;
                currentPlotVariant = OutputPlotVariant.DIFFERENTIAL;
                continue;
            }
            if (streamTokenizer.sval.toLowerCase().equals("scatter")) {
                currentPlotType = PlotType.SCATTER;
                currentPlotVariant = OutputPlotVariant.DIFFERENTIAL;
                continue;
            }
            if (!streamTokenizer.sval.toLowerCase().equals("load")) continue;
            streamTokenizer.nextToken();
            String plotGnuFileName = streamTokenizer.sval;
            streamTokenizer.nextToken();
            String categoryLabel = streamTokenizer.sval;
            ObsAnaOutputPlotCategory cat = null;
            HashMap<String, ObsAnaOutputPlotCategory> existingCategories = currentPlotType == PlotType._2D ? existing2dPlotCategories : (currentPlotType == PlotType._3D ? existing3dPlotCategories : existingScatterPlotCategories);
            boolean bl = createNewCategory = !existingCategories.containsKey(categoryLabel);
            if (createNewCategory) {
                cat = new ObsAnaOutputPlotCategory();
                cat.setName(categoryLabel);
                existingCategories.put(categoryLabel, cat);
                if (currentPlotType == PlotType._2D) {
                    output.add2DPlotCategory((OutputPlotCategory)cat);
                } else if (currentPlotType == PlotType._3D) {
                    output.add3DPlotCategory((OutputPlotCategory)cat);
                } else {
                    output.addScatterPlotCategory((OutputPlotCategory)cat);
                }
            } else {
                cat = (ObsAnaOutputPlotCategory)existingCategories.get(categoryLabel);
            }
            if (encounteredCategoryLabels.contains(categoryLabel)) {
                currentPlotVariant = currentPlotVariant == OutputPlotVariant.DIFFERENTIAL ? OutputPlotVariant.CUMULATIVE : OutputPlotVariant.REVERSE_CUMULATIVE;
                encounteredCategoryLabels.clear();
            }
            encounteredCategoryLabels.add(categoryLabel);
            OutputPlotSet plotSet = null;
            if (currentPlotVariant == OutputPlotVariant.DIFFERENTIAL) {
                plotSet = new OutputPlotSet();
                cat.addPlotSet(subject, plotSet);
            } else {
                plotSet = cat.getPlotSet(subject);
            }
            OutputPlot plot = new OutputPlot();
            if (currentPlotVariant == OutputPlotVariant.DIFFERENTIAL) {
                plotSet.setDifferentialPlot(plot);
            } else if (currentPlotVariant == OutputPlotVariant.CUMULATIVE) {
                plotSet.setCumulativePlot(plot);
            } else {
                plotSet.setReverseCumulativePlot(plot);
            }
            plot.setGnuplotFile(new NEOPOPFile(plotGnuFileName));
            this.readObsAnaPlotGnuFile(outputDirPath.resolve(plotGnuFileName).toFile(), output, outputDirPath, plot, currentPlotType == PlotType._3D);
        } while (token != -1);
        this.currentFileReader.close();
    }

    private void readObsAnaPlotGnuFile(File file, ObsAnaOutput output, Path outputDirPath, OutputPlot plot, boolean _3dPlot) throws IOException {
        int token;
        this.logger.trace("readObsAnaPlotGnuFile(file={}, output={}, outputDirPath={}, plot={})", new Object[]{file, output, outputDirPath, plot});
        StreamTokenizer streamTokenizer = this.createStreamTokenizer(file);
        streamTokenizer.whitespaceChars(92, 92);
        State state = State.DEFAULT;
        ArrayList<String> dataFileNames = new ArrayList<String>();
        block7: do {
            token = streamTokenizer.nextToken();
            switch (state) {
                case DEFAULT: {
                    if (token != -3) break;
                    if (streamTokenizer.sval.equals("set")) {
                        state = State.SET_STATEMENT;
                        break;
                    }
                    if ((!streamTokenizer.sval.equals("plot") || _3dPlot) && (!streamTokenizer.sval.equals("splot") || !_3dPlot)) continue block7;
                    state = State.PLOT_STATEMENT;
                    break;
                }
                case SET_STATEMENT: {
                    if (token == -3 && streamTokenizer.sval.equals("output")) {
                        state = State.SET_OUTPUT_STATEMENT;
                        break;
                    }
                    state = State.DEFAULT;
                    break;
                }
                case SET_OUTPUT_STATEMENT: {
                    if (token == 34) {
                        plot.setPictureFile(new NEOPOPFile(streamTokenizer.sval));
                    }
                    state = State.DEFAULT;
                    break;
                }
                case PLOT_STATEMENT: {
                    if (token != 34) break;
                    if (!dataFileNames.contains(streamTokenizer.sval)) {
                        dataFileNames.add(streamTokenizer.sval);
                        plot.addDataFile(new NEOPOPFile(streamTokenizer.sval));
                    }
                    state = State.PLOT_STATEMENT_AFTER_DATA_FILE_NAME;
                    break;
                }
                case PLOT_STATEMENT_AFTER_DATA_FILE_NAME: {
                    if (token != 44) break;
                    state = State.PLOT_STATEMENT;
                }
            }
        } while (token != -1);
        this.currentFileReader.close();
    }

    @Inject
    @Optional
    void mainComponentOutputSelected(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/output/mainComponentSelected") MainComponentType outputType, Output output, EPartService partService, MApplication app, Model model) {
        this.logger.trace("mainComponentOutputSelected(outputType={})", (Object)outputType);
        this.logger.debug("Main component output selected: {}", (Object)outputType);
        MainComponentOutput componentOutput = null;
        boolean populationGenerator = true;
        switch (outputType) {
            case POP_GEN: {
                componentOutput = output.getPopGenOutput();
                populationGenerator = true;
                break;
            }
            case POP_ANA: {
                componentOutput = output.getPopAnaOutput();
                populationGenerator = true;
                break;
            }
            case OBS_SIM: {
                componentOutput = output.getObsSimOutput();
                populationGenerator = false;
                break;
            }
            case OBS_ANA: {
                componentOutput = output.getObsAnaOutput();
                populationGenerator = false;
            }
        }
        this.logger.debug("Main component output: {}", (Object)componentOutput);
        output.setCurrentComponentOutput(componentOutput);
        this.selectedComponentOutput = componentOutput;
        this.selectedCategory = null;
        this.selectedSubject = null;
        this.selectedPlotSet = null;
        this.selectedPlot = null;
        this.getAndRemoveOutputObjectParts(partService, app);
        this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/output/showMainComponent", (Object)componentOutput);
        app.getContext().set(MainComponentOutput.class, (Object)componentOutput);
        Path currentOutputDirPath = populationGenerator ? model.getWorkspace().getProject().getPath().resolve("01-POPGEN").resolve("output") : model.getWorkspace().getProject().getPath().resolve("02-OBSSIM").resolve("output");
        app.getContext().set("de.tu_bs.ilr.esa.estec.neopop.gui.currentOutputDirPath", (Object)currentOutputDirPath);
    }

    @Inject
    @Optional
    void outputCategorySelected(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/output/categorySelected") OutputCategory category, Model model, EPartService partService, EModelService modelService, MApplication app) {
        this.logger.trace("outputCategorySelected(category={})", (Object)category);
        this.getAndRemoveOutputObjectParts(partService, app);
        this.selectedCategory = category;
        this.setPlotSetAndPlotSelection(app);
        this.createOutputObjectParts(model, partService, app);
    }

    private void setPlotSetAndPlotSelection(MApplication app) {
        this.logger.trace("setPlotSetAndPlotSelection()");
        if (this.selectedCategory == null) {
            this.selectedPlotSet = null;
            this.selectedPlot = null;
            return;
        }
        if (this.selectedComponentOutput != null && this.selectedComponentOutput.getClass() == MainComponentOutput.class) {
            this.selectedPlotSet = null;
            this.selectedPlot = null;
            return;
        }
        if (this.selectedCategory instanceof OutputSummaryCategory) {
            this.selectedPlotSet = null;
            this.selectedPlot = null;
            return;
        }
        if (this.selectedSubject == null && this.selectedComponentOutput instanceof ObsAnaOutput) {
            this.selectedPlotSet = null;
            this.selectedPlot = null;
            return;
        }
        if (this.selectedComponentOutput instanceof PopAnaOutput) {
            PopAnaOutputPlotCategory cat = (PopAnaOutputPlotCategory)this.selectedCategory;
            this.selectedPlotSet = cat.getPlotSet();
        } else {
            ObsAnaOutputPlotCategory cat = (ObsAnaOutputPlotCategory)this.selectedCategory;
            this.selectedPlotSet = cat.getPlotSet(this.selectedSubject);
        }
        if (this.selectedPlotSet != null) {
            this.selectedPlot = this.selectedPlotSet.getDifferentialPlot();
            app.getContext().set(OutputPlotSet.class, (Object)this.selectedPlotSet);
            app.getContext().set(OutputPlot.class, (Object)this.selectedPlot);
        } else {
            app.getContext().remove(OutputPlotSet.class);
            app.getContext().remove(OutputPlot.class);
        }
    }

    private void createOutputObjectParts(Model model, EPartService partService, MApplication app) {
        this.logger.trace("createOutputObjectParts()");
        if (this.selectedCategory == null) {
            return;
        }
        if (this.selectedSubject == null && this.selectedComponentOutput instanceof ObsAnaOutput && !(this.selectedCategory instanceof OutputSummaryCategory)) {
            return;
        }
        Path outputDirPath = this.createOutputDirPath(model);
        if (this.selectedCategory instanceof OutputSummaryCategory) {
            this.createSummaryOutputPart(outputDirPath, partService, app);
            this.hideSecondaryOutputPartStack(app);
        } else {
            this.createPlotPart(outputDirPath, partService, app);
            this.removeSecondaryOutputObjectParts(partService, app);
            this.createGnuplotFilePart(outputDirPath, partService, app);
            this.createDataFileParts(outputDirPath, partService, app);
            this.showSecondaryOutputPartStack(app);
        }
    }

    private void removeSecondaryOutputObjectParts(EPartService partService, MApplication app) {
        this.logger.trace("removeSecondaryOutputObjectParts()");
        MPartStack secondaryOutputObjectPartStack = (MPartStack)this.modelService.findElements((MUIElement)app, "de.tu_bs.ilr.esa.estec.neopop.gui.partstacks.output.object.secondary", MPartStack.class, null).get(0);
        List parts = this.modelService.findElements((MUIElement)secondaryOutputObjectPartStack, null, MPart.class, null);
        for (MPart part : parts) {
            partService.hidePart(part);
        }
    }

    private Path createOutputDirPath(Model model, boolean popgen) {
        this.logger.trace("createOutputDirPath(.., popgen={})", (Object)popgen);
        return model.getWorkspace().getProject().getPath().resolve(popgen ? "01-POPGEN" : "02-OBSSIM").resolve("output");
    }

    private Path createOutputDirPath(Model model) {
        this.logger.trace("createOutputDirPath(..)");
        Output output = model.getWorkspace().getProject().getOutput();
        boolean popgen = this.selectedComponentOutput == output.getPopGenOutput() || this.selectedComponentOutput == output.getPopAnaOutput();
        return this.createOutputDirPath(model, popgen);
    }

    private void createDataFileParts(Path outputDirPath, EPartService partService, MApplication app) {
        this.logger.trace("createDataFileParts(outputDirPath={})", (Object)outputDirPath);
        for (NEOPOPFile dataFile : this.selectedPlot.getDataFiles()) {
            Path dataFilePath = outputDirPath.resolve(dataFile.getFileName());
            this.createSecondaryOutputObjectPart("Data File " + dataFile.getFileName(), dataFilePath.toString(), PartType.TEXT_OUTPUT_OBJECT, partService, app);
        }
    }

    private void createGnuplotFilePart(Path outputDirPath, EPartService partService, MApplication app) {
        this.logger.trace("createGnuplotFilePart(outputDirPath={})", (Object)outputDirPath);
        Path gnuplotFilePath = outputDirPath.resolve(this.selectedPlot.getGnuplotFile().getFileName());
        MPart part = this.createSecondaryOutputObjectPart("gnuplot File", gnuplotFilePath.toString(), PartType.GNUPLOT_TEXT_OUTPUT_OBJECT, partService, app);
        app.getContext().set("de.tu_bs.ilr.esa.estec.neopop.gui.gnuplotFilePart", (Object)((ITextOutputObjectPart)((PartController)part.getObject()).getPart()));
    }

    private void createPlotPart(Path outputDirPath, EPartService partService, MApplication app) {
        this.logger.trace("createPlotPart(outputDirPath={})", (Object)outputDirPath);
        HashMap<String, String> properties = new HashMap<String, String>();
        this.addPlotPicFilePathProperty(properties, outputDirPath, this.selectedPlotSet.getDifferentialPlot(), "differentialPlotFilePath");
        this.addPlotPicFilePathProperty(properties, outputDirPath, this.selectedPlotSet.getCumulativePlot(), "cumulativePlotFilePath");
        this.addPlotPicFilePathProperty(properties, outputDirPath, this.selectedPlotSet.getReverseCumulativePlot(), "reverseCumulativePlotFilePath");
        MPart part = this.createPrimaryOutputObjectPart(PartType.PLOT_OUTPUT_OBJECT.getID(), "Plot", properties, partService, app);
        app.getContext().set(IPlotOutputObjectPart.class, (Object)((IPlotOutputObjectPart)((PartController)part.getObject()).getPart()));
    }

    private void addPlotPicFilePathProperty(Map<String, String> properties, Path outputDirPath, OutputPlot plot, String propertyName) {
        this.logger.trace("addPlotPicFilePathProperty(properties={}, outputDirPath={}, plot={}, propertyName={})", new Object[]{properties, outputDirPath, plot, propertyName});
        if (plot != null) {
            Path plotPicFilePath = outputDirPath.resolve(plot.getPictureFile().getFileName());
            properties.put(propertyName, plotPicFilePath.toString());
        }
    }

    private MPart createSecondaryOutputObjectPart(String label, String filePath, PartType partType, EPartService partService, MApplication app) {
        this.logger.trace("createSecondaryOutputObjectPart(label={}, filePath={})", (Object)label, (Object)filePath);
        MPartStack secondaryOutputObjectStack = (MPartStack)this.modelService.findElements((MUIElement)app, "de.tu_bs.ilr.esa.estec.neopop.gui.partstacks.output.object.secondary", MPartStack.class, null).get(0);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("filePath", filePath);
        return this.createOutputObjectPart(secondaryOutputObjectStack, partType.getID(), label, properties, partService);
    }

    private OutputPlotSet getPlotSetToShow() {
        this.logger.trace("getPlotSetToShow()");
        OutputPlotSet result = null;
        if (this.selectedCategory instanceof PopAnaOutputPlotCategory) {
            PopAnaOutputPlotCategory popAnaOutputPlotCategory = (PopAnaOutputPlotCategory)this.selectedCategory;
            result = popAnaOutputPlotCategory.getPlotSet();
        } else {
            ObsAnaOutputPlotCategory obsAnaOutputPlotCategory = (ObsAnaOutputPlotCategory)this.selectedCategory;
            result = obsAnaOutputPlotCategory.getPlotSet(this.selectedSubject);
        }
        this.logger.trace("Result: {}", (Object)result);
        return result;
    }

    private void createSummaryOutputPart(Path outputDirPath, EPartService partService, MApplication app) {
        this.logger.trace("createSummaryOutputPart(outputDirPath={})", (Object)outputDirPath);
        OutputSummaryCategory summaryCategory = (OutputSummaryCategory)this.selectedCategory;
        Path summaryFilePath = outputDirPath.resolve(summaryCategory.getSummaryFile().getFileName());
        if (!summaryFilePath.toFile().exists()) {
            summaryFilePath = outputDirPath.resolve("dummy");
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("filePath", summaryFilePath.toString());
        this.createPrimaryOutputObjectPart(PartType.TEXT_OUTPUT_OBJECT.getID(), "Summary", properties, partService, app);
    }

    private Map<String, String> createPropertyMap(String ... mappings) {
        this.logger.trace("createPropertyMap(mappings={})", (Object)Arrays.toString(mappings));
        HashMap<String, String> result = new HashMap<String, String>();
        int index = 0;
        do {
            String key = mappings[index++];
            String val = mappings[index++];
            result.put(key, val);
        } while (index < mappings.length);
        this.logger.trace("Result: {}", result);
        return result;
    }

    private void showSecondaryOutputPartStack(MApplication app) {
        this.logger.trace("showSecondaryOutputPartStack()");
        this.logger.debug("Getting secondary output object stack");
        MPartStack secondaryOutputObjectStack = (MPartStack)this.modelService.findElements((MUIElement)app, "de.tu_bs.ilr.esa.estec.neopop.gui.partstacks.output.object.secondary", MPartStack.class, null).get(0);
        this.logger.debug("Setting its visibility");
        secondaryOutputObjectStack.setVisible(true);
    }

    private void hideSecondaryOutputPartStack(MApplication app) {
        this.logger.trace("hideSecondaryOutputPartStack()");
        MPartStack secondaryOutputObjectStack = (MPartStack)this.modelService.findElements((MUIElement)app, "de.tu_bs.ilr.esa.estec.neopop.gui.partstacks.output.object.secondary", MPartStack.class, null).get(0);
        secondaryOutputObjectStack.setVisible(false);
    }

    private MPart createPrimaryOutputObjectPart(String id, String label, Map<String, String> properties, EPartService partService, MApplication app) {
        this.logger.trace("createPrimaryOutputObjectPart(id={}, label={}, properties={})", new Object[]{id, label, properties});
        MPartStack primaryOutputObjectStack = (MPartStack)this.modelService.findElements((MUIElement)app, "de.tu_bs.ilr.esa.estec.neopop.gui.partstacks.output.object.primary", MPartStack.class, null).get(0);
        return this.createOutputObjectPart(primaryOutputObjectStack, id, label, properties, partService);
    }

    private MPart createOutputObjectPart(MPartStack stack, String id, String label, Map<String, String> properties, EPartService partService) {
        this.logger.trace("createOutputObjectPart(stack={}, id={}, label={}, properties={})", new Object[]{stack, id, label, properties});
        MPart part = partService.createPart(id);
        part.getTags().add("removeOnHide");
        part.getTags().add("NoAutoCollapse");
        part.setLabel(label);
        part.getProperties().putAll(properties);
        stack.getChildren().add(part);
        partService.showPart(part, EPartService.PartState.VISIBLE);
        return part;
    }

    private List<MPart> getOutputObjectParts(MApplication app) {
        this.logger.trace("getOutputObjectParts()");
        MPartSashContainer verticalPartSashContainer = (MPartSashContainer)this.modelService.findElements((MUIElement)app, "de.tu_bs.ilr.esa.estec.neopop.gui.partsashcontainers.output.vertical", MPartSashContainer.class, null).get(0);
        List outputObjectParts = this.modelService.findElements((MUIElement)verticalPartSashContainer, null, MPart.class, null);
        this.logger.trace("Result: {}", (Object)outputObjectParts);
        return outputObjectParts;
    }

    private void getAndRemoveOutputObjectParts(EPartService partService, MApplication app) {
        this.logger.trace("getAndRemoveOutputObjectParts()");
        IEclipseContext activeWindowContext = app.getContext().getActiveChild();
        List<MPart> outputObjectParts = this.getOutputObjectParts(app);
        if (activeWindowContext == null || activeWindowContext.get(EPartService.class) != partService) {
            this.removeOutputObjectPartsWithoutPartService(outputObjectParts, app);
        } else {
            this.removeOutputObjectPartsUsingPartService(partService, outputObjectParts, app);
        }
        this.eventBroker.send("de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/output/destroy", null);
    }

    private void removeOutputObjectPartsUsingPartService(EPartService partService, List<MPart> parts, MApplication app) {
        this.logger.trace("removeOutputObjectPartsUsingPartService(parts={})", parts);
        for (MPart part : parts) {
            partService.hidePart(part);
        }
    }

    private void removeOutputObjectPartsWithoutPartService(List<MPart> parts, MApplication app) {
        this.logger.trace("removeOutputObjectPartsWithoutPartService(parts={})", parts);
        for (MPart part : parts) {
            part.getParent().getChildren().remove(part);
            part.setVisible(false);
            part.setToBeRendered(false);
        }
    }

    private void clearSecondaryOutputObjectPartStack(MApplication app) {
        final MPartStack secondaryOutputPartStack = (MPartStack)this.modelService.findElements((MUIElement)app, "de.tu_bs.ilr.esa.estec.neopop.gui.partstacks.output.object.secondary", MPartStack.class, null).get(0);
        this.uiSynch.syncExec(new Runnable(){

            @Override
            public void run() {
                secondaryOutputPartStack.getChildren().clear();
            }
        });
    }

    @Inject
    @Optional
    void outputPlotPictureSelected(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/output/plotPictureSelected") OutputPlotVariant selectedPlotType, Model model, EPartService partService, MApplication app) {
        this.logger.trace("outputPlotPictureSelected(selectedPlotType={})", (Object)selectedPlotType);
        this.selectedPlot = selectedPlotType == OutputPlotVariant.DIFFERENTIAL ? this.selectedPlotSet.getDifferentialPlot() : (selectedPlotType == OutputPlotVariant.CUMULATIVE ? this.selectedPlotSet.getCumulativePlot() : this.selectedPlotSet.getReverseCumulativePlot());
        Path outputDirPath = this.createOutputDirPath(model);
        this.removeSecondaryOutputObjectParts(partService, app);
        app.getContext().set(OutputPlot.class, (Object)this.selectedPlot);
        this.createGnuplotFilePart(outputDirPath, partService, app);
        this.createDataFileParts(outputDirPath, partService, app);
        partService.showPart(partService.findPart(PartType.PLOT_OUTPUT_OBJECT.getID()), EPartService.PartState.ACTIVATE);
    }

    @Inject
    @Optional
    void outputSubjectSelected(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/output/subjectSelected") OutputSubject subject, Model model, EPartService partService, EModelService modelService, MApplication app) {
        this.logger.trace("outputSubjectSelected(subject={})", (Object)subject);
        this.getAndRemoveOutputObjectParts(partService, app);
        this.selectedSubject = subject;
        this.setPlotSetAndPlotSelection(app);
        this.createOutputObjectParts(model, partService, app);
    }

    class PlotGnuFile {
        public String picFileName;
        public List<String> dataFileNames = new ArrayList<String>();

        PlotGnuFile() {
        }

        public String toString() {
            return "PlotGnuFile [picFileName=" + this.picFileName + ", dataFileNames=" + this.dataFileNames + "]";
        }
    }

    class PlotsGnuFile<T extends OutputPlotCategory> {
        public List<PlotsGnuFileEntry<T>> _2dPlotEntries = new ArrayList<PlotsGnuFileEntry<T>>();
        public List<PlotsGnuFileEntry<T>> _3dPlotEntries = new ArrayList<PlotsGnuFileEntry<T>>();
        public List<PlotsGnuFileEntry<T>> scatterPlotEntries = new ArrayList<PlotsGnuFileEntry<T>>();

        PlotsGnuFile() {
        }

        public String toString() {
            return "PlotsGnuFile [_2dPlotEntries=" + this._2dPlotEntries + ", _3dPlotEntries=" + this._3dPlotEntries + ", scatterPlotEntries=" + this.scatterPlotEntries + "]";
        }
    }

    class PlotsGnuFileEntry<T extends OutputPlotCategory> {
        public String plotGnuFileName;
        public String categoryName;
        public PlotGnuFile plotGnuFile;
        public T category;
        public OutputPlotSet plotSet;
        public OutputPlot plot;

        PlotsGnuFileEntry() {
        }

        public String toString() {
            return "PlotsGnuFileEntry [plotGnuFileName=" + this.plotGnuFileName + ", categoryName=" + this.categoryName + ", plotGnuFile=" + this.plotGnuFile + ", category=" + this.category + ", plotSet=" + this.plotSet + ", plot=" + this.plot + "]";
        }
    }

    static enum ReadState {
        EXPECTING_LOAD_COMMAND,
        EXPECTING_GNU_FILE_NAME,
        EXPECTING_SUBJECT_NAME;

    }

    static enum State {
        DEFAULT,
        SET_STATEMENT,
        SET_OUTPUT_STATEMENT,
        PLOT_STATEMENT,
        PLOT_STATEMENT_AFTER_DATA_FILE_NAME;

    }

    class SubjectsGnuFile {
        public List<SubjectsGnuFileEntry> entries = new ArrayList<SubjectsGnuFileEntry>();

        SubjectsGnuFile() {
        }

        public String toString() {
            return "SubjectsGnuFile [entries=" + this.entries + "]";
        }
    }

    class SubjectsGnuFileEntry {
        public String subjectName;
        public String plotsGnuFileName;
        public PlotsGnuFile<ObsAnaOutputPlotCategory> plotsGnuFile;
        public OutputSubject subject;

        SubjectsGnuFileEntry() {
        }

        public String toString() {
            return "SubjectsGnuFileEntry [subjectName=" + this.subjectName + ", plotsGnuFileName=" + this.plotsGnuFileName + ", plotsGnuFile=" + this.plotsGnuFile + ", subject=" + this.subject + "]";
        }
    }
}

