/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter.controllers;

import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.PresenterUtil;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.DialogType;
import de.tu_bs.ilr.esa.estec.neopop.gui.view.IView;
import de.tu_bs.ilr.esa.estec.neopop.model.Model;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostConstruct
    void postConstruct() {
        this.logger.trace("postConstruct");
    }

    @Inject
    @Optional
    void importProject(@EventTopic(value="de/tu-bs/ilr/esa/estec/neopop/gui/presenterAndView/project/import") Event event, Model model, IView view, PresenterUtil presenterUtil) {
        this.logger.trace("importProject");
        Path sourceFile = (Path)event.getProperty("de/tu-bs/ilr/esa/estec/neopop/filePath");
        Path projDirPath = (Path)event.getProperty("de/tu-bs/ilr/esa/estec/neopop/folderPath");
        this.logger.info("Importing file {} as project {}", (Object)sourceFile, (Object)projDirPath);
        if (!presenterUtil.isValidProjectDirPathForProjectCreation(projDirPath)) {
            presenterUtil.reboundWithError("You selected an invalid folder", DialogType.IMPORT_PROJECT, projDirPath, view);
            return;
        }
        projDirPath.toFile().mkdirs();
        this.unzip(sourceFile, projDirPath);
    }

    private void unzip(Path sourceFile, Path targetProj) {
        ZipInputStream zis = null;
        FileOutputStream fos = null;
        try {
            try {
                FileInputStream fis = new FileInputStream(sourceFile.toString());
                zis = new ZipInputStream(fis);
                ZipEntry entry = null;
                byte[] buffer = new byte[1024];
                int bytesRead = 0;
                entry = zis.getNextEntry();
                while (entry != null) {
                    File file = targetProj.resolve(entry.getName()).toFile();
                    if (entry.isDirectory()) {
                        file.mkdirs();
                    } else {
                        fos = new FileOutputStream(file);
                        bytesRead = zis.read(buffer, 0, 1024);
                        while (bytesRead != -1) {
                            fos.write(buffer, 0, bytesRead);
                            bytesRead = zis.read(buffer, 0, 1024);
                        }
                    }
                    entry = zis.getNextEntry();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (zis != null) {
                        zis.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (zis != null) {
                    zis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

