/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.presenter;

import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.Activator;
import de.tu_bs.ilr.esa.estec.neopop.gui.presenter.PreferenceEntry;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public String get(PreferenceEntry entry) {
        this.logger.trace("get(entry={})", (Object)entry);
        IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(Activator.getSymbolicBundleName());
        String result = prefs.get(entry.getKey(), null);
        this.logger.trace("Result={}", (Object)result);
        return result;
    }

    public void set(PreferenceEntry entry, String value) {
        this.logger.trace("set(entry={}, value={})", (Object)entry, (Object)value);
        IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(Activator.getSymbolicBundleName());
        if (value == null) {
            prefs.remove(entry.getKey());
        } else {
            prefs.put(entry.getKey(), value);
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            this.logger.error("Could not set preference entry {} to {}", new Object[]{entry, value, e});
        }
    }
}

