/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.model.internal;

import de.tu_bs.ilr.esa.estec.neopop.model.CompleteVarIndexes;
import de.tu_bs.ilr.esa.estec.neopop.model.connector.IModelConnector;
import de.tu_bs.ilr.esa.estec.neopop.model.internal.VarDataType;

public class SwitchVarDataType
extends VarDataType<Boolean> {
    public SwitchVarDataType() {
        super(Boolean.class);
        this.logger.trace("SwitchVarDataType()");
    }

    @Override
    protected Boolean doGet(IModelConnector connector, String id, CompleteVarIndexes indexes) {
        this.logger.trace("doGet(connector={}, id={}, indexes={}", new Object[]{connector, id, indexes});
        int intResult = connector.get_integer(id, indexes.get(0), indexes.get(1));
        if (intResult != 0 && intResult != 1 && intResult != -999999) {
            this.logger.error("Getting variable {}{} failed: Unexpected int result: {}", new Object[]{id, indexes, intResult});
            throw new RuntimeException();
        }
        Boolean result = null;
        if (intResult == 0) {
            result = Boolean.FALSE;
        } else if (intResult == 1) {
            result = Boolean.TRUE;
        }
        return result;
    }

    @Override
    protected void doSet(IModelConnector connector, String id, CompleteVarIndexes indexes, Boolean value) {
        this.logger.trace("doSet(connector={}, id={}, indexes={}, value={})", new Object[]{connector, id, indexes, value});
        int toSet = -999999;
        if (value == Boolean.FALSE) {
            toSet = 0;
        } else if (value == Boolean.TRUE) {
            toSet = 1;
        }
        connector.set_integer(id, toSet, indexes.get(0), indexes.get(1));
    }

    @Override
    protected int doCheck(IModelConnector connector, String id, CompleteVarIndexes indexes, Boolean value) {
        this.logger.trace("doCheck(connector={}, id={}, indexes={}, value={})", new Object[]{connector, id, indexes, value});
        int toCheck = -999999;
        if (value == Boolean.FALSE) {
            toCheck = 0;
        } else if (value == Boolean.TRUE) {
            toCheck = 1;
        }
        return connector.check_integer(id, toCheck, indexes.get(0), indexes.get(1));
    }
}

