/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.model.internal;

import de.tu_bs.ilr.esa.estec.neopop.model.CompleteVarIndexes;
import de.tu_bs.ilr.esa.estec.neopop.model.connector.IModelConnector;
import de.tu_bs.ilr.esa.estec.neopop.model.internal.VarDataType;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeVarDataType
extends VarDataType<Date> {
    private Calendar utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public DateTimeVarDataType() {
        super(Date.class);
        this.utcCalendar.setLenient(false);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    protected Date doGet(IModelConnector connector, String id, CompleteVarIndexes indexes) {
        this.logger.trace("doGet(connector={}, id={}, indexes={}", new Object[]{connector, id, indexes});
        CompleteVarIndexes indexesClone = new CompleteVarIndexes(indexes);
        indexesClone.add(1);
        int year = connector.get_integer(id, indexesClone.get(0), indexesClone.get(1));
        indexesClone.newLastIndex(2);
        int month = connector.get_integer(id, indexesClone.get(0), indexesClone.get(1));
        indexesClone.newLastIndex(3);
        int day = connector.get_integer(id, indexesClone.get(0), indexesClone.get(1));
        indexesClone.newLastIndex(4);
        int hour = connector.get_integer(id, indexesClone.get(0), indexesClone.get(1));
        indexesClone.newLastIndex(5);
        int minute = connector.get_integer(id, indexesClone.get(0), indexesClone.get(1));
        indexesClone.newLastIndex(6);
        int second = connector.get_integer(id, indexesClone.get(0), indexesClone.get(1));
        this.utcCalendar.set(1, year);
        this.utcCalendar.set(2, month - 1);
        this.utcCalendar.set(5, day);
        this.utcCalendar.set(11, hour);
        this.utcCalendar.set(12, minute);
        this.utcCalendar.set(13, second);
        Date result = this.utcCalendar.getTime();
        this.logger.trace("result={}", (Object)this.dateFormat.format(result));
        return result;
    }

    @Override
    protected void doSet(IModelConnector connector, String id, CompleteVarIndexes indexes, Date value) {
        this.logger.trace("doSet(connector={}, id={}, indexes={}, value={}", new Object[]{connector, id, indexes, value});
        this.utcCalendar.setTime(value);
        int year = this.utcCalendar.get(1);
        int month = this.utcCalendar.get(2) + 1;
        int day = this.utcCalendar.get(5);
        int hour = this.utcCalendar.get(11);
        int minute = this.utcCalendar.get(12);
        int second = this.utcCalendar.get(13);
        CompleteVarIndexes indexesClone = new CompleteVarIndexes(indexes);
        indexesClone.add(1);
        connector.set_integer(id, year, indexesClone.get(0), indexesClone.get(1));
        indexesClone.newLastIndex(2);
        connector.set_integer(id, month, indexesClone.get(0), indexesClone.get(1));
        indexesClone.newLastIndex(3);
        connector.set_integer(id, day, indexesClone.get(0), indexesClone.get(1));
        indexesClone.newLastIndex(4);
        connector.set_integer(id, hour, indexesClone.get(0), indexesClone.get(1));
        indexesClone.newLastIndex(5);
        connector.set_integer(id, minute, indexesClone.get(0), indexesClone.get(1));
        indexesClone.newLastIndex(6);
        connector.set_integer(id, second, indexesClone.get(0), indexesClone.get(1));
    }

    @Override
    protected int doCheck(IModelConnector connector, String id, CompleteVarIndexes indexes, Date value) {
        this.logger.trace("doCheck(connector={}, id={}, indexes={}, value={}", new Object[]{connector, id, indexes, value});
        this.utcCalendar.setTime(value);
        int year = this.utcCalendar.get(1);
        int month = this.utcCalendar.get(2) + 1;
        int day = this.utcCalendar.get(5);
        int hour = this.utcCalendar.get(11);
        int minute = this.utcCalendar.get(12);
        int second = this.utcCalendar.get(13);
        CompleteVarIndexes indexesClone = new CompleteVarIndexes(indexes);
        indexesClone.add(1);
        int result = connector.check_integer(id, year, indexesClone.get(0), indexesClone.get(1));
        indexesClone.newLastIndex(2);
        result += connector.check_integer(id, month, indexesClone.get(0), indexesClone.get(1));
        indexesClone.newLastIndex(3);
        result += connector.check_integer(id, day, indexesClone.get(0), indexesClone.get(1));
        indexesClone.newLastIndex(4);
        result += connector.check_integer(id, hour, indexesClone.get(0), indexesClone.get(1));
        indexesClone.newLastIndex(5);
        result += connector.check_integer(id, minute, indexesClone.get(0), indexesClone.get(1));
        indexesClone.newLastIndex(6);
        if ((result += connector.check_integer(id, second, indexesClone.get(0), indexesClone.get(1))) == 6) {
            result = 1;
        } else if (result < 6) {
            result = 0;
        } else if (result > 6) {
            result = 42;
        }
        this.logger.trace("result={}", (Object)result);
        return result;
    }
}

