/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.model;

import de.tu_bs.ilr.esa.estec.neopop.model.CoordinateSystemType;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElement;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElementReference;
import de.tu_bs.ilr.esa.estec.neopop.model.Location;
import de.tu_bs.ilr.esa.estec.neopop.model.LocationType;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawGbModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawOptModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawRadModule;
import de.tu_bs.ilr.esa.estec.neopop.model.ObsSimRawSbModule;
import de.tu_bs.ilr.esa.estec.neopop.model.Sensor;
import de.tu_bs.ilr.esa.estec.neopop.model.SensorSystem;
import de.tu_bs.ilr.esa.estec.neopop.model.SensorType;
import de.tu_bs.ilr.esa.estec.neopop.model.VarUsage;
import de.tu_bs.ilr.esa.estec.neopop.model.Vars;
import java.util.List;

public class SensorManifestation
extends InputElement {
    public static final String PROP_COORDINATE_SYSTEM_TYPE = "coordinateSystemType";
    public static final String PROP_LINE_OF_SIGHT1 = "lineOfSight1";
    public static final String PROP_LINE_OF_SIGHT2 = "lineOfSight2";
    public static final String PROP_MIN_RANGE = "minRange";
    public static final String PROP_MAX_RANGE = "maxRange";
    public static final String PROP_SENSOR_NAME = "sensorName";
    public static final String PROP_LOCATION_NAME = "locationName";
    public static final String PROP_LOCATION = "location";
    public static final String PROP_TELESCOPE = "telescope";
    protected VarUsage<CoordinateSystemType> coordinateSystemType;
    protected VarUsage<Double> lineOfSight1;
    protected VarUsage<Double> lineOfSight2;
    protected VarUsage<Double> minRange;
    protected VarUsage<Double> maxRange;
    protected VarUsage<String> sensorName;
    protected VarUsage<String> locationName;
    protected InputElementReference<Location> location;
    protected InputElementReference<Sensor> telescope;
    protected ObsSimRawGbModule gbModule;
    protected ObsSimRawSbModule sbModule;
    protected ObsSimRawOptModule optModule;
    protected ObsSimRawRadModule radModule;

    public SensorManifestation(SensorSystem parent, ObsSimRawGbModule gbModule, ObsSimRawSbModule sbModule, ObsSimRawOptModule optModule, ObsSimRawRadModule radModule, int ... additionalIndexes) {
        super(parent, additionalIndexes);
        this.gbModule = gbModule;
        this.sbModule = sbModule;
        this.optModule = optModule;
        this.radModule = radModule;
        this.coordinateSystemType = new VarUsage<CoordinateSystemType>((InputElement)this, Vars.OBSSIM_CHOICE_NET_SENSOR_ORIENTATION, PROP_COORDINATE_SYSTEM_TYPE, CoordinateSystemType.LOCAL_HORIZON, new int[0]);
        this.lineOfSight1 = new VarUsage<Double>((InputElement)this, Vars.OBSSIM_DBL_NET_LINE_OF_SIGHT_1, PROP_LINE_OF_SIGHT1, 45.0, new int[0]);
        this.lineOfSight2 = new VarUsage<Double>((InputElement)this, Vars.OBSSIM_DBL_NET_LINE_OF_SIGHT_2, PROP_LINE_OF_SIGHT2, 90.0, new int[0]);
        this.minRange = new VarUsage<Double>((InputElement)this, Vars.OBSSIM_DBL_NET_MIN_RANGE, PROP_MIN_RANGE, 1);
        this.maxRange = new VarUsage<Double>((InputElement)this, Vars.OBSSIM_DBL_NET_MAX_RANGE, PROP_MAX_RANGE, 2);
        this.sensorName = new VarUsage<String>((InputElement)this, Vars.OBSSIM_STR_NET_SENSOR, PROP_SENSOR_NAME, "<sensor name>", new int[0]);
        this.locationName = new VarUsage<String>((InputElement)this, Vars.OBSSIM_STR_NET_LOCATION, PROP_LOCATION_NAME, "<location name>", new int[0]);
        this.location = new InputElementReference(this, PROP_LOCATION);
        this.telescope = new InputElementReference(this, PROP_TELESCOPE);
        List<Location> locations = parent.getLocationType() == LocationType.GROUND_BASED ? gbModule.getGroundLocations() : sbModule.getOrbits();
        String locationName = this.getLocationName();
        for (Location loc : locations) {
            if (!loc.getName().equals(locationName)) continue;
            this.setLocation(loc);
            break;
        }
        List<Sensor> sensors = parent.getSensorType() == SensorType.OPTICAL ? optModule.getOpticalTelescopes() : radModule.getRadarTelescopes();
        String sensorName = this.getSensorName();
        for (Sensor sensor : sensors) {
            if (!sensor.getName().equals(sensorName)) continue;
            this.setTelescope(sensor);
            break;
        }
    }

    public CoordinateSystemType getCoordinateSystemType() {
        return this.coordinateSystemType.get();
    }

    public void setCoordinateSystemType(CoordinateSystemType coordinateSystemType) {
        this.coordinateSystemType.set(coordinateSystemType);
    }

    public boolean checkCoordinateSystemType(CoordinateSystemType coordinateSystemType) {
        return this.coordinateSystemType.check(coordinateSystemType);
    }

    public double getLineOfSight1() {
        return this.lineOfSight1.get();
    }

    public void setLineOfSight1(double lineOfSight1) {
        this.lineOfSight1.set(lineOfSight1);
    }

    public boolean checkLineOfSight1(double lineOfSight1) {
        return this.lineOfSight1.check(lineOfSight1);
    }

    public double getLineOfSight2() {
        return this.lineOfSight2.get();
    }

    public void setLineOfSight2(double lineOfSight2) {
        this.lineOfSight2.set(lineOfSight2);
    }

    public boolean checkLineOfSight2(double lineOfSight2) {
        return this.lineOfSight2.check(lineOfSight2);
    }

    public double getMinRange() {
        return this.minRange.get();
    }

    public void setMinRange(double minRange) {
        this.minRange.set(minRange);
    }

    public boolean checkMinRange(double minRange) {
        return this.minRange.check(minRange);
    }

    public double getMaxRange() {
        return this.maxRange.get();
    }

    public void setMaxRange(double maxRange) {
        this.maxRange.set(maxRange);
    }

    public boolean checkMaxRange(double maxRange) {
        return this.maxRange.check(maxRange);
    }

    public String getSensorName() {
        return this.sensorName.get();
    }

    public void setSensorName(String sensorName) {
        this.sensorName.set(sensorName);
    }

    public boolean checkSensorName(String sensorName) {
        return this.sensorName.check(sensorName);
    }

    public String getLocationName() {
        return this.locationName.get();
    }

    public void setLocationName(String locationName) {
        this.locationName.set(locationName);
    }

    public boolean checkLocationName(String locationName) {
        return this.locationName.check(locationName);
    }

    public Location getLocation() {
        return this.location.getElement();
    }

    public void setLocation(Location location) {
        this.location.setElement(location);
    }

    public boolean checkLocation(Location location) {
        if (location == null) {
            return false;
        }
        for (Location location2 : this.gbModule.getGroundLocations()) {
            if (location2 != location) continue;
            return true;
        }
        for (Location location3 : this.sbModule.getOrbits()) {
            if (location3 != location) continue;
            return true;
        }
        return false;
    }

    public void recheckLocation() {
        this.location.recheck();
    }

    public Sensor getTelescope() {
        return this.telescope.getElement();
    }

    public void setTelescope(Sensor telescope) {
        this.telescope.setElement(telescope);
    }

    public boolean checkTelescope(Sensor telescope) {
        if (telescope == null) {
            return false;
        }
        for (Sensor sensor : this.optModule.getOpticalTelescopes()) {
            if (sensor != telescope) continue;
            return true;
        }
        for (Sensor sensor : this.radModule.getRadarTelescopes()) {
            if (sensor != telescope) continue;
            return true;
        }
        return false;
    }

    @Override
    public SensorSystem getParent() {
        return (SensorSystem)this.parent;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "[parent=" + this.parent + "]";
    }
}

