/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.model;

import de.tu_bs.ilr.esa.estec.neopop.model.BasePathType;
import de.tu_bs.ilr.esa.estec.neopop.model.ICheckDependencyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModelElement {
    private Map<String, BasePathType> basePathTypes = new HashMap<String, BasePathType>();
    private Map<String, Set<ICheckDependencyListener>> checkDependencyListeners = new HashMap<String, Set<ICheckDependencyListener>>();
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    public boolean hasListeners(String propertyName) {
        return this.pcs.hasListeners(propertyName);
    }

    protected void setBasePath(String property, BasePathType value) {
        this.basePathTypes.put(property, value);
    }

    public BasePathType getBasePathType(String property) {
        return this.basePathTypes.get(property);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public void addCheckDependencyListener(String property, ICheckDependencyListener l) {
        Set<ICheckDependencyListener> propertyListeners = this.checkDependencyListeners.get(property);
        if (propertyListeners == null) {
            propertyListeners = new HashSet<ICheckDependencyListener>();
            this.checkDependencyListeners.put(property, propertyListeners);
        }
        propertyListeners.add(l);
    }

    public void fireCheckDependencyChanged(String property) {
        Set<ICheckDependencyListener> listeners = this.checkDependencyListeners.get(property);
        if (listeners != null) {
            for (ICheckDependencyListener listener : listeners) {
                listener.checkDependencyChanged();
            }
        }
    }

    public void removeCheckDependencyListener(String property, ICheckDependencyListener listener) {
        Set<ICheckDependencyListener> listeners = this.checkDependencyListeners.get(property);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }
}

