/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.model;

import de.tu_bs.ilr.esa.estec.neopop.model.GUIInterfacePart;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElementContainer;
import de.tu_bs.ilr.esa.estec.neopop.model.InputElementListContainer;
import de.tu_bs.ilr.esa.estec.neopop.model.ModelElement;
import de.tu_bs.ilr.esa.estec.neopop.model.VarUsage;
import de.tu_bs.ilr.esa.estec.neopop.model.connector.IModelConnector;
import de.tu_bs.ilr.esa.estec.neopop.model.internal.VarIndexes;
import java.util.ArrayList;
import java.util.List;

public abstract class InputElement
extends ModelElement {
    protected VarIndexes indexes;
    protected IModelConnector connector;
    protected List<InputElementListContainer<? extends InputElement>> elListContainers = new ArrayList<InputElementListContainer<? extends InputElement>>();
    protected List<InputElementContainer<? extends InputElement>> elContainers = new ArrayList<InputElementContainer<? extends InputElement>>();
    protected InputElement parent = null;
    protected List<VarUsage<?>> varUsages = new ArrayList();
    protected GUIInterfacePart guiInterfacePart;
    private boolean suppressEvents = false;

    protected InputElement(InputElement parent, int ... additionalIndexes) {
        this(parent.guiInterfacePart, parent, additionalIndexes);
    }

    protected InputElement(GUIInterfacePart guiInterfacePart, InputElement parent, int ... additionalIndexes) {
        this.indexes = new VarIndexes(parent.indexes);
        if (additionalIndexes != null) {
            int[] nArray = additionalIndexes;
            int n = additionalIndexes.length;
            int n2 = 0;
            while (n2 < n) {
                int additionalIndex = nArray[n2];
                this.indexes.add(additionalIndex);
                ++n2;
            }
        }
        this.connector = parent.connector;
        this.parent = parent;
        this.guiInterfacePart = guiInterfacePart;
    }

    protected InputElement(GUIInterfacePart guiInterfacePart, IModelConnector connector) {
        this.indexes = new VarIndexes();
        this.connector = connector;
        this.guiInterfacePart = guiInterfacePart;
    }

    public void setSuppressEvents(boolean suppress) {
        this.suppressEvents = suppress;
        for (VarUsage<?> varUsage : this.varUsages) {
            varUsage.setSuppressEvents(suppress);
        }
    }

    public boolean isSuppressEvents() {
        return this.suppressEvents;
    }

    public void synchIndexedPropertiesWithFortran() {
        for (InputElementListContainer<? extends InputElement> inputElementListContainer : this.elListContainers) {
            inputElementListContainer.synchElementsWithFortran();
        }
        for (InputElementContainer inputElementContainer : this.elContainers) {
            inputElementContainer.synchIndexedPropertiesWithFortran();
        }
    }

    public void newLastIndex(int newLastIndex) {
        this.loadTempValues();
        this.indexes.newLastIndex(newLastIndex);
        this.saveTempValues();
    }

    public void checkChangeAgainstTempValuesAndCheckDependencies() {
        for (VarUsage<?> varUsage : this.varUsages) {
            varUsage.checkChangeAgainstTempValues();
        }
        for (InputElementContainer inputElementContainer : this.elContainers) {
            inputElementContainer.checkChangeAgainstTempValues();
        }
        for (InputElementListContainer inputElementListContainer : this.elListContainers) {
            inputElementListContainer.checkChangeAgainstTempValues();
        }
    }

    public void loadTempValues() {
        for (VarUsage<?> varUsage : this.varUsages) {
            varUsage.loadTempValue();
        }
        for (InputElementContainer inputElementContainer : this.elContainers) {
            inputElementContainer.loadTempValues();
        }
        for (InputElementListContainer inputElementListContainer : this.elListContainers) {
            inputElementListContainer.loadTempValues();
        }
    }

    public void defragmentateLists() {
        for (InputElementContainer<? extends InputElement> inputElementContainer : this.elContainers) {
            inputElementContainer.defragmentateLists();
        }
        for (InputElementListContainer inputElementListContainer : this.elListContainers) {
            inputElementListContainer.defragmentate();
        }
    }

    public void saveTempValues() {
        for (VarUsage<?> varUsage : this.varUsages) {
            varUsage.saveTempValue();
        }
        for (InputElementContainer inputElementContainer : this.elContainers) {
            inputElementContainer.saveTempValues();
        }
        for (InputElementListContainer inputElementListContainer : this.elListContainers) {
            inputElementListContainer.saveTempValues();
        }
    }

    public void setDefaultValues() {
        for (VarUsage<?> varUsage : this.varUsages) {
            varUsage.setDefaultValue();
        }
        for (InputElementContainer inputElementContainer : this.elContainers) {
            inputElementContainer.setDefaultValues();
        }
        for (InputElementListContainer inputElementListContainer : this.elListContainers) {
            inputElementListContainer.setDefaultValues();
        }
    }

    public String getErrorMessage() {
        switch (this.guiInterfacePart) {
            case NEOPOP: {
                return this.connector.get_error_message("N");
            }
            case POPGEN: {
                return this.connector.get_error_message("P");
            }
            case OBSSIM: {
                return this.connector.get_error_message("O");
            }
        }
        throw new RuntimeException();
    }

    public InputElement getParent() {
        return this.parent;
    }

    public IModelConnector getConnector() {
        return this.connector;
    }
}

