/*
 * Decompiled with CFR 0.152.
 */
package de.tu_bs.ilr.esa.estec.neopop.gui.util;

import de.tu_bs.ilr.esa.estec.neopop.model.ModelElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UberUtil {
    private static Logger logger = LoggerFactory.getLogger(UberUtil.class);

    public static String get(ModelElement modelElement, String property) {
        String getMethodName = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
        Method getMethod = UberUtil.getMethod(modelElement, getMethodName);
        try {
            return (String)getMethod.invoke((Object)modelElement, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            logger.error("Could not invoke method \"{}()\" on model element {}: {}", new Object[]{getMethodName, modelElement, e, e});
            return null;
        }
    }

    public static void set(ModelElement modelElement, String property, String string) {
        String setMethodName = "set" + property.substring(0, 1).toUpperCase() + property.substring(1);
        Method setMethod = UberUtil.getMethod(modelElement, setMethodName);
        try {
            setMethod.invoke((Object)modelElement, string);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            logger.error("Could not invoke method \"{}({})\" on model element {}: {}", new Object[]{setMethodName, string, modelElement, e, e});
        }
    }

    private static Method getMethod(ModelElement modelElement, String methodName) {
        Method[] methodArray = modelElement.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(methodName)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private UberUtil() {
    }
}

